library(ggplot2)
library(ggtree)

WORK_DIR <- paste0(Sys.getenv("HOME"), "/code/malawi_transposon/script/R_SCRIPT/local/phylogenetic/")
setwd(WORK_DIR)

################################################################################
################################################################################

# plot phylogenetic tree based on presence/absence matrix
loaded_tree <- readRDS("pa_matrix_phylogenetic_tree_ranked.rds")$tree

n_sv <- 150538
ut <- 5000

ggtree(loaded_tree) + 
  theme_tree2() +
  geom_nodepoint() +
  geom_tippoint() +
  #geom_text(aes(label=node), hjust=-.3) +
  geom_tiplab(offset = 0, hjust = -.25, align=FALSE, linesize=.5) +
  scale_x_continuous(limits = c(0, ut/n_sv * 7),  # Change these values to set the desired range
                     breaks = seq(0, ut/n_sv * 6, by = ut/n_sv),
                     labels = seq(0, ut * 6, by = ut)) +
  xlab("Number of structural variant differences") +
  theme(plot.margin = unit(c(0, 0.5, 0, 0.5), "cm")) 
ggsave(file="pa_matrix_phylogenetic_tree_ranked.pdf", width = 6.6, height = 3.2)


################################################################################
################################################################################

# plot phylogenetic trees based on 
# averaged SV backbone proportions and bubble density

# SV proportion
dis_matrix <- matrix(c(0.00, 6.95, 7.77, 7.37, 7.08, 6.31, 9.86, 8.32,
                       6.33, 0.00, 5.38, 6.75, 6.51, 5.96, 8.48, 7.44,
                       7.35, 5.51, 0.00, 7.35, 7.03, 6.33, 9.48, 8.04,
                       7.44, 7.12, 7.67, 0.00, 5.52, 5.08, 9.12, 7.86,
                       7.30, 7.12, 7.67, 5.80, 0.00, 4.73, 9.20, 7.89,
                       6.52, 6.31, 6.70, 5.30, 4.79, 0.00, 8.23, 7.32,
                       8.28, 7.48, 8.34, 7.54, 7.20, 6.36, 0.00, 2.96,
                       7.49, 7.09, 7.68, 6.95, 6.87, 6.12, 3.68, 0.00), 
                     nrow = 8, 
                     dimnames = list(color_schema_species$species_abrv,
                                     color_schema_species$species_abrv))


# bubble density
dis_matrix <- matrix(c(0.000, 0.077, 0.079, 0.088, 0.087, 0.087, 0.094, 0.095,
                       0.075, 0.000, 0.061, 0.084, 0.084, 0.084, 0.090, 0.089,
                       0.080, 0.064, 0.000, 0.090, 0.090, 0.089, 0.095, 0.095,
                       0.090, 0.087, 0.090, 0.000, 0.073, 0.083, 0.097, 0.096,
                       0.088, 0.087, 0.090, 0.073, 0.000, 0.069, 0.096, 0.096,
                       0.088, 0.086, 0.088, 0.073, 0.068, 0.000, 0.095, 0.095,
                       0.098, 0.094, 0.097, 0.098, 0.098, 0.097, 0.000, 0.041,
                       0.098, 0.093, 0.096, 0.097, 0.097, 0.096, 0.041, 0.000), 
                     nrow = 8, 
                     dimnames = list(color_schema_species$species_abrv,
                                     color_schema_species$species_abrv))


# make the matrix symmetrical by averaging
dis_matrix_sys <- matrix(0, 
    nrow = 8, ncol = 8,
    dimnames = list(color_schema_species$species_abrv, color_schema_species$species_abrv)
)
for (i in 1:8) {
  for (j in 1:8) {
    dis_matrix_sys[i,j] <- (dis_matrix[i,j] + dis_matrix[j,i]) / 2
  }
}

# plot neighbour joining tree
dist_matrix <- as.dist(dis_matrix_sys)
tree <- nj(dist_matrix)
plot(tree, main = "Phylogenetic Tree")
tiplabels(tree$tip.label)
