library(GenomicRanges)
library(dplyr)
library(tidyr)
library(tibble)
library(readr)

theme_set(theme_classic())

setwd(paste0(Sys.getenv("HOME"), "/code/malawi_transposon/script/R_SCRIPT/"))

source("modules/frequently_used_items.R")
source("modules/get_chrom_sizes.R")
source("modules/import_transposons_into_granges.R")

gr_te <- import_transposons_into_granges("astCal", annoType="calliptera")
df_te <- as.data.frame(gr_te)

# region with weird anomaly
df_te %>% 
  filter(score > 30, score < 31, stringr::str_detect(name, "TcMar") ) %>% 
  group_by(repmask_id, name) %>% 
  summarise(sum_width = sum(width)) %>% 
  arrange(desc(sum_width)) %>% 
  head()

# normal
df_te %>% 
  filter(score > 32, score < 33, stringr::str_detect(name, "TcMar") ) %>% 
  group_by(repmask_id, name) %>% 
  summarise(sum_width = sum(width)) %>% 
  arrange(desc(sum_width)) %>% 
  head()

df_te %>% 
  filter(score > 28, score < 29, stringr::str_detect(name, "TcMar") ) %>% 
  group_by(repmask_id, name) %>% 
  summarise(sum_width = sum(width)) %>% 
  arrange(desc(sum_width)) %>% 
  head()
