# this script creates TxDB objects for calliptera and zebra genome annotations

library(GenomicFeatures)
setwd(paste0(Sys.getenv("HOME"), "/code/malawi_transposon/cloud/genome/") )

txdb <- makeTxDbFromGFF(
  "mayZeb2.0_ensembl/mayZeb_v2.0.gtf.gz",
  dataSource='ensembl',
  organism='Maylandia zebra',
  chrominfo=read.table("mayZeb2.0_ensembl/chrom.sizes", col.names=c('chrom', 'length'))
)
saveDb(txdb, file="mayZeb2.0_ensembl/mayZeb_v2.0.gtf.sqlite")

txdb <- makeTxDbFromGFF(
  "mayZeb2.0_ensembl/mayZeb_v2.0.gff.gz",
  dataSource='ensembl',
  organism='Maylandia zebra',
  chrominfo=read.table("mayZeb2.0_ensembl/chrom.sizes", col.names=c('chrom', 'length'))
)
saveDb(txdb, file="mayZeb2.0_ensembl/mayZeb_v2.0.gff.sqlite")


txdb <- makeTxDbFromGFF(
  "astCal1.2_ensembl/astCal_v1.2.gtf.gz",
  dataSource='ensembl',
  organism='Astatotilapia calliptera',
  chrominfo=read.table("astCal1.2_ensembl/chrom.sizes", col.names=c('chrom', 'length'))
)
saveDb(txdb, file="astCal1.2_ensembl/astCal_v1.2.gtf.sqlite")

txdb <- makeTxDbFromGFF(
  "astCal1.2_ensembl/astCal_v1.2.gff.gz",
  dataSource='ensembl',
  organism='Astatotilapia calliptera',
  chrominfo=read.table("astCal1.2_ensembl/chrom.sizes", col.names=c('chrom', 'length'))
)
saveDb(txdb, file="astCal1.2_ensembl/astCal_v1.2.gff.sqlite")
