#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J pav_gene
#SBATCH --mail-type=END
#SBATCH -n 24
#SBATCH -N 1
#SBATCH --mem=32G
#SBATCH -o "./s_out/slurm-%j.txt"
#SBATCH -p 2004

# FOR CONDA: ACTIVATE YOUR ENVIRONMENT FIRST
# single line command to run, replace as necessary
# export SBATCH_CMD="bash helloworld.sh"; mkdir -p s_out/; sbatch ~/clst/submit_sbatch_big.sh; export SBATCH_CMD=""

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)


GRAPHDIR="$HOME/code/malawi_transposon/cloud/graph_genome/malawi_haplochromines_zebra/"
BACKBONEDIR="$HOME/code/malawi_transposon/cloud/genome/mayZeb2.0_ensembl/"

cd $GRAPHDIR/pseudoreference/

date
echo "RUNNING PAV: genes"
odgi pav -i odgi/graph_chop100.og \
  -b $BACKBONEDIR/txdb_gene.bed -p pav/graph_path_to_species.mapping \
  > pav/txdb_gene_by_species.pav
date
echo

date
echo "RUNNING PAV: exons"
odgi pav -i odgi/graph_chop100.og \
  -b $BACKBONEDIR/txdb_exon.bed -p pav/graph_path_to_species.mapping \
  > pav/txdb_exon_by_species.pav
date
echo

date
echo "RUNNING PAV: upstream"
odgi pav -i odgi/graph_chop100.og \
  -b $BACKBONEDIR/txdb_upstream.bed -p pav/graph_path_to_species.mapping \
  > pav/txdb_upstream_by_species.pav
date
echo

date
echo "RUNNING PAV: downstream"
odgi pav -i odgi/graph_chop100.og \
  -b $BACKBONEDIR/txdb_downstream.bed -p pav/graph_path_to_species.mapping \
  > pav/txdb_downstream_by_species.pav
date
echo

date
echo "RUNNING PAV: exonic parts"
odgi pav -i odgi/graph_chop100.og \
  -b $BACKBONEDIR/txdb_exonic_parts.bed -p pav/graph_path_to_species.mapping \
  > pav/txdb_exonparts_by_species.pav
date
echo

date
echo "RUNNING PAV: intronic parts"
odgi pav -i odgi/graph_chop100.og \
  -b $BACKBONEDIR/txdb_intronic_parts.bed -p pav/graph_path_to_species.mapping \
  > pav/txdb_intronparts_by_species.pav
date
echo
