#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J variantcall
#SBATCH --mail-type=END
#SBATCH -n 10
#SBATCH -N 1
#SBATCH -o "./s_out/slurm-%A_%a-minigraphcall.txt"
#SBATCH -p 2004

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)

# command: sbatch --array 1-8 /path/to/this/script 

FASTADIR="$HOME/code/malawi_transposon/cloud/genome/longread-decompress/renamed"
FASTALIST=(mayZeb2.0_ensembl troMau2.0 astCal1.2_ensembl aulStu5.0 otoArg1.0 copChr1.0 rhaChi1.0 rhaChi2.0)

GRAPHDIR="$HOME/code/malawi_transposon/cloud/graph_genome/malawi_haplochromines_zebra/"
GRAPHNAME="malawi_haplochromines_zebra"

SAMPLE=`cat <(for i in ${FASTALIST[@]}; do echo $i; done) | awk -v line=$SLURM_ARRAY_TASK_ID '{if (NR == line) print $0}'`

echo "CALLING VARIANTS FOR " $SAMPLE
date
minigraph -xasm -c --call $GRAPHDIR/$GRAPHNAME-graph.gfa $FASTADIR/$SAMPLE.renamed.fa > $GRAPHDIR/$SAMPLE.variants
date

