# %%
import pandas as pd

df = (
    pd.read_csv(snakemake.input[0], #"output/subgraph/rx1/subgraph_round1.paths.fragments",
        names = ['chr', 'start', 'end'],
        dtype = {'chr': str, 'start': int, 'end': int}
    )
)
# %%
df_agg = (
  df.groupby('chr')
    .agg({'start': min, 'end': max})
    .reset_index()
)

# %%
df_agg.to_csv(snakemake.output[0], header=False, index=False, sep='\t')