#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J repmask
#SBATCH --mail-type=END
#SBATCH -n 12 
#SBATCH -N 1
#SBATCH --mem=100GB
#SBATCH -o "s_out/slurm-%A_%a-repmask.txt"
#SBATCH -p 1804

# FOR CONDA: ACTIVATE YOUR ENVIRONMENT FIRST
# single line command to run, replace as necessary
# export SBATCH_CMD="bash helloworld.sh"; mkdir -p s_out/; sbatch ~/clst/submit_sbatch_big.sh; export SBATCH_CMD=""

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)

# command: sbatch --array 1-8 /path/to/this/script

# Script to annotate pseudoreference with astCal RepeatModeler library.

GRAPHDIR="$HOME/code/malawi_transposon/cloud/graph_genome/malawi_haplochromines/"
RMLIB_DIR="$GENOME_DIR/repeatmodeler/calliptera_repbase_jun21/"
LIBRARY_NAME="astCal1.2_ensembl"

FASTALIST=(astCal aulStu mayZeb rhaChi troMau copChr otoArg rhaChi2)
SAMPLE=`cat <(for i in ${FASTALIST[@]}; do echo $i; done) | awk -v line=$SLURM_ARRAY_TASK_ID '{if (NR == line) print $0}'`

date
singularity exec \
    "docker://dfam/tetools:1.3" \
    bash -c "
    cd $RMLIB_DIR
    pwd

    export LIBDIR=$HOME/raw/repeatmasker/Libraries/

    date
    printf 'running RepeatMasker...\n'
    RepeatMasker \
      -e rmblast \
      -pa 12 \
      -no_is \
      -gff \
      -lib $LIBRARY_NAME-families.fa \
      -dir $GRAPHDIR/pseudoreference/repeatmasker_astCalLib/raw_output/ \
      $GRAPHDIR/pseudoreference/fasta/path_$SAMPLE.fa

    date
"
date

