#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J convert_to_vgGFA 
#SBATCH --mail-type=END
#SBATCH -n 16
#SBATCH -N 1
#SBATCH --mem=64G
#SBATCH -o "./s_out/slurm-%j_.txt"
#SBATCH -p 2004

# FOR CONDA: ACTIVATE YOUR ENVIRONMENT FIRST
# single line command to run, replace as necessary
# export SBATCH_CMD="bash helloworld.sh"; mkdir -p s_out/; sbatch ~/clst/submit_sbatch_big.sh; export SBATCH_CMD=""

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)

# This script converts the VG graph into ODGI format. It produces several chopped versions at different granularities.


GRAPHDIR="$HOME/code/malawi_transposon/cloud/graph_genome/malawi_haplochromines/"
cd $GRAPHDIR/pseudoreference/odgi/

date
echo "CONVERTING VG-GFA INTO OG"
odgi build -g graph.gfa -o graph.og -t 16
date
echo

date
echo "EXTRACTING PATHS AS FASTA"
odgi paths -i graph.og -f > graph_paths.fa
samtools faidx graph_paths.fa
date
echo

date
echo "SORTING OG"
odgi sort -i graph.og -O -P -Y -t 16 -o graph_sort.og
date
echo

date
echo "CHOPPING OG WITH SEGMENT SIZE OF 100"
odgi chop -i graph.og -o graph_chop100.og -c 100 -t 16 
odgi view -i graph_chop100.og -g -t 16 > graph_chop100.gfa
date
echo

date
echo "CHOPPING OG WITH SEGMENT SIZE OF 250"
odgi chop -i graph.og -o graph_chop250.og -c 250 -t 16 
odgi view -i graph_chop250.og -g -t 16 > graph_chop250.gfa
date
echo

date
echo "CHOPPING OG WITH SEGMENT SIZE OF 500"
odgi chop -i graph.og -o graph_chop500.og -c 500 -t 16 
odgi view -i graph_chop500.og -g -t 16 > graph_chop500.gfa
date
echo

date
echo "CHOPPING OG WITH SEGMENT SIZE OF 1000"
odgi chop -i graph.og -o graph_chop1000.og -c 1000 -t 16 
odgi view -i graph_chop1000.og -g -t 16 > graph_chop1000.gfa
date
echo
