#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J convert_to_vgGFA 
#SBATCH --mail-type=END
#SBATCH -n 24
#SBATCH -N 1
#SBATCH --mem=64G
#SBATCH -o "./s_out/slurm-%j.txt"
#SBATCH -p 2004

# FOR CONDA: ACTIVATE YOUR ENVIRONMENT FIRST
# single line command to run, replace as necessary
# export SBATCH_CMD="bash helloworld.sh"; mkdir -p s_out/; sbatch ~/clst/submit_sbatch_big.sh; export SBATCH_CMD=""

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)

# This script adds chromosome paths into the minigraph GFA and converts it into VG format.


GRAPHDIR="$HOME/code/malawi_transposon/cloud/graph_genome/malawi_haplochromines/"
GRAPHNAME="malawi_haplochromines"

date
cd $GRAPHDIR/pseudoreference/
mkdir odgi/
cat ../$GRAPHNAME-graph.gfa <(cat nodes_and_paths/*.pseudoref.paths | cut -f1,3,4,5) > tmp.gfa
echo "CONVERTING GFA INTO VG-GFA"
vg view -F tmp.gfa --threads 24 -v | vg view -V - --threads 24 -g > odgi/graph.gfa
rm tmp.gfa
date

