#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J repmodelmask
#SBATCH --mail-type=END
#SBATCH -n 24
#SBATCH -N 1
#SBATCH --mem=64G
#SBATCH -o "s_out/slurm-%A_%a-other.txt"
#SBATCH -p 2004

# FOR CONDA: ACTIVATE YOUR ENVIRONMENT FIRST
# single line command to run, replace as necessary
# export SBATCH_CMD="bash helloworld.sh"; mkdir -p s_out/; sbatch ~/clst/submit_sbatch_big.sh; export SBATCH_CMD=""

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)

# command: sbatch --array 1-7 /path/to/this/script

# This script runs RepeatModeler and RepeatMasker on all the Malawi haplochromines genomes, except astCal1.2.

date

FASTADIR="$HOME/code/malawi_transposon/genome/longread-decompress/"
FASTALIST=(aulStu5.0 mayZeb2.0_ensembl rhaChi1.0 troMau2.0 copChr1.0 otoArg1.0 rhaChi2.0)
SAMPLE=`cat <(for i in ${FASTALIST[@]}; do echo $i; done) | awk -v line=$SLURM_ARRAY_TASK_ID '{if (NR == line) print $0}'`

RMLIB_DIR="$REPO_DIR/cloud/repeatmodeler/all_species_repbase_aug22/$SAMPLE/"
OUT_DIR="$REPO_DIR/cloud/out/repmask/all_species_repbase_aug22/$SAMPLE/raw_output/"

LIBRARY_NAME=$SAMPLE
mkdir -p $RMLIB_DIR
mkdir -p $OUT_DIR

singularity exec \
    "docker://dfam/tetools:1.3" \
    bash -c "
    mkdir $RMLIB_DIR
    cd $RMLIB_DIR
    pwd

    export LIBDIR=$HOME/raw/repeatmasker/Libraries/

    date
    printf 'building database...\n'
    BuildDatabase -name $LIBRARY_NAME $FASTADIR/$SAMPLE.ref.fa

    date
    printf 'running RepeatModeller...\n'
    RepeatModeler -pa 24 -database $LIBRARY_NAME -LTRStruct

    date
    printf 'running RepeatMasker...\n'
    RepeatMasker \
      -e rmblast \
      -pa 24 \
      -no_is \
      -gff \
      -lib $LIBRARY_NAME-families.fa \
      -dir $OUT_DIR \
      $FASTADIR/$SAMPLE.ref.fa
    date
"
date
