#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J repmask
#SBATCH --mail-type=END
#SBATCH -n 8
#SBATCH -N 1
#SBATCH -o "s_out/slurm-%A_%a-repmask.txt"
#SBATCH -p 1804

# FOR CONDA: ACTIVATE YOUR ENVIRONMENT FIRST
# single line command to run, replace as necessary
# export SBATCH_CMD="bash helloworld.sh"; mkdir -p s_out/; sbatch ~/clst/submit_sbatch_big.sh; export SBATCH_CMD=""

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)

# command: sbatch --array 1-8 /path/to/this/script

# This script runs RepeatMasker on all the genomes, using the RepeatModeler library trained on astCal1.2_ensembl.

date

RMLIB_DIR="$GENOME_DIR/repeatmodeler/calliptera_repbase_jun21/"
OUT_DIR="$REPO_DIR/out/repmask/calliptera_repbase_jun21/raw_output/"

FASTADIR="$HOME/code/malawi_transposon/genome/longread-decompress/"
FASTALIST=(aulStu5.0 mayZeb2.0 rhaChi1.0 troMau2.0 astCal1.2 copChr1.0 otoArg1.0 rhaChi2.0)
SAMPLE=`cat <(for i in ${FASTALIST[@]}; do echo $i; done) | awk -v line=$SLURM_ARRAY_TASK_ID '{if (NR == line) print $0}'`

LIBRARY_NAME="astCal1.2_ensembl"  # formerly calliptera_repbase_ltr

singularity exec \
    "docker://dfam/tetools:1.3" \
    bash -c "
    cd $RMLIB_DIR
    pwd

    export LIBDIR=$HOME/raw/repeatmasker/Libraries/

    date
    printf 'running RepeatMasker...\n'
    RepeatMasker \
      -e rmblast \
      -pa 8 \
      -no_is \
      -gff \
      -lib $LIBRARY_NAME-families.fa \
      -dir $OUT_DIR \
      $FASTADIR/$SAMPLE.ref.fa

    date
"

date
