DATA_DIR="$REPO_DIR/out/sample_symlinks/"
OUT_DIR="$REPO_DIR/out/repmask_processed/"

# calliptera samples
samples_astCal='astCal astCal_alone astCal_noLTR astCal_oreKar'
for sample in $samples_astCal
do
    echo processing... $sample
    cat $DATA_DIR/$sample | python $MODULE_DIR/parse_repmask_to_simple.py | python $MODULE_DIR/modify_chr_column.py 2 --alias $META_DIR/alias_astCal1.2_chr-ensembl.txt --drop-mito > $OUT_DIR/$sample.simple
    cat $OUT_DIR/$sample.simple | python $MODULE_DIR/parse_simple_to_bedready.py > $OUT_DIR/$sample.bedready.txt
    cat $OUT_DIR/$sample.bedready.txt | awk 'BEGIN { first = 1; last = 12 }{ for (i = first; i < last; i++) { printf("%s\t", $i) } print $last }' > $OUT_DIR/$sample.bed12.bed
    cat $OUT_DIR/$sample.bedready.txt | python $MODULE_DIR/parse_bedready_for_viz.py > $OUT_DIR/$sample.bedviz.bed
    echo
done

# greg's calliptera, need to convert from genbank to ensembl
sample='astCal_greg'
echo processing... $sample
cat $DATA_DIR/$sample | python $MODULE_DIR/parse_repmask_to_simple.py | python $MODULE_DIR/modify_chr_column.py 2 --alias $META_DIR/alias_astCal1.2_genbank-ensembl.txt --drop-mito > $OUT_DIR/$sample.simple
cat $OUT_DIR/$sample.simple | python $MODULE_DIR/parse_simple_to_bedready.py > $OUT_DIR/$sample.bedready.txt
cat $OUT_DIR/$sample.bedready.txt | awk 'BEGIN { first = 1; last = 12 }{ for (i = first; i < last; i++) { printf("%s\t", $i) } print $last }' > $OUT_DIR/$sample.bed12.bed
cat $OUT_DIR/$sample.bedready.txt | python $MODULE_DIR/parse_bedready_for_viz.py > $OUT_DIR/$sample.bedviz.bed
echo

# mayZeb from longread
sample='mayZeb'
echo processing... $sample
cat $DATA_DIR/$sample | python $MODULE_DIR/parse_repmask_to_simple.py | python $MODULE_DIR/modify_chr_column.py 2 --alias $META_DIR/alias_mayZeb2.0_chr-ensembl.txt --drop-mito > $OUT_DIR/$sample.simple
cat $OUT_DIR/$sample.simple | python $MODULE_DIR/parse_simple_to_bedready.py > $OUT_DIR/$sample.bedready.txt
cat $OUT_DIR/$sample.bedready.txt | awk 'BEGIN { first = 1; last = 12 }{ for (i = first; i < last; i++) { printf("%s\t", $i) } print $last }' > $OUT_DIR/$sample.bed12.bed
cat $OUT_DIR/$sample.bedready.txt | python $MODULE_DIR/parse_bedready_for_viz.py > $OUT_DIR/$sample.bedviz.bed
echo
    
# greg's mayZeb
sample='mayZeb_greg'
echo processing... $sample
cat $DATA_DIR/$sample | python $MODULE_DIR/parse_repmask_to_simple.py | python $MODULE_DIR/modify_chr_column.py 2 --alias $META_DIR/alias_mayZeb2.0_ncbi-ensembl.txt --drop-mito > $OUT_DIR/$sample.simple
cat $OUT_DIR/$sample.simple | python $MODULE_DIR/parse_simple_to_bedready.py > $OUT_DIR/$sample.bedready.txt
cat $OUT_DIR/$sample.bedready.txt | awk 'BEGIN { first = 1; last = 12 }{ for (i = first; i < last; i++) { printf("%s\t", $i) } print $last }' > $OUT_DIR/$sample.bed12.bed
cat $OUT_DIR/$sample.bedready.txt | python $MODULE_DIR/parse_bedready_for_viz.py > $OUT_DIR/$sample.bedviz.bed
echo

# other fish
samples_other='rhaChi aulStu troMau oreKar'
for sample in $samples_other
do
    echo processing... $sample
    cat $DATA_DIR/$sample | python $MODULE_DIR/parse_repmask_to_simple.py | python $MODULE_DIR/modify_chr_column.py 2 --drop-mito > $OUT_DIR/$sample.simple
    cat $OUT_DIR/$sample.simple | python $MODULE_DIR/parse_simple_to_bedready.py > $OUT_DIR/$sample.bedready.txt
    cat $OUT_DIR/$sample.bedready.txt | awk 'BEGIN { first = 1; last = 12 }{ for (i = first; i < last; i++) { printf("%s\t", $i) } print $last }' > $OUT_DIR/$sample.bed12.bed
    cat $OUT_DIR/$sample.bedready.txt | python $MODULE_DIR/parse_bedready_for_viz.py > $OUT_DIR/$sample.bedviz.bed
    echo
done


