# Script to parse bedready into a custom BED9+12 format for IGV visualisation.
# Usage: python /path/to/script.py -h

import sys
import argparse
import pandas as pd
from pathlib import Path

def cmdline_args():
    p = argparse.ArgumentParser(
        description="Format a BEDready file for IGV visualisation.",
        usage='cat input.txt | python format_simple_to_bedready.py [options] > output.txt',
        formatter_class=argparse.RawDescriptionHelpFormatter
    )
    return p.parse_args()

def read_bedready_from_stdin():
    dtype = {'chr': str, 'id': str, 'color': str, 'block_sizes': str, 'block_starts': str}
    return pd.read_table(sys.stdin, index_col=False, dtype=dtype)

# parse arguments
args = cmdline_args()

# read repeatmasker file from stdin
df = read_bedready_from_stdin().iloc[:, 0:12]

# split transposons
index_split = df['block_count'] > 1
df.loc[index_split, ['thick_start', 'thick_end']] = 0

# single unit transposons
index_single = df['block_count'] == 1
df.loc[index_single, ['block_count', 'block_sizes', 'block_starts']] = ""

# write to standard output
df.to_csv(sys.stdout, sep='\t', na_rep='', index=False, header=False)
