#!/bin/bash
#SBATCH -n 1                   # Number of cores
#SBATCH -N 1                    # Ensure that all cores are on one machine
#SBATCH --mail-type=END,FAIL         # Type of email notification- BEGIN,END,FAIL,ALL

#find all files in the current directory and grab them 1 by 1 depeding on which task is being run
WORKDIR="$HOME/code/malawi_transposon/"

arrayfile=`ls $WORKDIR/genome/longread_subset/*.fai | awk -v line=$SLURM_ARRAY_TASK_ID '{if (NR == line) print $0}'`

printf $arrayfile"\n"
cut -f1,2 $arrayfile 

#sbatch -p 1804 --array 1-6 sbatch_getchromsize.sh /path/to/fai/
