import subprocess

# 定义命令列表
commands = [
    "./software/RaMA -r ./data/mixture_seq1_2.fasta -q ./data/mixture_seq2_2.fasta -o ./result/RaMA2",
    "./software/tandem_aligner --first ./data/mixture_seq1_2.fasta --second ./data/mixture_seq2_2.fasta -o ./result/UniAligner2"
    # "./software/wfa2 ./data/mixture_seq1.fasta ./data/mixture_seq2.fasta ./result/wfa/cigar.txt"
]

# 运行命令的函数
def run_command(command):
    try:
        print(f"正在运行: {command}")
        result = subprocess.run(command, shell=True, check=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
        print(f"命令执行成功: {command}")
        print(f"输出: {result.stdout}")
    except subprocess.CalledProcessError as e:
        print(f"命令执行失败: {command}")
        print(f"错误信息: {e.stderr}")

# 依次运行每个命令
for cmd in commands:
    run_command(cmd)

print("所有命令执行完成。")
