# 加载必要的库
library(ggplot2)

# 读取CSV文件
data <- read.csv("./csv/chr_match_length_anchor_counts.csv")

# 将Chromosome列转换为有序因子，按照1-22, X的顺序排列
data$Chromosome <- factor(data$Chromosome, levels = c(paste0("chr", 1:22), "chrX"))

# 画散点图，横坐标是Chromosome，纵坐标是Coverage
ggplot(data, aes(x = Chromosome, y = Coverage)) +
  geom_point(color = "#f08080", size = 4) +  # 使用淡红色的点
  labs(title = "Total coverage identified by RaMA \nacross Chromosomes",
       x = "Chromosome",
       y = "Anchor Coverage") +
  theme_minimal(base_size = 15) +  # 使用简约主题
  theme(
    plot.title = element_text(hjust = 0.5, face = "bold"),  # 标题居中并加粗
    axis.text.x = element_text(angle = 45, hjust = 1),  # x轴标签倾斜显示
    panel.grid.minor = element_blank(),  # 去除小网格线
    panel.grid.major = element_line(color = "gray", linetype = "dashed"),  # 设置大网格线为虚线
    panel.border = element_rect(color = "black", fill = NA, size = 1)  # 添加基础的黑色框线
  )

# 保存图像
ggsave("./plot/chr_coverage.svg", width = 10, height = 6)
