# 绘制内存使用的散点图

# 构建数据框用于绘图
plot_data_memory <- data.frame(
  Chromosome = rep(chromosomes, 3),
  Memory = benchmark_data$Memory_Usage,
  Method = factor(benchmark_data$Software)
)

# 绘制图表
p_memory <- ggplot(plot_data_memory, aes(x = Chromosome, y = Memory, color = Method, shape = Method)) +
  geom_point(size = 3) +
  scale_color_manual(values = c("RaMA" = "#FF6347", "minimap2" = "#64B345", "wfmash" = "#4682B4")) +
  scale_shape_manual(values = c(16, 15, 17)) +  # 改变点的形状
  labs(x = "Chromosome", y = "Memory Usage (GB)", title = "Comparison of Memory Usage across three Methods") +
  theme_minimal() +
  theme(
    aspect.ratio = 4/9,
    legend.text = element_text(size = 14),
    plot.title = element_text(hjust = 0.5, size = 16),
    axis.title.x = element_text(size = 16),
    axis.title.y = element_text(size = 16),
    axis.text.x = element_text(size = 12),
    axis.text.y = element_text(size = 12),
    legend.position = "top",
    legend.title = element_blank()
  )

# 显示图表
print(p_memory)

# 保存为 SVG 文件
ggsave(filename = "./plot/memory_comparison.svg", plot = p_memory, width = 9, height = 4)
