# 安装并加载必要的包
# 安装 ggplot2 包，如果尚未安装
if (!requireNamespace("ggplot2", quietly = TRUE)) {
  install.packages("ggplot2")
}

# 加载 ggplot2
library(ggplot2)
# 安装并加载 dplyr 包
if (!requireNamespace("dplyr", quietly = TRUE)) {
  install.packages("dplyr")
}
library(dplyr)

# 安装并加载 scales 包
if (!requireNamespace("scales", quietly = TRUE)) {
  install.packages("scales")
}
library(scales)


# 导入CSV数据
benchmark_data <- read.csv("./csv/benchmark_results.csv", stringsAsFactors = FALSE)

# 确保染色体列没有问题
benchmark_data$Chromosome <- trimws(benchmark_data$Chromosome)

# 修改因子的 levels，确保染色体顺序一致
chromosomes <- factor(gsub("chr", "", benchmark_data$Chromosome), levels = c(1:22, "X"))

# 构建数据框用于绘图
plot_data <- data.frame(
  Chromosome = rep(chromosomes, 3),
  Time = benchmark_data$Real_Time,
  Method = factor(benchmark_data$Software)
)

# 绘制图表
p <- ggplot(plot_data, aes(x = Chromosome, y = Time, color = Method, shape = Method)) +
  geom_point(size = 3) +
  scale_color_manual(values = c("RaMA" = "#FF6347", "minimap2" = "#64B345", "wfmash" = "#4682B4")) +
  scale_shape_manual(values = c(16, 15, 17)) +  # 改变点的形状
  labs(x = "Chromosome", y = "Real Time (s)", title = "Comparison of Real Time across three Methods") +
  theme_minimal() +
  theme(
    aspect.ratio = 4/9,
    legend.text = element_text(size = 14),
    plot.title = element_text(hjust = 0.5, size = 16),
    axis.title.x = element_text(size = 16),
    axis.title.y = element_text(size = 16),
    axis.text.x = element_text(size = 12),
    axis.text.y = element_text(size = 12),
    legend.position = "top",
    legend.title = element_blank()
  )

# 显示图表
print(p)

# 保存为 SVG 文件
ggsave(filename = "./plot/time_comparison.svg", plot = p, width = 9, height = 4)
