# 加载所需的库
library(ggplot2)
library(dplyr)

# 定义数据
data <- data.frame(
  Algorithm = rep(c("reliable-RaMA", "RaMA", "UniAligner"), each = 11),
  Key = c(1, 2, 4, 3, 18, 13, 5, 8, NA, NA, NA,    # reliable-RaMA
          1, 2, 4, 3, 5, 6, 12, 18, 9, 13, 8,     # RaMA
          1, 2, 4, 3, 5, 6, 9, 13, 8, 7, NA),      # UniAligner
  Value = c(81, 26, 6, 8, 1, 1, 1, 1, NA, NA, NA,  # reliable-RaMA
            112, 34, 9, 10, 5, 2, 2, 1, 2, 1, 2,   # RaMA
            117, 39, 5, 11, 4, 2, 1, 1, 1, 1, NA)  # UniAligner
)

# 去除 NA 值以清理数据，并过滤掉 Key 值为 1、2、3、4 的行
data <- data %>%
  na.omit() %>%
  filter(!Key %in% c(1, 2, 3, 4))

# 重新编码 Key 值，去除不需要显示的位置并缩短距离
data <- data %>%
  mutate(Key_recode = case_when(
    Key == 5 ~ 1,
    Key == 6 ~ 2,
    Key == 7 ~ 3,
    Key == 8 ~ 4,
    Key == 9 ~ 5,
    Key == 13 ~ 6,   # 重编码 13 为 6
    Key == 18 ~ 7    # 重编码 18 为 7
  ))

# 绘制折线图并显示具体数值
p <- ggplot(data, aes(x = Key_recode, y = Value, color = Algorithm, shape = Algorithm, group = Algorithm)) +
  geom_line(size = 1) +
  geom_point(size = 3) +
  geom_text(aes(label = Value), vjust = -0.5, size = 3.5) +  # 添加每个点的具体数值
  scale_x_continuous(breaks = c(1, 2, 3, 4, 5, 6, 7),       # 设置新的 x 轴刻度
                     labels = c(5, 6, 7, 8, 9, 13, 18)) +    # 显示原始标签
  labs(x = "HOR-indel Multiplicity", y = "HOR-indel count") +
  theme_minimal() +
  theme(
    axis.title.x = element_text(size = 14),         # 调大横坐标字体
    axis.title.y = element_text(size = 14),         # 调大纵坐标字体
    axis.text.x = element_text(size = 12),          # 调大横坐标刻度字体
    axis.text.y = element_text(size = 12),          # 调大纵坐标刻度字体
    legend.title = element_blank(),
    panel.border = element_rect(color = "black", fill = NA, size = 1)  # 添加整个单元格的黑色边框
  )

# 保存为 PDF
ggsave("./plot/HOR_indel_5-18.pdf", plot = p, width = 8, height = 3)
