# 加载所需的库
library(ggplot2)
library(tidyr)

# 数据框定义
data <- data.frame(
  Algorithm = c("reliable-RaMA", "RaMA", "UniAligner"),
  Total_Indel = c(288, 406, 564),
  HOR_Indel = c(125, 180, 182)
)

# 使用 tidyr 进行数据转换
data_long <- data %>%
  pivot_longer(cols = c(Total_Indel, HOR_Indel), 
               names_to = "Indel_Type", values_to = "Count")

# 绘制柱状图
p <- ggplot(data_long, aes(x = Algorithm, y = Count, fill = Indel_Type)) +
  geom_bar(stat = "identity", position = position_dodge(width = 0.8), color = "black", size = 0.3) +  # 添加柱的黑边
  geom_text(aes(label = Count), 
            position = position_dodge(width = 0.8), 
            vjust = -0.5, size = 5) +
  scale_fill_manual(values = c("Total_Indel" = "#b04333", "HOR_Indel" = "#2c6fa1")) +
  labs(x = NULL, y = "Indel count") +  # 移除横坐标标签和标题
  scale_y_continuous(limits = c(0, 600)) +  # 设置 y 轴上限为 600
  theme_minimal() +
  theme(
    legend.title = element_blank(),
    axis.title.y = element_text(size = 14), # 调大纵坐标字体
    axis.text.x = element_text(size = 14),  # 调大横坐标字体
    axis.text.y = element_text(size = 12),  # 调大纵坐标刻度字体
    panel.border = element_rect(color = "black", fill = NA, size = 1)  # 添加整个框的黑边
  )
ggsave("./plot/Indel_bar.pdf", plot = p, width = 8, height = 6)