import pandas as pd

# 读取CSV文件
df = pd.read_csv('./csv/RaMA_performance.csv')

# 计算各个指标的平均时间和内存
avg_suffix_array_time = df['suffix_array_time'].mean()
avg_suffix_array_memory = df['suffix_array_memory'].mean()

avg_sparse_table_time = df['sparse_table_time'].mean()
avg_sparse_table_memory = df['sparse_table_memory'].mean()

avg_anchor_search_time = df['anchor_search_time'].mean()
avg_anchor_search_memory = df['anchor_search_memory'].mean()

avg_alignment_time = df['alignment_time'].mean()
avg_alignment_memory = df['alignment_memory'].mean()

# 计算总平均时间和总平均内存
avg_total_time = avg_suffix_array_time + avg_sparse_table_time + avg_anchor_search_time + avg_alignment_time
avg_total_memory = avg_suffix_array_memory + avg_sparse_table_memory + avg_anchor_search_memory + avg_alignment_memory

# 计算各个指标时间和内存所占比例
suffix_array_time_percentage = (avg_suffix_array_time / avg_total_time) * 100
sparse_table_time_percentage = (avg_sparse_table_time / avg_total_time) * 100
anchor_search_time_percentage = (avg_anchor_search_time / avg_total_time) * 100
alignment_time_percentage = (avg_alignment_time / avg_total_time) * 100

suffix_array_memory_percentage = (avg_suffix_array_memory / avg_total_memory) * 100
sparse_table_memory_percentage = (avg_sparse_table_memory / avg_total_memory) * 100
anchor_search_memory_percentage = (avg_anchor_search_memory / avg_total_memory) * 100
alignment_memory_percentage = (avg_alignment_memory / avg_total_memory) * 100

# 创建一个DataFrame来存储结果
summary = pd.DataFrame({
    'Metric': ['suffix_array', 'sparse_table', 'anchor_search', 'alignment'],
    'Avg_Time': [avg_suffix_array_time, avg_sparse_table_time, avg_anchor_search_time, avg_alignment_time],
    'Avg_Time_Percentage': [suffix_array_time_percentage, sparse_table_time_percentage, anchor_search_time_percentage, alignment_time_percentage],
    'Avg_Memory': [avg_suffix_array_memory, avg_sparse_table_memory, avg_anchor_search_memory, avg_alignment_memory],
    'Avg_Memory_Percentage': [suffix_array_memory_percentage, sparse_table_memory_percentage, anchor_search_memory_percentage, alignment_memory_percentage]
})

# 打印结果
print(summary)

# 保存结果到CSV
summary.to_csv('./csv/RaMA_performance_ratio.csv', index=False)

