# 安装并加载必要的包
if (!require(ggplot2)) install.packages("ggplot2")
if (!require(dplyr)) install.packages("dplyr")
if (!require(scales)) install.packages("scales")

# 导入CSV数据
RaMA_data <- read.csv("./csv/RaMA_performance.csv", stringsAsFactors = FALSE)
UniAligner_data <- read.csv("./csv/UniAligner_performance.csv", stringsAsFactors = FALSE)

# 确保染色体列没有问题
RaMA_data$chromosome <- trimws(RaMA_data$chromosome)
UniAligner_data$chromosome <- trimws(UniAligner_data$chromosome)

# 修改因子的 levels，确保和 RaMA_data$chromosome 中的格式一致
chromosomes <- factor(gsub("chr", "", RaMA_data$chromosome), levels = c(1:22, "X"))

# 构建数据框用于绘图
plot_data <- data.frame(
  Chromosome = rep(chromosomes, 3),
  Memory = c(RaMA_data$rare_alignment_memory, RaMA_data$total_memory, UniAligner_data$total_memory),
  Method = factor(rep(c("RaMA rare-alignment memory", "RaMA total memory", "UniAligner total memory"), each = length(chromosomes)))
)

# 绘制图表，不使用缩放
p <- ggplot(plot_data, aes(x = Chromosome, y = Memory, color = Method, shape = Method)) +
  geom_point(size = 3) +
  scale_color_manual(values = c("RaMA rare-alignment memory" = "#FF6347", "RaMA total memory" = "#64B345", "UniAligner total memory" = "#4682B4")) +
  scale_shape_manual(values = c(16, 15, 17)) +  # 改变点的形状
  labs(x = "Chromosome HOR Array", y = "Mean Memory (GB)") +  # 添加标题
  theme_minimal() +
  theme(aspect.ratio = 4/9,
        legend.text = element_text(size = 12),  # 调整图例标签字体大小
        plot.title = element_text(hjust = 0.5, size = 16),  # 标题居中并设置大小
        axis.title.x = element_text(size = 16),  # 调整 x 轴标题的字体大小
        axis.title.y = element_text(size = 16),  # 调整 y 轴标题的字体大小
        axis.text.x = element_text(size = 12),   # 调整 x 轴刻度标签的字体大小
        axis.text.y = element_text(size = 12),   # 调整 y 轴刻度标签的字体大小
        legend.position = "top",  # 将标签放在图表上方
        legend.title = element_blank())  # 去除图例标题

# 使用 ggsave 保存图表
print(p)  # 显示在 RStudio 的 plot 窗口

# 保存为 SVG 文件
ggsave(filename = "./plot/memory.svg", plot = p, width = 9, height = 4)
