import os
import subprocess
from tqdm import tqdm

def run_rama(ref_dir, query_dir, output_base_dir, num_runs=10):
    chromosomes = [f"chr{i}_cen.fasta" for i in range(1, 23)] + ["chrX_cen.fasta"]
    chromosome_mapping = {f"chr{i}_cen.fasta": f"chr{i}" for i in range(1, 23)}
    chromosome_mapping["chrX_cen.fasta"] = "chrX"

    for run in range(1, num_runs + 1):
        for chromosome in tqdm(chromosomes, desc=f"RaMA Run {run}"):
            ref_path = os.path.join(ref_dir, chromosome)
            query_path = os.path.join(query_dir, chromosome)
            output_dir = os.path.join(output_base_dir, f"run_{run}", chromosome_mapping[chromosome])

            if not os.path.exists(output_dir):
                os.makedirs(output_dir)

            command = f"./RaMA -r {ref_path} -q {query_path} -o {output_dir} -t 1"
            print(f"Running: {command}")
            subprocess.run(command, shell=True, check=True)

def run_unialigner(ref_dir, query_dir, output_base_dir, num_runs=10):
    chromosomes = [f"chr{i}_cen.fasta" for i in range(1, 23)] + ["chrX_cen.fasta"]
    chromosome_mapping = {f"chr{i}_cen.fasta": f"chr{i}" for i in range(1, 23)}
    chromosome_mapping["chrX_cen.fasta"] = "chrX"

    for run in range(5, num_runs + 1):
        for chromosome in tqdm(chromosomes, desc=f"UniAligner Run {run}"):
            ref_path = os.path.join(ref_dir, chromosome)
            query_path = os.path.join(query_dir, chromosome)
            output_dir = os.path.join(output_base_dir, f"run_{run}", chromosome_mapping[chromosome])

            if not os.path.exists(output_dir):
                os.makedirs(output_dir)

            command = f"./tandem_aligner --first {ref_path} --second {query_path} -o {output_dir}"
            print(f"Running: {command}")
            subprocess.run(command, shell=True, check=True)

ref_dir = "/mnt/d/Result/RaMA/data/human_genome/chm13/chm13_cen"
query_dir = "/mnt/d/Result/RaMA/data/human_genome/chm1/chm1_cen"
output_rama_dir = "/mnt/d/Result/RaMA/exp/new_chm13_chm1/result/RaMA2"
output_unialigner_dir = "/mnt/d/Result/RaMA/exp/new_chm13_chm1/result/UniAligner1"

run_rama(ref_dir, query_dir, output_rama_dir)
# run_unialigner(ref_dir, query_dir, output_unialigner_dir)
