import os
import subprocess

# 定义输入序列路径
sequences = {
    "template": ["../../data/human_genome/template/template1.fasta", "../../data/human_genome/template/template2.fasta"],
    "cen_X": ["../../data/human_genome/chm13/chm13_cen/chrX_cen.fasta", "../../data/human_genome/hg002/hg002_cen/chrX_MATERNAL_cen.fasta"]
}

# 定义输出目录
output_dirs = {
    "template": "./result/template/",
    "cen_X": "./result/cen_X/"
}

# 定义软件及其执行命令
software_commands = {
    # "RaMA": lambda r, q, out_dir: f"./software/RaMA -r {r} -q {q} -o {out_dir}",
    # "UniAligner": lambda r, q, out_dir: f"./software/tandem_aligner --first {r} --second {q} -o {out_dir}",
    # "WFA2": lambda r, q, out_file: f"./software/wfa2 {r} {q} {out_file}",
    # "WFA10": lambda r, q, out_file: f"./software/wfa10 {r} {q} {out_file}",
    # "WFA50": lambda r, q, out_file: f"./software/wfa50 {r} {q} {out_file}",
    # "minimap2": lambda r, q, out_file: f"./software/minimap2 -a {r} {q} > {out_file}",
    "wfmash": lambda r, q, out_file: f"./software/wfmash {r} {q} > {out_file}"
    #
}

# CIGAR提取函数
def extract_cigar_from_sam(sam_file):
    cigar_results = []
    with open(sam_file, "r") as f:
        for line in f:
            if not line.startswith('@'):
                fields = line.split('\t')
                cigar = fields[5]  # 第6列是CIGAR
                cigar_results.append(cigar)
    return cigar_results

# 将PAF转换为CIGAR
def convert_paf_to_cigar(paf_file):
    cigar_results = []
    with open(paf_file, "r") as f:
        for line in f:
            fields = line.split('\t')
            # 根据PAF字段信息自行处理转换为CIGAR的逻辑
            # 假设第13列包含的CIGAR信息作为简化例子
            if len(fields) > 12:
                cigar_results.append(fields[12])  # 示例，具体需根据实际PAF格式提取
    return cigar_results

# 运行比对软件
def run_software(software, r, q, out_dir):
    os.makedirs(out_dir, exist_ok=True)
    if software == "minimap2":
        output_file = os.path.join(out_dir, "result.sam")
        cmd = software_commands[software](r, q, output_file)
        print(cmd)
        subprocess.run(cmd, shell=True)
    elif software == "wfmash":
        output_file = os.path.join(out_dir, "result.paf")
        cmd = software_commands[software](r, q, output_file)
        print(cmd)
        subprocess.run(cmd, shell=True)
    else:
        output_file = os.path.join(out_dir, "cigar.txt")
        # 创建并打开文件
        with open(output_file, 'w') as f:
            f.write("")  # 创建一个空的 CIGAR 文件，可以写入其他内容
        cmd = software_commands[software](r, q, output_file)
        print(cmd)
        subprocess.run(cmd, shell=True)
        print(f"{software} finished")

# 批量运行所有比对任务
def run_all():
    for key in sequences:
        seq1, seq2 = sequences[key]
        out_dir = output_dirs[key]

        for software in software_commands:
            for key in sequences:
                seq1, seq2 = sequences[key]
                out_dir = output_dirs[key]
                if not os.path.exists(out_dir):
                    os.makedirs(out_dir)
                print(f"Running {software} for {key} sequences...")
                software_out_dir = os.path.join(out_dir, software)
                run_software(software, seq1, seq2, software_out_dir)

if __name__ == "__main__":
    run_all()
