# 加载必要的库
library(ggplot2)

# 读取CSV文件
data <- read.csv("./csv/query_thread_results.csv")

# 绘制美化后的折线图
ggplot(data, aes(x = Threads, y = Average.Query.Time..s.)) +
  geom_line(size = 1.2, color = "#0072B2") +  # 添加折线，使用更柔和的蓝色
  geom_point(size = 4, shape = 21, fill = "#D55E00", color = "black") +  # 添加带黑色边框和橙色填充的数据点
  labs(title = "Comparison of Block Sparse Table Query Time\n across Different Numbers of Threads",
       x = "Number of Threads", 
       y = "Average Query Time (s)") +
  scale_x_continuous(breaks = seq(1, 16, 1)) +  # 设置X轴刻度
  theme_minimal(base_size = 16) +  # 设置简约主题和字体大小
  theme(
    plot.title = element_text(hjust = 0.5, size = 22, face = "bold", color = "#0072B2"),  # 标题加粗并居中，使用蓝色
    axis.title.x = element_text(size = 18, face = "bold"),  # x轴标签加粗
    axis.title.y = element_text(size = 18, face = "bold"),  # y轴标签加粗
    axis.text = element_text(size = 14),  # 调整轴文本字体大小
    panel.grid.major = element_line(size = 0.5, linetype = 'solid', color = "grey80"),  # 添加主要网格线
    panel.grid.minor = element_line(size = 0.25, linetype = 'dotted', color = "grey90"),  # 添加次要网格线
    panel.background = element_rect(fill = "white", color = NA)  # 使用白色背景
  )

# 保存美化后的折线图
ggsave("./plot/query_time_thread.svg", width = 10, height = 6)
