library(tidyverse)
library(parallel)

# SVs
qtls <- mclapply(
  list.files(pattern = "models.*tsv.gz"),
  function(p) read_tsv(p) %>% filter(term == "sv") %>%
              separate(cpgi_name,
                       into = c("bin_chrom", "bin_start", "bin_end"),
                       convert = T, remove = T, sep = "_") %>%
              separate(sv_name,
                       into = c("sv_chrom", "sv_start", "sv_end", "allele"),
                       convert = T, remove = T, sep = "_"
  ) , mc.cores = 22, mc.preschedule = T) %>%
  bind_rows()

qtls$adj.p.value <- p.adjust(qtls$p.value, method = "fdr")

print("Writing")
mclapply(1:22, function(gchrom) {
  qtls %>%
    filter(sv_chrom == paste0("chr", gchrom)) %>%
    write_tsv(paste0("1.qtls_MAF5_chr", gchrom, ".tsv.gz"))
}, mc.cores = 22, mc.preschedule = T)

pvalues_sig <- qtls %>% filter(adj.p.value <= 0.05)
pvalues_sig %>% write_tsv("SV_mQTLs_p005.tsv.gz")


# SNPs
library(tidyverse)
library(parallel)

# args = commandArgs(trailingOnly = TRUE)
# gchrom = args[1]
# gchrom_out = args[2]

pvalues <- mclapply(list.files(pattern = "genotype_methyBin*"), read_tsv,
  #
  # , function(p) { read_tsv(p) %>%
  #              separate(binId,
  #                       into = c("bin_chrom", "bin_start", "bin_end"),
  #                       convert = T, remove = T, sep = ":") %>%
  #              separate(snpId,
  #                       into = c("snp_chrom", "snp_start"),
  #                       convert = T, remove = T, sep = ":") },
  mc.cores = 22, mc.preschedule = 22
)
N <- pvalues %>%
  lapply(nrow) %>%
  unlist() %>%
  sum()

N_df <- pvalues %>% mclapply(function(df) {
  df$adj.p.value <- p.adjust(df$pvalue, method = "fdr", n = N)
  df
}, mc.cores = 22, mc.preschedule = T)

pvalues <- pvalues %>% lapply(function(df) { df$adj.p.value <- p.adjust(df$pvalue, method = "fdr", n = N); df })


print("Writing")
mclapply(1:22, function(gchrom) {
  pvalues[[gchrom]] %>%
    write_tsv(paste0("snps_chunk_", gchrom, ".tsv.gz"))
}, mc.cores = 22, mc.preschedule = T)


write_tsv(pvalues %>% filter(adj.p.value <= 0.05), gchrom_out)
