import sys
import gzip
import itertools

cpgs_index = gzip.open(sys.argv[1], "r")
cpgs_index.readline()

cpgs = dict()

mc_files = open(sys.argv[2], "r")

for line in cpgs_index:
    node, pos, strand = line.decode().split()
    pos = int(pos)
    if not node in cpgs:
      cpgs[node] = dict()


    if not pos in cpgs[node]:
        if strand == "+":
            cpgs[node][pos] = 0
        elif strand == "-":
            cpgs[node][-pos] = 0

for f in mc_files:
    mcf = open(f.rstrip(), "r")
    for line1, line2 in itertools.zip_longest(*[mcf]*2):
        fields1 = line1.split()
        node1 = fields1[0]
        pos1 = int(fields1[1])
        strand1 = fields1[2]
        depth1 = float(fields1[3])
        score1 = float(fields1[4])

        fields2 = line2.split()
        node2 = fields2[0]
        pos2 = int(fields2[1])
        strand2 = fields2[2]
        depth2 = float(fields2[3])
        score2 = float(fields2[4])

        if strand1 == "+":
            pos1 = abs(pos1)
        elif strand1 == "-":
            pos1 = -abs(pos1)


        if strand2 == "+":
            pos2 = abs(pos2)
        elif strand2 == "-":
            pos2 = -abs(pos2)

        if depth1 + depth2 == 0:
            continue

        score = (score1 * depth1 + score2 * depth2) / (depth1 + depth2)
        if node1 in cpgs and node2 in cpgs and \
           pos1 in cpgs[node1] and pos2 in cpgs[node2] and \
           score >= 127 and \
           (depth1 + depth2) >= 5:
            cpgs[node1][pos1] = cpgs[node1][pos1] + 1
            cpgs[node2][pos2] = cpgs[node2][pos2] + 1
    mcf.close()

for node in cpgs:
    for pos in cpgs[node]:
        strand = "+"
        if pos < 0:
            strand = "-"
        if cpgs[node][pos] > 0:
            print(node, str(abs(pos)), strand, str(cpgs[node][pos]))
