# Preprocessing: 01_preprocessing_nanorcs

## Introduction
NanoRCS is composed of nanopore sequencing of RCA-enhanced cfDNA molecules. Each nanopore read contains multiple 
repeats of the same cfDNA fragments. Consnesus algorithm is applied to generate a consensus sequence from multiple 
repeats on the same nanopore read.

How you can apply consensus algorithm is detailed in section (I).

You could also find the code for raw nanorcs error rate (II) we take the first repeat of each nanorcs read, 
to resemble error rate of native cfDNA sequencing. 
- Related to Fig 2A, Suppl Fig 2A, Fig 5, Suppl Fig 2, Suppl Fig 8, Suppl Fig 10, 


## I. Generating Consensus NanoRCS bam files for all downstream analysis
1. Consensus bam files used in the manuscript was generated by a stable version tag 0.9.0 of [cyclomicsseq pipeline](https://github.com/cyclomics/cyclomicsseq/releases/tag/0.9.0). 
2. An example submission can be found as below:

```angular2html
# Define parameters
REF="/path/to/ref/genome.fa"
SAMPLE="SAMPLE_NAME"
RUN="RUN_NAME"
BACKBONE="BACKBONE_NAME"
INPUT="/data/raw_data/GWC/${RUN}/pass"
OUTPUT="/path/to/output/processed_data/01_preprocess_nanorcs/consensus/${SAMPLE}_${RUN}"

# Run command with nextflow
nextflow run cyclomics/cyclomicsseq -r 0.9.0 --report false \
--roi_detection.min_depth 10000  \
--roi_detection.max_distance 0 \
--bwamem.readgroup $RUN \
--bwamem.sampletag $SAMPLE \
--output_dir $OUTPUT \
--backbone $BACKBONE \
--input_read_dir $INPUT \
--reference $REF \
--sequence_summary_tagging true \
--sequencing_quality_summary $INPUT/sequencing_summary.txt \
-with-report $OUTPUT/nf_report.html \
-with-trace $OUTPUT/trace.txt \
--max_mem_gb 64 
```
3. Downstream filtering: A snakemake workflow in this folder can be used for downstream filtering. After acquiring bam files from the standard cyclomicsseq bioinformatics pipeline, a specialized pipeline 
to separate reads with backbone and reads without backbone was applied. This downstream filtering can also merge 
multiple runs with same sample name and continue the analysis for the merged file. Please continue in
`consensus_nanorcs` folder, where you will find a snakemake workflow.
4. Install snakemake in your environment (installation suggestion see snakemake website: https://snakemake.readthedocs.io/en/stable/getting_started/installation.html)
5. Create (a) a samplesheet and (b) a configfile in folder `consensus_nanorcs/configs` accordingly.
6. An example snakemake submission script at the folder `consensus_nanorcs`:
```angular2html
snakemake --configfiles configs/config_example.yaml
```
7. Expected output folder is defined in configs/config.yaml. As an example, we designed the output folder at 
`NanoRCS/output/01_preprocess_nanorcs/consensus_filtered`. 
8. Bam files for downstream analyses will appear within this folder with filenames: `NanoRCS/output/01_preprocess_nanorcs/consensus_filtered/final_bam/*_clean_merge_runs.bam`. Downstream analyses take bam files from here. 
9. Library complexity estimation for Suppl. Fig 1 will appear at `NanoRCS/output/01_preprocess_nanorcs/consensus_filtered/bam_complexity`. Plotting scripts can be found in folder `10_figures`.

## II. Raw NanoRCS bam files for SNV error rate (Fig 2A). Folder:  raw_nanorcs_error_rate

1. From fastq -> bam, use Snakemake pipeline in `raw_nanorcs_error_rate` after updating `config.yaml`. 

2. From bam with all alignments -> bam with only first alignment
   1. Use first_align_nanorcs_wrapper.sh to submit `first_align_nanorcs.py` per chromosome.
   2. For slurm parallel submission option: check `first_align_nanorcs_wrapper.sh` and 
`first_align_nanorcs_parallel_submission_exmaple.sh` 

3. Export bam files to `./output/processed_data/Fig2A_raw_nanorcs/`, continue in folder `03_snv_error_rate`.