#!/usr/bin/env perl
use strict;
use Getopt::Long;
use MCE::Child;
use MCE::Channel;


#### Align probes to local assembly ####
#### Return position in assemble ":" probe
#### Positions surrounding the breakpoint to be used for MAAFT - index + parents


# Read input and output file names from command line
my ($ref_file, $output_file5) = @ARGV;
if ($#ARGV != 2)
{
    print "Input and output files should be specified.\n";
}



my $chnl = MCE::Channel->new( impl => 'Simple' );

#spin up worker early before creating big hash---------
mce_child
{
    local $SIG{__WARN__} = sub {};
    while ( my ($cmd, @args) = $chnl->recv ) {
        local ($?, $!);
        system($cmd, @args);
        $chnl->send2($?, $!);
    }
};

sub syscmd {
    my $cmd = shift;
    return unless $cmd;

    $chnl->send($cmd, @_);
    my ($status, $errmsg) = $chnl->recv2;
    
    if ($status == -1) {
        print "SYSTEM: failed to execute ($cmd): $errmsg\n";
    }
    elsif ($status & 127) {
        printf "SYSTEM: $cmd died with signal %s, %s coredump\n",
            ($status & 127), ($status & 128) ? 'with' : 'without';
    }
    else {
        #printf "SYSTEM: $cmd exited with status %d\n", $status >> 8;
    }
}   

### To be changed - or make option
#my $output_file5  = "/users/erika/Desktop/22q11_50994_full_shasta_hapdup_phased_2_hg38_22q11_contig_786_2_2.txt";
#"11029A_8gg_HAP1.txt";
open(OUTPUT, ">" .$output_file5) or die "\nCan't open file $output_file5, $!\n";

### Assembly is specific to 22q11 sample (cf local de novo assembly Nicolas)
#my $ref_file = "/media/nicolas/Data/Mappings/Perl/NOVOLoci/22q11/Apes/GCF_000001405.39_GRCh38.p13_genomic.fna.gz";
#my $ref_file = "/Users/erika/Desktop/22q11_50994_full_shasta_hapdup_phased_2_hg38_22q11_contig_786_2_2.fasta";
#my $ref_file = "/Users/erika/Data/sftp_VSC_stg00113/nanowgs_map_assembly/22q11.fasta";
#"/Users/erika//Desktop/22q11_44064_shasta_hapdup_phased_1_hg38_22q11_contig_1100.fasta"; 
#"/home/luna.kuleuven.be/u0133570/Perl/assembly_11029A_22q11_8_HAP1.fasta";

my $FILE_REF;   
#open ($FILE_REF, '-|', 'gzip', '-dc', $ref_file) or die "Can't open file $ref_file, $!\n";
open ($FILE_REF, $ref_file) or die "Can't open file $ref_file, $!\n";

#open ref file----------------------------------------------------------------------------------------------------------------------------------
my $chromosome = "";
my $chromosome_length = '0';
my $sequence_prev = "";

my %probes;
my %probes2;

my %full_seq;
#$full_seq{"A1_BLUE"} = "TTTCTAGATTGACCACTCAGGAGTTACTCTGGCCTCCCCTTCACTCCTGCTAGACTGAAAACAAGGACAGACTTGCCTGGCCTCTCTCCCCGAGTAGACACCTACCCCCAGTGAACACATCCTGTCAGTGTCCTCCCGTCTATTTGCAAATTGATTGACTGTTTCATTGCTGGCCTTGGATGACCTCTCCTAGAGGGCAGGGACGGTGGTGTTCGGCAAAGCCTTGGTCGTCTGGATAATGGGAAATGGGGTCTTCTGGTGAATTTAATTACAGGGTTAGGTGGAAACTTTGCTTCAACTCTCATTATTAGAAAGTCTATTGTAAAGCTTTTTAAAATACAACTGACCACTTTCCAGCGAGGGTAGAGTTAATATGCCTTAATCTTTGATTTAGGATCTTGCAGTGCCCCAGGCTCACCATTCTCTTCTGCTACTATAATTATAGATGCGGAAGACATACAGACTGGGCTGACGACTGCTTGGAAGCTAATTTCTAGAATAAACCCTTGCTACCACATCTTGTGATTTTTGCCCTTCTGAAGGTGGAGTTCCAAAATAAAAACAAAATCCCGCTTAACTGAGGGTTCCAGTTGAGGGAGGTCTGCTGCCATGGTCTTTGTTAAGTGCCTGCCACCATGGCCCACAATTAGTCAGTTAATAAAGGGTTCTTGATGAGAGAATTTGGCAACATGTGATTTTCCACAAATATAAGCTTGATTTTGATGCAACCACTCATTTCTTTGAAAAATCAGGGGGCATTCACACACAGGTGTTCTAGATTTCCTTACAGTAAAACCTACCCTTTACAAGGAATAGCTGTGTTCACTTTGAAGCAGTAAAGAAGCAGGTGTCCACTCATGGCAAATGAGGAACTCCCTTTTTTTTTTTTTTTTTTTGAGACGGGGTCTCACTCTTTTTTTGTGTGTGTGAGATGGGGGCCACCCAGGCTAGAGTGCAGTAGTGCAATTACAGCTCACTGTAGCCTCAACCTTCTGGGCTCAACCAGTTCTTCCCACCTCAACTTCTGAAGCAGCTGAGACTACAGGTATGTACCACCATGCCCAGGTAATGCTTTTGATTTTTAGTAAGATGAGGTCTTGTTATATTGCCCAGGCTGGTCTCAAACTCCTGAGCTCAAGTGATCCTCCTGCCTCAGTGGCATGAGCCACTATGCCCAGCCAGAAGCTAAAAATATTAATCAAGGAGTCATAACTAAGGATGCACTGCACACCCGAAGCCAGGGACCACAAGAGGTCAGCAACTGGGACTGCTTCCTCCAGTTCCCAGGCTGGGGCTCAGCAGCAGTGGCCTGGGCTCTGGGGACTTACTTTAAGCCGAAATCCCAAACTCATTATCATTCAAACCAATTTTCTGTGTCCAGCATCATCCCACCTAAACTGGTCCTTAAAACCACTGACAGTCATTTCTCCAATCTGTAAAAGGCCTGCTGAGGCCTTTGCATTATCAGGACTTAACTGGGAGTAGAATGCCCTCCCCATCCAAATCCTGACCATTTCTGAACACTCAGCCCATGTCCTCTTCCTGAGTGTCTTCCCCAACAACAACCACCTACGCTGAACTTTACTTTGATCTCTGCAGCAAACTGTAGATAGAGATGGGATCTCACTATGTTGCCTAGCTGGTCTTGAACTACTGAGCTCAAGTGATCTCCCTGCTTCTGCCTCCCAAAGTGCTAGGATTACAGCAGTGAGCCACCACACCTGGCCTATGTATGCCTTTTTTTTTCTTTTCTTTTTTTTTTTTTTTGAGACAGAGTCTTGCTCTGTGGCCCAGTCCGCAGTGCAGTGGTGCAATCTCGGCTCATGGCAACCTCCAGGTTCAAGGCATTTTCCTGCCTCAGCCTTCCAAGGAGCTGGGATTACAGGCACGCACCATCACGCCCAGCTAATTGGCCAGGCTGGTCTCAAACTCCTGACCTCAGGTGATCCACCCACCTTGGCCTCCCAAAGTGCTGGGATTACAGGTGTAAGCCACCACACCCGGCCACGTGTGCATTTTAAAACGTTATGCTCAGACGGGGTCTATAGGTTTCACCAGACTGCCAAAAGGATCCATGACACAAAAAAAGTACTCTCAGTTGCATCCTTCGGAACCTTTCAACACATACACATATACCTCACTCATCCTTTTGTGAAGAGTGTCTATTAATCACTAGATTAAGAGGATTTGGATAAAATTTATAAACGTACAAACTTTGCTACCAAGGACTGACACATTTACTTTTCTAGCTCATCAGTTTATGTCCTAGAAAAATTCCAGAGCCATATTAACCAGCTGTTTCCTATTTTTCATTTTACGATGGTGTTTCCACTTTCACCTGCAAAGTGACTAATAGTAATACCTATTACAGTAATTTAAGTAACACCATTTAGAGTAATTTCATCTTTAGTACTGTATTTATACTACTAAGAAAGCCGCCAACGATTCAAGCTGCACTCACTGGTGAAACCCTATGCTATATACGTAATTAATTTATTTCCTAAATTCTTACCTCCCTCCACCCCCTCCATTGGAAAATAAACTCTAAGAATGCAAAAGTTTTTGTGTGTTTTTCTTCAACGCTTAGAGCAGTGCCTGGCACCTAACAGTCAATATCTGCTAACTTTGATGAATGAATGGTATATTTATATTATGCAATATTACTATGCAGCCATGAAACACAATGAGTTAGAGTGGTACCAGCTAATTTAATGGAATTTCCAGAAGTATGAAATTAAGAAAACAAGAAGAAAAGTGTCAAAAATATCATCCCACTTTTTTTTTCTTCCCTGAAACGGAGTCGTGCTCTGACACCCAGGCTACAGTATAGTGCTGCCATCATGGCTCACTGCAACCTCAACCTTCTGGGCTCAGGGAATCCTTCCACCTCAGCCTCCCATGTAGCTGGGACTACAGGTGTGTGCCACAACGCCCAGCTAATTTATTTTAAATTATTTTTTGTAGAGACAGGGTCTCCCTATGTTGCCCAGGCTGGTCTCAAACTACTAGGCTCAAGTGATCCTCCCACCTCAGCTTCCCAAAGTGTTGGGATTACAGGTGTGAGCCACTGTGCCCAGCCTAATCCCACTTTTTAAAAAGTATACCCCCAAATCCATACACTGGTGAGGAAGTGGAGAACGTGGAATCCTCACACACAGAATGTAAAATGGTACAGCTCTGGAGAACATTTTAGCAGTTTCTCAAAATGTTTAACGTAGCTACTACATGACCCAGCAATTCAACTCCCAGATATACACCTGAGAGAACTGAAAGGATATGTCCACACAAAAATTTGCAGAGGAACTTGTACACACTTGTTCACAGTAGCATTATTCATAATAGCCCAAAGTGGCAAAAACACAAATGTTCATCAACTGATGGACAAATAAAGCATGAACAACTGATGGACAAATAAAGTATATCATTCAGCATATAAGAAATGAAGTGCTAATACATGCTACAACAGGAATAGACCTTAATAACATTTTGCTAAATGAAAAAAGCCAAACAAAAGGTCACATGTTGTATGATTCCATTTACATAAAAATACCTAGACTAGGCAAATCCGTAGAGACACAAAGATCAGTGACTGCCCAGAGCCAGAGGGAGTGGTGAATGTGAAATGGCTGCTAATGAGTACAGACTTCTTTTTGAGGTATTGAACATGTTATGGAATCAGATGGTGGTGATCAATGCATAACTTTGTGAATATACCAAAAACCACATGAAAGGTACACTTTAAAAGCCTGAATTTTAAGGTATGTGAATTGTATCTCCATAAACCTGTGATTTTGTTAATATACGCTTATTTGCAAACGAATACATGGATAATGAGGAATAATATGAAAGGTTAATGACAACCTTGGTGATAGGGTACAGGAGACTGGGAGAGGAAGATAAGTGTTGAGGTAGAAGAAGACAAAAAATAAAAGGCTAAAACAATAATCCAGGGCCAGAGGCCATGAGTTGGGAGATGGAGCAAGACGAAGTGTACAAAGAAATGAGCATAAATCATAAAAATGAGGGAACTAGGGTTGAAAACTCCAGCAAGTAGTTTGTAATGGGGGAGATGAAGCAAACCTAAGTAACTGCAATGATTCAACGGAATTTGCAGAAAATGCAGAAGGGCGAGAAAACAATGAAAAAATGGATCAGAAGATTTAAAATTGGCTCTACCCCACCAAAGTTTTAAAAAGCAAGCAAGAAGAAAATTCAGTTGCTCCTGGGCAAGAATTCTTGGGCCCAGTGGGGTAGAACCAAACCATGATAAGGAGACACCAGTGTTTTGTAAGCAAGAGAATATATTAAGGAGAGAAAAGGGGCATTTATTGGGAGAAAAGTTCTCACTGTGATTGTTCTGGACTAAAGTAGCCCCATCGGACTGCCTCAGGAACTCATGGTGGAAGAGGTGCCACTGGAAAATGGCTAAGTCGGGATCTTCCCCAAGAACACTAGAAGAGACAGAGGAAGAATAGAAGAGCTTTAAATTTTAGCAGATATTTCTTTTTCTTGTTTAATTAAAATAAATCTTATTGACCTAATATTTTTGAGACTGGGCTCTTGCAATGCTCCCCAGACTGAACTCAAACTCCTAGGCTCAAGAGATTCTTCCACTTCAGCCTCCTGAAAAGCTGGCACTACAGGTGCACACCACTGGGCCCAGCATAATGGCTATTTCTTGACAAATCTTGACAATGCCACCAGTATGTTTTTCTTTAGAGACAGAGTCTCGCTTTGTAGCCCAGGCTGGAGAACAGTGGTGTGATCCTAGCTCACTGCAGCCTCAAACACCTGGACTCAGGAGATCCCCCTGCCTCAGCCTCTCAAGTAGCTGAGACTACAGGTGCGCACCACCACACTTGGCGAATTTTATTTTATTTTTTTTATTATACTTTAAGTTCTAGGGTACATACACCTGGCTAATTATAAAATGTTTATCTGTACAGACAGGTTCTCGTTATGTTGCCCAGGCTGGTCTCGAACTCTCGGCCTCAAGCAATCCTCTCCTCCTCACCTTCCAAAGCCCCGAAATATGCCCACATCCAGCCTGCCACCAGTTTCTTTGCATACTTCTTTCCTAGGCTTGACCAAGACCTTTACTTTCTTCTGTGTACAGCTCAGCATTAAAAAAAAACAAAAAAGTTTAGGCTGGGCACAATGGCTCACGCCTGTAATCCCAACACTTAGGGTGGCCAAGGTGGGAGGTTTGCTTGAACCCAGGAGTTCCACACCAGCCTAGGCAAGATGGCAAGACCACGTCTCTCCAAAACAATTTTTGTAAAATTAGCCAGGTGTGCTGGCGTGGGCCTGCAGTCTCAGCTAGTGAGAAGACTAAGGCAAGAGGAACCCTTGAACCCAGGAGTTCAAGGCTACGGTGAGCTGTGATCACCTCTCCAGCCTGGGTGATAGGGTGAGACCCAGTCTCTGAAAACAATTAAAAATAAAAAAAGTTGAATAATGAGTCTTCTTTTTAGAGGCAATGTATTTTTCCTCTTTAACTTTTTGTTTTCCTTAGGCTATATGCACAATAGACAAAGTTGAAATTTAATCTTAATCTCGTAAACCCTTACTGTCCAAACACATCAAACTCAAAAAAAAAAAAAAGACAAAAACAAAAAAGGTGAAAGGTGTACAAGAGAAAAAAGGGAAGTAATCTGTGCCAAATGTACATTCCTTCCACAATTTGGGACAAAAATGATGTCTACCTGGTCTCTGGGTGCCAAAATAAGACATTAGAGACACTCCCCTCCTTCAAGAAATAAAATTGGAATCAGACACTAAGATACAATTAAACAGACTTTGAAAGTTGGTATGCACTACTGGGAGGTGTCTCACAGCTGGCAGGGTCAACTGCAACTAGAAGAAAAG";
$full_seq{"A1_BLUE"} = "ACCTACCCCCAGTGAACACATCCTGTCAGTGTCCTCCCGTCTATTTGCAAATTGATTGACTGTTTCATTGCTGGCCTTGGATGACCTCTCCTAGAGGGCAGGGACGGTGGTGTTCGGCAAAGCCTTGGTCGTCTGGATAATGGGAAATGGGGTCTTCTGGTGAATTTAATTACAGGGTTAGGTGGAAACTTTGCTTCAACTCTCATTATTAGAAAGTCTATTGTAAAGCTTTTTAAAATACAACTGACCACTTTCCAGCGAGGGTAGAGTTAATATGCCTTAATCTTTGATTTAGGATCTTGCAGTGCCCCAGGCTCACCATTCTCTTCTGCTACTATAATTATAGATGCGGAAGACATACAGACTGGGCTGACGACTGCTTGGAAGCTAATTTCTAGAATAAACCCTTGCTACCACATCTTGTGATTTTTGCCCTTCTGAAGGTGGAGTTCCAAAATAAAAACAAAATCCCGCTTAACTGAGGGTTCCAGTTGAGGGAGGTCTGCTGCCATGGTCTTTGTTAAGTGCCTGCCACCATGGCCCACAATTAGTCAGTTAATAAAGGGTTCTTGATGAGAGAATTTGGCAACATGTGATTTTCCACAAATATAAGCTTGATTTTGATGCAACCACTCATTTCTTTGAAAAATCAGGGGGCATTCACACACAGGTGTTCTAGATTTCCTTACAGTAAAACCTACCCTTTACAAGGAATAGCTGTGTTCACTTTGAAGCAGTAAAGAAGCAGGTGTCCACTCATGGCAAATGAGGAACTCCCtttttttttttttttttttgagacggggtctcactctttttttgtgtgtgtgagatgggggccacccaggctagagtgcagtagtgcaattacagctcactgtagcctcaaccttctgggctcaaccagttcttcccacctcaacttctgaagcagctgagactacaggtatgtaccaccatgcccaggtaatgcttttgatttttagtaagatgaggtcttgttatattgcccaggctggtctcaaactcctgagctcaagtgatcctcctgcctcagTGGCATGAGCCACTATGCCCAGCCAGAAGCTAAAAATATTAATCAAGGAGTCATAACTAAGGATGCACTGCACACCCGAAGCCAGGGACCACAAGAGGTCAGCAACTGGGACTGCTTCCTCCAGTTCCCAGGCTGGGGCTCAGCAGCAGTGGCCTGGGCTCTGGGGACTTACTTTAAGCCGAAATCCCAAACTCATTATCATTCAAACCAATTTTCTGTGTCCAGCATCATCCCACCTAAACTGGTCCTTAAAACCACTGACAGTCATTTCTCCAATCTGTAAAAGGCCTGCTGAGGCCTTTGCATTATCAGGACTTAACTGGGAGTAGAATGCCCTCCCCATCCAAATCCTGACCATTTCTGAACACTCAGCCCATGTCCTCTTCCTGAGTGTCTTCCCCAACAACAACCACCTACGCTGAACTTTACTTTGATCTCTGCAGCAAACTGTAGAtagagatgggatctcactatgttgcctagctggtcttgaactactgagctcaagtgatctccctgcttctgcctcccaaagtgctaggattacagcagtgagccaccacacctggccTATGTATGCCtttttttttcttttctttttttttttttttgagacagagtcttgctctgtggcccagtccgcagtgcagtggtgcaatctcggctcatggcaacctccaggttcaaggcattttcctgcctcagccttccaaggagctgggattacaggcacgcaccatcacgcccagctaattggccaggctggtctcaaactcctgacctcaggtgatccacccaccttggcctcccaaagtgctgggattacaggtgtaagccaccacacccggccACGtgtgcattttaaaacgttatgctcagacggggtctataggtttcaccagactgccaaaaggatccatgacacaaaaaaagtACTCTCAGTTGCATCCTTCGGAACCTTTCAACACATACACATATACCTCACTCATCCTTTTGTGAAGAGTGTCTATTAATCACTAGATTAAGAGGATTTGGATAAAATTTATAAACGTACAAACTTTGCTACCAAGGACTGACACATTTACTTTTCTAGCTCATCAGTTTATGTCCTAGAAAAATTCCAGAGCCATATTAACCAGCTGTTTCCTATTTTTCATTTTACGATGGTGTTTCCACTTTCACCTGCAAAGTGACTAATAGTAATACCTATTACAGTAATTTAAGTAACACCATTTAGAGTAATTTCATCTTTAGTACTGTATTTATACTACTAAGAAAGCCGCCAACGATTCAAGCTGCACTCACTGGTGAAACCCTatgctatatacgtaattaatttatttcctaaattcttacctccctccaccccctccattggaaaataaactctaagaatgcaaaagtttttgtgtgtttttcttcaacgcttagagcagtgcctggcacctaacagtcaatatctgctaactttgatgaatgaatggtatatttatattatgcaatattactatgcagccatgaaacacaatgagttagagtggtaccagctaatttaatggaatttccagaagtatgaaattaagaaaacaagaagaaaagtgtcaaaaatatCATCCCACtttttttttcttccctgaaacggagtcgtgctctgacacccaggctacagtatagtgctgccatcatggctcactgcaacctcaaccttctgggctcagggaatccttccacctcagcctcccatgtagctgggactacaggtgtgtgccacaacgcccagctaatttattttaaattattttttgtagagacagggtctccctatgttgcccaggctggtctcaaactactaggctcaagtgatcctcccacctcagcttcccaaagtgttgggattacaggtgtgagccactgtgcccagccTAATCCCACTTTTTAAAAAGTATACCCCCAAATCCATACactggtgaggaagtggagaacgtggaatcctcacacacagaatgtaaaatggtacagctctggagaacattttagcagtttctcaaaatgtttaacgtagctactacatgacccagcaattcaactcccagatatacacctgagagaactgaaaggatatgtccacacaaaaatttgcagaggaacttgtacacacttgttcacagtagcattattcataatagcccaaagtggcaaaaacacaaatgttcatcaactgatggacaaataaagcatgaacaactgatggacaaataaagtatatcattcagcatataagaaatgaagtgctaatacatgctacaacaggaatagaccttaataacattttgctaaatgaaaaaagccaaacaaaaggtcacatgttgtatgattccatttacataaaaatacctagactaggcaaatccgtagagacacaaagatcagtgactgcccagagccagagggagtggtgaatgtgaaatggctgctaatgagtacagacttctttttgaggtattgaacatgttatggaatcagatggtggtgatcaatgcataactttgtgaatataccaaaaaccacatgaaaggtacactttaaaagcctgaattttaaggtatgtgaattgtatctccataaacctgtgattttGTTAATATACGCTTATTTGCAAACGAATACATGGATAATGAGGAATAATATGAAAGGTTAATGACAACCTTGGTGATAGGGTACAGGAGACTGGGAGAGGAAGATAAGTGTTGAGGTAGAAGAAGACAAAAAATAAAAGGCTAAAACAATAATCCAGGGCCAGAGGCCATGAGTTGGGAGATGGAGCAAGACGAAGTGTACAAAGAAATGAGCATAAATCATAAAAATGAGGGAACTAGGGTTGAAAACTCCAGCAAGTAGTTTGTAATGGGGGAGATGAAGCAAACCTAAGTAACTGCAATGATTCAACGGAATTTGCAGAAAATGCAGAAGGGCGAGAAAACAATGAAAAAATGGATCAGAAGATTTAAAATTGGCTCTACCCCACCAAAGTTTTAAAAAGCAAGCAAGAAGAAAATTCAGTTGCTCCTGGGCAAGAATTCTTGGGCCCAGTGGGGTAGAACCAAACCATGATAAGGAGACACCAGTGTTTTGTAAGCAAGAGAATATATTAAGGAGAGAAAAGGGGCATTTATTGGGAGAAAAGTTCTCACTGTGATTGTTCTGGACTAAAGTAGCCCCATCGGACTGCCTCAGGAACTCATGGTGGAAGAGGTGCCACTGGAAAATGGCTAAGTCGGGATCTTCCCCAAGAACACTAGAAGAGACAGAGGAAGAATAGAAGAGCTTTAAATTTTAGCAGATATTTCTTTTTCTTGTTTAATTAAAATAAATCTTATTGACCTAATAtttttgagactgggctcttgcaatgctccccagactgaactcaaactcctaggctcaagagattcttccacttcagcctcctgaaaagctggcactacaggtgcacaccactgggcccagcATAATGGCTATTTCTTGACAAATCTTGACAATGCCACCAGTATGtttttctttagagacagagtctcgctttgtagcccaggctggagaacagtggtgtgatcctagctcactgcagcctcaaacacctggactcaggagatccccctgcctcagcctctcaagtagctgagactacaggtgcgcaccaccacacttggcgaattttattttattttttttattatactttaagttctagggtacatacacctggctaattataaaatgtttatctgtacagacaggttctcgttatgttgcccaggctggtctcgaactctcggcctcaagcaatcctctcctcctcaccttccaaagCCCCGAAATATGCCCACATCCAGCCTGCCACCAGTTTCTTTGCATACT";
#$full_seq{"A2_GREEN"} = "TGACATCAGTGGTGTCAAGACAACTCTAAGAAGGTTTTCCGTGATCCTGCAAGCCCTGCCTTCCTTCCTGGGATCCTGCCTTCAATTTGATTGCACAGGTACCACAGCAAGCCAGTGCTGTGTGCTCCGAGTTCCAGGGCGTCCTCCAGCTCAGCCACTGCACTGAGAACATGGACTCTCTGTGGGGCCCAGGAGCCGGGAGTCACCCCTTTGGGGTCCACAACACCCGGCTGTCCCCAGACTTGTGTCCAGGGAAGATAGTGTTGAGGGCCCTCAAGGAGAGCGGGGCAGGGATGCCTGAGCAGGACAAGGACCCTAGAGTCCAAGAGAATCCTGGTGATCAGAGAAGGGTCCCCGAGGTCACCGGGGATGCACCGTCTGCATTTCGGCCCCTGCGGGACAATAGAGGCCTCTCTCCCTTTGTGCCCGGGCCCGGGCCTCTGCAGACAGACCTCCATGCCCAGAGGTCAGAAATCAGATATAACCAGACATCCCAGACCTCCTGGACGAGCTCCTGCACCAACCGAAATGCCATCTCCAGCTCCTACAGCTCCACGGGAGGCTTGCCGGGGCTAAAGCGGAGGAGGGGGCCAGCCTCATCCCACTGCCAGCTGACCCTCAGTTCCTCAAAGACAGTGAGTGAGGACAGGCCTCAGGCTGTCTCTTCAGGTCACACCCAGTGTGAAAAGGCAGCAGATATAGCACCAGGGCAGACACTCGCCCTCAGGAATGACTCCTCCACATCCGAGGCCTCTAGGCCCAGTACACACAAGTTTCCCCTGCTGCCACGCAGGCGAGGGGAGCCTTTGATGCTGCCACCTCCCTTAGAGCTGGGGTACCGGGTCACTGTTGAAGACCTGGACCGGGAGAAGGAGGCGGCATTCCAGCGCATCAACAGTGCACTGCAGGTTGAGGACAAGGCCATCTCGGACTGCAGACCCTCACGACCTTCCCACACTTTGTCCTCACTTGCAACAGGGACTTCTGGTCTGCCTGCCATTTCTAAAGCACCCAGTATGGATGTACAGCAGGAGACACACAAGTCCCAAGACTGCCTGGGCCTACTGGCCCCCTTAGCATCTGCTGCAGGTGTCCCCTCTACAGCTCCCATGTCTGGGAAGAAGCACAAACCACCAGGCCCCCTGTTCTCCTCCTCAGATCCCCTTCCTGCCACCTCTTCCCATTCCCAGGACTCAGCCCAGGTCACCTCGCTGATTCCTGCCCCCTTCCCAGCTGCAAGCATGGATGTGGGCATGAGAAGAACAAGGTGTGGCACTTCTGCTCCTGCAGCTGCCGCAGCAGCCCCTCCCCCCTCCACATTGAACCCCACGTTGGGGTCACTACTGGAGTGGATGGAGGCCCTTCACATTTCTGGGCCTCAGCCACAGCTGCAGCAGGTGCCCAGAGGTCAGAACCAGAGATCCCAGACCTCCCGGACCAGCTCGTGCCCCAAACGAAATGCCATCTCGAGCCCCTACCGCTCTACGGGAGGCCTCCCGGAACGAAAGCGGAGAAGGGGGCCAGCCTCATCCCACTGCCAGCTGAACCTCAGTTCCTGAAACACAGTGAGTGAGGACGGACCTCAGGCTGTCTCTTCGGGTCACACCCAGTGTGAAAAGATGGCAGATACAGCACCAGGGCAGACACTCGCCCCCAGGGGTGGCTCCCCCAGATCCCAGGCCTCTAGGCCCTGTAGATGCAAGTTTCCCCTGCTGCCACGCAGGCGAGGGGAGCCTTTGATGCTGCCACCTCCCTTAGAGCTGGGGTACCGGGTCACTGCTGAAGACCTGGACCAGGAGAAGGAGGCGGCTTTCCAGCGCATCAAGAGTGCACTGCAGGTTGAGGACAAGGCCATTTAGTACTGCAGACCCTCACGGCCTTCCCACACTTTGTCCTCACTTGCAACAGAGGCTTCTGGTCTGCCTGCCATTTCTAAAGCACCCAGTATGGATGCACAGCAGGAGAGACACAAGTCCCAAGACTGCCTGGGCCTAGTGGCCCCCCAGCATCTGCTGCACAGGCCTGTAGTCCCAGCTACTCAGGAGGCTGAGGCAGGAGAAGGGCATAAACCCGGGAGGCAGAGCTTGCAGTGAGCTGAGATCGCGCCACTGCACTCCAGCCTGGGTGACAGAGCGAGACTCCGTCTCAAAAAAAAAGAAAAAGAAAAAAAAGTTATTGTGACATTTCTGTATGAAATCAGCCTTCACTACATGGATAGGACCAGCACGCTTCTGCGGCACAACTCTGCAATCATACTACATTTTTTTTTTTGTATTTTTTTTATTCCTTTTGAGACAGAGTCTCACTCTGTCACCCAGGCTGAAGTGCAGCCGAGATCTCGGCTCACTGCAACCTCCACCTCCTGGGTTCAAGCAATTCTCCTGTCTCAGCCTCCCAAGTAGCTGGGACTACAGGCACACGTCAAAAGGCCTGGCTAATTTTTGTATTTTTAGTAGAGATGGAGTTTTGCCATATTGGTCAGGCTGGTCTCGAACTCCTGACCTCAGGTGATCTACCTGTCTTAGCCTCCCGAAGTGCTAGGATTACAGGTGTATGTTTATTTATTTATTTAAGATGGAATCTTGCTCTGTATTTATTAATTTATTTAGTTGAGATGGAGTCTTGCTCCATCACCCAGGCTAGGGTGCAGTGGTGCAATCTCGGCTCACTGCAACCTCTGACTTCCAGTTTCAAGCGATTCTCCTGCCTCAGTGTCCCAAGTAGCTGGGATTACAGGTGCCTGCCACCACAGCTGGCTAATTTTTGTATTTTTAGTAGAGACAGTGTTTCACCATCTTGGCCAGGCTGGTCTCGGGCTCCTGACCTCATGAACCACCTGCCTCAGCCTCCCAAAGTGTTGGGATTACAGGCCTAAGGCACCATGCTCGGCCATATTTATTTAATTATTTAGAGACAAAGTCTTGCTCTGTCACCCAGGCTGGAGTGCAGTGGCGCCATCTCAGCTTACTGCAGCCTCCGTCTCTGAGGTTTAAGCGATTCTCATGCCTCAGCCTCCTGAGTAACTGGGACTACAGGTACTCACCACCATGCAGGGATATTTTTTTCTATTGTTTTATAGAGACACGGTTTCACCATATTGGCCAGGCTGGTCTCGAACTCCTGACCTTAGGTGATCTGACAGCCTCGTCCTCTCAAAGCACTGGGATTACAGGCATGAGCCGCCAAGCCCGGCCTCTCACTACATTTAAGTGACACCATGGCTCATGCCTGTAATCCTAGCACTTTGGGAGGCCAAGGCAGGTGGATCACCTGATGTCAGGAGTTCGAAACGAGCCTGGCCAACATGGGGAAACCCCGTCTCTAGTAAAAATACAAAAATTAGTCAGGTGTGGTGGTACAAGCCTGTAGGCCCAGCTACTTGGAAGACTGAGGCAGGAGAATCACTTTAAGCGGGAGGCAGAGGTTGCAGTGAGCCAATCTCAAAAAAGAAAGAAAAAAAAAAAGAAAAACATATGATGCTGGGGCATCTCGGCCTCAATACCTGCATGAGCACAGTCACGTCCAGGCCAGGGCTGCTGGTCGAGGTCCGGCCCCATCTCTTCCAGCAGAAAGGGAGTAAGCTTGCAGGGAGGCTGGGGGACAAGATCCCAGGATCTCAGCCTCTGCTCATGGATCAGCTCTGAGACCCCGAGTGAGCTGGGGGTGCTCTGTGCGCATTGGTTTCCCCAGCTGTCAAGTAAAGGGATTGGATGAGGAAGTCTTGTCAAGGTGGAATGATCTCAGATTTGGGGCAGCAGTGAATGATCCCGCTCCCTGGGCCCATGCCAGTGGCCTGGCCTCGGCTCAACACAGCCCCAACACTCTGGAATGGGGATGAGGGGGCAGTCAGCTCTTGCTCCTAGTAAGAGAGATGCAACAGGGCTCTGTGGCTGAGCTGGGTGCCTTGCCTCACACCTGTAATCCCAACCTTTGAGAGGCCAAGGCAGGAGGATTGCTCGAGGCCGGGAATTTTGAGAATAGCCTGGACAACATAGCCAGACCCCATGTCTACAAAATAATAATAAAACACACAGCTATAGTCCAAGCTACTTGGCAGGCTGAGGCAGGAAGGTCCCTTGAGTCCGGGAATTGGAGGCTGCATTGAGCTATAATCGCACCACTGCACTCCAGCTTGGGTGACAAAGTGAGACCCTGTCTCTAAAAGAAAAAAAAATTGGCCTGTGAGCATGGGTTTGATTTTCAAACAGGACCTGGAGGGTAGGGACAGACAGTGCTGTCACCCTTAGGTGCTGAACACTCAGAAACGGGCCAGCGGCAGCCCTTCCCTCACCTGCAGACACCAGATTGGGCAGAACAGCACATGGCACTTGCAGCTCTTGCAGTGAGGGCAGAACCCAGTGTCAACCCTTCTGCCTGTGGGAGGGGCTGCTGAGGCCTGCGGAGAGGCCAGGGTGGAGGCTCGTCCCCTTGTCCAGCCCTTGGCGTGGTCTCCACCAGGTCCCCAGCCCACCAGTGCAGGGCGCCCCTGAGCCTGCTGCTGCCATGGGCCCTGTCTCTACCCAGGACGTCCCCACACCCTCGCAGTGTCAGGGAAATGATCATGGTGGCGGTGACACTCCGCAGGCAGGGCTGCTGAGAGAAGCTGAGAAGGGTCACACTGCAGGCAGGGGCCCGTGTGACAAGCCCCTCTCACCCCGAGAGAGCTGACCAGGCAGCTCACGAGCAGAGCCACATCCCGGGAGTCCGAGAAAGGTCCTGGCTGGGCTCAGCCACCTCATTGGCCACGGGCAGCCTTTGTCATGTGAGCCTTGCTCTCCTGGGGAGGCTCAGGCTGACAGCTGATGTGGGCATTGCCGAAGGTAACCCGTGGCCCAGTGTATATGGCCGGGTCTCCTCAAGCTGCATTCATTCAAGTAGGACCCAGGGTGCGTGCCCATCTCCAGCCCAGGGCAGCTCCCCTGTAAGCTGGGTGAGCTACTGAAGCCAAGGCGGGAGGCAGCTGACAACACCCACAGCCCATGCGGAGGTGGTGGAAAGGCTGAACTCAGCAGCAACACCAAATCCTGGACCAGGCAAAAACCACCCAAGACTGAGGGGCTCGTGCCAGAGCGGTGGCCACAGGTAAGAACCCGGGCCCAGGCTGTGTGGCAGGAATCCTCCATGTCCCAGGGCTTAGCATAGCAAAGGAAGACCAGCCGGGTCACCCTGGTGGCCATCTGTCCCTGTCCCACCTGCAGAGTCAGAACAGCCTCTCCCCAGTGGGGATCATCTCTCTCTGCCAAAGCAACAGCGGTCCCTGCCCCAACCAGACTACCCCACTCAGTGGAGTTACGGATGCTGCTCCAGCATCCTAACACTGCCCAGCTGGTGCCTGCCTGTGCTCACCCACACCCCCCAGGCCGGCCTTCCCTGCAGCCTGGGCTTGGCCACCTTGGCCTGATTGAGCACTGAGGCCTCCTGGGCACCCAGCCCCATCACTGCACCTGCTGCTTCCAGCCCCACCCCACCGGCTCAGGGGTTCTTCCCAGCGGCGCTGATCATGAAGTCAACATGCACGCAAGTCGTCTCAGGAAACTTCTTAATGAAAGTGTCGGCCACGGTGGTGTGTAGGTGGCTGAGCTCAGATTGCAGCTGCTAAGACACCAGCCACTTACCAAGAGAAAGCCAGGCTGCTTCAAACCCAGGGCCCACGGCAAAAAAGCATCACTTCCGGCCGGGGAGTCTGGAAGCCACGCCTTGTGGGAGGTCACACTGGCATCTAGGCCTTCGCCTGCATTGCAGAAGGAGAGCCGGGTCCCCCTCCTGGAGAACGCTGCGTTCCCCAGCCCCACACCGGCTTTGCCACCACACAGGCTGTTGAGGCAGGAGGCGGGTAAGACGTAGCTGTAGACCCAAAGCAACCACCAGCCCTGGGACCCTGCGGGAGAGGAGCACTTTTAGAACATGGAAAAGTGTGGTCATCCCATCATTAGACAGCACACATCCTACATAAATAAAAAGTCGTATGGGGAAGGAGGTTGGGGAGGGAATAAAAAATTGGCACAGACATTGATAGACTGGTTTCCAGTTTCAAGGTAACAGATGCACATCATGAGACCAGAGGAGGCAGAGACAAGGCTGGATTTGGCTTTTCTAAGCAACATGTGTTCCTGCGCAGGGCTGAATGGTCGCTGAGACAGAGATGGAAGCCAGGACAAGGGAGCCCACCGGGCCCAGATAGGTACAGAGAGCAGAGGCTCCTGTTCTGTCCTCGCCACCCACGAGGGTGACACTGCTTGTAAATGGTGGCTGTGCTCTCCCAGCAAGAAAAAAGCACAACTAAATCCACACTGCACACAGACGCAGACAGAAAGCCTTCAAGTGGCTCTGTTTTCTGCTCCCTGCCTTGCCAGGTCCACAAGCAGAGAGGAGTGTCAGGCACATGGCCCCGCTGTCAGGCTCCCCAGTGAGCTGCGGGCTCAGCAGGAGCTGCCCACTGACACACAGGGGACACCCACTCCTGCCACCTTGGGAGCGGTTGCCAGACAGAGCCGCACTGGGTGCTGGTGTCATCCAGGGACCCCACACACTTCCTTAAATGTGATCCTGCTTCCCTCTGCGCAGCTGCATCCTCTCCTCCTGCAGGACCGTCTGGAAACTTGGCTCTCAGTTTGCTCTCCCTTCTCTCCTCTGCCTGCCCCAAGCCCCTCTTTCTAAAAAAGTGATGCCATGTTCATGGGGTTATTTCTTGAAAATACTTGGCGGCCTCCATGCTTCTGTTTTCTTTGAGCCAGGTGGTCAGGAGGGCTTACAAACAATGCCTGGGCTCCCCCGCAGCTGTCGGCAGATGGGGTAGCGAATGGTCCTGTGCCTCCACCTGCTCCGGGAGGGAGTCTCCCGTCTCTAGGCCTAGCCCCTTCCTAACCCTCCACGTATCCTGTTCTCCAGAGACTTCAGAACCCACTCCTGAGAACAGCGGAGCCAGGCGCTTAGAGGAAGACCAAATGCTGCCAGGACACGGATTGTCCAGGATTACATTCCAGCATCTTATTAGGTATCTGGATCTGTTGGGGAAAAAATTAGAAACTATGTATAAAACTTAAAAATATTCAAGCATCAAAAGGTTATTTAGGATGAAAGTTTTAAAACAAGTCATCAGCAAGCTGCTACCACCAAGTGGAGACTTATACAAAAGTTGAGCGAGTCCACTGAGCTGAGAGGACAGAAATGAAGTCACCTGTGCTGGGGCAGGGGCAGGGACACTGGGGGCAGGGAGTGTGTGGGCAGAGAAGCCAGAGAAGTCCAGGCCTGTGGAAGCCAAACAGGAGAGCGTGGGCCGGAAGGGCGGTCAGGATCGGGGGACGAGGTCGCTCTCCCTGGAGAACGAACCCTAAGGTGCATAGCCTGGGATTCCCTCCCTGGAGGTCCTGTCCCCCGACATTTCACGGGCCTTCTGAGCTGCCTTCCAAGGAGGACTAACACGGCAACAAAAGAACCATTTCTGCACAAAAATCCTTCTGGGAAGAAAAAGAAGAAAGCCAAGAATGGAGTCAAAACGCTACCCAGTGCTGACTAAGCCTCTCAAACCCTGTTCTAGGTGGACTGTGGTTTCTAAGTCAGGGAAATGGAAGAGGCCCCACCCACACAGGGACAGGGCCATGGCCCCCACAGGATGAAGCAGCAGCGTTTATTCAAGATACAACAGTGAGGGAATCCGGTCACGTTCCCTTCTCCCCAGAGAGGGCGCTTCTTGACAAGTGATTCAGTAGAAATCTTTTA";
$full_seq{"A2_GREEN"} = "AGGGAAGATAGTGTTGAGGGCCCTCAAGGAGAGCGGGGCAGGGATGCCTGAGCAGGACAAGGACCCTAGAGTCCAAGAGAATCCTGGTGATCAGAGAAGGGTCCCCGAGGTCACCGGGGATGCACCGTCTGCATTTCGGCCCCTGCGGGACAATAGAGGCCTCTCTCCCTTTGTGCCCGGGCCCGGGCCTCTGCAGACAGACCTCCATGCCCAGAGGTCAGAAATCAGATATAACCAGACATCCCAGACCTCCTGGACGAGCTCCTGCACCAACCGAAATGCCATCTCCAGCTCCTACAGCTCCACGGGAGGCTTGCCGGGGCTAAAGCGGAGGAGGGGGCCAGCCTCATCCCACTGCCAGCTGACCCTCAGTTCCTCAAAGACAGTGAGTGAGGACAGGCCTCAGGCTGTCTCTTCAGGTCACACCCAGTGTGAAAAGGCAGCAGATATAGCACCAGGGCAGACACTCGCCCTCAGGAATGACTCCTCCACATCCGAGGCCTCTAGGCCCAGTACACACAAGTTTCCCCTGCTGCCACGCAGGCGAGGGGAGCCTTTGATGCTGCCACCTCCCTTAGAGCTGGGGTACCGGGTCACTGTTGAAGACCTGGACCGGGAGAAGGAGGCGGCATTCCAGCGCATCAACAGTGCACTGCAGGTTGAGGACAAGGCCATCTCGGACTGCAGACCCTCACGACCTTCCCACACTTTGTCCTCACTTGCAACAGGGACTTCTGGTCTGCCTGCCATTTCTAAAGCACCCAGTATGGATGTACAGCAGGAGACACACAAGTCCCAAGACTGCCTGGGCCTACTGGCCCCCTTAGCATCTGCTGCAGGTGTCCCCTCTACAGCTCCCATGTCTGGGAAGAAGCACAAACCACCAGGCCCCCTGTTCTCCTCCTCAGATCCCCTTCCTGCCACCTCTTCCCATTCCCAGGACTCAGCCCAGGTCACCTCGCTGATTCCTGCCCCCTTCCCAGCTGCAAGCATGGATGTGGGCATGAGAAGAACAAGGTGTGGCACTTCTGCTCCTGCAGCTGCCGCAGCAGCCCCTCCCCCCTCCACATTGAACCCCACGTTGGGGTCACTACTGGAGTGGATGGAGGCCCTTCACATTTCTGGGCCTCAGCCACAGCTGCAGCAGGTGCCCAGAGGTCAGAACCAGAGATCCCAGACCTCCCGGACCAGCTCGTGCCCCAAACGAAATGCCATCTCGAGCCCCTACCGCTCTACGGGAGGCCTCCCGGAACGAAAGCGGAGAAGGGGGCCAGCCTCATCCCACTGCCAGCTGAACCTCAGTTCCTGAAACACAGTGAGTGAGGACGGACCTCAGGCTGTCTCTTCGGGTCACACCCAGTGTGAAAAGATGGCAGATACAGCACCAGGGCAGACACTCGCCCCCAGGGGTGGCTCCCCCAGATCCCAGGCCTCTAGGCCCTGTAGATGCAAGTTTCCCCTGCTGCCACGCAGGCGAGGGGAGCCTTTGATGCTGCCACCTCCCTTAGAGCTGGGGTACCGGGTCACTGCTGAAGACCTGGACCAGGAGAAGGAGGCGGCTTTCCAGCGCATCAAGAGTGCACTGCAGGTTGAGGACAAGGCCATTTAGTACTGCAGACCCTCACGGCCTTCCCACACTTTGTCCTCACTTGCAACAGAGGCTTCTGGTCTGCCTGCCATTTCTAAAGCACCCAGTATGGATGCACAGCAGGAGAGACACAAGTCCCAAGACTGCCTGGGCCTAGTGGCCCCCCAGCATCTGCTGCACAGgcctgtagtcccagctactcaggaggctgaggcaggagaagggcataaacccgggaggcagagcttgcagtgagctgagatcgcgccactgcactccagcctgggtgacagagcgagactccgtctcaaaaaaaaagaaaaagaaaaaaaaGTTATTGTGACATTTCTGTATGAAATCAGCCTTCACTACATGGATAGGACCAGCACGCTTCTGCGGCACAACTCTGCAATCATACTACATttttttttttgtattttttttattccttttgagacagagtctcactctgtcacccaggctgaagtgcagccgagatctcggctcactgcaacctccacctcctgggttcaagcaattctcctgtctcagcctcccaagtagctgggactacaggcacacgtcaaaaggcctggctaatttttgtatttttagtagagatggagttttgccatattggtcaggctggtctcgaactcctgacctcaggtgatctacctgtcttagcctcccgaagtgctaggattacaggtgtATGTTTATTTATTTATTTAAGATGGAATCTTGCTCTGTATTTATTAAtttatttagttgagatggagtcttgctccatcacccaggctagggtgcagtggtgcaatctcggctcactgcaacctctgacttccagtttcaagcgattctcctgcctcagtgtcccaagtagctgggattacaggtgcctgccaccacagctggctaatttttgtatttttagtagagacagtgtttcaccatcttggccaggctggtctcgggctcctgacctcatgaaccacctgcctcagcctcccaaagtgttgggattacaggcctaaggcaccatgctcggccATAtttatttaattatttagagacaaagtcttgctctgtcacccaggctggagtgcagtggcgccatctcagcttactgcagcctccgtctctgaggtttaagcgattctcatgcctcagcctcctgagtaactgggactacaggtactcaccaccatgcagggatatttttttctattgttttatagagacacggtttcaccatattggccaggctggtctcgaactcctgaccttaggtgatctgacagcctcgtcctctcaaagcactgggattacaggcatgagccgccaagcccggccTCTCACTACATTTAAGTGACACCAtggctcatgcctgtaatcctagcactttgggaggccaaggcaggtggatcacctgatgtcaggagttcgaaacgagcctggccaacatggggaaaccccgtctctagtaaaaatacaaaaattagtcaggtgtggtggtacaagcctgtaggcccagctacttggaagactgaggcaggagaatcactttaagcgggaggcagaggttgcagtgagccaaTCTCaaaaaagaaagaaaaaaaaaaagaaaaaCATATGATGCTGGGGCATCTCGGCCTCAATACCTGCATGAGCACAGTCACGTCCAGGCCAGGGCTGCTGGTCGAGGTCCGGCCCCATCTCTTCCagcagaaagggagtaagcttgcagggaggctgggggacaagatcccaggatctcagcctctgctcatggatcagctctgagaccccgagtgagctgggggtgctctgtgcgcattggtttccccagctgtcaagtaaagggattggatgaggaagtcttgtcaaggtGGAATGATCTCAGATTTGGGGCAGCAGTGAATGATCCCGCTCCCTGGGCCCATGCCAGTGGCCTGGCCTCGGCTCAACACAGCCCCAACACTCTGGAATGGGGATGAGGGGGCAGTCAGCTCTTGCTCCTAGTAAGAGAGATGCAACAGGGCTCTGTGGCTGAgctgggtgccttgcctcacacctgtaatcccaacctttgagaggccaaggcaggaggattgctcgaggccgggaattttgagaatagcctggacaacatagccagaccccatgtctacaaaataataataaaacacacagctatagtccaagctacttggcaggctgaggcaggaaggtcccttgagtccgggaattggaggctgcattgagctataatcgcaccactgcactccagcttgggtgacaaagtgagaccctgtctctaaaagaaaaaaaaaTTGGCCTGTGAGCATGGGTTTGATTTTCAAACAGGACCTGGAGGGTAGGGACAGACAGTGCTGTCACCCTTAGGTGCTGAACACTCAGAAACGGGCCAGCGGCAGCCCTTCCCTCACCTGCAGACACCAGATTGGGCAGAACAGCACATGGCACTTGCAGCTCTTGCAGTGAGGGCAGAACCCAGTGTCAACCCTTCTGCCTGTGGGAGGGGCTGCTGAGGCCTGCGGAGAGGCCAGGGTGGAGGCTCGTCCCCTTGTCCAGCCCTTGGCGTGGTCTCCACCAGGTCCCCAGCCCACCAGTGCAGGGCGCCCCTGAGCCTGCTGCTGCCATGGGCCCTGTCTCTACCCAGGACGTCCCCACACCCTCGCAGTGTCAGGGAAATGATCATGGTGGCGGTGACACTCCGCAGGCAGGGCTGCTGAGAGAAGCTGAGAAGGGTCACACTGCAGGCAGGGGCCCGTGTGACAAGCCCCTCTCACCCCGAGAGAGCTGACCAGGCAGCTCACGAGCAGAGCCACATCCCGGGAGTCCGAGAAAGGTCCTGGCTGGGCTCAGCCACCTCATTGGCCACGGGCAGCCTTTGTCATGTGAGCCTTGCTCTCCTGGGGAGGCTCAGGCTGACAGCTGATGTGGGCATTGCCGAAGGTAACCCGTGGCCCAGTGTATATGGCCGGGTCTCCTCAAGCTGCATTCATTCAAGTAGGACCCAGGGTGCGTGCCCATCTCCAGCCCAGGGCAGCTCCCCTGTAAGCTGGGTGAGCTACTGAAGCCAAGGCGGGAGGCAGCTGACAACACCCACAGCCCATGCGGAGGTGGTGGAAAGGCTGAACTCAGCAGCAACACCAAATCCTGGACCAGGCAAAAACCACCCAAGACTGAGGGGCTCGTGCCAGAGCGGTGGCCACAGGTAAGAACCCGGGCCCAGGCTGTGTGGCAGGAATCCTCCATGTCCCAGGGCTTAGCATAGCAAAGGAAGACCAGCCGGGTCACCCTGGTGGCCATCTGTCCCTGTCCCACCTGCAGAGTCAGAACAGCCTCTCCCCAGTGGGGATCATCTCTCTCTGCCAAAGCAACAGCGGTCCCTGCCCCAACCAGACTACCCCACTCAGTGGAGTTACGGATGCTGCTCCAGCATCCTAACACTGCCCAGCTGGTGCCTGCCTGTGCTCACCCACACCCCCCAGGCCGGCCTTCCCTGCAGCCTGGGCTTGGCCACCTTGGCCTGATTGAGCACTGAGGCCTCCTGGGCACCCAGCCCCATCACTGCACCTGCTGCTTCCAGCCCCACCCCACCGGCTCAGGGGTTCTTCCCAGCGGCGCTGATCATGAAGTCAACATGCACGCAAGTCGTCTCAGGAAACTTCTTAATGAAAGTGTCGGCCACGGTGGTGTGTAGGTGGCTGAGCTCAGATTGCAGCTGCTAAGACACCAGCCACTTACCAAGAGAAAGCCAGGCTGCTTCAAACCCAGGGCCCACGGCAAAAAAGCATCACTTCCGGCCGGGGAGTCTGGAAGCCACGCCTTGTGGGAGGTCACACTGGCATCTAGGCCTTCGCCTGCATTGCAGAAGGAGAGCCGGGTCCCCCTCCTGGAGAACGCTGCGTTCCCCAGCCCCACACCGGCTTTGCCACCACACAGGCTGTTGAGGCAGGAGGCGGGTAAGACGTAGCTGTAGACCCAAAGCAACCACCAGCCCTGGGACCCTGCGGGAGAGGAGCACTTTTAGAACATGGAAAAGTGTGGTCATCCCATCATTAGACAGCACACATCCTACATAAATAAAAAGTCGTATGGGGAAGGAGGTTGGGGAGGGAATAAAAAATTGGCACAGACATTGATAGACTGGTTTCCAGTTTCAAGGTAACAGATGCACATCATGAGACCAGAGGAGGCAGAGACAAGGCTGGATTTGGCTTTTCTAAGCAACATGTGTTCCTGCGCAGGGCTGAATGGTCGCTGAGACAGAGATGGAAGCCAGGACAAGGGAGCCCACCGGGCCCAGATAGGTACAGAGAGCAGAGGCTCCTGTTCTGTCCTCGCCACCCACGAGGGTGACACTGCTTGTAAATGGTGGCTGTGCTCTCCCAGCAAGAAAAAAGCACAACTAAATCCACACTGCACACAGACGCAGACAGAAAGCCTTCAAGTGGCTCTGTTTTCTGCTCCCTGCCTTGCCAGGTCCACAAGCAGAGAGGAGTGTCAGGCACATGGCCCCGCTGTCAGGCTCCCCAGTGAGCTGCGGGCTCAGCAGGAGCTGCCCACTGACACACAGGGGACACCCACTCCTGCCACCTTGGGAGCGGTTGCCAGACAGAGCCGCACTGGGTGCTGGTGTCATCCAGGGACCCCACACACTTCCTTAAATGTGATCCTGCTTCCCTCTGCGCAGCTGCATCCTCTCCTCCTGCAGGACCGTCTGGAAACTTGGCTCTCAGTTTGCTCTCCCTTCTCTCCTCTGCCTGCCCCAAGCCCCTCTTTCTAAAAAAGTGATGCCATGTTCATGGGGTTATTTCTTGAAAATACTTGGCGGCCTCCATGCTTCTGTTTTCTTTGAGCCAGGTGGTCAGGAGGGCTTACAAACAATGCCTGGGCTCCCCCGCAGCTGTCGGCAGATGGGGTAGCGAATGGTCCTGTGCCTCCACCTGCTCCGGGAGGGAGTCTCCCGTCTCTAGGCCTAGCCCCTTCCTAACCCTCCACGTATCCTGTTCTCCAGAGACTTCAGAACCCACTCCTGAGAACAGCGGAGCCAGGCGCTTAGAGGAAGACCAAATGCTGCCAGGACACGGATTGTCCAGGATTACATTCCAGCATCTTATTAGGTATCTGGATCTGTTGGGGAAAAAATTAGAAACTATGTATAAAACTTAAAAATATTCAAGCATCAAAAGGTTATTTAGGATGAAAGTTTTAAAACAAGTCATCAGCAAGCTGCTACCACCAAGTGGAGACTTATACAAAAGTTGAGCGAGTCCACTGAGCTGAGAGGACAGAAATGAAGTCACCTGTGCTGGGGCAGGGGCAGGGACACTGGGGGCAGGGAGTGTGTGGGCAGAGAAGCCAGAGAAGTCCAGGCCTGTGGAAGCCAAACAGGAGAGCGTGGGCCGGAAGGGCGGTCAGGATCGGGGGACGAGGTCGCTCTCCCTGGAG";
$full_seq{"A3_CYAN"} = "agtcagaatggatgctttcaccagcagacccggccatgtggctgctcggtcctgggtgctcgctgctgtgcgagacattagccctttagttatgagcctgtgggaacttcaggggttcccagtggggagagcagtggcagtgggaggcatctgggggccaaaggtcagtggcagggggtacttcagtattatacaactgctgtgaccagacttgtatactggccgaatatcagtgctgTTTGTAATTTTTCACTTTGAGAACCAACATTAATTCCATATGAATCAAGTGTTTTGTAACTGCTattcatttattcagcaaatatttattgatcatctcttctccataagatagtgtgataaacacagtcatgaataaagttattttccacaaaaggactttgcagttttaacgggggGCAGTAGGGATTGTGCTATAGAAATTCAAAGGCAAGGGAAGTCACTTCTGTTGTGGGGCCCTGGGAGGAGCCTACAGGCTGGAAAGGGTTAAGGTGGAGGTCTCCGATAGGGGCAGCGTACACAGTGGACTGGCTGCAAAAGGCCGTGCTCAGCATTCAGACAGCATCACACACTCCGCTTTTCTCTACCAGGGAGGCAGGTGGGGAAGGATAGCGATGGGAAGGCAGGCGGAGCTCAGAATGTGGAAGGGGATCCAGTAAGGCTTGGAAGTTTGCACCTGATCTGGTGGGTGGTGAGGAGCCCTTGAAGGGGCAAGGAGGTGAGAAGCACTCAGCTGTGTTCTTACACTGATCTGCCACTGGGGTTAGAGACAAACGTGGTGGGAATGGAAAGCCACGCACAGTCACTAGCGCCTCTGGGGGGAGAATGGATGTGGCTGGTGAGAGAACAGGGGGGCCCAGGGAGAGTCCGGcaccaacctggcggggggagcccagtgggtgtgagcacccccactttagagatgaagtgatggagacattcagatgtttaaccccttgttcaagattccatacttgataaatggcagaTCAAACTCCCAACATAAAATGTGGGTCATTTCTTTATTATTTTATTTGTATTGGTTAACAATGATCAGCCATGCAAGAATAAATGATTATTGTAAAATCTGCAAACAATGTAGATATGTAGAGAGTCCCTTCCTTGGAGCTTGACCTTGTCAGACAGGTATAGatgagtgttccagggcagccgtaaaaactgccagagactgggctgcttataacagaaacgcatggtctcccagaagcccacattcaaggtgtccaaaggcctggctcctggaggctctggaggagagcctgttccctgtctctcagcttctgccggttgccagcaagtgttgccgttcattcactccagccactgcctccatctgcacacagcaaAACAGCGTATCCTGAAGTGCTCAACCTTATAGCCATTATTTTAAAATATCCGGAACACACAGGACCGTGGGAGTGGCTGTTGGAGAAATTTTCATGAAGGAAGAAAGATTACAACTAAGTTTTAAAATGCTAGTTTTGTTTGTTTTGTCTTGGAGAGGAGGTAAAAGTGGGAGTAAAAATAGGGAGTTTGGTGTAAGGTGGGAAAAGCAAAGGAACCCCGCATGGATGGGCTGAAGGGTGTGATGGGAGAACAGTGAGAAGTACGTTTGGGGAAGCAATTGGAAATAGTAGCTAAGCTTAATCACAATCTATCAAAAGGGACTTGTTGAAGAATTAATGTGTGACTAGGAACAGGGAGGTTATGGGCTTGTCAGCTCGACAGCGGGCACTCAGTTCCACTAACGAATGATGCCCGTGTGGACAGACAGAATGATGGACAGGCAGATGAATGCGTGGGCTTTATGTGAAACAGGTCCTCTTGGTTGTTGACAAGATACTGTTTTAAAGTTCCATTTTGCCATACTTCGAACAGCTTGTCATTAGCTCAATTTAGCCACATGTAAAATCACTAAGGCGGACTTCCAGAGTTCCCACATGAAAATCAAATGTAAACCAGCAGTGACCTGCTTCAACACCATCATCGGAAGTCAGAAGTTGAACTCTTTTTTGatgtttaaagcctgcataatattcgctgtattattattcagcatattactatttccttcgtgatggaaatttggtttatcccaattttctattctatcaaaacaccgctacatagaaaatccccatgcacatatttctcctaattgtggaaatatttTACATAAAAGACTCTAGACATGGGATGAAATTCCCAGGTTATTGGAATTTTAAAATAGATAGGTACTTCCAAATTGACCTCTTACAAATTATATGAATTCGTAAGCTTCCAACTGTTATGGAGTTACCCATTTTGAGAAATCTGTGCTAAAAGGACCCAAACAATGCTGATGACAATGATCAGGATAATAAGTACGCTGGGAAGACAACAAAATGATTTAGATCTTAGACAAGTCATTCTAGGTGTCTCCACTGTTTCAGTTCTTGCGTTCGTTCATTCTTGTGCTTTTTCGTTTTACCAAATAAAATAGCTCCTTGATGTCATATGAATCCACGCTATGCTTAATGAGTATTGGTTAGTAAAATGCCTATAACTAGTAATCTTCATCTATGCAattaaatattaattcataaaacacttcaaatgtaaacaataattagtaaatGAAAAGTACATAATACCTCAATTAGAAAAAAATCACTCCATTAAAAAGACATTATTTGTGTGATAAAAGAGATTGCCATTTTTGTATTTTTCTACAAGGTTAAAGAAAACTAAGTCAACTTATACAAGTGAATTTTAAAAGACTTTAgggcaggcgtggtggctcacacctgtaatcccagcactttaagaggccgaggagggcagatcacctgaggtcaggagttcgaaaccagcctgaccaacatggtgaaatctcatttctactaaaaatacaaaaaaattagcccagtgtggtggcatgtgcctataatctcagctacttgggaggctgagacaggagaatagtttgaacctgggaggcggaggttgcaatgaaccaggatcgcaccattgcactccagcttgggcaacaagagtgaaactccatctcaaaaataaataaataaataaataaataaaataaataaaAGCCTTTAACCCAGAATGCTGAGTAAATTGGCCAAAAATGCTAACCTATGCATTTCAATACTATAGGAGTCGCATGGGTAGAAATAACCAGATGAAATACTTCTGGTATTTCACCTTCCCAACCCACACGAGCCAGTGTTTTTCTGTGAATAACAAAAACAGCAGAATTTACTTGCCTCTCCATAAGAGGTTACCACTTCTGTGTGTTCCCCCGAAACAGGTGGTGGCTGGGTGAGAAGGTGGACAGCACTAGGGCAGGAGATGGGGGCTCCAGTATCGTGGGTGAGCTTCCTAAACCTCTGCAACTTTCAGCCCCtaaatgggatgagccatcagaatttttagcacaatgcccagaacaaagtaaggatttgacaaatgacgcctctCTCCACATTGTTCTGTCATCAGCCACCGCATCCTGTACCTCCAAGCCCACTGGGCTCCGGCTGTTTCCATCACATGGAGAATGACTCAGAGCCTGGCCTCCAGCCACCCTCCTGGCCTTTCTTCTTCTCACTCTGCCACTGGCTCCTCATGGACCACCAGCCTGGGTGTCCTCAGACATACCACACACTTCACTGTGGGAGTCACGCAGCCCTCAATGCTCCTTCTCCAGGGAGCCACGGGGCTTTCCTCCTCAGGAGGACTCTGCAAGCAGCTGGATGAAGGGCCCTCCCGTCTCTCATCCTTCCTTAATTTTTGTCACAGTTCTCCTTCCTTCCACTCAGTGCAGTGCACACTgattgatcctccatcttccccaaaagacaggaacagcatgagcagtggAGAGTAGATTCCAATGATAGAAAAAATAGTCAGTGATTTCTCATTTCCATTGATCATCAATGAAGAAAATGTATCCTGAAGGTCATGTACCTCCTATGGGACTGCTGCATCCTCAGCCTCCTGAATTTCAGCCCAGCACCTTCCTCCCCAGCACAGCAACAGGTCAGCCCTTACCAGCATCCCTCTCTTATTGCCTTTGTGCAGAGCCAGCACCAGGGCCAGGGGAGGCCTTGGGATTGTCCCTCCCCAACAATCTGTGAAACAATCCTTTATGTCACCAACAAAGCACAGCCTTCTGCACTGGTGGTCAGTCCCTCTCAACACCTCTGTCACTGTAAAGCTGGCAGGCAACCCTCCAAGGTTGGCCTTCCCAAGCACTGCACCTCTAGGTGACAGAGCACGTCCTTACCTTGAAGCCTGGGCGCCCAGTCTATCCTGTCCAATGAGCGAGCTGTGGAGAAGGGGGGATTCCGGGTTAAGGGGAGACTAGCAGGGCTCCTGCTTTTATGTTGCCCTGTTGGGAAGGCTATTAAAGAAACATAAAGTGCTAAGCAGTGAGGATAGAACATGTTTTCATTATTTCAACCAATACATTCCACAGATGGAATAATAAGAAATGCTACAACCAagctaactgaatccaacagcatatcaaaaagataatccaccatgattcaagtgggtttcatactagggatgcagggatggtttaacatacgcaagtcaataaatgtgatacatcacatcaataaaactaaaaacaaaaatcacatgataatctgaatagatgcagaaaaagcctttgacaaaatccagcatttctttatgattaaaaccgttcgtcacaatcagcatagaacggacataccttaaggtaataaaagctatctatgacaaacccacagccaacattttcctgaatgggggagagttgaaagcattccccctgaggaagggaacaagacaaagatgcccacgttcaccgcttctcaacacagtgctgttcactacagcattggttataagagcaagactggaaacagaacaaatggatacccatagcggggtgcttaagtaattttgggaatagtcatggggtgcagtactttatagctctgaaacaatacaatggatttacatttgaaatgtggaatgataactaaggtgcattgcccagtgatatatgcagaggtgcagaggactttgtgtaAACACGATCACACATCAGCCTGCATTCCAGGTGCATGCTTCTATTTGCACATAGATTGCAGGGATGATATGCAAACAAAAATGTTGACTTGGTGTTTGGAAGTTCAGAGTGGAAGGGAAACTTCCTTGCTAACCTTTTATGATATTTAGAGTTTCTAAATGTGAATACGTAATACATTTAGAAATCTTAGTTAATAAGAAAAGCCTCTGTTCCTGGCCTCTTGCTGGCACATGTCAGGTGGAAATGGGGCTGTCATGCTAATGTGTGCAAACTGAGAAAAATCCAAGAATGGGAGTCTGCTTTTTTCATCATACAAATAATTGTTAATAGAAACAGTATGATAATTGCTCATTGATATACCATGCATATTCTATTAGATAATAATAAATTTCTGAAATTTGAACTATACTTACACATGGAAATTGAAATATATGGATGAAACATTGTGGCTTATATAGGCAATTGTTTTATTGGCATTTTACAAACTGATCATCATTCCTCATGGCACGGGTCCATGTGATATTAAGTAGCTTGTTATGCTTGGGAAAGGCAGTGATGACCACAAGAATGACTTCAACTACTAAAGTACAATGGAGATTTCAACAATGTTTTGTTTAATATTTAAATATTTCATTGTGCTCCCAGGCTTTTTCTCACCCTAATAGCTCTCATCCATATCATGTGGGTCCCATTAATACAGATAACTCCGAATGCACCACTCTTCCATTATATCCAGTCAATTGCTGGTTACCTTGGGCCTACCAACTGGGGGAGGGCAGGGGCTGCTGGCCACCTCCTCATCTACAGTAAGAGTCAATGAGCAGTTAAATGGATACTGAAAACCATTTATCCTGCTGGAGTGA";
#$Full_seq{"A3_CYAN"} = "TCATTTTATACATCAGGAGGAAAGCCAGGGAGCACGGTACACTCTCCAGCTACCGTGGGGCCAGCACACTGTCCAGCCACCTTGGGCCAGTGAAACGGAAAAAGTTCCCTTGTTGCCCTAGCAGTGTGTGTGAGAAGGGGAGTGGCTCGCTTCTTCAGTGCTCCACTGCCCAAACCTCTAGGGGAGCTTACAGACGGGCAGGCTGTGGAGCTCCGACCCCACAGCAGTGTCTAGGGGTGAAGGTTTACAGCTGAAGCCCCAGTGGGCGTGTGTCACGGGGGCTTTTTTAGTTTGTCGTCTGTAGGGTGGCTTGTGTTAGTCAGAGGGCTTTCTGGATCCTGGGGTTCTTGCCTTTGTGTACCAGAAGAGTCAGATCACACGTGGACTTGGAGAATGAGTGCAAGGTTTTATTGAGGGGAGGTGGCTCCCAGCAGATAGGGGAAGCTAGAAGGGGGTGGAGTGGGAAGGTTTTCCCCTGGAGTGGGGCCGCTGTGCACCCGGGCTGTCCTCCAACTGCCCCAGCCAAACTCCGCGTGGTTCTGCCAGTCAGTGGCCTGCCAGCATGCCGGTGCCTATCAGTGCGTTCATCTCGACATCCAGCCGCCCGTGTGTGTCTCCGCTGATGTGCTCCTCTCCACGTCCAGCTGCCTGTGTCTGCCTGCTAAGGTCTCAGGGGATTTTATAAGCACAGGATGGGGGCGTGGCAGGCCAGGGTGGTCGTGAGAAATGCAACATTTGGGTAGGAAGTGCCTGTTCTCACCTAGGTCCGTGGGGTTGGAGCCCTAGTCTGGGACCATGCCCTCCTCTACCCAGCACTTCCTTTCCCTGCTTCCGTATCATTTAAATGGACCACACTTTTCCCTTCCCAGCACTTGCCTTCCCTATCAACAGCACATTCTCTAGCCACCATGGGGTCAGCACACTCTCCAGCTACGTCGGGCCAGCAGCGGCTGGGCTCCAACTCAGGTCTGCACCAGACCCTCATTCTTAAACCCCTGCGTCTCGGCCTGCCCATGTTCCAGCTTCCCCAAGTCTTGACTCCCAATGTCCCAGCCTCCTTGAGGTCTCAGTCTCCCTGTTCCAGGCCTCAGCCTCCCCTGAGTCCCTGCCTAGCCCAGTTCCTACCTCCCACTTCCCCTCCCCAGGTCTCTGCTACCATGGCCCACCCAGCTGCACCCCCACCCCACACTTCTCCTGGGACCCAGGAGGCCACTCATGGGCTAAGCCTGGTGGCATCTTCATGTAAACCTTGCCCTGAGCACACGCCCGTGGCTGTGGCTGCTGACTTTCACTGTGCATATTAAATGCCATTAAGATGGTTGCGATTGGTTTTCAGTGTCCAGAGGACTGCAGCACACGGAGAAACAGCCGCCCTGCAGGGCCTCTCCCCGAGCTCTGGCGGGTGAGCCCTTGTGGGAGGGGCTGGGGAGCTGGGACCCATTTAGGGTGTGGTTGGGGGAGAAGGCAGGAGGCAGGTGGGACCTCCCCCGGAACCTCTCCTGAGACACCCTAAGGGCTGGGAATGGGAGCTACTTGGTGGGGGAACCCAGCAGGGGTTTCCTGTCCCCGGGCTCTGGCCATGACGAGGACCCTCCTGCTGTTGCCTCTCCCAAGGCCACTCGGCCCCTGCTCACTGTGCAACCTTACAGAGCAGCTCAGCCTCTCTGAGCCCCTCTGTCATCTTTAGCCACTGCCCACCAGAGTCCCCTTGGAGCTGCTGGCCAAGGCAAGGCTGGGCAGGGGCTTGACATAGGCTCTCACGCCTTCAGATGCCCTCAAATGGGATTCAACCCCGTCTTGGCTCCTGAGACCTCCCAGCCTGGGGTCTGAGGGTCTGTCCAGATCTGCAGGTAGATGGCTGGGCCTGCAGGGACAGAGGCGGCCGGCGGAGGGCAGCAGAGGGCCGCAGAACTGAGCGGCCGGCACTCACCAGGCCGGGATGTGGCCACCCTGCATGCAAGCAGCCCTGCCTCTGCCCTGGGTCTTGTCCCACCCCCCAGGACACCCAGGCCCTGGCTTGGCTGCGGCAGGGAGGCCAGGCCTCACCCCTCTCCCTCCTGACACCTGCCCAGCCACTGGCTTGGGCCGCCGCCCTCCAGGCCTCTCCTGCCACCCACCCCAGCACCAGGCCCCCTGATGCCCCTGCTTCCCTCCCAAGGGTCCCTCCTAGACACCATCCTGGCCCAGCCAAGATGCCAGCACAGGATCTCCCCAAAACACTCTGGGCCCTGGAGGACAGGGTGAGGCTCCGGCACCTTCCAGGTGGCACTCATGATGGACAATCTCAGGGGCCACACACCCTGGACCCACCTCCCCCAGTGCAGAGACCCCCACGGCAGGCTCTCAGCCGTGAATATGGACACACAAGGCTCCCGGGACATGGGCAAAGGGTTGACACTGGCTCATAGTGTGGGCACCATGTCACAGGGCGAGACGGAGACTCAGCCCCCAGGGTAGCGGCCAGTGCTGACCTTGGGCTAGGCCAGGGCCTGGCCATGCTGAACCAGGTCTGAGCATCCTCAGGGGCCAGCCTCTCCCTGTGGGGTCCCCACAAAGGTGGCCATGGGCTGTCCTCTGATGACAGGAAGCCCCCCTTCCCGTCAGCCCCGTCTGTCAGCTCCCTCTGCCCTGGGGTGAGGCCTCTATGGTGAGGCCCATGGTCCTGGCTCCAACCTCGCACTCCTCGGGACCCACTCCCATGCCCGGCTCCCTGCCAGACCCACACACCCAACCCAGCTAACACCAGCCCCACCCTGTCCTGCCCCACGGGGGCAGTGCCCTCCACTCTCCTTCACTGGTCCCCTCTCCGTCCTCCTCTCACCCACTCTTAAGAAACCTCCCACACATGAGCACCCGTCCGTCCCCACACCTGCTCACCAGGCCTGGCTGGGCCTGACCCTCTCCTGAAGTGAGGGCTGCAGCCTGGTCGGCTCAGCTCATCAGCACAGACTTGTTTCTGTCACAACAGCTGATGAGGACTGAGCAGATCATGGGCTAGCCAGGTCTCCATGGCCTGCCCCAGGCACCGTGATGTTCCAGGATGGTAAAATGAGGGAGGAGGTCCAGGTGGCTGACAGCTGGCTGAGGCAGAATGCGCTGATTGGCGCTGCCCAGAGGGGAGGTGGACCCCTGGGCTAAGGGAGCTCCAAGGAACAGAGCTGAACCCACCACTAACAAAAGATGGGCCAGAGCCAGCACCGTATGCCACAGCACGCAGAACAAAGGCCTCGTGCCCTGTGCCCAGCTGGCCGTGTGTCCCCTCCAGGCCCGTCACTGGGCTTCCTGACCGCCTCATCTCCACTGTCTCTGGTAGCCACCCTCATTGTACCCTTCTCCATGGTGCCCTCTGAATGAGGCCACCATGTCCGAGGGGACATGGATGACTCCAGCTGGCATGGCCTTGCCCATCCCTTGGGGCTGCAGCACAGTGGCCACCCTCTCCTCACTGCTGGGAATGTTCTGGAGCTGAGTTGGTGCAGGGAGGGTGAAGAGGCCCCGAGCCCTCCACACACCCACCTCTGGCAGCAGTTAGCAGCAGCTGGGGAGAGAAGGGTGTGAGCTCTTGCAGACATGGCACCCCAGGGTATCCTGTGCCAGGGGACACTTTGGCCATGAAGGAACTGTCGGGGCATGGCAAGCTCTGGGGGGCATCGAGGGTGCACTGACAGCACTTGTAGGGGAGCGGGGTCCCAGTCTCAGCACTGTCCAGTCAGACAGGCCTGGCCTGAGTTCCAACTGCCTCTCCCAGCTGTTTGACCCCAAACATCATGGTTTTCTGGCCTCTGGAACGGTGCTGGAGAGGGATGAAAGCATCACCGGGGGTGCAGGAGGAACCACAAAGTCCTGTGGAAGTTCATGGCAGCTGTGAGCCTTTCATTCTGAGTATCTGAGACCCCAGGAGGGGCTGGGCGCTCGTCTGGGCTGATGTCTCACAGTGAGGGGCGGCGGCCCCAGCCAGGATGCACCATTCATTGCCATTGATGAGGTCTGGGAAGAGAGGTGGTTTGGGGGACATCATACGGGGTCCCTGGGCCGGAGGGTCCCATCTTTGGAACAGAGGGGCCGGGGGCCATTCCAGAACAGTGTCCAGGAGAGAATGGGCTCTAAGCCGACCACCCAGCCCCCTCCTGCCATGTGGGGCTCTGTGCTGAGTGCATGGCCCCCCAGCCCCCCGCCTGTTTGATGGCTTCTCCCCTCCCCTCTCTGCTGCCTGGTCCCCTGGAGCTCTCCCTTCCCCAGCATGGGGCTCAGTTAAAGAAAAAACTGATTCCTGCAGATGAGGGGAGGAACAGCCCTGCTGGAGGCAAGGTGGGCGTGGGGGGAGCTTGTCTCCCCTGATGCGCAGGCAGTGGCTGGCGGAGCGTCTTCGGGGGTGGGGGATGAAAGCTCAGACTCTGGCCTGTGGGTTCCAGCTCTAGGCTTCCCAACCACCAGGCTCCCCAAAAGGTCTGTAGTGTCCTGGGCACCCAGGCCCCGATCTCGGGGGCAGGGGGCACAGTGCCTCCCACAAGCGGCTCTCGGCCCAGCCTCAGGGCTCCTCACGCACACCCAGGGCCTCTGGAGTGGGCAACTCCTGCACCCTCCACTTCCCTCAGCTCAAAACCAGGGCAGGTTCGAAACGCGCGTGCAGCTCATCATAAACACGGGTTTGGAATTTCTAACGCGGTGCCTCCAATTTCACAAAATATTGCCCCACTTTAGACATTCTCAAGGAAAGGAAATGGGGGCTGGGAGGGCCCAGGGCCTGTGGAGGGTGGGGCTGGGGGAAGCAGCCATGGGACCCTTTCCCTGCTGCTTTCAATCTGGCTCAGATATTTTTTAGATGAAATAAAATCTGATTCAGTGGTGGTTTCTGCACTGCCCCCAGGGTCTGGGGTCAGAATTCCCCCGCTGGGGCACAATAGGTGCCATTTCCCATGTTTGGGGGCTCAGGGAACAGGGTGTAAGCCATGAGGGGAGGGGCTTGGGAAGGTGGGGATGGGCTGCTGGAGGCCGTGGGCCGGCGTCTTGGTGTGGCAGCCTCCACCACGGCAGGCAGGTCATTTGATGCCCAAGGCCCAGGGCCCCCTGTCCAAGGTGAGGAGCTGTGGCTGGGTCTCTGGGGAGGCCAGGCTGCCTGCAGTGGACCGGCTATACCCTGGAGCCCCGCGCTAATGCCCATCCTCAGATGCTCCCAGCTCCGGCTTGCCTCAGGGCCTTGGCACTGGTGACCCCTCCCGGTCTCCTGCACTGTCTTCAGAGCCTATGGCAGCAGCCCCACCTGAGTTCCAGCTCTGCAGTCTGCTTTGGGCCACATTTCCTCACTGCAGGCCCAGCTGGCTCTCAGCATGGTATCTGCCCGGGTGCCCACATCACAGAGACTGGGGTATGGAGGATGGCAGGCTCCCAGGGACCCTCTGGGCCGATCTCCAGGTTGGGTGCATGCTGGACACTCACTCCATTCTGCCCTCCATTTGCCCATGCTCCGTCCACCCAGCCGGGCCCGGAGGGTCAGGGGTGTGTGGGCAGGTGCTGCTCAGAGGCCCTGGCTATGGGGCAGGGGGCCCAGCCTCAAGACTGCGGCCTGGCCCTGAGCGTGGGCGCAGCCTGGCTCCCCGACTCTCCCTCCCCATAAATAAAAGATTCCCTTCCTCCTTCCAGCTTGCGCAGCCGCCGCCTGCTCGCCGGCCCGGCCCTTTGTGCCCACGCGTTGCCATGGAGATGGGCGATTCAAAGTCCTGGCACTTCAAGGCTTCCCTCCTCTCCTGGTGGGCCGGGGCGGGGGTAGCCGGGATGGTTGCCCGAGCCCCAGTGGGTGCCGCCTCCTCTCTCTGTCCAGTAAAATGCCAGATCCTGCCGGGGCTAGGGCACCCACCAATTCTCACTCTGGTGTGGGTGGCTGACTCTGGCCCCTACCCTGAAAACAGATGCGCTTTTACAGGGACCTTCTTCAAAGTTTGATAGAATAAGGGAAACTGAGGCACAGCTGGTCCCTTGGCCACCGTGGGGAACACAGAGCCGACCCCCTGTATCATGCACCATTTGCACAGTGGGCTGCTTTCAGCTGTGTGCTGGCCAGGGTCATCAGGCTCCAGGACGTGGCCCTGCGGAGAGGCTGCCCTTCCTCCATCCCAGCATGGACGGCCCAGGGCTGGAAGCCGGGATTTGGGGTGAGCTGCACGGGGATGACTAATCCAGCCACAAAGCCGTCCCCTCCACACTCTGCCCGCCATGCGGGTTGGAGCTATCTCTGAGTCACCGTGGAGACGTTGAGAATGTCGCAGGGTCTTTGAGGCTCTTCCGCTCCCCCCAATCCTGTTCCCCACTCATACTTTTTATCTCCCCACAATCTGCCCTTTGATCATCTCCTAAGACTCATGCAACCAGCAGAATTGACGGCAGCACTTTCTGGTTCAGCCACTGCCTCCCACCTACCCCACTGCGGCAGCCACTTGGTATTTGTTGCCTGCTCACTGTGGCAGCCAGGCAAGTCTGGGACCCCTTAGAGCCTCGGTTTCCTCTCCTGTGTAATGGAAGCAGTCGTCCACTCTTAACAAATGTCCAGAGATGTCTGGGGGCCAGGTCTCTGTGCTGGGCCTGGGAACAAGACACCTGATTTTGGGGGAGATTCTGTCCCCCTTGCTCCACCCCATGAACTCTGGTGAGGGTGACCACCACACACCACAGTTACTTCCGGGCCCCAAGTGGCTGGCCCATCAGGGACTTCCCGGGAGTCACAGGTTGGAGGGAAGGAAGCCAGGGAGAGGTGGCAGAGCTGGCTGCACCCCAAGGCTGTCTCCAAGGGGCCCACCCTTGGCCTCCATCCACCCCTCCCTGGCCCGGACCCCTGTCCTGCCTCAGCAGCCCAGCCCACGGCAGCTGTCCCCTCACAGGCTACAAAGATGGTGGCCCTGGTCCTGGCCGTGGAGCAGGCAAGGCACGTGGAACATAAAGAAATATGGTTGTGAAGTGGCCAGGCCATGGAGGAAGCTCGGGGGACCTCGATGTCTACATTAAGACCTCCCAGGAGTGGGTTGTCCCTTCTGGAAGGGTGCTGGGGACAGCCGTGTGGCCCTTTTCAGTGGAAGGATCCCACATCCTCAGGCAGTGCCATCACATCCCCTGAGAAGCCCTGAAACCCAGGCATGAGGATGCAGCTGGCCCGGTCCCGGCAGGGAAGGGAGTGCAGCAGCTGGGCTCCGGCTCGCCTACCCACTGATTGCCAGTGTCCTGGGTGAGAAAGCAGGAGGCTTTTGTGCACACATGGGCCTCGGGACTGGGTCAGGGCTCAGGCTCCCCAGACGGGAGAAAGTGCATGCAGGGCCACCGGCTCCCCAGCTGAGGCTGAGGGAGGTGTCCTTGCCTTCCGTGCTCGGAGCCCTGTCTCAGGTGCTTGGCGCTCTTCTCTGCATCTTGGGTTTCCAGCAGGCCTGCCCCGCCCCAGGACTTGTGGGGAGGCTGGGACTGACCGCGATCCCCCAGGAACAAGGCAGATGATTGATAGAACTGGGCCCCGCCTGCTCTCTCAGCCCCCAGAGCCCCCAGAGGTGAGCTCCAGATGTCACCAGGGCTAATTTGGGAGCCCCTGCCCCATAGAGGAAACCCCCTGCACCAGGCAGAGCCCCGCTTGGCCCCTGCTTCAGCCGAGGGCTGCGGCCCATGCTGCCACCTCCCCTGCCCTGCAGCGGAGCTAGATGATGGCTGTTCTGTCAAGGGGGCCCTCGGCCTAGAGCATCAGTGCCACTCGGCCAGGACTAGCTCAGGTGGTAGTTTGGGGCTTTGACCCTGGCCTGTCTGATCTGCAGGCCGAGCATCCCCCACCACACTGTTTTCTACAGGATGGAATGGAAAGGAAGCCAGAGACCGGGAGACCCAGCCACAGCCATGCAGGAGAGGGCTGGTCAGGGCTGAGGCTGCTGCCCCTGACCTGAGAGCAACGGCACCATGCCCCTCCATCTGCCATCTGCACACAGGGTCGCCTCCAGCCCACAGGGCAAGGGGGCCAGGGCTGGGTCCTGAGTGCAGGGGTGTCCTTGGCAGGGTAAGAGTCAGCCTAACTCAAACTCCACTGCCACACTTTGCAGTGAGACTGACAGGTGGAATAAACCCACC";
$full_seq{"A4_GREEN"} = "AGCCTCTCCATCCCCGCCTGGCCAGCACCCCCATTCCCCCTGGCCCCTCCCTTCTCTAGGGTACCTGGCTCCCCTCCCCCACCAGCCCTGCACCCCTGCCAGAGcctcctcttcttcctcctcctccCCACAGCCACAATCTGCTTCTGGCACTTGGTTTCAGTGCTGTGTCATCCAGGCTAGCAAGAGTTGCTGCGGCCGTTAAGTCTGCTGTGACAAAGCGACCATGGTCTCCCTGGCCCCCGGAGCAGCTCTGAGGGTCACCTGACTTTATATTCAAACCTGATCAAGTCAGTGACCACGGAGAGAGCTCAGCTGCATGACCAACAGCACCCAGAGCCTTCCTGAAGCTCCCCAGAGGCGCTCGGACCCTCAGGGGCAGCTCTGCCCACACTCACAGGAAAGGAGAGGGTCCCCCTCAGATGCCGGGAAGGGGAAAGGCAGAGCAGTGGTCAGTGAGCCGCATCCCAGAGGCCTCCATGTCAAGGGGCCTCAGCTGCCCACTTTCCACCTGGCTGCTCAAGGAGCAAGCCCTGGGCCAGGAGCCCCCGCCAGGAGGCCTTCCCTCCCACCCACTCCTGGGCAGCCCCACATGGGCCAGGGACTCCACATGTGCTGCCAGGGCCCCTGAGGCTGCAGCCCAGTGATGGGAGCTGGCAGGCAGATATGCTCTGGCCACCTTATGCTGACAGAGATGTGACAGAAGAGGGTGGAATGTCACCATGTGACTAGGGAACAGGCAGGCAGCACGTGAACCCCTGCCTGAGACAGGGAGCTCCTGGGCCCCTGGCTTGGGCACCTCAAGACCAGTCATGAGATCAGCCCTAAGACCTTCACGCCAAGGCTTAGGTACAGCCAGGAAAAGCCATCCCCAAGGGGGACTCACTGTCTATGTTAAGGCCGGGGTGGCAGCCAGGGCCCTGCCCAGGGCAGAAACCCTCATGGCAAGTAACAGCAGACAGTGGGGACAGGGCCTCAGGGGCCTCCATGACCCTGAAGAGAAGGTCCCATCCTGAAACCACACAGCCCACAGTTTGGATAACACGGGACTTAACCACACAGGTGTCTGCCTGTGAGGCAGCTCACCTTCATGAAACAGGATCATTATCTGACAGGTCCCCAGGCAGATGAGTTCCCGCTCAGCATTCCCACAGCTGCTGTGTTCATCCTCTGAGGTGGGCCTGGCAGGAGAGGCTGGGGAAGCCAGGGCTGCTCCCTCTCCTGCTCTGACACACTCAGAGGCAGAACACCATAGGCTACCGCTGCTCCTCTCCGTGAACTTCCAGAGCACAGACCAGGCTGACACAGCCAAGCAGTGGCCAAGATGACCACACAGCACGTGCAGTGGCCAGAGGGGCAGCCAGGTCTCAGAGTGGATGGCTACGCAGCAAGGACAGGGCCACACTCTCCAACAGGCATCATGGATAAGTCACAAGGAGACACAAATGGTGGTTCCCAGGCAGGTCAGGGGTCCTATTTCCACTGGAGAAGAGGAAGAAAGCACCCTGGGAGCAGCTGATTCAGAACTGCGGGTGCCACACAGGAAATCTGGCTTTCGCCACCTGGGACGTTGCCACGTCCTGGCTCAAGGCACCACAGGGAAGAGGGGGGCACATGGCACTGGCAGCTGTGGGGTGTTAGAGGAGGAAGGGTGAACCAGTGGATGTGGGGCCCTGATCAGGGTGGGGACCACATCCCAATGCCTCCTTAAAGCCAGGACCTGCCTCGTGCTCCCCCAGTCCCACCCCTCATCATGCCCAGGGCATAGTCTGTTGAAGGGCACATGATCGCACACATGGGCACGACCTGGGACAACAGAGGAGGGAAGAGCGACAAGGGGACATAGGGCAGAGGAGGACAAGCACGTGTCCCCAGGGGGTCTTCAGAGACAGCAGGAAGACCCTGACCACCCCCTCAGCCTCCACCTCAGCTCTGGGTGGCTGTCCCTGGGGACGTGATGCCTATTGAAACAAGCAGAGCATGGGGGTCCACACCCCGCCCTTGTCCAACTCTCTCCTGGAGGGAAGCCTGGCAAGCCGCTTCCTACCTGTACCCCCCTCCCCAGCTCCCCAACCCTCTGCCTCCCCAGCCCCTCGCTCAGGACACTCACTGCACACATATCCTGCCTCCAGCCAGCCCTGGGCCTGCACAGCCAGACCAATGCCCCCATCCACCCCCTAGGTGTTCCCTCACAGCCCAATCATCAGGAAGATGCCTTGGCCCCTTCCCCATCCCCAAGCCCTCAGCCTGCTTCGGGGATCCCTGGGACTCCTCTCCTGGGGTTGGGTGGGGCCCTGGCCTCTGGGAAGCATGGTCCACCCCCCCCCCGGGTGGGCATTGCCCTCCTGCACCTCCAGGCTCCCACCTCCTCTTTCTTTCTCGGGAGCACTGCTGGGACTCACTTTGCCATGCACTCAGACGCCTCCATCCTCCCTGGGCCTCTCACGGCCAGCACCACTTGCCATGGCCTTAATTTGGGGCGGTGGCCTCAGTGTCTCTCCCCAGAGTAGAGCCCATGGCCCTTGTGACAGGAGGGTAGGTTAGGAAGGCAGATCTCTAAGCAGTTCCCTGCACTAGGGTCTGCGTGACTGGTCACTCCTGGCCAAGCAGGCCATGCTGCAGTGTGGACATCAGACCAGTGCTTGCAGACCCAGCCCTACCCCCATGGCTCAGGCCCCTCTGAAAGCACAAAGCAGCTGAGCTCGGTAGGTGTCCTCAGCATGCACCCCTGTGAGGACAGGAGGGAACCCTGTTCACTTCCCAGAGCTGGAGCAGGACCCCTGCAGACAGCAGCCACCAGCAGCAAGACAGGTGAATCCCTTGCAGGGCAAAGGACTCAAGCTCCTAAGGACACAGGTGCCCAGCCCCCTGGCAGAGTGCAGGCCAGTCCACCTCCAGACACTCAGCCTGCAGGGCAGGGAGGAAGCCAGGCAGGACCACCCTGGGAAAGGAGTCTTTTCATACCAGAGGCGCCTGAGAGGAAAATCCCATTGTGAAACCAAGTCCCCACCCAGACTCCTTCTGAGAACACACAGGCCATTGGTTATTCAACAGGCAGCTCAGCAAAGGCTGCAGCCAAGAGCTCAGGCAGCTGCAAGGCCCACGGGGCCTGCTAGGAACACAGTGGGGTGCTGGGGCTGTAGTACCCCACCTTCAAAACAGCCAATCGCAAGGCAGGGGCTGGGCTCCCCTGGCCAATCCTCTCCAGGCAGCTGGCAGCCGACATGCTGAGGCAAGCCTCAGACATTCCGTTCCCAGGGCTGGAGGCCTCATGTGACTGCCTTTCCCTCCCCTTCCCAGGCCAGCCACCAGGGGAGGGGCAGGAACAACCACCAAGGCCTGACCAGGTCCACAGAGGGACTGTCCCAAGCCTTATGTGGGTCAGGCCCGGCTGCTGTCAGGGTGCAGGGGACCCAAATACATAGGAAGacatagggagatcccatctttacaaaaaaaaattaaaacttagccaggtatggtggtgcgtgcctgtggtcccagctacttagggggctcagatgggaggatcacttgagcccagaaggttggctgcagtgaacaatggcaccactgcactctagcctgggcaacagagcaagaccctactttaaaaaaaCtggttgaaagaaatcaaaacaagaataatattttgtgacacaagaaaattatatgaaattctaattactatggccctactgaggcagagtgaagccgttgtggcagggagggtgtggcccgactgagagtctgtgctacctggctgtttacacaaacttgctgaccTGATGGAGGAGGCTCTGCTACAGCCTCTCTTTTGCAGGGATTCCTGACCCGCAGGCAGGTCCCACTGCCCGACCCTTGCCTGGCCTCAGCCTGCCCTGCAGTTGTGGAACCTCCCAGGCCTGGCCCCTGCCCCATTGTCAGTGGAGAAGGGAATTGAAGCCAGGAGCAGTGTAGCAGGCCGGCCTGGAGTCAGCTCCTGGAGGCCACTAAGCTGATACAAGGCCCCTTCCCTGGGCAGTGAGTGTAGAGGGCAGTTGGTACCACCCTGACCCGCCCTCCTGGGCAGGGCATCAGGACAGAACAACAAGACCACGTTTCCCTCCACTTCCTGGAGCAGTCCCTGGCTCATGTGAGATCCAGGCGAGACCAACCATTCTTTGCAGAGTGCTTGGTTCATATGCTGGTGCCTGTGCTCCTCCAGGCGGTGGACTAGATAGGGCCAAGGGCCATTCTGTACTCTGCTTCCTCAGGCCTCACGCACACCAGGCCTCCCATGAAAGCCCAGAGCTGTCCACCGCATGAAACAAAAATGCAAGAACTCCAGGCAGAGCCCAGGAGGGTCATCGGTAGTTGGGCTGACCAAGCTCTCCTAGCCTTGGCCTCTGCCCAGCTGAGGCTGAAGCCCAGCAGCTGGATACATCCCACCTGCTCCCACTGGGTGCTCCAGGGTCATGATCAGAAAGCCCGCAGACACCGGGCAGGCCTTACTCCATCTCCTTGTGCTCTGCCTCCTCGGGGCTCAGGTCCTCCTCCACTCCATAGTCCAGGATGGCGCTGACACCGAAGGCCCTGTAGTGCCGAAGCAGGGGCTGGATGGACTCCTGGTCCTCCCCGGCTACAAAATGCCCATAGAAGGTCATCTTCATGAGCTTGTTGAATAGCCTCTGTCCTAGAAGTTTCCTGGAAACATACAGCAGCTGAAAGGCAAAGGGAAGCCGCTGTCCTGGGCTGCCTGAACTCTCCTTTCCCAGCAAGGCACCGCTGCTCATCCCCGACCACACTTCACCCCAGCCATGGGGCCTCGATATGGTCTCTTGGCGACTGGGCTTTCAGGGTCAGTTTCATGGTGAAGACCAGCTAAAGCCGCTTGCTTCTCCACCCTGTCCATCACTCCAGTTCCCATCCAGGGCAGAGAGACCACAGGAGGTGCTGCCTGCTTGGCCTGAGGACACTGTTCCCACCTGGACTCTGCCCCTTCAGGGCCCCACCCATGAGTCACTCCAGCAGCACACAGTGGGTGCCTGACCACTGCTTGGTGGATAAAAAGGAGAATGGCCAGCCTCCCTGGGGATGACAGCCGGCATTTTGAGACCATCCTCTGTATCCACACCTTGGTAGTTCTGCTGCGGAAGAGGAGGATCTAACTTGACTTTCTAGTACTtgagtgcccagatttttcaatgttttgttccctcttatcccaagtcccttaaacagtgtgactggcaTGAGGCCAGCCCCCGAATGGATGCTAAATAACAAACGTGTGAAACTCAGGCTGAGTCTGCGCCCAGCTGGAGGGAGGCATGCCCTGGCAACAAGGACAATGAGCTAGATGACAGTCCACAGGGGCCTGTGAGATGACTCCCACCCCAGGACCCATGCGCTCTGCAGGGTCATCTGGGGCTGACCAGCCACTCTGACAGATGCTGCCCGGGAACTGTCTGTCTCCTCCAATCATATTTCACCACGTCGCTCATTCAGATGTCCCAAGCTGCCATGCACCAAGCACCTTTTATAGACTGGAAACAACCAAAGGAAACCGACCAGGATCTCACATCCTGGTGGTAAAGGAACCCCAAAGGGGAAGGAGGGACTCTGCCTATGACTCAGGACAGGGGGATGGGGCAGTGCCTGCAGGGTAGGGCAGGGGTGTTTACTAACCCAGATCCAGGAGTGGGGCTTGCCAAGGCGAGGAGATGGCATGGACAACTGTGGGAGCTCCAGCACGGGGGACAGCCAGGGCAGAAAGGACAGGGACAACGAGAGGCTACTTGGAGAGGAGGGCCGAGTGTGATGCTCAGAAGCACACCTCCGCGTTGTGTCTGCTGCCCCTGCCGACTCAGCCCCAACACAGGAAGAGCCTGGGGTTTCTCAAACCCAATGGATACTAGAACTCCTTTTATGTGGGGAGCATCTCTTGAGACCGTAGTTTCAGGAACAACTTCTAGTCTAAGCAAAACCATTAGCGAGTCAAACACTTACACCCAAGCCAGCCCTGAGCACCCACACGCCTGCCCACAGGCAGACATAGCCCCACAGCCTTACCCTGAACATTGGTGCCCCATGGAGACGCCTCCTGACCATCACCCCTGGGCACGCCATGGGGCAGCCCCAAGGACCAGGGTTTCCCAGGCACTCACCCCTGCCTTCCTGCAGCCTCCAAGCAGAATCTGACTTTAAGGCATTTTGTTCTTTTATCAAGAGGATTAGAAACTGGAAAATGAACAGGCTGACATGTTCTCCGTCTCCCACTGAGCCTGAGCCAGGCCTCATTCCTGCTGGCAGCACCCAGGGATAGTTGGGAGAACAGGATGGGTCTGAAACATATCAAAGATCACCCAAGTGGCAGGCGGGGCAGAACTGGGGACCTGAACACCATCACTGGGCTTATCCACATCCGCTCTGAGAGAACCATCAGAAAACAACAGGAGGGAGGGTGGGCAACTGTCGACTGCCGCACGGGGCCACGCAGTCTCCCTCTACCTAACTGCTCGCCTCCGCACGGCCAGCACTAAATGAAGGGGCGGGAGCCCAGGCTGCACTGACTCCAGGGATGCTTATTCACAAAGATGGGGGGCTGGGGGACTGGGCCCGGGCTGAGGGTGGAAGCTCCCTGCACAGGGCTGCAGAAGCACACAGGCAGGGCTGGCAAGTTTTTTATTTATTTATTTTTAGAGGCAGGGTCTCActcctgggctcaagcgacactcctatctcggcctccagagtagttgggactacaggcatgcaccaccacactcagctaacttttattttttcttttttttgaggcagagttttgctcttgttgcccaggctggagtgcagtagcacaatctcggctcactgcaacctccacctcccaggttcaagcgattctcccgcctcagcctcccaagtagcagagattacaggcgcacaccaccatgcccagctaatttttatatttttagtagagatggggtttctccatgttggccaggctggtctcaaactcctgacttcaggtgatccacccgcctcggccacccaaagtgctgggatgacaggcatgagccaccgcacctggccccagctaacttttaaaaatattttgtagagacagggtttcacgatgttgctcaggctggtcttgaactcctagccttaaatgatcctcctgccttgacctccttaagtgctagaattacaggcatgagccaccatgccTAGGCATGAGCCTAGGGCTTGTAATTTTAAAGCTGACTCCACAGCAAAGCAACCACTTTAACACCATCCTGGTGTCACTGATGTCCCCGCATGGCACTACCTGAGACCAGGGCAGCCCCACATCTTCTTCAGGTGAGGAGATCCTTCGAGGATTTAGAAACCTGCACCAGTAACACATACACTTGTACCCCCTGTGAAAGACTCAACCAAATGTGTGCAGAGTAACACTGGTAGAGCCGGTTCTCTCCCCTCCCCCCACTCAGGGAACCACTGTCACCACGGGTCCTGTCCCTTCTGTGAGGGCGCACACCCAACCTCAGTGCTGTTGTCATGGAAATCCTG";
#$full_seq{"A4_GREEN"} = "AATAAAGGTAGTTACCTGGTTCCAAGACAGAGCCAGTCAGGGCTGAGAGGAACGGAGGCGGGAAGGCACCAGCACACAGAGGTCCCCAAATCCCCAGCGAGGCCCCCTTACTCAGGCCTCCACCCCAGAGCCAGGGTCTCCCAGGCAGCTCTGATGCAAGCACAGGCTCCTGCCCCCGCACAGCCAGCCCTGCAGTCCCGCCCTGTCCTCCAGGCCGGCCCTCCTGTAGCATTCTTGCCCCGACACTTCTTTTCCAAGCAACAACCAGAAATGTTCCTTTAAAGTGAAAGCAGATCTTACCATCTCATCTTGTTTCACGCCACCCCACCCAGGGTTCCCATCATTTCCTAGTAATGCCCAAAGTCCTGGGCCCCTGGCTTGGGCACCTCAAGACCAGTGAGGCCAGGATGCAGGCTGTCCCCCGCTAGGCTGGCCACACTCTGCTCAGCCAAGCCCCTGTCCTTCCTGCAGAAGCCTCTCCATCCCCGCCTGGCCAGCACCCCCATTCCCCCTGGCCCCTCCCTTCTCTAGGGTACCTGGCTCCCCTCCCCCACCAGCCCTGCACCCCTGCCAGAGCCTCCTCTTCTTCCTCCTCCTCCCCACAGCCACAATCTGCTTCTGGCACTTGGTTTCAGTGCTGTGTCATCCAGGCTAGCAAGAGTTGCTGCGGCCGTTAAGTCTGCTGTGACAAAGCGACCATGGTCTCCCTGGCCCCCGGAGCAGCTCTGAGGGTCACCTGACTTTATATTCAAACCTGATCAAGTCAGTGACCACGGAGAGAGCTCAGCTGCATGACCAACAGCACCCAGAGCCTTCCTGAAGCTCCCCAGAGGCGCTCGGACCCTCAGGGGCAGCTCTGCCCACACTCACAGGAAAGGAGAGGGTCCCCCTCAGATGCCGGGAAGGGGAAAGGCAGAGCAGTGGTCAGTGAGCCGCATCCCAGAGGCCTCCATGTCAAGGGGCCTCAGCTGCCCACTTTCCACCTGGCTGCTCAAGGAGCAAGCCCTGGGCCAGGAGCCCCCGCCAGGAGGCCTTCCCTCCCACCCACTCCTGGGCAGCCCCACATGGGCCAGGGACTCCACATGTGCTGCCAGGGCCCCTGAGGCTGCAGCCCAGTGATGGGAGCTGGCAGGCAGATATGCTCTGGCCACCTTATGCTGACAGAGATGTGACAGAAGAGGGTGGAATGTCACCATGTGACTAGGGAACAGGCAGGCAGCACGTGAACCCCTGCCTGAGACAGGGAGCTCCTGGGCCCCTGGCTTGGGCACCTCAAGACCAGTCATGAGATCAGCCCTAAGACCTTCACGCCAAGGCTTAGGTACAGCCAGGAAAAGCCATCCCCAAGGGGGACTCACTGTCTATGTTAAGGCCGGGGTGGCAGCCAGGGCCCTGCCCAGGGCAGAAACCCTCATGGCAAGTAACAGCAGACAGTGGGGACAGGGCCTCAGGGGCCTCCATGACCCTGAAGAGAAGGTCCCATCCTGAAACCACACAGCCCACAGTTTGGATAACACGGGACTTAACCACACAGGTGTCTGCCTGTGAGGCAGCTCACCTTCATGAAACAGGATCATTATCTGACAGGTCCCCAGGCAGATGAGTTCCCGCTCAGCATTCCCACAGCTGCTGTGTTCATCCTCTGAGGTGGGCCTGGCAGGAGAGGCTGGGGAAGCCAGGGCTGCTCCCTCTCCTGCTCTGACACACTCAGAGGCAGAACACCATAGGCTACCGCTGCTCCTCTCCGTGAACTTCCAGAGCACAGACCAGGCTGACACAGCCAAGCAGTGGCCAAGATGACCACACAGCACGTGCAGTGGCCAGAGGGGCAGCCAGGTCTCAGAGTGGATGGCTACGCAGCAAGGACAGGGCCACACTCTCCAACAGGCATCATGGATAAGTCACAAGGAGACACAAATGGTGGTTCCCAGGCAGGTCAGGGGTCCTATTTCCACTGGAGAAGAGGAAGAAAGCACCCTGGGAGCAGCTGATTCAGAACTGCGGGTGCCACACAGGAAATCTGGCTTTCGCCACCTGGGACGTTGCCACGTCCTGGCTCAAGGCACCACAGGGAAGAGGGGGGCACATGGCACTGGCAGCTGTGGGGTGTTAGAGGAGGAAGGGTGAACCAGTGGATGTGGGGCCCTGATCAGGGTGGGGACCACATCCCAATGCCTCCTTAAAGCCAGGACCTGCCTCGTGCTCCCCCAGTCCCACCCCTCATCATGCCCAGGGCATAGTCTGTTGAAGGGCACATGATCGCACACATGGGCACGACCTGGGACAACAGAGGAGGGAAGAGCGACAAGGGGACATAGGGCAGAGGAGGACAAGCACGTGTCCCCAGGGGGTCTTCAGAGACAGCAGGAAGACCCTGACCACCCCCTCAGCCTCCACCTCAGCTCTGGGTGGCTGTCCCTGGGGACGTGATGCCTATTGAAACAAGCAGAGCATGGGGGTCCACACCCCGCCCTTGTCCAACTCTCTCCTGGAGGGAAGCCTGGCAAGCCGCTTCCTACCTGTACCCCCCTCCCCAGCTCCCCAACCCTCTGCCTCCCCAGCCCCTCGCTCAGGACACTCACTGCACACATATCCTGCCTCCAGCCAGCCCTGGGCCTGCACAGCCAGACCAATGCCCCCATCCACCCCCTAGGTGTTCCCTCACAGCCCAATCATCAGGAAGATGCCTTGGCCCCTTCCCCATCCCCAAGCCCTCAGCCTGCTTCGGGGATCCCTGGGACTCCTCTCCTGGGGTTGGGTGGGGCCCTGGCCTCTGGGAAGCATGGTCCACCCCCCCCCCGGGTGGGCATTGCCCTCCTGCACCTCCAGGCTCCCACCTCCTCTTTCTTTCTCGGGAGCACTGCTGGGACTCACTTTGCCATGCACTCAGACGCCTCCATCCTCCCTGGGCCTCTCACGGCCAGCACCACTTGCCATGGCCTTAATTTGGGGCGGTGGCCTCAGTGTCTCTCCCCAGAGTAGAGCCCATGGCCCTTGTGACAGGAGGGTAGGTTAGGAAGGCAGATCTCTAAGCAGTTCCCTGCACTAGGGTCTGCGTGACTGGTCACTCCTGGCCAAGCAGGCCATGCTGCAGTGTGGACATCAGACCAGTGCTTGCAGACCCAGCCCTACCCCCATGGCTCAGGCCCCTCTGAAAGCACAAAGCAGCTGAGCTCGGTAGGTGTCCTCAGCATGCACCCCTGTGAGGACAGGAGGGAACCCTGTTCACTTCCCAGAGCTGGAGCAGGACCCCTGCAGACAGCAGCCACCAGCAGCAAGACAGGTGAATCCCTTGCAGGGCAAAGGACTCAAGCTCCTAAGGACACAGGTGCCCAGCCCCCTGGCAGAGTGCAGGCCAGTCCACCTCCAGACACTCAGCCTGCAGGGCAGGGAGGAAGCCAGGCAGGACCACCCTGGGAAAGGAGTCTTTTCATACCAGAGGCGCCTGAGAGGAAAATCCCATTGTGAAACCAAGTCCCCACCCAGACTCCTTCTGAGAACACACAGGCCATTGGTTATTCAACAGGCAGCTCAGCAAAGGCTGCAGCCAAGAGCTCAGGCAGCTGCAAGGCCCACGGGGCCTGCTAGGAACACAGTGGGGTGCTGGGGCTGTAGTACCCCACCTTCAAAACAGCCAATCGCAAGGCAGGGGCTGGGCTCCCCTGGCCAATCCTCTCCAGGCAGCTGGCAGCCGACATGCTGAGGCAAGCCTCAGACATTCCGTTCCCAGGGCTGGAGGCCTCATGTGACTGCCTTTCCCTCCCCTTCCCAGGCCAGCCACCAGGGGAGGGGCAGGAACAACCACCAAGGCCTGACCAGGTCCACAGAGGGACTGTCCCAAGCCTTATGTGGGTCAGGCCCGGCTGCTGTCAGGGTGCAGGGGACCCAAATACATAGGAAGACATAGGGAGATCCCATCTTTACAAAAAAAAATTAAAACTTAGCCAGGTATGGTGGTGCGTGCCTGTGGTCCCAGCTACTTAGGGGGCTCAGATGGGAGGATCACTTGAGCCCAGAAGGTTGGCTGCAGTGAACAATGGCACCACTGCACTCTAGCCTGGGCAACAGAGCAAGACCCTACTTTAAAAAAACTGGTTGAAAGAAATCAAAACAAGAATAATATTTTGTGACACAAGAAAATTATATGAAATTCTAATTACTATGGCCCTACTGAGGCAGAGTGAAGCCGTTGTGGCAGGGAGGGTGTGGCCCGACTGAGAGTCTGTGCTACCTGGCTGTTTACACAAACTTGCTGACCTGATGGAGGAGGCTCTGCTACAGCCTCTCTTTTGCAGGGATTCCTGACCCGCAGGCAGGTCCCACTGCCCGACCCTTGCCTGGCCTCAGCCTGCCCTGCAGTTGTGGAACCTCCCAGGCCTGGCCCCTGCCCCATTGTCAGTGGAGAAGGGAATTGAAGCCAGGAGCAGTGTAGCAGGCCGGCCTGGAGTCAGCTCCTGGAGGCCACTAAGCTGATACAAGGCCCCTTCCCTGGGCAGTGAGTGTAGAGGGCAGTTGGTACCACCCTGACCCGCCCTCCTGGGCAGGGCATCAGGACAGAACAACAAGACCACGTTTCCCTCCACTTCCTGGAGCAGTCCCTGGCTCATGTGAGATCCAGGCGAGACCAACCATTCTTTGCAGAGTGCTTGGTTCATATGCTGGTGCCTGTGCTCCTCCAGGCGGTGGACTAGATAGGGCCAAGGGCCATTCTGTACTCTGCTTCCTCAGGCCTCACGCACACCAGGCCTCCCATGAAAGCCCAGAGCTGTCCACCGCATGAAACAAAAATGCAAGAACTCCAGGCAGAGCCCAGGAGGGTCATCGGTAGTTGGGCTGACCAAGCTCTCCTAGCCTTGGCCTCTGCCCAGCTGAGGCTGAAGCCCAGCAGCTGGATACATCCCACCTGCTCCCACTGGGTGCTCCAGGGTCATGATCAGAAAGCCCGCAGACACCGGGCAGGCCTTACTCCATCTCCTTGTGCTCTGCCTCCTCGGGGCTCAGGTCCTCCTCCACTCCATAGTCCAGGATGGCGCTGACACCGAAGGCCCTGTAGTGCCGAAGCAGGGGCTGGATGGACTCCTGGTCCTCCCCGGCTACAAAATGCCCATAGAAGGTCATCTTCATGAGCTTGTTGAATAGCCTCTGTCCTAGAAGTTTCCTGGAAACATACAGCAGCTGAAAGGCAAAGGGAAGCCGCTGTCCTGGGCTGCCTGAACTCTCCTTTCCCAGCAAGGCACCGCTGCTCATCCCCGACCACACTTCACCCCAGCCATGGGGCCTCGATATGGTCTCTTGGCGACTGGGCTTTCAGGGTCAGTTTCATGGTGAAGACCAGCTAAAGCCGCTTGCTTCTCCACCCTGTCCATCACTCCAGTTCCCATCCAGGGCAGAGAGACCACAGGAGGTGCTGCCTGCTTGGCCTGAGGACACTGTTCCCACCTGGACTCTGCCCCTTCAGGGCCCCACCCATGAGTCACTCCAGCAGCACACAGTGGGTGCCTGACCACTGCTTGGTGGATAAAAAGGAGAATGGCCAGCCTCCCTGGGGATGACAGCCGGCATTTTGAGACCATCCTCTGTATCCACACCTTGGTAGTTCTGCTGCGGAAGAGGAGGATCTAACTTGACTTTCTAGTACTTGAGTGCCCAGATTTTTCAATGTTTTGTTCCCTCTTATCCCAAGTCCCTTAAACAGTGTGACTGGCATGAGGCCAGCCCCCGAATGGATGCTAAATAACAAACGTGTGAAACTCAGGCTGAGTCTGCGCCCAGCTGGAGGGAGGCATGCCCTGGCAACAAGGACAATGAGCTAGATGACAGTCCACAGGGGCCTGTGAGATGACTCCCACCCCAGGACCCATGCGCTCTGCAGGGTCATCTGGGGCTGACCAGCCACTCTGACAGATGCTGCCCGGGAACTGTCTGTCTCCTCCAATCATATTTCACCACGTCGCTCATTCAGATGTCCCAAGCTGCCATGCACCAAGCACCTTTTATAGACTGGAAACAACCAAAGGAAACCGACCAGGATCTCACATCCTGGTGGTAAAGGAACCCCAAAGGGGAAGGAGGGACTCTGCCTATGACTCAGGACAGGGGGATGGGGCAGTGCCTGCAGGGTAGGGCAGGGGTGTTTACTAACCCAGATCCAGGAGTGGGGCTTGCCAAGGCGAGGAGATGGCATGGACAACTGTGGGAGCTCCAGCACGGGGGACAGCCAGGGCAGAAAGGACAGGGACAACGAGAGGCTACTTGGAGAGGAGGGCCGAGTGTGATGCTCAGAAGCACACCTCCGCGTTGTGTCTGCTGCCCCTGCCGACTCAGCCCCAACACAGGAAGAGCCTGGGGTTTCTCAAACCCAATGGATACTAGAACTCCTTTTATGTGGGGAGCATCTCTTGAGACCGTAGTTTCAGGAACAACTTCTAGTCTAAGCAAAACCATTAGCGAGTCAAACACTTACACCCAAGCCAGCCCTGAGCACCCACACGCCTGCCCACAGGCAGACATAGCCCCACAGCCTTACCCTGAACATTGGTGCCCCATGGAGACGCCTCCTGACCATCACCCCTGGGCACGCCATGGGGCAGCCCCAAGGACCAGGGTTTCCCAGGCACTCACCCCTGCCTTCCTGCAGCCTCCAAGCAGAATCTGACTTTAAGGCATTTTGTTCTTTTATCAAGAGGATTAGAAACTGGAAAATGAACAGGCTGACATGTTCTCCGTCTCCCACTGAGCCTGAGCCAGGCCTCATTCCTGCTGGCAGCACCCAGGGATAGTTGGGAGAACAGGATGGGTCTGAAACATATCAAAGATCACCCAAGTGGCAGGCGGGGCAGAACTGGGGACCTGAACACCATCACTGGGCTTATCCACATCCGCTCTGAGAGAACCATCAGAAAACAACAGGAGGGAGGGTGGGCAACTGTCGACTGCCGCACGGGGCCACGCAGTCTCCCTCTACCTAACTGCTCGCCTCCGCACGGCCAGCACTAAATGAAGGGGCGGGAGCCCAGGCTGCACTGACTCCAGGGATGCTTATTCACAAAGATGGGGGGCTGGGGGACTGGGCCCGGGCTGAGGGTGGAAGCTCCCTGCACAGGGCTGCAGAAGCACACAGGCAGGGCTGGCAAGTTTTTTATTTATTTATTTTTAGAGGCAGGGTCTCACTCCTGGGCTCAAGCGACACTCCTATCTCGGCCTCCAGAGTAGTTGGGACTACAGGCATGCACCACCACACTCAGCTAACTTTTATTTTTTCTTTTTTTTGAGGCAGAGTTTTGCTCTTGTTGCCCAGGCTGGAGTGCAGTAGCACAATCTCGGCTCACTGCAACCTCCACCTCCCAGGTTCAAGCGATTCTCCCGCCTCAGCCTCCCAAGTAGCAGAGATTACAGGCGCACACCACCATGCCCAGCTAATTTTTATATTTTTAGTAGAGATGGGGTTTCTCCATGTTGGCCAGGCTGGTCTCAAACTCCTGACTTCAGGTGATCCACCCGCCTCGGCCACCCAAAGTGCTGGGATGACAGGCATGAGCCACCGCACCTGGCCCCAGCTAACTTTTAAAAATATTTTGTAGAGACAGGGTTTCACGATGTTGCTCAGGCTGGTCTTGAACTCCTAGCCTTAAATGATCCTCCTGCCTTGACCTCCTTAAGTGCTAGAATTACAGGCATGAGCCACCATGCCTAGGCATGAGCCTAGGGCTTGTAATTTTAAAGCTGACTCCACAGCAAAGCAACCACTTTAACACCATCCTGGTGTCACTGATGTCCCCGCATGGCACTACCTGAGACCAGGGCAGCCCCACATCTTCTTCAGGTGAGGAGATCCTTCGAGGATTTAGAAACCTGCACCAGTAACACATACACTTGTACCCCCTGTGAAAGACTCAACCAAATGTGTGCAGAGTAACACTGGTAGAGCCGGTTCTCTCCCCTCCCCCCACTCAGGGAACCACTGTCACCACGGGTCCTGTCCCTTCTGTGAGGGCGCACACCCAACCTCAGTGCTGTTGTCATGGAAATCCTGGGACTTTCCTAAACCCTCCTCAATAAGTCTGGCTTTCAGGCAAGGGCGGGCCCCACTGCTGTCCCCATCCAAGGCAGCAGCTCAAAGATCAGCTACTACAACCTGACACGCCTGTGGCAGATGTGGCCTCACTGCCCGGGTGCCTCACAGACCTGTGCTGGCTCAGCAGAAGGAATCTCCCCACAGCCCAGAGGGTGAGGGAAGGAACTCCCCTCTGGCCCGCTCACAGGACCAGGTTCTAGTGAGCAGCTCACAAGCCCAGGACCTGGCCTCTGCCTTCTTCCAGTGCTGAGGCTGCCGACACCCATGGGACCACTAGCAAGACAACAGTACAGACCCCACTGAGGGACTTCCCAGGGCACAGGTGGGACCCTAGGGGAGCCTGGGAGAGGTCACCTCTGGATGCCCTGCCTCTTCCAGGTACTCACAGCACCATCCCTGAGCCCTGGCACTTGCCTCAAGAAGGCACCCAAGGGACAGCGGAGCCAACAGTTTCCTCCCACAGTCACGGAACAGCACCTGGCATTCCCCGCAGCAGACTGGGCACCAAACCCCACACCCAGCTCTGCTGGCTTCTCTGTGCAACAACTTGTCTTGAATCTAGACAAGAAACCTTA";
#$full_seq{"A5_MAGENTA"} = "TACGGAGTCTTCTAAGAGATTTTGCAATGAGGAGAAGCATTGTTTTCAAACTATATAACTGAGCCTTATTTATAATTAGGGATATTATCAAAATATGTAACCATGAGGCCCCTCAGGTCCTGATCAGTCAGAATGGATGCTTTCACCAGCAGACCCGGCCATGTGGCTGCTCGGTCCTGGGTGCTCGCTGCTGTGCAAGACATTAGCCCTTTAGTTATGAGCCTGTGGGAACTTCAGGGGTTCCCAGTGGGGAGAGCAGTGGCAGTGGGAGGCATCTGGGGGCCAAAGGTCAGTGGCAGGGGGTATTTCAGTATTATACAACTGCTGTGACCAGACTTGTATACTGGCTGAATATCAGTGCTGTTTGTAATTTTTCACTTTGAGAACCAACATTAATTCCATATGAATCAAGTGTTTTGTAACTGCTATTCATTTATTCAGCAAATATTTATTGATCATCTCTTCTCCATAAGATAGTGTGATAAACACAGTCATGAATAAAGTTATTTTCCACAAAAGGACTTTGCAGTTTTAACGGGGGGCAGTAGGGATTGTGCTATAGAAATTCAAAGGCAAGGGAAGTCACTTCTGTTGTGGGGCCCTGGGAGGAGCCTCCAGGCTGGAAAGGGTTAAGGTGGAGGTCTCCGATAGGGGCAGCGTACACAGTGGACTGGCTGCAAAAGGCCGTGCTCAGCATTCAGACAGCATCACACACTCCGCTTTTCTCTACCAGGGAGGCAGGTGGGGAAGGATAGCGATGGGAAGGCAGGCGGAGCTCAGAATGTGGAAGGGGATCCAGTAAGACTTGGAAGTTTGCACCTGATCTGGTGGGTGGTGAGGGGCCCTTGAAGGGGCAAGGAGGCGAGGAGCACTCAGCTGTGTTCTTACACTGATCTGCCACTGGGGTTAGAGACAAACGTGGTGGGAATGGAAAGCCACGCACAGTCACTAGCGCCTCTAGGGGGAGAATGGATGTGGCTGGTGAGAGAACAGGGGGGCCCAGGGAGAGTCCGGCACCAACCTGGGTGGGGGAGCCCAGTGGGTGTGAGCACCCCCACTTTAGAGATGAAGTGATGGAGACATTCAGATGTTTAACCCCTTGTTCAAGATTCCATACTTGATAAATGGCAGATCAAACTCCCAACATAAAATGTGGGTCATTTCTTTATTATTTTATTTGTATTGGTTAACAATGATCAGCCATGCAAGAATAAATGATTATTGTAAAATCTGCAAACAATGTAGATATGTAGAGAGTCCCTTCCTTGGAGCTTGACCTTGTCAGACAGGTATAGATGAGTGTTCCGGGGCAGCCGTAAAAACTGCCAGAGACTGGGCTGCTTATAACAGAAACGCATGGTCTCCCAGAAGCCCACATTCAAGGTGTCCAAAGGCCTGGCTCCTGGAGGCTCTGGAGGAGAGCCTGTTCCCTGTCTCTCAGCTTCTGCCGGTTGCCAGCAAGTGTTGCCGTTCATTCACTCCAGCCACTGCCTCCATCTGCACACAGCAAAACAGCGTATCCTGAAGTGCTCAACCTTATAGCCATTATTTTAAAATATCCGGAACACACAGGACCGTGGGAGTGGCTGTTGGAGAAATTTTCATGAAGGAAGAAAGATTACAACTAAGTTTTAAAATGCTAATTTTGTTTGTTTTGTCTTGGAGAGGAGGTCAAAGTGGGAGTAAAAATAGGGAGTTTGGTGTAAGGTGGGAAAAGCAAAGGAACCCCGCATGGATGGGCTGAAGGGTGTGATGGGAGAACAGTGAGAAGTACGTTTGGGGAAGCAATTGGAAATAGTAGCTAAGCTTAATCACAATCTATCAAAAGGGACTTGTTGAAGAATTAATGTGTGACTAGGAACAGGGAGGTTATGGGCTTGTCAGCTCGACAGTGGGCACTCAGTTCCACTAACGAATGATGCCCGTGTGGACAGACAGAATGATGGACAGGCAGATGAATGCGTGGGCTTTATGTGAAAAAGGTCCTCTTGGTTGTTGACAAGATACTGTTTTAAAGTTCCATTTTGCCATACTTCGAACAGCTTGTCATTAGCTCAATTTAGCCACATGTGAAATCACTAAGGCGGACGGACTTCCAGAGTTCCCACATGAAAATCAAATGTAAACCAGCAGTGACCTGCTTCAACACCATCATCGGAAGTCAGAAGTTGAACTCTTTTTTGATGTTTAAAGCCTGCATAATATTCGCTGTATTATTATTCAGCATATTACTATTTCCTTCGTGATGGAAATTTGGTTTATCCCAATTTTCTGTTCTATCAAAACACCGCTACATAGAAAATCCCCATGCACATATTTCTCCTAATTGTGGAAATATTTTACATAAAAGACTCTTGACATGGGATGAAATTCCCAGGTTATTGGAATTTTAATATAGATAGGTACTTCCAAATTGACCTCTTACAAATTATATGAATTCGTAAGCTTCCAACTGTTATGGAGTTACCCATTTTGAGAAATCTGTGCTAAAAGGACCCAAACAATGCTGATGACAATGATCAGGATAATAAGTACGCTGGGAAGACAACAAAATGATTTAGATCTTAGACAAGTCATTCTAGGTGTCTCCACTGTTTCAGTTCTTGCGTTCGTTCATTCTTGTGCTTTTTCATTTTACCAAATAAAATAGCTCCTTGATGTCATATGAATCCACGCTATGCTTAATGAGTATTGGTTAGTAAAATGCCTATAACTAGTAATCTTCATCTATGCAATTAAATATTCATTCATAAAACACTTCAAATGTAAACAATAATTAGTAAAAGAAAAGTACATAATACCTCAATTAGAAAAAAATCACTCCATTAAAAAGACATTATTTGTGTGATAAAAGAGATTGCCATTTTTGTATTTTTCTACAAGGTTAAAGAAAACTAAGTCAACTTATACAAGTGAATTTTAAAAGACTTTAGGGCAGGCGTGGTGGCTCACACCTGTAATCCCAGCACTTTAAGAGGCCGAGGAGGGCAGATCACCTGAGGTCAGGAGTTCGAAACCAGCCTGACCAACATGGTGAAATCTCATTTCTACTAAAAATACAAAAAAATTAGCCCAGTGTGGTGGCATGTGCCTATAATCTCAGCTACTTGGGAGGCTGAGACAGGAGAATAGTTTGAACCTGGGAGGCGGAGGTTGCAATGAACCAGGATCGCACCATTGCACTCCAGCTTGGGCAACAAGAGTGAAACTCCATCTCAAAAATAAATAAATAAATAAATAAAATAAATAAAAGCCTTTAACCCAGAATGCTGAGTAAATTGGCCAAAAATGCTAACCTATGCATTTCAATATTATAGGAGTTGCATGGGTAGAAATAACCAGATGAAATACTTCTGGTATTTCACCTTCCCAACCCACACGAGCCAGTGTTTTTCTGTGAATAACAAAAACAGCAGAATTTACTTGCCTCTCCATAAGAGGTTACCACTTCTGTGTGTTCCCCCGAAACAGGTGGTGGCTGGGTGAGAAGGTGGACAGCACTAGGGCAGGAGATGGGGGCTCCAGTATCGTGGGTGAGCTTCCTAAACCTCTGCAACTTTCAGCCCCTAAATGGGATGAGCCATCAGAATTTTTAGCACAATGCCCAGAACAAAGTAAGGATTTGACAAATGACGCCTCTCTCCACATTGTTCTGTCATCAGCCACCGCATCCTGTACCTCCAAGCCCACTGGGCTCCGGCTGTTTCCATCACATGGAGAATGACTCAGAGCCTGGCCTCCAGCCACCCTCCTGGCCTTTCTTCTTCTCACTCTGCCACTGGCTCCTCATGGACCACCAGCCTGGGTGTCCTCAGACATACCACACACTTCACTGTGGGAGTCACGCAGCCCTCACTGCTCCTTCGCCAGGGAGCCACGGGGCTTTCCTCCTCAGGAGGACTCTGCAAGCAGCTGGATGAAGGGCCCTCCCGTCTCTCATCCTTCCTTAATTTTTGTCACAGTTCTCCTTCCTTCCACTCAGTGCAGCGCACACTGATTGATCCTCCATCTTCCCCAAAAGACAGGAACAGCATGAGCAGTGGAGAGTAGATTCCAATGATAGAAAAAATAGTCAGTGATTTCTCATTTCCATTGATCATCAATGAAGAAAATGTATCCTGAAGGTCATGTACCTCCTATGGGACTGCTGCATCCTCAGCCTCCTGAATTTCAGCCCAGCACCTTCCTCCCCAGCACAGCAACAGGTCAGCCCTTACCAGCATCCCTCTCTTATTGCCTTTGTGCAGAGCCAGCACCAGGGCCAGGGGAGGCCTTGGGATTGTCCCTCCCCAACAATCTGTGAAACAATCCTTTATGTCACCAACAAAGCACAGCCTTCTGCACTGGTGGTCAGTCCCTCTCAACACCTCTGTCACTGTAAAGCTGGCAGGCAACCCTCCAAGGTTGGCCTTCCCAAGCACTGCACCTCTAGGTGACAGAGCACGTCCTTACCTTGAAGCCTGGGCGCCCAGTCTATCCTGTCCAATGAGCGAGCTGTGGAGAAGGGGGGATTCCGGGTTAAGGGGAGACTAGCAGGGCTCCTGCTTTTATGTTGCCCTGTTGGGAAGGCTATTAAAGAAACACAAAGTGCTAAGCAGTGAGGATAGAACATGTTTTCATTATTTCAACCAATACATTCCACAGATGGAATAATAAGAAATGCTACAACCAAGCTAACTGAATCCAACAGCATATCAAAAAGATAATCCACCATGATTCAAGTGGGTTTCATACTAGGGATGCAGGGATGGTTTAACATACGCAAGTCAATAAATGTGATACATCACATCAATAAAACTAAAAACAAAAATCACATGATAATCTGAATAGATGCAGAAAAAGCCTTTGACAAAATCCAGCATTTCTTTATGATTAAAACCGTTCGTCAAAATCAGCATAGAACGGACATACCTTAAGGTAATAAAAGCTATCTATGACAAACCCACAGCCAACATTTTCCTGAATGGGGGAGAGTTGAAAGCATTCCCCCTGAGGAAGGGAACAAGACAAAGATGCCCACGTTCACCGCTTCTCAACACAGTGCTGTTCACTACAGCATTGGTTATAAGAGCAAGACTGGAAACAGAACAAACGGATACCCATAGCGGGGTGCTTAAGTAATTTTGGGAATAGTCATGGGGTGCAGTACTTTATAGCTCTGAAACAATACAATGGATTTACATTTGAAATGTGGAATGATAACTAAGGTGCATTGCCCAGTGATATATGCAGAGGTGCAGAGGACTTTGTGTAAACACGATCACACATCAGCCTGCATTCCAGGTGCATGCTTCTATTTGCACATAGATTGCAGGGATGATATGCAAACAAAAATGTTGACTTGGTGTTTGGAAGTTCAGAGTGGAAGGGAAACTTCCTTGCTAACCTTTTATGATATTTAGAGTTTCTAAATGTGAATACGTAATACATTTAGAAATCTTAGTTAATAAGAAAAGCCTCTGTTCCTGGCCTCTTGCTGGCACATGTCAGGTGGAAATGGGGCTGTCATGCTAATGTGTGCAAACTGAGAAAAATCCAAGAATGGGAGTCTGCTTTTTTCATCATACAAATAATTGTTAATAGAAACAGTATGATAATTGCTCATTGATATACCATGCATATTCTATTAGATAATAATAAATTTCTGAAATTTGAACTATACTTACACATGGAAATTGAAATATATGGATGAAACATTGTGGCTTATATAGGCAATTGTTTTATTGGCATTTTACAAACTGATCATCATTCCTCATGGCACGGGTCCATGTGATATTAAGTAGCTTGTTATGCTTGGGAAAGGCAGTGATGACCACAAGAATGACTTCAACTACTAAAGTACAATGGAGATTTCAACAATGTTTTGTTTAATATTTAAATATTTCATTGTGCTCCCAGGCTTTTTCTCACCCTAATAGCTCTCATCCATATCATGTGGGTCCCATTAATACAGATACTTCCGAATGCACCACTCTTCCATTATATCCAGTCAATTGCTGGTTACCTTGGGCCTACCAACTGGGGGAGGGCAGGGGCTGCTGGCCACCTCCTCATCTACAGTAAGAGTCAATGAGCAGTTAAATGGATACTGAAAACCATTTATCCTGCTGGAGTGAGAAATAAATGGTTTCTTTCAATAGCGTAGTAAAATGCATCTTTTCCAAACTATTTATATGACTCAAGGCCCATCTCAATTTCAGATGTGGTTAGCCTCAATTCCTGATTCTCACCAAGGTGTGTAATGTCATCCACGGCCCAGTGCAGAGGAACACAGGTGCTGCCGTCAGACTGCCAGGGTCCGATCCCGCCTCCTCACTCACCCCGGGAGATCCCTTTAAGCCAGGAGTCAACAGTGAGGATGGAAACATGAGTGCTTTTTAAAGTCCTGAAAGTTCAGAGGCAGACTGTCAATTTCTCCTCCACCCCTGGGCACACACCAGGAGAACTCTGTCTCCAGGTTGAAGGAAGTGCCTGTGAGAGAGTTGTGTCCCTCAGATTCTGTTCACCACAGGTGACACTCGATGCAACCCCAAACCTCTTCTGCACAATCCCAAGGGGTGCTGACTAATCCAACCCAAAGGCTGTGATGTTTGGCAGAGGCAGAAAAGAAAAGGCCAGGTGTTCTGGGAAAGACCACCTTTAAATATCACAGCACCCTCATAGCCCAGAGAGACAGTTCTAACTATT";
$full_seq{"A5_MAGENTA"} = "GGTGGATGGCCTCTGTCCTGGCAGTGCAACATTGCTGGAAGCATCCTCCAAGAGTCACCCATCCCCACAGACACTGATGGAGGACAGCAATGATGCTTCCTGACAGCAACCACCATTCACTGAGCATTCAGCAGGGGTGGGTGTCAGGGTCAGCCTCCACCACGTCACTGTGGGAACAGCCCCCAGGACCCGCTAACTCATTTTATACATCAGGAGGAAAGCCAGGGAGCACGGTACACTCTCCAGCTACCGTGGGGCCAGCACACTGTCCAGCCACCTTGGGCCAGtgaaacggaaaaagttcccttgttgccctagcagtgtgtgtgagaaggggagtggctcgcttcttcagtgctccactgcccaaacctctaggggagcttacagacgggcaggctgtggagctccgaccccacagcagtgtctaggggtgaaggtttacagctgaagccccagtgggcgtgtgtcacgggggcttttttagtttgtcgtctgtagggtggcttgtgttagtcagagggctttctggatcctggggttcttgcctttgtgtaccagaagagtcagatcacacgtggacttggagaatgagtgcaaggttttattgaggggaggtggctcccagcagataggggaagctagaagggggtggagtgggaaggttttcccctggagtggggccgctgtgcacccgggctgtcctccaactgccccagccaaactccgcgtggttctgccagtcagtggcctgccagcatgccggtgcctatcagtgcgttcatctcgacatccagccgcccgtgtgtgtctccgctgatgtgctcctctccacgtccagctgcctgtgtctgcctgctaaggtctcaggggattttataagcacaggatgggggcgtggcaggccagggtggtcgtgagaaatgcaacatttgggtaggaagtgcctgttctcacctaggtccgtggggttggagccctagtctgggaccatgccctcctctacccagcacttcctttccctgcttccgtatcatttaaatggaccacacttttcccttcccagcacttGCCTTCCCTATCAACAGCACATTCTCTAGCCACCATGGGGTCAGCACACTCTCCAGCTACGTCGGGCCAGCAGCGGCTGGGCTCCAACTCAGGTCTGCACCAGACCCTCATTCTTAAACCCCTGCGTCTCGGCCTGCCCATGTTCCAGCTTCCCCAAGTCTTGACTCCCAATGTCCCAGCCTCCTTGAGGTCTCAGTCTCCCTGTTCCAGGCCTCAGCCTCCCCTGAGTCCCTGCCTAGCCCAGTTCCTACCTCCCACTTCCCCTCCCCAGGTCTCTGCTACCATGGCCCACCCAGCTGCACCCCCACCCCACACTTCTCCTGGGACCCAGGAGGCCACTCATGGGCTAAGCCTGGTGGCATCTTCATGTAAACCTTGCCCTGAGCACACGCCCGTGGCTGTGGCTGCTGACTTTCACTGTGCATATTAAATGCCATTAAGATGGTTGCGATTGGTTTTCAGTGTCCAGAGGACTGCAGCACACGGAGAAACAGCCGCCCTGCAGGGCCTCTCCCCGAGCTCTGGCGGGTGAGCCCTTGTGGGAGGGGCTGGGGAGCTGGGACCCATTTAGGGTGTGGTTGGGGGAGAAGGCAGGAGGCAGGTGGGACCTCCCCCGGAACCTCTCCTGAGACACCCTAAGGGCTGGGAATGGGAGCTACTTGGTGGGGGAACCCAGCAGGGGTTTCCTGTCCCCGGGCTCTGGCCATGACGAGGACCCTCCTGCTGTTGCCTCTCCCAAGGCCACTCGGCCCCTGCTCACTGTGCAACCTTACAGAGCAGCTCAGCCTCTCTGAGCCCCTCTGTCATCTTTAGCCACTGCCCACCAGAGTCCCCTTGGAGCTGCTGGCCAAGGCAAGGCTGGGCAGGGGCTTGACATAGGCTCTCACGCCTTCAGATGCCCTCAAATGGGATTCAACCCCGTCTTGGCTCCTGAGACCTCCCAGCCTGGGGTCTGAGGGTCTGTCCAGATCTGCAGGTAGATGGCTGGGCCTGCAGGGACAGAGGCGGCCGGCGGAGGGCAGCAGAGGGCCGCAGAACTGAGCGGCCGGCACTCACCAGGCCGGGATGTGGCCACCCTGCATGCAAGCAGCCCTGCCTCTGCCCTGGGTCTTGTCCCACCCCCCAGGACACCCAGGCCCTGGCTTGGCTGCGGCAGGGAGGCCAGGCCTCACCCCTCTCCCTCCTGACACCTGCCCAGCCACTGGCTTGGGCCGCCGCCCTCCAGGCCTCTCCTGCCACCCACCCCAGCACCAGGCCCCCTGATGCCCCTGCTTCCCTCCCAAGGGTCCCTCCTAGACACCATCCTGGCCCAGCCAAGATGCCAGCACAGGATCTCCCCAAAACACTCTGGGCCCTGGAGGACAGGGTGAGGCTCCGGCACCTTCCAGGTGGCACTCATGATGGACAATCTCAGGGGCCACACACCCTGGACCCACCTCCCCCAGTGCAGAGACCCCCACGGCAGGCTCTCAGCCGTGAATATGGACACACAAGGCTCCCGGGACATGGGCAAAGGGTTGACACTGGCTCATAGTGTGGGCACCATGTCACAGGGCGAGACGGAGACTCAGCCCCCAGGGTAGCGGCCAGTGCTGACCTTGGGCTAGGCCAGGGCCTGGCCATGCTGAACCAGGTCTGAGCATCCTCAGGGGCCAGCCTCTCCCTGTGGGGTCCCCACAAAGGTGGCCATGGGCTGTCCTCTGATGACAGGAAGCCCCCCTTCCCGTCAGCCCCGTCTGTCAGCTCCCTCTGCCCTGGGGTGAGGCCTCTATGGTGAGGCCCATGGTCCTGGCTCCAACCTCGCACTCCTCGGGACCCACTCCCATGCCCGGCTCCCTGCCAGACCCACACACCCAACCCAGCTAACACCAGCCCCACCCTGTCCTGCCCCACGGGGGCAGTGCCCTCCACTCTCCTTCACTGGTCCCCTCTCCGTCCTCCTCTCACCCACTCTTAAGAAACCTCCCACACATGAGCACCCGTCCGTCCCCACACCTGCTCACCAGGCCTGGCTGGGCCTGACCCTCTCCTGAAGTGAGGGCTGCAGCCTGGTCGGCTCAGCTCATCAGCACAGACTTGTTTCTGTCACAACAGCTGATGAGGACTGAGCAGATCATGGGCTAGCCAGGTCTCCATGGCCTGCCCCAGGCACCGTGATGTTCCAGGATGGTAAAATGAGGGAGGAGGTCCAGGTGGCTGACAGCTGGCTGAGGCAGAATGCGCTGATTGGCGCTGCCCAGAGGGGAGGTGGACCCCTGGGCTAAGGGAGCTCCAAGGAACAGAGCTGAACCCACCACTAACAAAAGATGGGCCAGAGCCAGCACCGTATGCCACAGCACGCAGAACAAAGGCCTCGTGCCCTGTGCCCAGCTGGCCGTGTGTCCCCTCCAGGCCCGTCACTGGGCTTCCTGACCGCCTCATCTCCACTGTCTCTGGTAGCCACCCTCATTGTACCCTTCTCCATGGTGCCCTCTGAATGAGGCCACCATGTCCGAGGGGACATGGATGACTCCAGCTGGCATGGCCTTGCCCATCCCTTGGGGCTGCAGCACAGTGGCCACCCTCTCCTCACTGCTGGGAATGTTCTGGAGCTGAGTTGGTGCAGGGAGGGTGAAGAGGCCCCGAGCCCTCCACACACCCACCTCTGGCAGCAGTTAGCAGCAGCTGGGGAGAGAAGGGTGTGAGCTCTTGCAGACATGGCACCCCAGGGTATCCTGTGCCAGGGGACACTTTGGCCATGAAGGAACTGTCGGGGCATGGCAAGCTCTGGGGGGCATCGAGGGTGCACTGACAGCACTTGTAGGGGAGCGGGGTCCCAGTCTCAGCACTGTCCAGTCAGACAGGCCTGGCCTGAGTTCCAACTGCCTCTCCCAGCTGTTTGACCCCAAACATCATGGTTTTCTGGCCTCTGGAACGGTGCTGGAGAGGGATGAAAGCATCACCGGGGGTGCAGGAGGAACCACAAAGTCCTGTGGAAGTTCATGGCAGCTGTGAGCCTTTCATTCTGAGTATCTGAGACCCCAGGAGGGGCTGGGCGCTCGTCTGGGCTGATGTCTCACAGTGAGGGGCGGCGGCCCCAGCCAGGATGCACCATTCATTGCCATTGATGAGGTCTGGGAAGAGAGGTGGTTTGGGGGACATCATACGGGGTCCCTGGGCCGGAGGGTCCCATCTTTGGAACAGAGGGGCCGGGGGCCATTCCAGAACAGTGTCCAGGAGAGAATGGGCTCTAAGCCGACCACCCAGCCCCCTCCTGCCATGTGGGGCTCTGTGCTGAGTGCATGGCCCCCCAGCCCCCCGCCTGTTTGATGGCTTCTCCCCTCCCCTCTCTGCTGCCTGGTCCCCTGGAGCTCTCCCTTCCCCAGCATGGGGCTCAGTTAAAGAAAAAACTGATTCCTGCAGATGAGGGGAGGAACAGCCCTGCTGGAGGCAAGGTGGGCGTGGGGGGAGCTTGTCTCCCCTGATGCGCAGGCAGTGGCTGGCGGAGCGTCTTCGGGGGTGGGGGATGAAAGCTCAGACTCTGGCCTGTGGGTTCCAGCTCTAGGCTTCCCAACCACCAGGCTCCCCAAAAGGTCTGTAGTGTCCTGGGCACCCAGGCCCCGATCTCGGGGGCAGGGGGCACAGTGCCTCCCACAAGCGGCTCTCGGCCCAGCCTCAGGGCTCCTCACGCACACCCAGGGCCTCTGGAGTGGGCAACTCCTGCACCCTCCACTTCCCTCAGCTCAAAACCAGGGCAGGTTCGAAACGCGCGTGCAGCTCATCATAAACACGGGTTTGGAATTTCTAACGCGGTGCCTCCAATTTCACAAAATATTGCCCCACTTTAGACATTCTCAAGGAAAGGAAATGGGGGCTGGGAGGGCCCAGGGCCTGTGGAGGGTGGGGCTGGGGGAAGCAGCCATGGGACCCTTTCCCTGCTGCTTTCAATCTGGCTCAGATATTTTTTAGATGAAATAAAATCTGATTCAGTGGTGGTTTCTGCACTGCCCCCAGGGTCTGGGGTCAGAATTCCCCCGCTGGGGCACAATAGGTGCCATTTCCCATGTTTGGGGGCTCAGGGAACAGGGTGTAAGCCATGAGGGGAGGGGCTTGGGAAGGTGGGGATGGGCTGCTGGAGGCCGTGGGCCGGCGTCTTGGTGTGGCAGCCTCCACCACGGCAGGCAGGTCATTTGATGCCCAAGGCCCAGGGCCCCCTGTCCAAGGTGAGGAGCTGTGGCTGGGTCTCTGGGGAGGCCAGGCTGCCTGCAGTGGACCGGCTATACCCTGGAGCCCCGCGCTAATGCCCATCCTCAGATGCTCCCAGCTCCGGCTTGCCTCAGGGCCTTGGCACTGGTGACCCCTCCCGGTCTCCTGCACTGTCTTCAGAGCCTATGGCAGCAGCCCCACCTGAGTTCCAGCTCTGCAGTCTGCTTTGGGCCACATTTCCTCACTGCAGGCCCAGCTGGCTCTCAGCATGGTATCTGCCCGGGTGCCCACATCACAGAGACTGGGGTATGGAGGATGGCAGGCTCCCAGGGACCCTCTGGGCCGATCTCCAGGTTGGGTGCATGCTGGACACTCACTCCATTCTGCCCTCCATTTGCCCATGCTCCGTCCACCCAGCCGGGCCCGGAGGGTCAGGGGTGTGTGGGCAGGTGCTGCTCAGAGGCCCTGGCTATGGGGCAGGGGGCCCAGCCTCAAGACTGCGGCCTGGCCCTGAGCGTGGGCGCAGCCTGGCTCCCCGACTCTCCCTCCCCATAAATAAAAGATTCCCTTCCTCCTTCCAGCTTGCGCAGCCGCCGCCTGCTCGCCGGCCCGGCCCTTTGTGCCCACGCGTTGCCATGGAGATGGGCGATTCAAAGTCCTGGCACTTCAAGGCTTCCCTCCTCTCCTGGTGGGCCGGGGCGGGGGTAGCCGGGATGGTTGCCCGAGCCCCAGTGGGTGCCGCCTCCTCTCTCTGTCCAGTAAAATGCCAGATCCTGCCGGGGCTAGGGCACCCACCAATTCTCACTCTGGTGTGGGTGGCTGACTCTGGCCCCTACCCTGAAAACAGATGCGCTTTTACAGGGACCTTCTTCAAAGTTTGATAGAATAAGGGAAACTGAGGCACAGCTGGTCCCTTGGCCACCGTGGGGAACACAGAGCCGACCCCCTGTATCATGCACCATTTGCACAGTGGGCTGCTTTCAGCTGTGTGCTGGCCAGGGTCATCAGGCTCCAGGACGTGGCCCTGCGGAGAGGCTGCCCTTCCTCCATCCCAGCATGGACGGCCCAGGGCTGGAAGCCGGGATTTGGGGTGAGCTGCACGGGGATGACTAATCCAGCCACAAAGCCGTCCCCTCCACACTCTGCCCGCCATGCGGGTTGGAGCTATCTCTGAGTCACCGTGGAGACGTTGAGAATGTCGCAGGGTCTTTGAGGCTCTTCCGCTCCCCCCAATCCTGTTCCCCACTCATACTTTTTATCTCCCCACAATCTGCCCTTTGATCATCTCCTAAGACTCATGCAACCAGCAGAATTGACGGCAGCACTTTCTGGTTCAGCCACTGCCTCCCACCTACCCCACTGCGGCAGCCActtggtatttgttgcctgctcactgtggcagccaggcaagtctgggaccccttagagcctcggtttcctctcctgtgtaatggaagcagtcgtccactcttaacaaatgtccagagatgtctgggggccaggtctctgtgctgggcctgggaacaAGACACCTGATTTTGGGGGAGATTCTGTCCCCCTTGCTCCACCCCATGAACTCTGGTGAGGGTGACCACCACACACCACAGTTACTTCCGGGCCCCAAGTGGCTGGCCCATCAGGGACTTCCCGGGAGTCACAGGTTGGAGGGAAGGAAGCCAGGGAGAGGTGGCAGAGCTGGCTGCACCCCAAGGCTGTCTCCAAGGGGCCCACCCTTGGCCTCCATCCACCCCTCCCTGGCCCGGACCCCTGTCCTGCCTCAGCAGCCCAGCCCACGGCAGCTGTCCCCTCACAGGCTACAAAGATGGTGGCCCTGGTCCTGGCCGTGGAGCAGGCAAGGCACGTGGAACATAAAGAAATATGGTTGTGAAGTGGCCAGGCCATGGAGGAAGCTCGGGGGACCTCGATGTCTACATTAAGACCTCCCAGGAGTGGGTTGTCCCTTCTGGAAGGGTGCTGGGGACAGCCGTGTGGCCCTTTTCAGTGGAAGGATCCCACATCCTCAGGCAGTGCCATCACATCCCCTGAGAAGCCCTGAAACCCAGGCATGAGGATGCAGCTGGCCCGGTCCCGGCAGGGAAGGGAGTGCAGCAGCTGGGCTCCGGCTCGCCTACCCACTGATTGCCAGTGTCCTGGGTGAGAAAGCAGGAGGCTTTTGTGCACACATGGGCCTCGGGACTGGGTCAGGGCTCAGGCTCCCCAGACGGGAGAAAGTGCATGCAGGGCCACCGGCTCCCCAGC";
$full_seq{"B1_YELLOW"} = "ATACTTGCACTCCGGGCCTTCTCCCATGCTCTCCAGCCCCCAGCCCCACAAAGCAGGCTGGATGTGGTCCTCATGCCCTGGGGCTTGGATGGGGGCCCCTGTACAGATGGCAGTGACAGCATCCTGGGACCAGGGCTGGGGCAGGAAAGGCTGGAGGGTCCCAGTCTCCAGGCAGGGGGAGGGGTGGTGGGCTGGGCACACAGCCCAGGAAGGGGCCCCCAGGTAGAGGCCTCTGCTGCAACAGAGGTGGGGGCCCTACCAGGGCCCCGGTTATGGCAGAACCTGCAGCTATCACACAAGCCACATTTGGGCCACACTGAGGCATCTTTATTTCTCTGGGTCACACAGAGCTTGGGCCTGGGAGCCTCTTCTGCATGGGGGCTGCAGCTGCCAAGGGAGCGGCTGAGACCAGAACAAGCGCTCGGGTGGGCCCCAGTGCAGGTTGGGATGTGCCCGGTGGAGTAAGGTGTGAGAACCCCCAGCCTCACTCTCTGCCTGGTCCTGAAGCAGACAGCAGCAGGCTGGCCCAGCCTCCCCTTTATGAGACTATCCTAGGGTTTGACAGCAAGTCCCAGATGAAGGGTGACAGGCAGCTGGGGTCCACCTGGTCTCTCCTCAGCAGGGGGAACCCCCTGCGGGCAGCTGGGAAGGCAGTGGCCAAAGGTCAAGAAGATGAACTCTGCCCAGACTTCTGCTGCCTGTGGCTATGGTGGGACAGGGCTGCCTTTCTGGTCACACTGGGCAGCAGGCGACTGCCAGGGACCTCCCAGTCCCAGGGCTGCATTCCCTGCCCGGCAGCCCCTCTGCTGCAGCTTTCGGATGAGTTCCAGCAGGTTCATCTGCAGCATCAGCTCCTGGGATACAGAGGGGCCCCATGAAGGCCAGAGTGACCCCCAGGCCCCTTTCATCCCGGCCCAAGGGTGCCAGGCAGTGAGCCCACGGGGGCGACCATCCTGTGAAGCCTGGTCATGGCCTGCCAGGACAGGGTGGAATCTGAGCTTCTGCCCCCAACAGGGCCACTCGGAATCTGAGCCTCTGCCCCCAGCAGGGCCACTCGGAATCTGAGCCTCTGCCCCCAGCAGGGCCACTCGGAATGGCATGCGGGAGGGGAGCAGAAGAGGGCCCTGTGTGGCACAGCAGGCCTGGAGAGGGTGGGCAGTGCCCATGGCTGGCTGGCTCACCCTCCTGTAGGGAATGGGCCTGGCCTCCGTGCTGGGAATGGCACAGAAATCCTTTCCAGAGCCTCAATCCTTCCACTTCACCCCCATACCCTGAGCCTGGCTCCCCAGGGACCAGCAGTAAAACCCCAGATGGAATGGGGCCCCGGGGCACTCGGGCTAGGGCAGAGCAGGCCCAGGCACTGACCTGTGGGTTGGTGGTCACGTAGAAGCCAGCCACCCCCGCCTTCTCCAGTGTGCTCTGCTGGTCAGCCACCTTCCGGTCCAGCTCCAGGATGATCTTCTGGTCCATCGCCCGCTGCTCCTCACGGATCCGGTGTTCCACGGCCTGCCATGGGGCCAGGGCGCGGAGGGGGAGAGGTGAGGGCAGCTCTGCCATCAGGGGGCGGGGAGGTGAGGGCAGCTCAAACACATGCTCCTGCTGCCGTCCCCAGTGGCAGCAGCTCTGACACCACCGGTGCATCCTCACCACACCCAGGCCTCTCCTCGGCCATGTGAACCCCTGAAGGGGGCCCCAAGGGGCTTCCACGAATGCCCTGGCTTGGGACTGCCTTAGGACCACACACACATCTCCACAGGCACACCCTGCCCCACGGCTTGTTGGTTACATGCCAGTCTCTGGTTGTCCCTGTGCTCCCTGGGAGAAGGATGGGCCCCTTCCTGGCCCCAACACCCTACCATTGCCTTTGTACCCCCCTGAGGCCACCTGCTCTGTGGAGGCCCAAACCCACGAGGAGCTGCTATCCAGGGGAGCACTGGTGGGTTCTCAACCTCCACCCAGCCCCAGCACACTTGGTATCCGCAAAGAGGAGCCACCTGGTGGGACTCACTAGGCCTCCAGTGTCCCACTCAGGCCCAGGACAGCCACCCATGCCTGAGCCCCCACACCCCTTCAGCTCAGCCCAGTCAGCAGAGCCAGGTGGTGCCCACAGGAGAGCTGGGCCGGCCACCCTGCCTGCGCCCCCAGTACCTCTAGTTCTCGCTGCTGAGCCGCCTGAACCACAGGCAGGTTGTGGGGCCGGCAGGCCTGCTGGGCTTCCTGGTGCTTCTGCCGCAGCGCCTGCCTGAGCACTGGGAGGGATGAGAGCCCGTCAGCAGGCGGTGGGACTCGGCAGCAGCCCTCACCCATGGGCACCTGCCTTGCCAGCCCAGCAGAGCAGCCAGGCCAAAGGGGTGTCTGCAGTGGGGAGGATGCCAGCCTCCTCCATCCTCCCACCCCACTGTCACCCAGGGCCGGGCCCTTATCTGGTGGCAAGTCTCCAGGGGACTCCAGAAGGTGCGGGGCACTGAAAGAGTGGGGTGGGGAAGACTGGCCAGGTGGGGCCAAAGCTGCAGCCCCAGACCCAGGGCAGCTGGAGGAGGCAGGCGGGAGGGAGGCTGCAGTCTGAGGGCTTCAGGGCCCCCATGGCCACAGGCCATGAGACATCTACTCAAGTGTCAGAGACCACCTCAGGCAAAGGCATGGGAAAGGAGCAGGAGGAGCGGGGTCGCTGACCCTGAGCGTGGGGCCTCTGCCTACCAGGGGTGTGGTCGGGCCCTCCACCCTCAGTGCTGCCCTTCAGGGTAGACAGCCCCTCCCTCATTTGCAGCTCCCAGCCCCCGCACAGCGCCAGAGGGAGAAGGGTGGGCAGACCTGGGAGGCCCAAGTTTGGGATGAGCTTGGGGTGCCATAAGCCTGTGTGGCTCTGAGGGGCTCACCCTCAGCCATCAAGTAAAGCTCCACGGTCCTTGCTAAACTGTGCACAAACACAGATGTGTGCAAACTGTCTGGTCTGAAGGGAATGTACAGAGGAAGCGATCATGGGACATAAACCACCATGAAACAGAACATGCAGCACCCCACAGCTGGCGCCAGTGACCAGTAAGTGCCAAATGGCTACAGCTCCCCAGGAGGGAGGGGTCCCTGGCCAAAAGAAAAGGTGAAACCCAACACTCTGTTCCTGGGAAGAGCCCTGATGTTGCAGCTCTTCTCTGGTGGCCAGTCCCCAGGGAACTCCAGGGCCCCTGAGGCTCCCCTGCAGGTAGCCTGGCTCCCGCTGTGCCTACAGCCTTCCCCGATCTCCTGTCTCTTCACATTCTGTACACACCTCGACGATGGTATTTACCAAAAGCCCCCCTCAAGACAGCTCCATAACACAGGGAAGCAGGGAAATGTCATCTCCTTCACTCTACTGATCAAACATTGCTACAAGTGCCAGGTCCACTACCAGATTCCACTAGATAGACAACCAAAAGGCAAGAAGAGAGCCACGCTGGCTGCCTGGGCAGAAGGGGCCTGGCCTTAGACATGACCAGGGAACACAAAGGAGGCAGGAGCAGCCAGTCGCCCCTGCCAAATCAGCAGGAGAAGCAGAAAGTCAATGCAGGCATGCCTGCTGCTGGTGGAACCAGGGCCTGGCCCAAACCTTCTGAAGCACAAACAGCATTGGGCCCAGGCAGTTACTAAAACTCCccatcctgctataaggaactatagctctgtggaaaaatggccgattccaggactgagacacggagaaaacaagaaaagatgagcctgaacacatacctgaaccagaaagcaagaaagtgctcacagaatgatggggcggcatctaaaggtgcctggagcgcccccaactggccacacatggcacagtctgggcattaaggaataatgaGCCATGCGCTTGGGATTAGTAAACTACATACATCTTACAGCTCAATAAAAAATTTTAAAAAGACAAtcgcccagacatttaggggaagaagtaatgccaattctacacaaactcttctggaaaactgaagaggagagaacacttcgaaactcatcctataaggctggcaaaaaccctgatacccaaaccagatattacatgaaaactatagaccacagtttatcatgaacatagaccaaaaaattcttaagattttagcaaatcaaatccagcatacataaaaaggatactacagcacgacccagtaggatggaattcaagtgactgtaattcactgtagtaatagaaaatgattcaccacgtgatcatctcaagagctgccgaaaagggaactgccaaaatccaacatccattcttgataaaaacacaccaatcctggagcagatggacactgcctGCCTTCTGGGGAAGGGGGCCTTGCACTGctaggagaaatttttgccacattaaacctgcttctaatcaggcttctaccagcagtccagtgtacaggaaacccagagagtggagaagcaggttaaatgcaagaggaagcatttcgtctgatagatcaagagcagggcattctataaaattagaatgccctggactctacaaaaaagtcaatgccacaataaatgttggggactgtttcagaagcaaagagaccaaagtaaccaattgtagtacatgaacttggactggatccttacttataaagcaacAATTTGCCACAAGTTAGGTACCATGATGTGGCCGTGCACTGAAAGTCAGGAGACACCCGGAACAGTTAATTTCTCAGGGGGCTACCTTCTGCAGCTGTGTAGGAGACCAGTTTTGTTCTAGAGCACTTGCTCCCAATCCAAGGCCAAGGTTGACCCCACCACCCAGGTTGTCTGGAGGCATTCTTGGTTTTCAGGACTAGGGAGGGTACCCCTGCcatcctgcaatgcgcaagacagcatctcaccaaaaagacttacccagccacaaatgtcagcatggctgggttgaaaatcctgGTCTCCAGGAATGCTGAAGACTCTTGGTGAATGCTATGCTGTCACATGTATATATTTTGGGATGTCAAGaactagagcaaaacgttaactattgaactttagtgaagagcacaagcgtatgcactatactatcttttcagcttttctaaatgttttaacttctaaaataagaagtttgggaaaaataaCAAAGGTGGAAACTGATGGTGCAGGGGGACCTGCCCTATATAAT";
$full_seq{"B2_RED"} = "GAGACTATTAACTAAGAACATACAGTTTTATTTATACTCAGAAGCAAGTAGATTATGTACATATATATGAAGATAAAAATTAAAAGGATAATTGTGTAAATTTGCATGTAGAGAGCTTTGAAAACCTGTTTACTTGTTAATGCTGTTTTGATGTATTGTGTCTTTGTTCTCCCGACCCATCATCCAGAGCTCTCTGCAGGAGCTAAGTGCTCATCAGTTCCATGATTTGGAAACTGTCTAAGTTTAGAGGCACTTGTATTTGTTAGTAAATAAGGCAAGATGATATTGTTTCACAGGTTTTAGTGCAGAAGACTGAATAGATAAGCTGCTCCACCCAGTACACTGGTGTTCATTTCATGGTCATCTCATCTGTTAACCATGGATATAAAACATTtatcttcaatgatggggttttaccatgttggtcaggctggtctcgaactcctgacctcaaatgatccacccacctccaccttccaaactgctgggattacaggtgtgagccactatgcctgacTGATTATTTTCATAACCAAGAAAAGAAATAAATACAATTAATGCTGGTGCATGGTATTAAATCTAGTTTTTAAAACATTCACACATAAACAAGGCAGAACCCTATACCCTCCATGATAAATGCAGTAGCAGTGTATGTGGGTCTGTGGAGGTTGAAAGGGACTTGGTAGATGTCAAGAAGGTAGTGGCAGTCCTGCTGGGCTTTTAAAGGGTCTGAAGAAGTGACAGGATGCTGTGGTTGAATCCTAGCATGTATTTTAGCATTTGTTCATTTGGAGTTGATTATTTCACGTTGCTTTCATTTGCCATTACCTGGAAAGCCAAGGGCTCTACTCTCATTTCCTTGCTGCTCTTTCTTTGCCTTCCTTGGTCCGTGAAGAAGATGGTCCAGGAGAAGCTCATTCCATGCTTGTTAACCAGGCACGCCCCTAAGTTCCAGTCCCTGAGTCATTCATGAGTAGCACTGCCAATGAACTGACAGCAATGCTGTGTCCCTCCACATCCCCTAGGTGACTCGAAGAAGCCTTCCAAAAAGCGTGTGAAAAGGAAGCCCTACTCTACTACCAAGGTAAAGTAGCCTGTCTTTGCCTAAGATGCAAATGTTGTTTTCTTGGATCCTTTATTTTTCAGTTGATATCAGCTATGGGAAAATTATCCACTACATTATAGGTGTTAGATAATATTTCCTTGGGGGTGGAGGAGGTGTATTTTACCAACTGACACCTGATTCCAGAGGACGTGCAAAATTGGCAGTGTCAGATAGTACACTGGGTGCTAAGGGATGTTTTCTTCAGGAACAAGCTTTCCACTTTAGATAAGAATTCTGCAATTTCTACTCAAAAATTACCTAGACAGAAACATTCTTCAAGAAAAGCTCCTGTGCTTTCCTAAGGGAACTCTACTCTAGAGTTGGGGCTTTTGACTTGAACCTTATTTCCAGTCTTGGTTACCCAGAGTTTCCAAGTGAACAAAAGACCTGTGTGAGCCATCCATAGCATAGCCTGATTCTCAGAGTGTTTTCCTTCTCTAATTACAGGTGACTTCAGGGAGCACATTCAATGGTACGTATTCTGGAATCACTCACTGGTTGTTAGAAAAGGATTCTACAGGAAATCTGGAGCTTAACTGCTGGCTTTTGTCTGGAGAGCCTCCATGATCCAAGACATCTGGTGGGAATGAGGATGTAGGGTATAGTAAAAGAAACTGGTTTTCCTGGTGACATACTCTTTTTATCTATGTATAGTTTCTGGGAACATGTTCACATTAGGTtgtgtgtgggtatgtgtgtattagggcgggggtggggtgaggtggtctgtgtgcaagtctgcatgatttgcttgtgaatgtgtgtctatgtgtgtTTCCCCTACGAAAAAAATGTTGTGTTTACCCAGCACAACTCTCAGTGCCATGTTTCTTAATTTAACAAATCAGACCACATActttacttacattagttcacacctcatcatcatcatgcccatatgttgtgagcttgtttactgagcccacatgccagatggagaaactaagccacataaataaatgtgccctggttcacttgctgcatagtgaagagtcaaaatGTTTACTCATACGGTGCTAATGTTGAAGGCCTGAACTACAACCTCTATTTATCAGCCAGTGAAGAGATCACTATTCACCATGCAAGGGAGTTCCAGCACCCTCTATGCCTGGAATTACCCACACCTGCAGAGATCCCAAACGCCATCCCTCACATAAGAGAACGTCATGATCTCATAATCCAGGTAGCTATGTAGACATCTTCCTGCAGGTGTCACATAGTCCTTAGTGTGAAACCAACATAGAAAGCCCATGTTTCTGATCAAATCACAGGTTCTGAAACACTAAGGGAGGCACTAAGTAGGACAATGTGGTGCCTGCGTGTCATAGCTGGGTCTCCTCAAGACATGGATCAAGTCCAGTAAGAATTGGGGAGATGCTTTAGAGTCTTGATGGAGTTATCACCACAAGCCCTCTGAGCTACACACTTTAGGGATCATGACCATTAAGTACTCAAATTACCATTTGGTTGTTATCCGGGTATCCGTCGTCCTTGTGGCAACCCTCTTGTGAAGCTGGTGTGGACAGCCTCAGTGCTGGAGCTGTGCCTGCCTTCTGAGTGGACCCTTTCTGTGTTAGCAGGTGGGTACAAGCGTGGGGGTCAGCACACTCAGTGGATTTACACACACAGCGTTGAAGAGTAAGGCTGGGCTTCATTATTTATACATTTTCAATAAATGATGATCTTCATAACATAAAATCAATGATGTAGTACACTAGAATACTGTCCCTAGTATTGAATCTTGTCTCTCAGCAAAGGGTTGCTTAAAGTCACGTGACAGATTCCATTCAACTGATGGCACATGCTGTAGCAGCAGTTAAAGCAGTCATTTGAAAAGGCTTTTACTATAAACTTACGTGTGAGCCTGAAGTGGGGGATAAAAGAGGCGATTAGCTCCCCTGTGCCATGTTTCTCTTATGTGCGTGGTGGAGGAAAATTACACAGGAAGGTGATGGAGAGAACAGAGCAAAGGATTGGACAGGTCCATTGAACCCATAAGACTATGGTGAGGTTAGTGAATGAGATTGGTCATTTTAGGTCAAATTTTACCCAGAGCTGGTGCAGCCACTGCCCATTCTTAGCCAGACCTTATTGCAGGCAGCTCTGATCAATAGTCAAGGAGGCAGTGGGGGTTGTAGACTTTACTCATTAAATCACCAAAGCACCAGCCCACACGGCCACTTTTCCAGTTAATTGACAGTAGCTTGCACATTCAGGTTTGATCAGTGGAAGGGAAGTTACTCTTTGCAGACCCATTTTTGACAATCATTTTGCGGTGTCGGAAGGTCTGAGCAGCCTCGGGAGGCAAGCAGTCCCTGGTCCCTCAGTGTAGTCACTGGAGGAGACAGTCACTGAGAGGCAGCTGGCAGGGTGAAGGGAAAGGGGAGGCAGGCCACAGAGATGACAGCCTTTAAGCTGTCATACTGGGAGGTCAAGGATCTGAAAGAGGAAGGAGAATTCTTTATCATTAAGGACCTGTCCTTATCTCAGGCATTTCCTCCAGAGCACCACCTTTGTCCACCCACACACCTTGGGCTAGGAGGACTGGAGAAAGACAGTGAGGGGTCTCTTGGGTCTCTGGCACAGGGCGTGATGAAGAGGTGGCAGTTTTTCAGGAATCTCTCTCTCTAGGGAACCAAATACATTTCCCATCTCAGGTCCTTCACTCAGCGGGGTTGAGGTTCTGCTCgtcacttatcatctctgaatgtcagcaccctcaagtgtaaaatctcagccacagcccctcctctgcaccccctgcagggctgatgtTCTCTATAAACCATAAGGCGTCATGCCCACGGAAAAGCCGAACAGGAAAGCATGCTCCACTGCCCCGGAGCCATCCAAGTTCCCCCTCCATATTCCGCCACTGCTAAGTGTCCAGCTTATTCCTCCTGGCATGTAGTAAACACTTAGAGAACATTACTGAAGTACCAGTCCTCTCTAAGGTTTTCCTG";
$full_seq{"B3_YELLOW"} = "tctgcctgcctcagcctcccaaagtgctgggattacaggGGATTAACTCTTTTATTCCTCTACACACTACGGGAACAACAGCTGAATGAATGAAATGAGCAGCATCTTAAGCTTCCGAGTGCTCTGGTTCTAGGTTCTTACCAAGTGCACATCAGCGATCTGGTCCTTAATCAGGTTCCAGAGTTTGAGGTACAGTTGGGCAGCATCATGTTGGACAAACACTGGCCACAGAGAAAAGGAACAGCCAATTAGTGAGGTCTTCAGAGTCACTTCTCATGCCCTGGTACTTAGACACACATGAACACTGATCACTTTGTCTCTTCCTAGCCCTCCACCCCACTGCAAGGCTAAGTCGGCACGACAGAAGAAGTGATCAATAAACAAACAGTAAGTTTGGTATTGATTTTTGAGAACGCCTCTTAATACTTAAGCTCCAGTgccagatgtagtggctcatgcctataatcttaacacttcgggaggccaaggtgggaggatcgcttgaactcaggagtttgagaccagcctgggcaacatagcaagactccgtctcgataaaaaatttaaaaaagtacttgagagtagcggtgcacgcctgtagtcagagctacttgggaggctgaagcaggaggatcactggagcccaggatgttgaggctacagtgagctgtgatgtcaccactgcactcagcctggggaatgagatgtccacagggactttgaaaagcactgatacattcctgaggatctagaaggccaggcgcatgcccaagtaagacctgagagggctccgatccctcccctctggctgaccacaaggccacatgcaagaaagcaatgaaggcgaatacagaatcatgaactgccCAGAAACGATAaaacagcaacaacaacaaaccctgctgtggggatctctgatgtccagtgttgccaccttacattatctaaaatgttcattttccaacaaaagagacaagacctacaatgaaacagaaaagcatggccacccaggaaaacagcaatcgtagaaccttccactgagaagccctagatgttggcgttactaaacaaagactttagccgttataatatgttcaaagaactaaagaaaaccatgtcaaaagatgtaaaagaaagtgtgaaaatgctgcctcaccaaataaaaagtatcaataaagaaaaaactataaaagaagaaccaagcagaaattcttgagttgaggagaaccataactgaaatgaaaaatgtactagaggaggtcaatagcagattagagctggcaaaagaaagaatccataaacctggagctaggttggttgaggttctccagactgaggacggaaggaaaGCTGAACACAGTACCTATGCAGcgaaaagctgaggagctgctcactgcgtgtagagctcaactaactctgatacaaaaaaaaatgtgatacaaaaggttttatacacaaacgtgaacttattctgaagccagcctggggcaaggagcaagacacatcctgccttttaatgtgccatttctcctttggaggagagaggggcattttcataaggtgtgttgtgggggtggggggagtgagcaatggcggttttctaccgggcagttatcaagttcccagcagctgagttggcgcctttccgggcagaaaagtggccgaGTGGGCATGCTTTCTCCATGCCTTCCTAGTGGGTGAAAGACAAACCCCTAGAGGGTGGAAGTTTCGAAGCCACCCCCTGGCAGGGAGAGTTCCCTGGTGGGTATGCTTTGGGCTGCAAATCTACTGCCAAGTCTCAGGAAAGATCAGCTGGAAGATCTTGCCCTGTTCTCAATCAAACCTCCATCAGCCTACCTCCATTTACAGATTCTTCCTTttgcccagcagggaatgtctggagaggggtaggcgaaaggtgatatttgcatttctaaagggctaacaggaaacaggaaacacggccgcggtgaggggtgagggatgggaagaggagaagtgaaaagaaagtaataagaaaactaatataactatctcttagaaaatgggagtactcagttacacccagatgggttcactagtgaacgatgggttctaccaaacatttatgggaaaaattataccaattccctacaacctcttccagaggacaaaagcagagagaacacttcctaactcattctctgaggccagcattatcctaacaccaaaaccagacagacattgtaagaaaaaaacctaaaaaccagtatctcccgtgaacataaatgcaaaattcctcaacaaaatattagtgaatcaaattcaactatgtataaaaagaatcacagagggtgacacaagcgagatggtagagaaggaggctcctggtgctccccttctcccatggacacacggtaaaactctcatctacacacagatcaactccctctgaaagaaacccagaaaccagctgagagaggcctgcacagggggcaatggggagaacacccacatcgcaaccggttggaaaagctgagacacactcgaaccacaagccccaccccagacacagtaccttactgtgaggaaggaatccctactcccagctttctcctggagaggggagggtttggaccacacataggcagccccagcttttgcagttcccactcaagggcttggctgctgggtcacctagctctgggagcagacatgggttagcagttatgaatcctctgcgaccacagaggacaaagaggcagttttaaacgggcacgtgagcacttccagcagctgtgctcagcacagagcaaacaggcagaaatgccaggctcccagttcctccctggaaggatatgtctgcgggctctcctagctgttgcccgagggatgggcttctattaataactggcctgcacctggagccaatgaggcaggtaaacaatagatttccaggagtctggacaggcctgtgggcaagtcccatgccttctcccaccccctgctgtatggtaaaatcaggtctctaacttcacacattgagtacacatttacccctctcaaatgaaggtctagctcctcaaccaccgagctttgggagctgacaaggctctgtatttgtaagtcccacaggggcacagagaccaaagaacatccccccaggcccagtgcagcgtgaacaggcaaaaaggcccggctcctactttctccctagaaggagtttgtctgcacagtgcagctgctgccctggggtttctatgcatctgggagctgacagagcaggaaaccagtgctcctctgagaccctgaacaggcaggtgagcacctccacagctgctcccactggtttgctcaacagatagcgtcaagcttccaactaacctgtccgtctctaagcagagaacagccagcatttgctaggcccctgggggtgacaaagagtaaaacaatgcatgaaggagtgtgcagtttaaacttgagtgcaggcacttgccacagatcctctctccagcattttgcagagcgagtggcagataaactcatgctcccagcttttccctgaggatagaataaactggaacacacatttaatgccccaacgtctccagctgcacctcaaggggctggtttctatctcccctgtctggggcactgacaggacatgacacattctaatctcctgagggccgctaagaacatagatgacagtttggacaacacaaaaggtcaagaggtgctccgagtgtctggcagggctaattggtaagttcgtctcttatacaaggcccgtgggacaagactgggagaggtatttttcttttttttttttgagacggagtctcgctctgtggcccaggctggagtgcagtggttcgatctcggctcactgcaaactccacctcccaggttcacgccattctcctgcctcagcctcccaagtagctgggactacaggcacccgccaccacgcccagctaattttttgtatttttagtagagacagggtttcaccgtgttagccaggatggtctccatctcctgacctcatgatctacccgcctcagcctcccaaagtgctgggattacaggtgtgagccatgatgcccagcctgggagaggtatttttcttaactaaagtacagaaaataacagagaatcaagaacaatgaagaaacagagaaatctgttccaagcaaaagaacaagataaatctccagaaaatgcccccggtgaaatgaagataagtgacttaccttacagacaattcaaaataatgatcatgaagatgcttaccatgtctaggacagcaatgcatgaacaaagtaagaatttcagcaaagagacagaaaaaagttcaaaagaaataatagagctgaagaatacaataactgaaataagagctcaaaagagaagctcaacagactaaatcaagcagaagaaaggattagcaaactagaagataggtcactggaaatcattcagaggagcaaaaatgaaaaagaatgaaaaagagtgaagatatcttaagagagttaggggacatcaagccgaccaaaataggcattatcagagtcccagaaggaggagagtgagaagagatggaaagcttatccaaagaaataAcagtcacgagttgcagatcaacatttcagtcaatggcagaccgcatgagcacagtggccatagcatgcagcctagctgtgtagtaggctgtcccatctaagtttgtgtaagtgcactccatgatgtccacacaatgacaaattcaccttctgatgcattttcagaacgtatccctgttggtaagcaacgcatacctataatgactgaaaacttcccaacccagggaaggaaatacaaatccacatccaggaagcccaaaggacaccaataagactgatctaaagcaacccacatcaagacacatcataatcaatttcaaaagttaaagacaaagaattctgaaagcagcaagagaaaagcaatgtattatacacaagggaAAACCCGTAAgtgtaggatttcttctgggggtgatgaaaatgttatgaaattagattgtgatgatggaggcacaactctgtgaatacactacaaacctttgaattgtatgtttttaaatggatgaattttacagtatgtgatgcacatcccaatatagctatctaaaaaaAAAACCTGACCTATTTGTGAATTATTTTGTAGAACATGTTTTCTCTTTTTTATTCCTTTATTCTGTTTTCCTGCAGTTCCCTAACTGTGGTGGAATAAGCTTGGAGGAGATGCCTTCACCTACTCTACTGAGAGGCAGAGAAAGGTTAGGTATGGAAGTAAAATGTCCATAAATAATATCAATTCTGCACCTCCAAAGATGTGTGCCTCTTACACAAATGTCTCTATAATCTGAGGGGTCCAGGCTACCTAACTTGCTTCTTGTTGCTTCACTGCCCATTAGTTCCTCTCTTCACTCTCTAAGCTTCCCATCCCCTTTGGATCAGCAGCCAGGAACCCAGTGGGAGGGTATCTTACGGGGCACGTTGTACTTCTGCAGGCAGTAGGCCAGCTCCAGGGGCCACACTGCTTTCTGCCGGCTGTCCTGCATCTTCTCCAGCAGCAGAAGCATCTGGAAAGGGACGCTTCTCCTCTGCTCGTCAGCTCCCCTGGGCACCGTGATCCTGCCACACAAGAACAGCCAGAAACCTCCTTACATgtagttctcaaagctaggtgcacactggaatcacctgggagaaattttaaatcttcatatccaggccactcccatacaaattaaaccagaattctgggtccggggggcggggcgcgggcagttatcagaatttttcagttcctcagattatttcaatgtgtggtcaaggttgagaagcacCATGTGAGTGAATCTGCTCTACAGGGGACCCTCTAGAGAGGGGGATCAGCATGACTGCTGCCTTGGCCCCTCTGCACCCTGCCCAGCAATCGTGCTAGAGCAGACGGCAGATGCACGAGGTCCTGGCTCCACATCTCGGGCAAGCAGCAAAATGTCCAGCCTAAAGCTCTCCAGACTGCAGAGGCACATGCTGGGTTAGGTCCTGGGAAGAAAGGCAACATGAAAGGCTGTCCGTGTGGTTTGGCAATGATTCATTTAATCACAGGCATTTTTCGGATGGGAAAAAGgagagagcacagggcagaaaaggagtgatagagagagacagagggagagagTGCATTGTGTGAGTGTTGGTGGAAGGAGGGGTGTGTACTCCCCACTGACTTACTCCTTCTCCGACTTTGGTCTAGTCCCAACTCTGTCTTTTAACCAAGTcagtggctgtcaatcctggctgcatttaaaatcacccaaagagggcttttaaaaagtaccaatacctggccgggcccagtggctcatgcctgtaatcacagaactttgggaagctgaggcgggcagatcacctgaggtcaggagattgagaccagcctggccaacatggtgaaaactcgtatctactaaacatacaaaaattatccaggtgtggtggcgggcgcctgtaatcccagctacttgagaggctgaggcaggagaatcccttgaacctgggaggcggaggttccactgagccgagattgcaccatccctctccagcctggggacagagtgaggctttagctcaaaaaaaaaaaaaaaaaagtaccaatacctgggccgcaccccagaccaaCCTAAGAAGTTTTAGAAATAATGTGTAGGCCAGAATATGCAGAAGCCGATCTTTCCTCTGCCAGCTTTTGAGAGAAGATCTCAAAAAGTCCAAGTCACTGTGAATAACTGAATATATTAAAAATGAAATAATACAggccgggtgcagtggctcacgcctgtaattccagcactttgggaggctgaggtgggtggatcacgaggtcaggagatcaagaccatcctggctaacacggtgaaaccccgtctctactaaaaatacaaaaaaaattagccaggcatggtggcgggctagtcccagctactcgggaggctgaagcaggagaatcgcttgaacccggggggcagagcttgcagtgagccaagatcgcgccactgccctccagcctgggcaacagagcaagactccatctcaaaaaaaaagaaaaagaaaTAATACAAACGCTTATCAGCCTGAAGAACAGTCTTACCTCTTCAATATCCTGGCGAAGTCCACATTCATTACAAACACCTGAATCAAGGAGTTAAGGCAGCAGGTCTGTCCAATGTTGTGTAAACCAACCAGGCCTATAAGGGGAAGAGAAAAAAATGCTGAGGGCAAGGCCTAGGTAAAGAAGTTGACAAggctgggcatggtggctcacgcctgcaattccagtactttgggaggccgaggtgggcggatcacctgaggtcgggagttcgagaccagcctggccaacatggtaaaacgtgtctctacaaaaaaatccaaaaatCAgccgggtgcggtggctcacgcctgtaatcccagcactttgggaggccaaggcaggtggatcacctgaggtcgggagttcgagaccagcctgatcaacatggtgaaaccccgtctctactaaaaaatacaaaactagctgggcatggtggcacatgcctgtaatcccagctactcgggaggctgaggtaggagaatcatttgaaaccaggaggtgaaggttgtggtgagccgagatcacaccattgcactcctttctgggcaacaatagtgaaactccatcaaaaaaaaaaagaagaagagaaCTTACAgcagggtgtggcgtttcacacctgtaatcctagcactttgaaaggccaaggtgggcagatcacctgaggtcaggagttcaagaccagcctgggcaacagggcaaaaccctgtctctactaaaaatacaaaagctagccaggcatggtggcaggtgtctataatcccagcttcttgggaggctaaggcagaagaatcattggacctaatttattgatttttttgaacttggaatatggtgtcatgacaaaatcatgccactgcactcaatcctggatgacagagcaagactctgtctcaaaaaaaaaaaGGTTACTTTTTATTTCCTGAAAAGCTTGACTTCCTGACAATGAAAGTCCTAAGGAGCGAGTGGCAGAAGACAGCTGGCAGCTGGCAGTCATTGGTGGGGCAAAGGCAGAGATACCACTGCTGACTCTACTGGGCCTCGGGCCTCAGCGCTCATGGGAAGGGACCCTCTTTCAAGCTTTTGGAGGGGTAAGGGAGGGCCAGGTAACAGTGCCTACATCTTAGGCACCGAAAACAACTGGAGCTGCTTCATGCAGTCAAGAATCCCCTGAAGAAGGAAGGCAGTTACCTCCCTATTCTCCAGATCTCTTCAGCTGGCCTGGCTCTCATCCTTTCCAAGACCTGGCTGTTTGCTTTGCATTTAGTTATATGAGCTAATTCATATGCTTCTAATAAATGCCTTTCATCCTTCTCCAAAGTTAGCCCTAGAGTATATTGCTGTTGTTTACAATCAAAAAGCCCCAGAGGTGTactctccaattctcttaataacctcatttttctgtcattacccctgttttagtacaagtagctgagcttcagagaagttaaaagatgtgcccaaggtcgcacagctaatgagtgtcacagtcagaatctgaacccaagtctgtctgaTGTGGGGTCATGACAAGAGCATGGGTTTTCTTGGGAGAAAAAAATGACTTCAAATCCCCACTTCCCGCATAAAAATGCACAATGGGTGTAGCAATGCCGAAGCCACAGAGCTATTGAGGATGGATGGAGGTGACGCATAGGAAAGCACATGGCCTAGGGTAtgtattcccaacactttgggaggccgaggtgggcagatcacctgaggccgggagttcaagaccaacctgaccaacatggagaaaccctgtctctactaaaaatacaagataagctgagtgtggtggtgcatgcctgtaatcccaactacttgggaggctgaggcaggagaatagcttgaacccaggaggcagaggttgtg";
$full_seq{"D1_BLUE"} = "aacttccggctcccagattcaggcaattcttctacctcagcctcctgagtagccaggattacagatgtgtgccaccacgcccggctgattttttttttttttttggtattttttttagtagagatggggtttcaccaggttggccaggctggtctcgaactcctgacctcaggtgatccacccacctcggccttccaagtgctgggattacaggcatgatccattgcgcctggcGAATTTTGATTTTTTTAATGTAGAAAAAGTgccaggtgagatggctcacacctataatcttagcatgttgggaggctgaggtgggaggatcccttgaagcctagagttcaagaccatcctgggcaacacagaaaggtccccatctctacaaaaagctttttaaaaaattagccaggcatgtggcacatacccgtagtttcgggtactcagaagactgaagcaggaggatcacctgatcccaggagtttgtggcttcagtgagctatgattgtgccactgcactccaacctggggaacagggccagattctgtctcaaaaaaaaagggaaggaaacaaaaaaaaTTGAGTTACAAATCAGTGCTGATTCTAACCCTGATTTTTTTCAACCCAGACTTGAGTCAAAGCCTTTCCAGAAATGTGTCTGTGTAGTTTCAATTCTTCAGGTTTGGGACAACCGATGTCAAACGTCCTTACCATTTCCTTCTAATGGCCTGTTCTTGCCTTAACCATGTGCCTGCTGCTCTGAGAATTCCTGTCAGCACTGGATCTGTCATTCTAAAAGAAATAGAATGTCATATGGCATTATCCTGCCTGAATATACACTTACTTGTCACAATGTATGGTCATTATCAGAAGCCCCTAGTCTTgtgggaatgccatgggctttggaatcagttcagggttgggaccaaatcctgtgtctatcaatgtgagatcctggacaagATTCTGAGTCAAAGAATCATAAACGATCAATCAATAACAAGCCTGGGATgggcatgatggttcacgcctataaccccaggacctcgggaggccaaggcaggtggatcacctgaggtcaggagttcgagaccaccctggccaacatggcaaaacctgtctttactaataatacaaaaatttggccggagttggtagctcatgcctgtaatcccagaactttgggaggccgaggcaggcagatcacctgaggtcaggagttcgagatcagtctggccaacatggtgaaaccctgtctctactaaaaatacaaaaattagccgggcatagtggtatgcacttgtaatcccagctactcaggaggctgaggcaggagaatcacctccaggagaacccagaggcagaggttgcagtgagccgagatcgtgccattgcactccagcctgagcaacaagagtgaaactctgtgttgtaaaagatagaagaaaaattagctggatgtggtggtgctcacctgtaacctcagctactcgggaggctgaggcaggagaatcgcttgaaccagaaagcggaggtttcagtgagccgagaccatgccaatgcattccagcctgggtgacagagcgagactctacctcaaaaaaacccaaaaaacaaaaaaacaaagaaaaACAATTAGCCTGAATTGAATATTCTATCTTCTATTCCTTAACTGTTGTTATCTGTTATCACTAGTATAATCTGACTAGCCCAGATTTTATTCTGAGCTTTGAGGGAAATAGTTTTGAAGACTTATAGTTCAAGGAAAATCTTTCCCTAGGCTCAGACTTGTGTTtttgtgaaatggggctaacgtctaccccgcaaggccatcatgaacataagctgagatgacagacctaagggaaaggccttgcacagagaaggactccatcagtgccagttctgttcttCACAACCCCTTGGttttttgtttttaattgaggaacaacatctatgctgaaaaatgcacaaagattaagcatagagcttggagaattttcacaaacagcataggtgtctatgtaaccagcccccagatctggaaatacagcatagccgggcatggtggtgggcacctgtagtccctgctattctggaggcttaagcaagaggatagatagcttgagtccaggagctcagggatgaagtgagctatgattgagccactgcactccagcctggtgacacagtacgatcccatttctaaataaataaatacagcaggcctctaaacatcccccattgtccccttcTCTCCTGGATCTTACTAGTTTGCGGGTATGAGACTGTCATCCACAGGGGAGAAGCTGCCCGAAGGAGCTTCTCTGAGACCTTGCGTGTGTGAGTGAAAAATGGTGAAGTTCTCAGATAGTAACAAAGTTCATCCTTGTAATGGGTGTCTCCTTAGGATATCCAGGTGAACGCAGAGTTTGATGGCCTTGCTAGCTCAGTGAGGGGAATTCTTCCAGAACTCTGCATAAAGACTGGCGCTTGCAGAGTGGAGTATAAAAAGGAGTTGCTGCCAGTCTTCAGATCAGCCCTGCCAGCGTCTGTCCCTAAGTGACCTTGGAGTGTGGCTTCCTCATCTCCAATCAGCTGCTTTGACCTCCAGGGTGAGGAGCTCTTTGACTCACGAGGCCTTGTTACCACTTGTGTCTGCACTGAGTCCTCACGTCAGCCGTGTGCTAAGTCCACACGGTGCTCACACACCTGTACCCTCCTCTGTGCCCCACGGACCCTGCACTCATCTGGGCCTTCATGTGCTCTCACTCATTCCTGTCACACAAACCCCTACTAAGTACTGCACATTGAACTGGGCATGGTATCCAAGATGCCCAAGCAAGTCCCTGCCCTCCCCATGTTCATGTTCTGGTGACCTCAGGAAACTATTAAAATGTAAGGAGGGGTGcacactctacttttgagaatgcaaacgggcacagcctttttggaaggcagtttatcatcatgcactgagagcctcaaaactgcctgtgccctttgatacaatcatttgactaatgtgctctagagaaataaccagagatgtataaaagattgatgcctaaagatgctcatggggccggacgcggtggctcacacttgtaatcccagcccttttggaggcctaggtgggtggatcccttgaggtcaggagtttgagaccagcttgacaaacatggtgaaaccccagctgtactaaaaatacaaaattagccaggcatgatggcgcacacctgtaatccccgctactcaggaggctgaggcaggagaattgcttgaatcctggaggtggaggctgcagttctcaccattgcactctagcctgggcaacaagagcaaaactctgtctcaaaaaaaaaaaagatgcccatggaaatgctgtttatcataatgaaaattggaagtgtccccaataacgggattggccaattaaaatttggATATGTTAAATGTTAAAAGCCACATGCTCAAAGAACACTTAACCATTCATGAAAATACACATGATTAATGTTCAGTGAGAAAATTGGGAAGaaaaaaatcacatggcagctgggtgcagtggcacgtgcctgtagccccagccattcagaggctgaggtaggaggattgcttgagctcaggagttggagaccagctggggcaatacaataagaccctgtctttaaaaatcaatcagtcaatcacatggcTTgtctgacagttcctcaaaagcttaatcatagaattaccgtataacccattatttccattcctaggtatatacttgaaagaaatgaagacatatgtccccacaagaactcgtgcatgaatatccatagcaacattatttataatattctaagagtgaaaatgcccaccagtggataaatgcaatgtggtatatccatacagtggaatattatttggcaataaaaaggaatttgaggtgataccaatgttctaaaatgtattgtggtgatggctacgtaactgtgcatattctaaaggcaattgaattacagatgctttacatgaatgaaccgtatggtatgtgaacggcatctcaataaaactgtttcgaaaagaaggaaaag";
$full_seq{"D2_RED"} = "GTAAATCCAGGTGCAAAACAGAACTCAAGTTAAGGCCTCCGCACAGCACTGCGTTCTAACTGTGAAGGATTCTTACTCTAGTGTCCTGTGTGGAGGTATTGGAATTGTCCATTGCTAAGACTCAGAGGAGAAAAGCACTTAGCATCGCAGGACTTGGAGCACCGGTGCTGAGGCAACCCTTCATTCATTCGTCGGATGTGTGTTAAGGCCCAGGGCAGGGGTCAGGGATTCTCCTCTCACACAGCACGTGGGTGGCAGGACCAACACCGGGTCTGACCTCCCAGCCGGGGGCACAGGCTGCTAACCCCAGGCCTGGAATCTGTCAGATGCCCTTCCCGTGCTGACTTGACTTAGACAGGCCTCCTGACCTTCCCACAAAGGTCATGTGTGATTCGCAGGGGTTCTGGCCGCTTGAAAGGTTCCTGAGAAAGTACATGCAATGAGGACAGAGCTTGCAGAGGGAGGACAGGCATGCAGAAGGCTCTGTGTGCAGCCCCAGACCTGGGTACCTTCGTCACCGTCCTCACCCCACCTCCGGGTGCGCAGATAGGGAGCAGGTCTCCTGTGTTATGGCCCAAGCAGGGCTGTTAGGACACTGAGAACATTCCCTCCTCCCGCAGGAGAGAGAGGTCCAAGGTGCCCTACATCGTGCGTCAGTGCGTGGAGGAGATCGAGCGCCGAGGCATGGAGGAGGTGGGCATCTACCGCATGTCTGGGGTGGCCGCAGACATCCAGGCACTGAAGGCAGGCTTCAACGTCAGTGAGTGTCGGCCTGCGCAGGACGGGATGGAGGTGTGGGCAGTGGTGTCCACGATGAGATCTCAGAGTGCTCCATGGCCCAGGCATGTCACATCCTTCTCTGTGTCTTTTCTTCATTTACTGTTTTATTATTTTTAAAAAAGAGAAAACAAGAGTTGTACAAACAGCTTCTATAGAAGCCAGTTTTTACACCATCGTACCCACTCGTGCCACTTGGTGCAGTGGACCAGGGGCTTCTGCGGGGCCTTGGCCTTCCTGCCTTGGGGTTGGACAGGAGGTGGAAGCCCAGGACTCAGTGCGGTCTGTCCACTGCCCTGTATGAGGATGTGGTGGGCAGAGGGCACTGATGAAATTCAGCGCAGGCCGGGGCTGCAGCCTCTCCGCCTCCATCTCACCAACCCTCACAGGCTTTGAAGGACCCGGACCTGCCTCAAATGCCAGGGGAGGGCACTGAGACCCCAGAGGGTCCTTCCCAGCATCTTCAAAGCAACAGGATTTTGTGCCTGCAGATCCTTCTTTGCAGCACACACCACCCACCCTGACCAGGACCCCTAGAATGCCCAGCATCCCTGGGAGGGCCCTGTGGTAGTTTCAGCTCCCTCTGAGGGCCCAGAATGAACCTGGCCTGTGGTGAGGATGTAAGCACCAATGGCCAATTGGGTCCAAAGGAAGACACCGGTTCAAACACTGAAACCAATCAGATTCTCCCACGGCCTTCCTGCTATCAGAAGACACTGGTGCAGGGGTGGTTGCTATGTACAGGGCAGAGCCACCCAATCCCCACGCAGGCGCTGTGTCCTGCCATGCTGGCCTCCTCCTGGCCATCACATCAGGCCAAGCAGGGGAGAGGAATGGGAATGCCCACGCACCCCTATCAACTCTGCAGACACAGAACCATGCACAGCTCTTGGGAGGAGTCAGATGAGCTGCTCAAAGCCCAGGAGGGACCCACACAGTGGTCAGCATGGCAGGGACGGTGCTTTAGCCAAGGCAGGGATGGTGGGTGACTCACTCAGGATCTTCAAGGAGGCCGCTGCATTTCCGTGCTCTTTCCAGATAACAAGGACGTGTCAGTGATGATGAGCGAGATGGACGTGAACGCCATCGCAGGCATGCTGAAGCTGTACTTCCGTGAGCTGCCCGAGCCCCTCTTCACTGACGAGTTCTACCCCAACTTCGCAGAGGGCATCGGTGAGCACTGGAGGCCTTGGCCTCATGGGAGACGTCTCCTCCACGTGCACTGCTGCCCTCAGAGGCTGTGAAAAGTGAGGTGTGGGAACCCGAGCTGTGCTTCCTCTGCCATGGTCGGAATTTTAACCCAACCTCAAAAAGCAGGGGACCAAAACTGAGCCTATCCTGGAAGGCCTTGCCCATCCCCAGAGGGCTCCCCATCCATATTTCTCAAGGAGGCCAAGTGGGTGAAATGGTCAGCACTGCCGTGCTGTGGGGTCCTAAAGTCTGCTGTCCTCCTTCCTGCAGACCAGGGCTAAACACTGGTGCCCAGGTGCTCTTGCCATGGGTCCTGGTCCAGCCAAGCATGGTTTCAAACATGACCTGACCCTTAGTCAACCTGGAGGCTGATGTCTAGAGTGGGCGCTGGAGCGTGCAGCACCTGTAGCCTGTGCATCACCCTTAGGGCAGGTCTGCCTCCCGGGCCCATGCACAGAGGACCTGGTCTCCCAGCCTGCAGGTGCCCCTGTGGTGTCCAGGATGTCGAGGGGGTCTCTGCGTACTTGGTGGGGCTGGGACCCTCCCACTTCCCACCTCCTTGTGTCCCTCACTCCCCTGTTTCATTCCATGCTGAGCCTCCCCTGCCTTGGGCTCCCTGGGGAGGGGGTGGTGGCAGGAGTTGCCCGAGGGCAGCTCTGCCCATGAgcagctgctctagcggctcctcctgctgctgtttgccgggtgctgctgACCCCTGCGAGGTAGAGAAAAGGCGTTCAGGTGGTTCACACCCCACACAGGTGCCCCTCACAGGGTCCTCACTGGCGGCCAGCGCTGTGGGTGTGACGATGATGACAAGCCTAAACTGCGCAAGGACTCGTGTCCCTGGCGCTCCATGTGACCACCTCGGGAGAGGTCTCCGGCTTGTCGTAACCCAGGGGAGTGACCCACTGCCTCCTGCAGCTCTTTCAGACCCAGTTGCAAAGAAGAGCTGCATGCTCAACCTGCTGTCGTCCCTGCCGGAGGCCAACCTGCTCACCTTCCTTTTCCTTCTAGACCACCTGGAAAGGTAGCCCAGCTCTCTTGTGGCTGCCCAGGACTCCAGGTCTCCAGGCCGTGGGGTGCCCCTCTGCTCCCACCAGACCCCCAGCACCAAGGACCTTTTCCCCCGACCCCTGTCTGCAGTAACTCACTGCTTCTAAGGACTAGCACCACTGCCACCCCCGCCCCTGCCTCTCCTCTTTGCCACCCTCCTCCCTCTGCACTGTGGCCTTAACAAAGAGCTCAGAGCTTTGGCCGTGGCCAGCAGTGCATTTGGACCGCCCCCCCTTCCCTCCCAAGCACATCAGGAAGACCTCCCCATCAGCCCAGAGCTGGCCCCTTGTCCTGGGCCACTGAGACCCAGAAGTACCAAGGCTGGAGTCAGCTTGCAGCACAGCCAGGGTCGAGGTCACTCCCTCCCTGAGGACTCTAGCACGGCACAGCCCCTCTGCCTCTCTCCTGGTGGTGGCGTTGAAACAGCACCCTCTGCTTCGGTCCTCTACAGGATGGCAGAGAAGGAGGCAGTCAATAAGATGTCCCTGCACAACCTTGGCACGGTGTTTGGCCCCACGCTGCTCCGGCCCTCCGAGAAGGAGAGCAAGCTCCCTGCCAACCCCAGCCAGCCCATCACCATGACTGACAGCTGGTCCTTGGAGGTCATGTCCCAGGTATGGGAAGACAGCCTCCAGCCCATGCAACCCCAGCCTGACAGAGGTGGCCTCTGCCTGCCCCACCCCCAGTCCTGCCCATCTTCCGACTTGCATTGTATGTGGTGGTGGCTGAGATTCAGAGACAGGGACTTGCCTAGGTTTGCATGGATGGGAGTGATAGGGGGTGCCTAGGCCACCTCCTGGTCCTGCTGGTGCACCTTGCTGGGGGCTTAAAACCACCCCAAGTGTTcgagtgtggtggctcatgcctgtaatcccagcactttgggaggccgaggcaggacaactgaacccaggtgtttgagaccagtctgggcaatgtagcaaaccccatctccagaaaaaatacaaagaaaaattaggcaggcattggggcacatatctgtaatcctaggtatctgggaggctgacacaggaggattgcttgagcccaggagttagaggctgcagtgatccatgatggagccactgtactccagcctgggggacagagcaaggccctgtGCATCTCTAAAATAAATAACCACCCCCCACCCAACAAGTCATGCCTTGTCAGGACCCCACCCCACCCCCGTCTCACTGTAAGGGGTTCATGACACCAGCAGGGGTTTCTAGCACCTGAGGTGGACTTGGGATCTTGGGCCCCAAAGACCTCCCACCAGCAGCTGTGCGCCCCCTTCCGAGCCACTCTCCTCTTCCCCACTCCGCGAGGGCAGGTCGAGGTGCTGCTGTACTTCTTGCGGCTGGAGGCCATCCCTGCCCTGGACAGCAAGGGACAGAGCATCCTGTTCTCCACCGATGTCTAAAGGTCCCAGTCCATCTCCTGGAGGCGGACAGACGGCCTGGAAACCTCTGGCTAATCAGGCCATCTGTAGAGTGGGAATCAAGATTTTCTGAGGCATCCTTGGGCCACCCCCAGGTGTCAGGCCATCTGCCAAGAGACAGCGGCCCAAAGCAGAAGGACAGGTGGCCTGGGCAGATCCCGCCCAGGTCTGAAAGCCCCAGGCTGGCCTCAGACTGTGGGTTTTTTATGTGGCCACCCGAGGGCGCCCCAAACCAGTTCATCTCGGAGTCCAGGCCTGGCCCTGGGAGACAGGGTGAAAGCAGTGGTTTTTATGAACTTAACTTATAGAGTCCAAAAGATTTCTACTGAATCACTTGTCAAGAAGCGCCCTCTCTGGGGAGAAGGGAACGTGACTGGATTCCCTCACTGTTGTATCTTGAATAAACGCTGCTGCTTCATCCTGTGGGGGCCATGGCCCTGTCCCTGTGTGGGTGGGGCCTCTTCCATTTCCCTGACTTAGAAACCACAGTCCACTTAGAACAGGGTTTGAGAGGCTTGGTCAGCACTGGGTAGCGTTTTGACTCCATTCTTGGCTTTCTTCTTTTTCTTCCCAGAGGGATTTTTGTGCAGAAATGGGTCTTTTGTTGCCGTGTTAGTCCTCCTTGGAAGGCAGCTCAGAAGGCCCGTGAAACGTCGGGGGACAGGACCCCCAGGGAGGGAATCCCAGGCTACGCACTTTAGGGTTCGTTCTCCAGGGAGAGCGACCTCGTCCCCCGATCCTGACCGCCCTTCCGGCCCACGCTCTCCTGTTTGGCTTCCACAGGCCTGGACTTCTCTGGCTTCTCTGCCCACACACTCCCTGCCCCCAGTGTCCCTGCCCCTGCCCCAGCACAGGTGACTTCATTTCTGTCCTCTCAGCTCAGTGGACTCGCTCAACTTTTGTATAAGTCTCCACTTGGTGGTAGCAGCTTGCTGATGACTTGTTTTAAAACTTTCATCCTAAATAACCTTTTGATACTTGAATATTTGTAAGTTTTATACATAGTTTCTAATTTTTTCCCCAACAGATCCAGATACCTAATAAGATGCTGGAATGTAATCCCTGGACAATCCGTGTCCTGGCAGCATTTGGTCTTCCTCTAAGCGCCTGGCTCCGCTGTTCTCAGGAGTGGGTTCTGAAGTCTCTGGAGAACAGGATACGTGGAGGGTTAGGAAGGGGCCAGGCCTAGAGACGGGAGACTCCCTCCCGGAGCAGGTGGAGGCACAGGACCATTCGCTACCCCATCTGCCGGCACCTGCGGGGGAGCCCAGGCATTGTTTGTAAACCCTCCTGACTACCTGACTCAAAGAAAACAGAAGCATGGAGGCCGCCAAGTATTTTCAAGAAATAATCCCATGAACGTGGCATCACTTTTTTAGAAAGAGGGGCTTGGGGCAGGCAGAGGAGAGAAGGGAGAGCAAACTGAGAGCCAAGTTTCCAGACGGTCCTGCAGGAGGAGAGGATGCAGCTGCGCAGAGGGAAGCAGGATCACATTTAAGGAAGTGTGTGGGGTCCCTGGATGACACCAGCACCCAGTACGGCTCTGTCTGGCAACCGCTCCCAAGGTGGCAGGAGTGGGTGTCCCCTGTGTGTCAGTGGGCAGCTCCTGCTGAGCCCGCAGCTCACTGGGGAGCCTGACAGCGGGGCCATGTGCCTGACACTCCTCTCTGCTTGTGGACCTGGCAAGGCAGGGAGCAGAAAACAGAGCCACTTGAAGGCTTTCTGTCTGCGTCTGTGTGCAGTGTGGATTTAGTTGTGCTTTTTTCTTGCTGGGAGAGCACAGCCACCATTTACAAGCAGTGTCACCCTCGTGGGTGGCGAGGACAGAACAGGAGCCTCTGCTCTCTGTACCTATCTGGGCCCGGTGGGCTCCCTTGTCCTGGCTTCCATCTCTGTCTCAGCAACCATTCAGCCCTGCGCAGGAACACGTGTTGCTTAGAAAAGCCAAATCCAGCCTTGTCTCTGCCTCCTCTGGTCTCATGATGTGCATCTGTTACCTTGAAACTGGAAACCAGTCTATCAATGTCTGTGCCAATTTTTTATTCCCTCCCCAACCTCCTTCCCCATACGACTTTTTATTTATGTAGGATGTGTGCTGTCTAATGATGGGATGACCACACTTTTCCATGTTCTAAAAGTGCTCCTCTCCCGCAGGGTCCCAGGGCTGGTGGTTGCTTTGGGTCTACAGCTACGTCTTACCCGCCTCCTGCCTCAACAGCCTGTGTG";
$full_seq{"D3_CYAN"} = "acaccaccactgcaatattacagtgttatgaatgtgactatatacttacctttccctgtgaacttttttttttgggacagagtctcgctctgtcgcccaggctggagggcagtgtccatgatctcggctcactgcaagctctgcctcccgggttcaagtcattctcctgcctccgcctcccgagtagctgggactacaggcacccgccaccacgcctggctaattttttgtatttttagtagagacggggtttcaccgtgttagccagcatgatccccctcttctgaccttgtgatccacccgccttggcctcccaaagtgctgggattacaggcgtgagccactgcgcccggcctacctgtgaacttaatatcttaatgttttaatgttgctaatcagaatccttttatttcaacttgaaaaactgccttataaggcaggtgcagtggtgatgaactcccttagaatttttttggtgggagtctgggaaagaccttatcatctctttttcatttctgaaggacagctttacaagttgtggccttcctgattggcagtttttttcttccaatacattgaatatagcatcctattctctcctggcttataaggtttctgctgagaaatccactgatagccttattgaagtttccttgtatgtgatgaattcctttcttcttgctgcttttgaaagtctctgtctttgacttttgatattttaattataatacatcttggtattatggtctttgggctggccttttttggggcctctgaacttcatgtgtctggaagcccacttgcctctaagaatttggaaagtttttacccattatgtcttcaaatatactttcaggccttttctatcttttttacttctaggaagtccataatatgtttgacccacttcatggtggtgtcctataaatcccaaaggtttttactttataaacttttttttctttctggtcttctgacgggatatttcaaatgtcctgtctttaatttcacagattctttcttctgtttgatcaagtctgcaattgaaattctctattgcattttcatttcattcatttatttatttttatatatttttgagacagagtctgtgtcacccaggcttgaatgcagtggtgccatcttggctcactccaacttccacctcccggttcaagcgattctcctgcctcagcctccctagtagctaggattacaggcatatgccaccatgcctggctaatttttgtatttttaatacagatggggttttggcatgttggccaggctggtcttgaactcttgacctcaagtgatccgcctgcctcggcctcccaaagtgctgggattacaggcatccgccacggcacccagcttgcattttcattttattcattgtattcttcagttctagaatttctgtttggttcttattatttctgtatctttattgaacttttagttttgttcatctactattttcttgatattattgagttgatatatacattctagtaaatttcactgagctatcttaattattttgaattgtcaggcaatttgtagatctctatttttggggggttgattactggagatttatgagtttattttggtagtgtcatatttgctgattcttcatgatctacagactttcattaatgtctatgaagaagcaaatacctcttcttctttttttttttttttgagacagagtcttgctctgtcacccagctggagtgcagtggcgtgatctcagctcactgtaacctccacctcccaggttcaaatgattctcctgcctcagcctcccaagcagctgggatcacaggcatgtgccaccacgcctggctaatttttttgtattttttgtagagacagagtttcaccatgttgtccaggctggtctcaaactcctggcctcaagtggtttgcccgccttggcctcccaaagtgctgggattacaggtgtgagccaccatgcccaatctctttctgtctttatagattggtttcagcaggtacaaaccttttcctgctggatcccttgactggatcacagtcaagtgggcctggagccatatcacatggctgctgcctggtctgcagctgaatctctgattggcaggccgctatcaaggcataggttggtgatgcagtttctgctggatcctcaggagaactggactgcctctgataccctgattgaacaggactggagccaggtcatggggccacttctagttctacagtcaagtcttcagatatcaggcctattaccaagggcatggactggtatagctccctgtgggtcccagattgagctcctgctggcttactaggtaggtccatgggaagacaggactgcctccagaccacagtagagcagggctagagccaagtcacaggacagctttggtgaccacatttgggttcaagattggtggtcctcttattaggagaatggatggtatgtctttcaccaggtcccaggatgggctggactgtgcccagactgtggcaaagcaagactggaatggagtcacagggctactttagtgtccatagctgagactgagatcagcaggcctgttaccaagggcatgtaaaggcatcactgaattcctgggcaggcacgactgactgtggtagagtggggctgaagccaggtcagggctgctttagtttctgcagtcaggaccatggttagaaggcctgttactgggggcataaatggtcatggttcctcctaggtgcttagtggatggggctagttgcaagaccatgatctagtggagctggacccaagtccataggaggacaaagctgctttcagtctgcaactgggaacctgtcactggtgtgtggacctgccttctcaaagcagctctccttggttttgggctttgctagagttttgccacctcctgcctggatattaaaactcttgcaaaggcagttttgtccatgaatggctgccagatcattgtttgtgtggggagaggtgagtggagggcctcctgttctgccatcttgctgatgtcaccctaagatgattatttgaattctttgtcaggcaatttgtagatcttcatgtctttggagtcagccactggagtttcattttgtttctttggtggtgtcatattttctcatgcttcctgttctttgaagacttagattgctttcttcatgtttgaagaaggagtcatcttttccactctttactaacttcaggagagaaagaccatcaattagctaagctatagattctgggggtctctcagtccttttctgtgggtggtccttcccttttaagggggatgtcttaggattttgtcccttgtcttcatttcacaaatgaataaaacaaccagaccagacataagtaaggaaatacagcacttgaacaacacctgaaaaaacaactagacctaacagacatacacaggatattctacccaacaacataatacacatacttctcaagtatacatgggacattttcaggatagaccacataacacatcacaaattaattctcaataggggctgggtgcagtggctcacatctgtaatcccagagtaatttgggaggctgaggcgggtggattgcttgaagccaggagcttgacatcagcctggccaacacggtgaaaccccatctctactaaaaatacaaaaattagctgggcatggtggtgcgtgcctgtgatcccagcttcttgggaggctgaagcgtgagaattgcttaggagcccaggaggttgaagctgcagtgagcagagattgtaccactgtactccagcctgtacttcatgacaaagaaaatgtaccattgtaccactgacagaacgagaccctgtcccaaaaaaggaaaaaagctcagtagatttaaaacgatagacatcatacaaagtgtcttctctgaccacaacaggataaagttagaaatcaataacagaagattttaaaaagttcacaaattagtagaatttaaacaacacactctcaaacaaccaatggatcaaagaaatcacaaagaaattataaaattcttaaagacaaatgaaaatgaaagcacactatatccaaacttatgggctgtggccagttgtggtggctcacacctgtaatcccagcactttgggagactgagggaggtggatagctagaggtcaggagttcaagatcagccaggccaacatggtgaaaccctgtctctaccaaaaacacaaaaattagctgggagtggtggtatgtgcctgtagtcccagctacccaggaggctgaggcatgagaatttcttgaacccaggaggcagaggttgcaccactgagctaacaccactgcactccagcctgggtgacagaatgagactctgtctcaaaaaacaaagaaacaacaaaaaaacacaacttatgagttgtggtgaaaggagtgctaaggaggaaatttatagctataaacacattaaaaaaagaaacacctcaattcaacaacataagtttacacattaagaaactagaaaaagaagaataaaactaaacccaaagttagcagaaggaaggaaacaatagagatcagggcagagataaatggaaaagagaatagaaaaacaataaaaaacaaaaccaaaagttggttcttcaaaaagattaataaaactgacaagactaaggaaaagggaaacaatctaaattacttaaaacagaaatgtatttgagaatatctttatatatttctgtctgtctgtctgtctgtctatctgcctgtctatgttttagaaacaagtgtctgtctatgtcttagagacaaggtctagctccattgccctggcaacaatcagatgcaaccacaatcagtggcacaatcggctcactgcagccttgaattcctgggctcgccactatgccagctctttttttttttttttttaagagacaggatcttgccatgttatccaggctgatcttgaactcctggcctcaaggaattttcccacctcggcctcccaaattgttggattacaggcatgacccaccattcccagcctagaaaggattataaaagattactataaataattgtgtgctcataaattggataacccagatgaaatagatgaattcctagacacacaaaacctaccaagactcaattataaagaaacagaaagtcagaatagacctaacctagtaagggaattgagtcagtaataagacaatctcatgacaaagaaaagtcctggacctgatagctttactggtgagttctgccaaacgtttaaagaagaactaacactgattcttttcaagcatttccaaagagtggaagaggagtgaatacctcttaactctttctatgaggccagcattaccctgataccaaagccaaaaacactgtaagaaaataaaacaacagatcaatatgcctctgatcattgatgcaaaaactctaaaaatgctagtatactgggtggggcacggtggctcatgcctgtaatcccagcactttgggaggctgaggtgggtggatcacctgaggtcaggagttcaagaccagcctgaccaacatagagaaactctgtctctactaaaaatacaaaattagccatgtgtggtggtgcatgcctgtaacctcagctactcgggaggctgagacaagagaatcgcttgaacccgggaggtggaggttgtggtgagccgagatcatgccattgtacttcagcctaggcaacaagagcaaaactttgtctaaaaaaaaactatcatactgaattcagcatcatattaaaaggattatacaccatgaccaagtgggatttattcctggaatgcaacgatgtttcaatatataaaaattgatccatataaattcagataattaattttaactgatgtatagttttacattatatgcacataccacgattcacttttccattttcctagtaatgagctttaagattatttccaatttttagctattaccaataatgtttcaacaaacacctttggacatctcttctgcaaatgtgtgtgtattctcttggagaaggtttaccttgtggaacttctagtgtgtatgtgtatgtgtgtgggtatatatatatacacatatgtatatattttcaactttactatatatttccaaaaaactcttcaaagtggcagatttaaactccccttcaccgtatataaattcacggttcctaaagcccttggcatagttttgtgtttttatagaaaagggcataaagtcttattgctgttgaattgtaccttgctcttttcaattgtcttttcacaataattcactatttatcatctgttgtgaatattgtgtagtagttcttaatcattttttctactatattatttattttatatcattaatttgtagaaatcctctttatataatggatattatacttttcaattatatattttgtaaatattttacccaattttctggcttgcatttaacctttatttaggatgcctaggatttttcattttaatacagtctaatttatttttcttttcttttcttcttcatgcattctggcatttgattaataagccatttgttgcccaacgtcattagttctctgtatatacttttaaatatcttaaacatgtaatattcataagtaatttcacaagtagtttaagatttgagtctttaacctaaatagatacaggattttgtgatatgctgtaatatacagatttttatttctatatggataaaaatttatatgttttttctgacatcatttattgaatagtataatttttctactgacttttagtatcatatcttttattacaagtccaatgtattcagcatatctatggatctatttcttggtgcttccattttttcccattgtttaacggtgtatcactgagccaaagcaaaccattttaattattataattaaaacacatttaaatattgataggctattattgttcaaaataactttggttctttctttccattgattattttaatatgacttttccaatcaagttctaaaaaaatactggtggtatatttattgaaatAACTTTAATGAAATTAAATGaaagatcatgtatttgttttctgaattaattcttagatacattaatgttttatgttaccatgaatgtgatattataatataatatttttaat";
$full_seq{"D5_MAGENTA"} = "AGGCCAGTCACACAAAGCAGTGAGAAGGTGATGCAGACAATTTCTTAATGACAAAAGGTCAGCCCAAAGCCAGTCATTAGCAAGGATGATCTGGCCCATTCCCATGGGAAGGTGTGGTGGCTCGGGAGCCCTCTTATGCCCTCCTCCCTCACTGCCCACAGCAGCCCCTACAGCTTTCCACTGAAGCTGCACTTGTGGCAGATCAGGGCAAGGAAGCTGCACTCACACAACAGCACAGCCTATGGGTGCAGAGCCCCAGGCAGTGGGTGTTTGCAATTCTTCGTGCAATAAGCCTTCACATTAACAGGGAAATTAAATGGACGCACTTAATCTCCTAAATCAGTTGAACTGAGGGAAAATTTGCCTACATCTCGCTGGGAGGCTAGCTCTAAGTACACGGGACACATGCACAGGGCTGAAAGGTATTTAAATCCACAGGGCCAGGGATACTGAAGGAGGAGGTTGGTGAGCACAACTGGGCAACTGTGTATTCCTGTGAGTGACTTCCTGGGGGTCTGGGGCGATGGAGCACTTGGAGGGGCTGGGCCGTCCCTGGATGCTGCACAGCACATCTTGGGGGAGTACCTGAAGTAGTCAAAGGCAGTGGAGTAGATCTTCTCGCGAAGCACATTGCGGATGGTTGCATTTGGAACCACATCGGCATGCAGGAGGGACAGCCCCAGGGTCAGCAGCCTGTGAGGGAGCCCCGGACCCGGTCAGAGCAGGAGCCTGGCCTGGGGCCAAGTTCACCTTATGGACTCTCTTCCCTGCCCTTCCAGGAGCAGCTCACTGAAATGTGTTCCCCGTCTACAGAAGTACCGTGATACACAGACGCCCCATGACACACTGTACACACCAGGGGCCCTGTGCTCCCCAGGAAGAGGGCCCTCACTTGAAGCGGGGCCCGATGGCCGCCACGTGCCGGTTCATGCTCCCCTTGGCCCTGCCGATGTTCAGGGACATGGAGCGCTGCAGCAGGCTGGAGAAGATCTCCACTTGGTCAGAGCTGCAGTACTTGGCGATCTCAAACCGCTGCACCAGGAACTGAGCGAAAAGAGGAAGACGCTGTGGTGGTGGGGCTGAGCCGGGCTAACCCTGGGGCCGGCAGAGACAGCTGAGGAGGGGTTCTGGGCTGACTGGCCGAGCTTGCCGAAGGCCTTGGGCTCGGCTACCCCCACCCCAGGAACAGTCCTGGCCCCCCAGGTGGAGCACCCCACAGCCTTCGTGGGGGAACAGGCACGTACGTCGATCCAGATGTAGTGGGGGGTCACTTCGGGGGGACAGGGTTTGGGTTGACTTGCTTCCGAGGCAGCCAGGGGGTCTGCTTCCTTTATCTCAGCAGAAAACAGGCCAAATTTCTGCTCCACTGTCATGTGCCAGCCCCTGCCATCTCCCGCATGAACTACAGGTACAGAAGGAATGTTAGCTCCTCTGTGAAACACAAAAAGGGGCTACTGTCAAGttttctctaattaaaaaaaggaacacgtgctcactgaataagatttagaaaccaagaaaagtatgaagaaaaaattgaagatcgcctatagtcccacatcccagggtcatctgtgtcagtgcttggtgtattttctccagcctctCGAGGCTGCATTCTGTTCAACCCGGTTCACCGTGTGGACATTGCAGGTGTGAGGTGGCAGCACCCGGGATGTACCTGATGCCCTGACAGGCACTGGGTAGGTGACTCTTCTCTATAACCCTGATAACCCTCTGTGGCTGTGAGCGGGAAGACCCCTCTGTGGGCTGCTGAGCTGGCAAGGGCAGAAGAGGGTTCTGGATCCAGGGCCTGGCTCCTCCTCTCCACCCCACACAGACCCTACCCGATACCTTCATCCCGCTAACCAGATTAGGAAGGCCCATGGAGCCGAGGCGAGCCTGCAGCCACCATGGCCAGGCCTGGGAGCCCAGGGTCAGGCTGCTCCCATGGCCCAGTCATGCTCAGCCAGGTCCCCATTCCGTGGGGGGGCATGAGGGGTGCCCAGAGGGAGCAGCATGGTGCCCGGGAGACACCTGGGTGCTGCAGAGAGTAAGAGGTGCAGCTCACACATGGAAAGCCCCCATGATTTCTGGGTGTTTTTACAAGGAGACCAACAAACAGCATTTGGCATCTGGCCAAAGAGGATTCTATCCCTCTGTTGTCCCAGCAGCACCAGCTTCTACAAGGGCTCCAAGCGCCTGTGCAGAGGTGGCAACGAGGCCTAATGAGTAGAACACACACCGCGGCTCCCTCCCCAGTACCATCCCCTCCCTTCTTCCTCATGAGGTGGATCAGGGTGGCCACGTGGCCAGTCACAGGGCTCTCAGCCAGGGTCCCTGCTGGCTGAGGCAGCCACTGTTCTCCCCGGCCACTCTAATGAGCCAGGGAGAGTGAACTGGGCAAGGCCCTGGGAACACATGCCAGGGTGAGCTTCATAAGGTCAAGGCAGCTGGCCTCTGC";
$full_seq{"D6_GREEN"} = "GTCCCCCTTACGTCTCAGTTGGCTCCACATCGCCAGCTCTGTATTCCACTTTCCCTCTCTCTACAACCCCAGTCTATGACTTTTGGGCCACGGAGTCTGGGTTCCTGGGCAACCTGGTTCACATCCTTCTCCTGCCGGCATGGCCTGGCTCCATTTCTGTTCGGCTACCAAAGCCCCAAGCTTTGTGGAGCCTGCCTGGCCTTGAGGAGGGGAATGGGCTCCATCCTGAGAGCCTGCAGGAGGGTTTAAGCTTCCCATCCCCCATTGCTACAGTAGCTCCCCCAGCTTTTCATTCCATATCCTTTATTTTTATTTATTAAAAACTTAATTTTTggccgggcgcagtggcttacgcctgtaatcccagcactttgggaggccgaggcaggcggatcacgaggtcaggagatcgagaccatcctggctaacacggtgaaaccccgtctctactaaaaatacaaaaaatagccaggtgtggtggcgggcgcctgtagtcccagctacttgggaggctgagggaggagaatggcgtgaacccgggaggcagagcttgcagtgagccaagatagcaccactgcactccagcctggcgacaaagtgagactctgtctcaaaaaaaaaaaaaaaaaaaaCACTTAAttttttttttttttgtagagacagggtctccctatgttgcctgggctggtctcaaactcttaatctcgagtgatcctcccacctcagcctcccagagggctgggattacaggcatgagccaccacacccagccGCATATTTTTTATTTTTGTTTCTATGTGttttctgtctgttctttgctgtctcctccatgtctagaacagtgcctggcacatgataggtgctcagtaaataCAGGACTGAAGAAGACAGAGGCAGACAGGCCAGATGTGGCTGCTGTCCTTAGGGAATTGACAGTCCATGATCTATGAGAATGAGCTGCAGACTGGGAGGCAGGTGTCCCAGCATGGGCTCACCAAGCTCCTACCCTCTCCCGGTCCAGCTTTCTCACCTATGAAATAAAAGTGAAgctggacatggtggcccacgcctctaatctcagcagtttgggaggccaaggtgggtggatcacttgagatcaggagattgagaccagcctggctaacatggtgaaaccccatctctactaaaaaacacaaaaattagccggacgtggtggcaggtgcctgtaatcccagctactcgggaggctgaggcaggagaattgctttaacctaggaagtggaggttacagtgagctgaggttgtgccactgcactccagcctgggtgacagagcaagactctgtctcaaaataaataaataaataaataaacaaaCAAACAATAAATGAAAGTGATGGATTACATGAATGGTTTTCAAACTGGGTTCCTCAGGGCTCAGTTTGGGGGAGAATGCAAAGGTTAAATACAAATAACAATGGAATGTAGTAACATTGGCGCTTGGGCGAGTGCTCTGGGTGAGGAATGTGGTGCTCATGGGGAGAAGAGCCGCAtcagagcaggcttcctgcatgaggcaaggaggaaacacaagagctgagagctgaaggagagggagtgagggctgccagaggagctgggaggcgatttcaggcagtgggaactggagctgcaaaCCCCCAGCCTCCTGCAGTCTGGCTATCTGTACCAGCCCTCACCCATGCCCACCACCCTCAGGGCACTCACATCCCTTCTTGCACTGATATTTTCCCGTCCTATCATGACCCTCGTTTGAGGGTGCAGGGAGGACTGGAGCTCAGAGAGGGAGGGTCACCTGGCCAGACCCTAACCCGCTGAGTTCCAGTGGAGTTCCTTTCATCCCCCAGCACTGGATGGGGCTGGATACCTGGAGAGGGACCGTGCTGCTCTTCCTGGGCCCTGCAGCCTGCCTGGCTGGTCCACATCTTCCTGGGCCAGGAGGGTAGTATGGTGCGAGCTTCTAGCTCTCTGGCTGGGGCCCCCTGGCCTACTGGGCTGGCTTCCTGCCCTGGTGGCCCTGGCCCAGCTCCCCAGCTCATGTGCCTCTGCAGCGAGTGGTCAGCCCCTTCCCATCTGCACTTTACAAGCCTCATCGCTGAATCCTCCCCATAGCCAGAGAGCCTGGCACTCTCCTCTCCAGAGAAGGAAACTGTCCAGGGTCACACAGGGACTTATGGGCAGGTCTGTGTGACCTGAGTCTGGGCTCTGAACTGGTGCTTGCAGGGTCTTGCCCTCTGGCTCTGGCAGCCTGAGTGTTACTGTAATCCCTGAGCCTTTGAACAAGCAGGCACTGCTTCCTGAGATCCCCATTGCTGCTATCAGCGTCTCTGTTTCCCAGCTCCACACTGCTGCCAGGACAGACGTATCTTCTGTCTTGTAGCATCTCCATTTCTCTTCCCTTTAGATCTAttttttttttttttttttttttgagatggagtctcgttctatcatccaggctggagtgcagtggcgcaatcttggctcactgtaacttctgtctcctggattcaagcgattcttctgcctcagcctcccaagtagctgggattacaggcgcatgccaccacgcctggctagtttttgtatttttagcagagacgaggtttcaccacgttggccaggctggtctcaaactcctgacctcaggtgatctgcccacctcagcctcccaaagtgctgagattacaggcatgagccaccgctcccggGCTGGATCTATTTCAATCACCCTCCTTCCTCTGCAGCCTGAAACTTGAGGCTTTGCCCACTTCCCAAAGGCACGAGTAGCAATGACCATTTGTTCTGTCATTTGGCCATAGCTCTAGGTCAGAGGACAGTCCTTCATCAAATGTTTGTTAAGCATGCAATCTAGCCAGGGGATGACAAGGGCCAAGTAATGTGTTAATTTCTTCATTCACTAAGCACAGAGAATGGAGTAgaaggaaggtggaaaggagaaggaaggaaaagagagaagaaggaggatagaa";
$full_seq{"D7_YELLOW"} = "gcagagcatgggccccagtgagccctGATCCATGAGGTCTGCTAGCATAATAATTATTCTTTCCATGTGCTGCACAGAGTGGCCCCGGAGGCCTTAGCAGAAATAACAGAAGCTCCCGGCCCTTTACCGTGGTGATGATGGTCCTGACCACTCATTGTGGGAGGGTGCTATGGGGCCAGGAAGGGATGGGGGGTGACAGAACTGCCCCTGAACCCTGACGGGAGCAGGCTTCTGTGGGCAAGGCCCCTTCCCGGTGGCTCAGCCAGCTCTGCACCCATGCCCCAAGTCTGCAGCATGGCTTACCCTTCTGGGACTGCTCCGAGCTGTTGAACATGCTGGCAAAGGCCAGCCTGGGGGCCACCTCGCGGGCATTGATGACCTCAGCTTTTCCTAGAAGAAGCAGGTAGGCAGGCCCACCCACCAAAACCCTTTATGCCACGTGAGCCTGGGGGCCACCCAGCTGTGCCTCGGCCCAACCCACACCCCCTGCCCCTCTCCCTCTCCTCTTCTGAGGCACTCATGAGTGGTGCTGTTGTAGATGGTGAGGAAGAGGCCAACCCCGATGCCCATGCTGTGGGCATTCATGAGCCCCACACACAACAGGGCTGCAATGGCTGCATCCACTGCAGAGCCACCGTCCCGCAGTGTGTCCCTGCCATGTGGCACATAAAGGCATGAGAACCTGCAGGCTTCCACCCTGGCCCCGCATACACACCCTGCTGCCCACCTGCCCAAAGGAGGATGGAAGAGAAGTCCATTCGAGTTTTGGGGtttttgtttttagtttctttctcttttttttgagatggagtcttgctctattgccaggctggagtgcagtggcacgatctcagctcactgcaacctctgcctcccgggttcaagccattctcctgcctcagcctcctgagtagctgggactacaggtgcatgccaccacgcccagctaatttttgtatttttagtagagatggggtttcaccatgttggccaggatggtctctatctcttgacttcatgatccgcctgccttggcctctttttttttttttttttttttttggagacaaagtctctctttgttgctcaggctggagtgcagtggtgtgatcttggatcactgcagcctcagtctcctgggctcaattgaccctcccatctcagcctcccaagtagctgggactatgggcacatgccaccatgcccagccaattttgtttgtttgtgtattttgtagagatggggtttcatcatgttgcccaggctggtcaagaactcctgtgctcaagtaatccacccaccttggcctcccaaagtgctggtattacaggcatgagccactgtgcccagcctttgttttatgagacagggtctcactttgtcacccaggatgaagtgcagtggcacagtcttggctcaatgcagctttgacctcctgggctcaagcaatcctcccacttcagtctcctgagtagctgggactacaggtaagaaccaccacaccgggcaattttttgtcttttttgtagagatagggtctttctatgttgcccaggctggtctcaaactcatggtctaaagcaatcctatcgcctcaacctcccaaagtgctgggattacagTTTCTTCTTTttcttttcttttttctttttttttttttctgagacagagtttcactcagttgcccaggctggagtgcagtggcatgatcttagctcactgcaacctctgcctcctgggttcaagcgattctcctgcctcagcctcctgagtagctgggattacaggcgcacaccaccatgcccggctaactttttatatttttagtagggacagagtgcaccatgttggccaggctgatctcgaactcctgacctcagtggtctgcccgcctcaaccccccaaagtgctgggattacaggtgtggaccaccttgcccagACAGTTTCCTCTTTATTAAGCAAACAAATGTACATGACTTTTATAATTGGGACAAAAAGGGAAATTGCTATACTTTATTAATAACATTTTTTTTTTCCCTGCTAGAGATggtggcttacacctgtaatctcagcactttgggaggccaaggtggaggatcacttgaggccaggagttcaagaccagcctgggcaatagagtgagaccatctctacaaaacagtcttttttaattagtcaggtatgatgcacgcctgtagtcctagctactcagggggctgaggtgagaggatcgcttaagcccaagagttcaaggctgcagtgagctatgatcatgccactgcactccagcctgggtgacagaacaagaccctgtctcaaaatatgaaaaaCATAATATTTTTTCTGTTTAAGTCTTTAGGAGGGAACTTATCTTTATATATAACATGAGATAAGAGTCTAAAATAGAATAACACAGTAGAAgccaggcaccatggctcacacctgtaatcccagcactttaggaagctgaggcgggaggatcacttaaacccaagagtttgaggctgcagtgggctatgatcgctcccctatactccagcctgggtgacagagtaagactccaccttaaaaaaagaaTAAGCCCTTCATGTCCCTGTTTGGGCAACAGCGTTCCttggggggaggggggaggggggagggatggcattgggagatatacctaatgctaaatgacgagttggtgggtgcagcacaccaacatggcacatgtgtacatatgtaacaaacctgcacattgtgcacatgtaccctaaaacttaaagtataataataaaataaaaTAAAAAAAAGAAAGAAAGAAATTGTCTCCTAACCaaaaaaaaaaaaaaaaaaaagaaaagaaaagaaaagaataagccgggcgtggtggctcatacctgtaatcccaacactttgggaggcccaggtgggtggattacctgaggtcaggagttcgagaccagcctgaccaacatggtgaaaccccatctctactaaaaacaccataattaggccaggcgcagtggctcacacctgtaatcccagcactttgagaggcagaggtgggaggatcacaaggtcaggagttcaagaccagcctggccaacatagcaaaaccctgtctctactaaaaatacaaaaattagctgggcatggtggcacatgcctgtagtctcagctactgtggaggctgaggcaggagaatcacttgaacctgggaggtggaggctgcagtaagccaagattgcaccactgccctccagcctgggtaacagagcgatactctgtctcagaaaacacacacacacacacacacacacacacacacacacacatatacacacacacaaatttgttgggcgtggtggcgcactcctataatcccagctacttgggaggcttaggcatgagaatcgcttgaacttgggaggcggaggttgcagttaactgagattgcaccactgcactccagcctggcaacagagcaaaactccatctctaaaTAGATatagatagatagatagatagatagatagatagatagatagatagatgatagatagatagatagatagataggaagaaataagtaaaaataacaaccaaacaacaaaaCAGTGGAGTTTATCCAAAGAAACAGAGACTCTTAGAACTGAGAAAAGGGGCCCTGTTTGGCTCTAGAGACCCACACCCTGCTCTCGGAGTCACCGTCCCCTTCCCAAAGGCTACTGAGAGAGTCCAAGCGAAGCttgcatgtggggaaactgagtctcagaggggtgaaggtattgctcaggtccacTTGCCCAGTTTTCAGGGCCCATGTCCCATGCCCTGCCCCGCTCACCTCCCAATCTCCAAGCACTGCTTGGCATCCGCGGCCATGGCAGCCCTGGTGTACACATGGTTGTCAGGTTCCTTGGAGGCCGAGGGCAGCCAGAGACAGAGGCCGACAATGaccagcaccaggaccacggccagcaggcccagcaccaCTAACTTCTTCTTCATGGCTCTGCTGCACCCACGGGGTAAGGAGCAGGGTCAGGCCCAGCCTCAGACATGCCCTGGCCCCTCCCCAACAGGGCACAGTCTAAAGTCGGGCCTCAGAAACACAAGGCCGGAgtctccttcccgcttcccagaatacgtgcaggctgtccggcccccagacctttgcgcaggccatgccctctgccagaagctctgggcctcatctctgccctcccaaatcctccctgcttatcttcagagcccatcctggtaagaaccccatctccagcagcggcccttcctgggagcccccagatttccacacccctctttctgcagggcctggcctacctcctcacagtggctgagcctccactgcttagggagaagctccagcagggatgggcctggcctggtttctcctgcgtcccccaccccagcctagagcctggcacTGTCCAGGAGTCCTCTGAAGACCCTCCACCCCACCTGGAGCATGGGGTTTAGCTTCCATAGTGCCCACAATCAGAGCGCCCCACAGATTCACTGCCACGGGGCCAGGACTTACCGTCCAGCAGCAGACGGGGGCCCCAAGCCTTGCCTGGGGTGTTGGCCACGAAAGACAGGAGGATTTGGTGGAAACAGCTGAGGAAATAACCGGGGTCTCCCTCACACTCTGCTGAAGCCTGTAGCCACAGAATCTTCTTCAGAGACTCTCTGATCAGGCAGCCTTCTCGTTCTCCTGAAGGTCAAGGGAGGTTACCTGAAGCACGCACAGCCCAGACCTTTCTGGGGGACTCCGTGTTACCTCCCTCTGCCTCTAGCTGGTTTCTCTGTCTCCAGTTGAACTCTGGAGGCAAAGAGGCTGTCAGTAACACATTTGTTTCCATGAATTCTCTCAGCATGTCTCCCAGGCACAGGGTTTTGCACGGAGCAGGGCAGGTAGGGGACAGGGCATTCCTGCACAAGCCCAGGATGTGCATGCGGTAAGCATGGCAAAGGgggctcaggaggcaccgccagcctgccctgctctgacgctggacttgccactcacctgctgtggggcctcaggcaaatcactgaacTGTCCAGCCTGGATGACGGCAGCACCTCACTTGCCTTGCTGCTGGGAGTGTTGTGAATAGAGTAGGTTAGACTGTGGGCAGGGCTTGGTGAATGGTAGCTGTGATTATCATCATGGCTGCACTGGGGACACCCCCAGGAGGCCTGAGTGGCACAGGTCTCTTGCTCACTGTATGTCCCCTGTGGACTCCCTTCCAGGCTGTGCAGTGAGTGGCAGCAGTGACCCTTGGGAAGTCTCATGGCTACGGCAGCAGGTGACAGGTGTGACAACAGGGAAGAGGGATGTGGTGACAGAGGTTGGGGTTCCCCTCTCCCACAGTCAGTTTCCCACAAAGGGCGGTGTCTGCCAGCAAGCCCCTCCAATGAGCCCCAAGCTTGGTTTCCCTCCACTCCACGCTGTCCCAGTGCAGAGCATCTGACCTCAGAGGCAGACACACTGTCCCAGAGGTGGTCTACGAATGGAGTCCCCGTGCCCTCCCCACACACAGGGAACATCCAAATGCCATCGTGGAAGGGTGGCCACCTCCCCAGGCTTGGTGGGCCTGGGGCCGATAGTGTGATACATTTGACCCCCTCCCAGCCCTGGATGCAGACACCAAGAGCAGAGAGACCTGGCAGTAGCCATGCAGCAGCGCACCACCCCACATCCCCAGCACAATCCAAAGCAGCCCCTCATCCCCACCGTGACCACCACAGCCTGAATCCAGGCGCCACCTGTTTCTGACCTGAACTCCCTCACAGCCCCTGCCTGCACTCCCTCCCTCCAACATCACCTGCCCTTCAGTCTTCCAGAAAGCAGCTAGAGGGCTCTGTCTGTCCAACTGCAGAACAGGCCCTGCCTCCTCCCTGCCCTGTTGGACAGCTCACACCCTTCACCAGGCCTGACAGCGCTCTTGCCACTCCAACACCCCGGGTCCCAGCCGGGAGTCCGGGTCAGGGTTAAGGGTTCCTGGTAGAGACACCGATTCCTGGAGGTCCAAAGAGCCTCAGGAGCTGGGCCAGCAATATGCAGCATCTATTATGGACACAGAACATTCCCATCACATggccgggtgcagtggctcacgcctttaatcccagcactttgggaggcagaggcaggtggatcacctgaggtgaagagttcgagaccagtctggccaacatggtgaaacccccatctccactaaaaatacaaaaaattagccaggcatggtggcaggtgcctgtaatcccagctactcaggagctgaggcaggagaattgcttgaacccgggaggtggaggttgcagtgaggcaagattgcaccactgcactccagcctgggccacaagagtgaaactccgtcacacacacacacacacacacacacaaaaaaaaaaaaaaagaaaaaaaaGGTCTCCTGCTGGAACACAGACTAGTTAGAGAAAGGAAAAATAAACAAATGATAGTATGTGTATTAATAAAAGAACTAGCAACACCCACTGCTTAGTTGTGATAATAAAAACTGGACATTAATATAGGCAGAAAAACAGAACAGCCTTGATATGGTTAACCCTTTGACACTGGCAAACACTGTGACCAGTGCTGCCCACACTGGAAGCTCCTGCATCCCTCTTCCTCATGTTTCCTTCAGCATTAAGGAGCAACAAGGGAGACAGCCAGTTCATAGTTCCTTACGCATGGAGCCAAAGGACCTTCAATGTACAAGGTCTGAGCAAGGACCCGCAGCCACATGTGCTTCCTGCTTCAGCAGTGCCCCGTGGGTCTCAGAGCTACCCAAAGGCCTATCCTTCCGAGAGGTTTCTCCTCTCTCCCAACTGATGTCATACGTCTCATCTTCCTTGTCATTCAGATCATCAACCACAAACGTCCTTGCCTTATATTTTCATATCCCTTTTCACCAGTTACAGGGTTAGTTAACTTACGAAATTCTTAACATCTGCATTAGATCTTTTTAAAGTTTCACCCTCAACCACCTATTATTTAGAAGTGAACACAGAAATTTAGTTTCCTTGTGCTATCTGTTGACCCCTAAAATATGCTGGGAGTTTTGGGATTTTTTTTAAAGTCAAATGCATGGCATAAAGCAAAATTACACTACTAAAGAACTGAGTCAGGCCAGACGCTGGCAACGTGAAGACAGCTTCTCCTTACCCACTAGGTTCATCTTTGCACTGTTAACTCCCAAAGTATTGCTTCTCGGTGCTGGGTGTGTGGCATTCATATTCCCCGGCATCCCGGGCCTGAAGATCTGTGATGTGCAATAGGGTTGGGTTCCCCTGGACTCTTTCTATGAAGATCTTCCCTCCGCGGACGCGCTGGGTGTAGATGGCATAGGGGAAGGAAGAGTCCATGGTGCTGACGATCTGCACCTCTCGCTCTGGCGACGAAGGCAGGTAAATGGACCACTGGAAATTCTGTTCAGAAGGTCCCTGG";


$probes{"CTTTCTAGATTGACCACTCAGGAGT"} = "A1_BLUE_F";
$probes{"CTTAGGAGCTTTTCTTCTAGTTGCA"} = "A1_BLUE_R";
$probes{"GTCAAGACAACTCTAAGAAGGTTTT"} = "A2_GREEN_F";
$probes{"TCTACTGAATCACTTGTCAAGAAGC"} = "A2_GREEN_R";
$probes{"GACCCGCTAACTCATTTTATACATC"} = "A3_CYAN_F";
$probes{"GTTTATTCCACCTGTCAGTCTCACT"} = "A3_CYAN_R";
$probes{"ATAAAGGTAGTTACCTGGTTCCAAG"} = "A4_GREEN_F";
$probes{"AGCCCTAAGGTTTCTTGTCTAGATT"} = "A4_GREEN_R";
$probes{"GGATCTACGGAGTCTTCTAAGAGAT"} = "A5_MAGENTA_F";
$probes{"CATAATAGTTAGAACTGTCTCTCTG"} = "A5_MAGENTA_R";
$probes{"GTACAAGTATAGGGCTGTAGGTGCT"} = "B1_YELLOW_F";
$probes{"CTTTTGTTGGCAGTAGTGTTCCTAT"} = "B1_3_YELLOW_R";
$probes{"CTTTGGAACAAAGCCACAGTAGTAT"} = "B2_RED_F";
$probes{"AATGAACTTCCACAGTACCTTCTTG"} = "B2_RED_R";
$probes{"ATACCAAGAGAATCCCCTTACCAGT"} = "B3_YELLOW_F";

$probes{"ACTCCTGAGTGGTCAATCTAGAAAG"} = "A1_BLUE_F-";
$probes{"TGCAACTAGAAGAAAAGCTCCTAAG"} = "A1_BLUE_R-";
$probes{"AAAACCTTCTTAGAGTTGTCTTGAC"} = "A2_GREEN_F-";
$probes{"GCTTCTTGACAAGTGATTCAGTAGA"} = "A2_GREEN_R-";
$probes{"GATGTATAAAATGAGTTAGCGGGTC"} = "A3_CYAN_F-";
$probes{"AGTGAGACTGACAGGTGGAATAAAC"} = "A3_CYAN_R-";
$probes{"CTTGGAACCAGGTAACTACCTTTAT"} = "A4_GREEN_F-";
$probes{"AATCTAGACAAGAAACCTTAGGGCT"} = "A4_GREEN_R-";
$probes{"GGATCTACGGAGTCTTCTAAGAGAT"} = "A5_MAGENTA_F-";
$probes{"CAGAGAGACAGTTCTAACTATTATG"} = "A5_MAGENTA_R-";
$probes{"AGCACCTACAGCCCTATACTTGTAC"} = "B1_YELLOW_F-";
$probes{"ATAGGAACACTACTGCCAACAAAAG"} = "B1_3_YELLOW_R-";
$probes{"ATACTACTGTGGCTTTGTTCCAAAG"} = "B2_RED_F-";
$probes{"CAAGAAGGTACTGTGGAAGTTCATT"} = "B2_RED_R-";
$probes{"ACTGGTAAGGGGATTCTCTTGGTAT"} = "B3_YELLOW_F-";

$probes2{"A1_BLUE_F"} = "CTTTCTAGATTGACCACTCAGGAGTTAC";
$probes2{"CTTAGGAGCTTTTCTTCTAGTTGCA"} = "A1_BLUE_R";
$probes2{"GTCAAGACAACTCTAAGAAGGTTTT"} = "A2_GREEN_F";
$probes2{"TCTACTGAATCACTTGTCAAGAAGC"} = "A2_GREEN_R";
$probes2{"GACCCGCTAACTCATTTTATACATC"} = "A3_CYAN_F";
$probes2{"GTTTATTCCACCTGTCAGTCTCACT"} = "A3_CYAN_R";
$probes2{"ATAAAGGTAGTTACCTGGTTCCAAG"} = "A4_GREEN_F";
$probes2{"AGCCCTAAGGTTTCTTGTCTAGATT"} = "A4_GREEN_R";
$probes2{"GGATCTACGGAGTCTTCTAAGAGAT"} = "A5_MAGENTA_F";
$probes2{"CATAATAGTTAGAACTGTCTCTCTG"} = "A5_MAGENTA_R";
$probes2{"GTACAAGTATAGGGCTGTAGGTGCT"} = "B1_YELLOW_F";
$probes2{"CTTTTGTTGGCAGTAGTGTTCCTAT"} = "B1_3_YELLOW_R";
$probes2{"CTTTGGAACAAAGCCACAGTAGTAT"} = "B2_RED_F";
$probes2{"AATGAACTTCCACAGTACCTTCTTG"} = "B2_RED_R";
$probes2{"ATACCAAGAGAATCCCCTTACCAGT"} = "B3_YELLOW_F";

#my $assembly_seq = '0';
my $assembly_seq = '';

while (my $line = <$FILE_REF>)
{   
    chomp $line;
    #$line =~ tr/actgn/ACTGN/;
    my $first = substr $line, 0, 1;

    if ($first eq '>' || $first eq '@')
    {        
        if ($line =~ m/>.*chr22.*/ || $line =~ m/>22.*/)
        {
            $chromosome = "yes";
            print OUTPUT $line."\n";
        }
        else
        {   
            $chromosome = "yes";
        }
    }
    elsif ($chromosome eq "yes")
    {
        $assembly_seq .= $line;
    }
}
my %probe_matches;
my %reverse_list;

foreach my $probe (keys %full_seq)
{
    my $output_file1  = "sequence_tmp.fasta";
    my $ref_file = "ref_tmp.fasta";
    
    open(OUTPUT_LONG1, ">" .$output_file1) or die "\nCan't open file $output_file1, $!\n";
    print OUTPUT_LONG1 ">".$probe."\n";
    print OUTPUT_LONG1 $full_seq{$probe};
    
    open(OUTPUT_LONG2, ">" .$ref_file) or die "\nCan't open file $ref_file, $!\n";
    print OUTPUT_LONG2 ">ref\n";
    print OUTPUT_LONG2 $assembly_seq;
    
    close OUTPUT_LONG1;
    close OUTPUT_LONG2;

    chomp($output_file1);
    chomp($ref_file);
    my $cmd = sprintf("/usr/local/ncbi/blast/bin/blastn -query %s -subject %s -out blast_${probe}.txt -outfmt 10", $output_file1, $ref_file);
    #my $cmd = sprintf("/usr/local/ncbi/blast/bin/blastn -query %s -subject %s -out blast_tmp.txt -outfmt 10", $output_file1, $ref_file);
    #print {$filehandle{$seed_id2}} "$cmd\n";
    
    #my $system_result = system($cmd);                   
    my $system_result = syscmd($cmd);  

    my $input_BLAST  = "blast_${probe}.txt";
    #my $input_BLAST  = "blast_tmp.txt";
    open(INPUT_BLAST, $input_BLAST) or print "\n\nCan't open blast file $input_BLAST, $!\n";
    my $blast_result = "";
    my $bit_score = "0";
    while (my $line2 = <INPUT_BLAST>)
    {                        
        my @blast_result = split /,/, $line2;
        my $accuracy = $blast_result[2];
        my $alignment_length = $blast_result[3];
        my $long_read_start_pos = $blast_result[6];
        my $long_read_end_pos = $blast_result[7];
        my $assembly_start_pos_tmp = $blast_result[8];
        my $assembly_end_pos = $blast_result[9];
        if ($accuracy > 87 && $alignment_length > length($full_seq{$probe})*0.5)
        {
            #print OUTPUT $assembly_start_pos_tmp." : ".$probe."\n";
            $probe_matches{$assembly_start_pos_tmp} = $probe;
            if ($assembly_start_pos_tmp > $assembly_end_pos)
            {
                $reverse_list{$assembly_start_pos_tmp} = undef;
            }
        }
    }
    close INPUT_BLAST;

    print "\n".$blast_result." BLAST_RESULT\n";
    print length($assembly_seq)." LENGTH_ASSEMBLY_SEQ\n";   
}

foreach my $matches (sort {$a<=>$b} keys %probe_matches)
{
    print OUTPUT $matches." : ".$probe_matches{$matches};
    if (exists($reverse_list{$matches}))
    {
        print OUTPUT " REV\n";
    }
    else
    {
        print OUTPUT "\n";
    }
}

$chnl->end;
MCE::Child->waitall;
    
close $FILE_REF;
close OUTPUT;


# qaccver saccver pident length mismatch gapopen qstart qend sstart sendevalue bitscore
# query, subject, Percentage of identical matches, Alignment length,Number of mismatches, Number of gap openings,
#   alignment view options:
#     0 = Pairwise,
#     1 = Query-anchored showing identities,
#     2 = Query-anchored no identities,
#     3 = Flat query-anchored showing identities,
#     4 = Flat query-anchored no identities,
#     5 = BLAST XML,
#     6 = Tabular,
#     7 = Tabular with comment lines,
#     8 = Seqalign (Text ASN.1),
#     9 = Seqalign (Binary ASN.1),
#    10 = Comma-separated values,
#    11 = BLAST archive (ASN.1),
#    12 = Seqalign (JSON),
#    13 = Multiple-file BLAST JSON,
#    14 = Multiple-file BLAST XML2,
#    15 = Single-file BLAST JSON,
#    16 = Single-file BLAST XML2,
#    17 = Sequence Alignment/Map (SAM),
#    18 = Organism Report
