package STARSEQR_parser;

use strict;
use warnings;
use Carp;


=STARSEQR_format

0       NAME
1       NREAD_SPANS
2       NREAD_JXNLEFT
3       NREAD_JXNRIGHT
4       FUSION_CLASS
5       SPLICE_TYPE
6       BRKPT_LEFT
7       BRKPT_RIGHT
8       LEFT_SYMBOL
9       RIGHT_SYMBOL
10      ANNOT_FORMAT
11      LEFT_ANNOT
12      RIGHT_ANNOT
13      DISTANCE
14      ASSEMBLED_CONTIGS
15      ASSEMBLY_CROSS_JXN
16      PRIMERS
17      ID
18      SPAN_CROSSHOM_SCORE
19      JXN_CROSSHOM_SCORE
20      OVERHANG_DIVERSITY
21      MINFRAG20
22      MINFRAG35
23      OVERHANG_MEANBQ
24      SPAN_MEANBQ
25      JXN_MEANBQ
26      OVERHANG_BQ15
27      SPAN_BQ15
28      JXN_BQ15
29      OVERHANG_MM
30      SPAN_MM
31      JXN_MM
32      OVERHANG_MEANLEN
33      SPAN_MEANLEN
34      JXN_MEANLEN
35      TPM_FUSION
36      TPM_LEFT
37      TPM_RIGHT
38      MAX_TRX_FUSION
39      DISPOSITION

0       PROP1--FLRT1
1       11213
2       1263
3       1168
4       TRANSLOCATION
5       CANONICAL_SPLICING
6       chr5:177421106:-
7       chr11:63883690:+
8       PROP1
9       FLRT1
10      Symbol:Transcript:Strand:Exon_No:Dist_to_Exon:Frame:CDS_Length
11      PROP1:ENST00000308304.2:-:2:0:1:3225
12      FLRT1:ENST00000246841.3:+:2:0:0:2025,MACROD1:ENST00000255681.6:-:NA:NA:NA:167127,MACROD1:ENST00000542359.1:-:NA:NA:NA:0,MACROD1:ENST00000543422.1:-:NA:NA:NA:0,MACROD1:ENST00000545464.1:-:NA:NA:NA:0
13      
14      GGCTCATCGCCTTCCTGACGGAGGTCATCGACAGCACCACCTGCCCCTCGGTGTGCCGCTGCGACAACGGCTTCATCTACTGCAACGACCGGGGACTCACATCCATCCCCGCAGATATCCCTGATGATGCCACCACCCTCTACCTGCAGAACAACCAGATCAACAACGCCGGCATCCCCCAGGACCTCAAGACCAAGGTCAACGTGCAGGTCATCTACCTATGCGAGAATGACCTGGA,GTGAGGCCCGAATCCAAGTATTCAGGCTCCAGG,ATTCGGGCCTCACTGACGCCAGTGTCCCGGGCA,ATCTCCCCCCTCCTGCACCAGGGAGCCTTCTGCAGGGTGGAGCACTCGAGTCCACCGTGGTGGTCGGGGTCCCAGTGGCCGGGTGTCTCTCAGGCAACAGGTTGCTGCCGACTCGCCCCTTCTTTGGCTTCTCAGCCTGGCGCCTCCTTTCTGCTTCCATGGCTCGCCACGGGGACCAAGTGTCCCTGAATCTCTGACTTGAGATTTCTCTGCTTCCGCAGCTCCTCTCCACACCTGTTCCCTCCCCTTCTCCCTCTGTGTATGCCACCCTCTGGGACTCTGTCTCTGAATGT,AGTCTTGCCCGGGACAATGGCCTCAGTGAGGCC,TGGAGCCTGAATACCTAGATTCGGGCCTCACTG,GAGCCTGAATACCTGGGTTCGGGCCTCACTGAG,CCTGGATTCGGGCCTCCCTGAGGCCAGTGTCCC,CTTGCCCGGGACACTGACCTCAGTGAGGCCCGA,GGAGCCTGAATACCTGCATTCGGGCCTCACTGA,CACTGGCCTCAGTGAGTCCCGAATCCAGGTATT,CCCCCAGCCATCCACCATGGTGGTGGCACACCCCACCGCC,TGGGCTGAAGGTGGTGCGGTGGCGGCGCCGGGAGTGCG,GGGACACTGGCCTCAGCGAGGCCCGAATCCAGG,CAGTGAGGCCCGAATCGAGGTATTCAGGCTCCA,TGGATTCGGGCCTCACGGAGGCCAGTGTCCCGG,CCTGAATACCTGGATTGGGGCCTCACTGAGGCC,CTCACTGAGGCCAGTGGCCCGGGCAAGACTCTC,GCCTGAATACCTGGATACGGGCCTCACTGAGGC,GGATTCGGGCCTCACTTAGGCCAGTGTCCCGGG,TCGGGCCTCACTGAGGACAGTGTCCCGGGCAAG,TACCTGGATTCGGGCCGCACTGAGGCCAGTGTC,AGTGAGGCCCGAATCCGGGTATTCAGGCTCCAG,CCGGGACACTGGCCTCGGTGAGGCCCGAATCCA,TGAGGCCAGTGTCCCGAGCAAGACTCTCTCGGG,GGGCCTCACTGAGGCCGGTGTCCCGGGCAAGAC,GGACACTGGCCTCAGTCAGGCCCGAATCCAGGT,TTGCCCGGGACACTGGTCTCAGTGAGGCCCGAA,GATTCGGGCCTCACTGCGGCCAGTGTCCCGGGC,CCTGAATACCTGGATTAGGGCCTCACTGAGGCC,TCGGGCCTCACTGAGGGCAGTGTCCCGGGCAAG,AGAGTCTTGCCCGGGAAACTGGCCTCAGTGAGG,GGATTCGGGCCTCACTAAGGCCAGTGTCCCGGG,CGGGCCTCACTGAGGCTAGTGTCCCGGGCAAGA,CACTGAGGCCAGTGTCTCGGGCAAGACTCTCTC,ACTGGCCTCAGTGAGGACCGAATCCAGGTATTC,GCCTCACTGAGGCCAGCGTCCCGGGCAAGACTC,CCTCAGTGAGGCCCGAGTCCAGGTATTCAGGCT,AATACCTGGATTCGGGTCTCACTGAGGCCAGTG,AGTCTTGCCCGGGACATTGGCCTCAGTGAGGCC,TTGCCCGGGACACTGGACTCAGTGAGGCCCGAA,AGCCTGAATACCTGGAGTCGGGCCTCACTGAGG,CCCGAGAGAGTCTTGCACGGGACACTGGCCTCA,CTCACTGAGGCCAGTGACCCGGGCAAGACTCTC,TGGAGCCTGAATACCTTGATTCGGGCCTCACTG,CTCACTGAGGCCAGTGCCCCGGGCAAGACTCTC,GGGGGGAGATCAAGGTACTCCCCGCAAGGAGGA,CCGAGAGAGTCTTGCCAGGGACACTGGCCTCAG,AGAGTCTTGCCCGGGAGACTGGCCTCAGTGAGG,TTTGGGAGGAACCAGTCCCCCGACATCTGGGCC,AAGGTTCTCCCCGCAATGCGGACAGAGGGGCCG,TGGTGGCCGTGGTCATAACAACGGTGGCCGTGA,TCCATGGTGGCCGTGGGCATCACAACGGTGGCC,GGCGTGGTGGTGGCAGAGGCGGTGGGGTGTGCC,AACCAGTACCCCGACAGCTGGCCGCGAGAGAGT,CCGAGAGAGTCTTGCCGGGGACACTGGCCTCAG,AGGACAGAGGGGCCGCACGCACTCCCGGCGCCG,GAGTCTTGCCCGGGACCCTGGCCTCAGTGAGGC,CACCACCTTCAGCCCAATGCAGTTGGAACAGCT,AGGAGGGGGGAGATCGCGGTTCACGCCGCAAGGAGGACA,GGTGGATGGCTGGGGGGGTCCGGCCCCACCTGG,TCTGGGCCCGAGAGAGACTTGCCCGGGACACTG,CCCAGTGCAGTTGGAAGAGCTGGAGTCAGCCTT,CCGAGAGAGTCTTGCCTGGGACACTGGCCTCAG,GAAGGCGATGAGCCCGGAGCAGAGGAACAGCCA,AGTCTTGCCCGGGACAGTGGCCTCAGTGAGGCC,AGAGAGTCTTGCCCGGTACACTGGCCTCAGTGA,CCGCGAGGAGGACAGACGGGCCGCCCGCACTCC
15      True
16      GGAACCAGTACCCCGACATC,TGGTCATCACAACGGTGGC
17      chr5:177421106:-:chr11:63883690:+:3:2
18      0.0
19      0.005
20      156
21      143
22      20
23      36.8621966269
24      35.8199857308
25      36.1678321678
26      2426
27      21969
28      4785
29      0.0505964623612
30      0.236466601266
31      0.294117647059
32      27.0974907445
33      49.5867296888
34      36.3490333196
35      5443.304913
36      4115.283164
37      1.131535
38      ENST00000308304.2--ENST00000246841.3|651
39      PASS

=cut


sub parse_fusion_result_file {
    my ($file) = @_;

    my @fusions;
    
    open (my $fh, $file) or die "Error, cannot open file $file";
    my $header = <$fh>;
    while (<$fh>) {
        chomp;

        my @x = split("\t");
        my $fusion_gene_A = $x[8];
        my $fusion_gene_B = $x[9];
        if ($fusion_gene_A eq $fusion_gene_B) { next; } # no self-fusions

        my $disposition = $x[39];
                
        my $chr_coords_A = $x[6];
        my $chr_coords_B = $x[7];
        
        my ($chrA, $coordA, $orientA) = split(/:/, $chr_coords_A);
        my ($chrB, $coordB, $orientB) = split(/:/, $chr_coords_B);

        my $junction_reads = $x[2] + $x[3];
        my $spanning_reads = $x[1];
        
        my $struct = {
            geneA => $fusion_gene_A,
            chrA => $chrA || ".",
            coordA => $coordA || ".",

            geneB => $fusion_gene_B,
            chrB => $chrB || ".",
            coordB => $coordB || ".",

            span_reads => $spanning_reads,
            junc_reads => $junction_reads,
        };
        
        push (@fusions, $struct);

    }

    close $fh;

    return(@fusions);
}


1; #EOM

