CTAT_SeraCareFusion
================
bhaas
2024-02-03

Fusion prediction results and benchmarking for SeraCare fusion v4 mix
are available here:
<https://github.com/fusiontranscripts/LR-FusionBenchmarking/tree/master/SeraCareFusions>

Analysis performed below:

The Iso-seq labeled sample is actually MAS-Iso-seq ‘monomer’ type. The
other two MAS-Iso-seq used the 8-concatemer arrays followed by
deconcatenation.

# number of fusion reads for each control fusion

``` r
control_fusions = read.table("data/SeraCare_fusion_targets.tsv", header=T, sep="\t")

control_fusions 
```

    ##         FusionName LeftGene   LeftBreakpoint RightGene  RightBreakpoint
    ## 1       KIF5B--RET    KIF5B chr10:32017143:-       RET chr10:43114480:+
    ## 2    SLC34A2--ROS1  SLC34A2  chr4:25664330:+      ROS1 chr6:117324415:-
    ## 3     FGFR3--TACC3    FGFR3   chr4:1806934:+     TACC3   chr4:1739702:+
    ## 4      LMNA--NTRK1     LMNA chr1:156130773:+     NTRK1 chr1:156874906:+
    ## 5       CD74--ROS1     CD74 chr5:150404680:-      ROS1 chr6:117324415:-
    ## 6     TMPRSS2--ERG  TMPRSS2 chr21:41508081:-       ERG chr21:38584945:-
    ## 7       NCOA4--RET    NCOA4 chr10:46012883:-       RET chr10:43116584:+
    ## 8  FGFR3--BAIAP2L1    FGFR3   chr4:1806934:+  BAIAP2L1  chr7:98362432:-
    ## 9      TPM3--NTRK1     TPM3 chr1:154170400:-     NTRK1 chr1:156874571:+
    ## 10      CCDC6--RET    CCDC6 chr10:59906122:-       RET chr10:43116584:+
    ## 11     PAX8--PPARG     PAX8 chr2:113235394:-     PPARG  chr3:12379704:+
    ## 12    EGFR--SEPT14     EGFR  chr7:55200413:+    SEPT14  chr7:55796092:-
    ## 13   SLC45A3--BRAF  SLC45A3 chr1:205680394:-      BRAF chr7:140794467:-
    ## 14       EML4--ALK     EML4  chr2:42295516:+       ALK  chr2:29223528:-
    ## 15     ETV6--NTRK3     ETV6 chr12:11869969:+     NTRK3 chr15:87940753:-
    ## 16      TFG--NTRK1      TFG chr3:100732672:+     NTRK1 chr1:156874571:+

``` r
# read in the ctat-LRF fusion predictions for each of the three samples

rep1_data = read.table("data/ctatLRF_FI/SeraCarev4Fusion.IsoSeq.m64020e_230609_061545.refined.Oct32023.ctat-LR-fusion.fusion_predictions.tsv.gz", header=T, com='', sep="\t") %>%
    mutate(dataset= 'ISO-seq')

rep2_data = read.table("data/ctatLRF_FI/SeraCarev4Fusion.m64363e_230614_195212.refine.bc08.MASseq.ctat-LR-fusion.fusion_predictions.tsv.gz", header=T, com='', sep="\t") %>%
    mutate(dataset = 'MAS-seq-R1')

rep3_data = read.table("data/ctatLRF_FI/SeraCarev4Fusion.m64363e_230614_195212.refine.bc09.MASseq.ctat-LR-fusion.fusion_predictions.tsv.gz", header=T, com='', sep="\t") %>%
    mutate(dataset = 'MAS-seq-R2')


ctatLRF_FI_data = bind_rows(rep1_data, rep2_data, rep3_data) %>% rename(FusionName = X.FusionName, SR_FFPM = FFPM) %>%
    mutate(num_SR = est_J + est_S) 

ctatLRF_FI_data %>% head()
```

    ##      FusionName num_LR LeftGene LeftLocalBreakpoint   LeftBreakpoint RightGene
    ## 1    KIF5B--RET     66    KIF5B               19983 chr10:32017143:-       RET
    ## 2 SLC34A2--ROS1     59  SLC34A2                4738  chr4:25664330:+      ROS1
    ## 3  FGFR3--TACC3     58    FGFR3                9864   chr4:1806934:+     TACC3
    ## 4   LMNA--NTRK1     51     LMNA               13767 chr1:156130773:+     NTRK1
    ## 5    CD74--ROS1     50     CD74                4950 chr5:150404680:-      ROS1
    ## 6  TMPRSS2--ERG     45  TMPRSS2                3407 chr21:41508081:-       ERG
    ##   RightLocalBreakpoint  RightBreakpoint      SpliceType
    ## 1                38630 chr10:43114480:+ ONLY_REF_SPLICE
    ## 2                56592 chr6:117324415:- ONLY_REF_SPLICE
    ## 3                26008   chr4:1739702:+ ONLY_REF_SPLICE
    ## 4                35485 chr1:156874906:+ ONLY_REF_SPLICE
    ## 5                46835 chr6:117324415:- ONLY_REF_SPLICE
    ## 6                27812 chr21:38584945:- ONLY_REF_SPLICE
    ##                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      LR_accessions
    ## 1 m64020e_230609_061545/21236204/ccs,m64020e_230609_061545/167184893/ccs,m64020e_230609_061545/19203215/ccs,m64020e_230609_061545/33162701/ccs,m64020e_230609_061545/16517487/ccs,m64020e_230609_061545/124126798/ccs,m64020e_230609_061545/115802344/ccs,m64020e_230609_061545/130091733/ccs,m64020e_230609_061545/157549438/ccs,m64020e_230609_061545/8849096/ccs,m64020e_230609_061545/25954726/ccs,m64020e_230609_061545/10617906/ccs,m64020e_230609_061545/75171757/ccs,m64020e_230609_061545/52691034/ccs,m64020e_230609_061545/78710781/ccs,m64020e_230609_061545/150800114/ccs,m64020e_230609_061545/164561469/ccs,m64020e_230609_061545/169542772/ccs,m64020e_230609_061545/104727488/ccs,m64020e_230609_061545/34997672/ccs,m64020e_230609_061545/10749828/ccs,m64020e_230609_061545/41552523/ccs,m64020e_230609_061545/131663325/ccs,m64020e_230609_061545/124324599/ccs,m64020e_230609_061545/66389385/ccs,m64020e_230609_061545/163315986/ccs,m64020e_230609_061545/95093658/ccs,m64020e_230609_061545/123536743/ccs,m64020e_230609_061545/150471819/ccs,m64020e_230609_061545/75301163/ccs,m64020e_230609_061545/8980482/ccs,m64020e_230609_061545/52430618/ccs,m64020e_230609_061545/110889415/ccs,m64020e_230609_061545/35720023/ccs,m64020e_230609_061545/118030398/ccs,m64020e_230609_061545/113116757/ccs,m64020e_230609_061545/178718633/ccs,m64020e_230609_061545/82970988/ccs,m64020e_230609_061545/162858879/ccs,m64020e_230609_061545/147720661/ccs,m64020e_230609_061545/983393/ccs,m64020e_230609_061545/72485159/ccs,m64020e_230609_061545/163908257/ccs,m64020e_230609_061545/18022479/ccs,m64020e_230609_061545/68684366/ccs,m64020e_230609_061545/53871491/ccs,m64020e_230609_061545/144837380/ccs,m64020e_230609_061545/152240565/ccs,m64020e_230609_061545/41944703/ccs,m64020e_230609_061545/173672925/ccs,m64020e_230609_061545/86444049/ccs,m64020e_230609_061545/51118839/ccs,m64020e_230609_061545/107677815/ccs,m64020e_230609_061545/109511696/ccs,m64020e_230609_061545/112592439/ccs,m64020e_230609_061545/47188792/ccs,m64020e_230609_061545/84279712/ccs,m64020e_230609_061545/29952497/ccs,m64020e_230609_061545/154141966/ccs,m64020e_230609_061545/7210866/ccs,m64020e_230609_061545/111869965/ccs,m64020e_230609_061545/81725643/ccs,m64020e_230609_061545/68814977/ccs,m64020e_230609_061545/173868293/ccs,m64020e_230609_061545/115541281/ccs,m64020e_230609_061545/151586261/ccs
    ## 2                                                                                                                                                                                                                                                       m64020e_230609_061545/74711208/ccs,m64020e_230609_061545/123406030/ccs,m64020e_230609_061545/147719943/ccs,m64020e_230609_061545/45416590/ccs,m64020e_230609_061545/169018673/ccs,m64020e_230609_061545/152242641/ccs,m64020e_230609_061545/158336424/ccs,m64020e_230609_061545/65143071/ccs,m64020e_230609_061545/165806159/ccs,m64020e_230609_061545/96602352/ccs,m64020e_230609_061545/9177323/ccs,m64020e_230609_061545/44566170/ccs,m64020e_230609_061545/133958490/ccs,m64020e_230609_061545/48760137/ccs,m64020e_230609_061545/12321664/ccs,m64020e_230609_061545/151783641/ccs,m64020e_230609_061545/151586485/ccs,m64020e_230609_061545/147130336/ccs,m64020e_230609_061545/137888080/ccs,m64020e_230609_061545/109119882/ccs,m64020e_230609_061545/150341735/ccs,m64020e_230609_061545/4916359/ccs,m64020e_230609_061545/123077981/ccs,m64020e_230609_061545/32312117/ccs,m64020e_230609_061545/49416901/ccs,m64020e_230609_061545/79234395/ccs,m64020e_230609_061545/157090355/ccs,m64020e_230609_061545/14747062/ccs,m64020e_230609_061545/112526279/ccs,m64020e_230609_061545/81068843/ccs,m64020e_230609_061545/175768088/ccs,m64020e_230609_061545/44632242/ccs,m64020e_230609_061545/9111007/ccs,m64020e_230609_061545/26216266/ccs,m64020e_230609_061545/151390099/ccs,m64020e_230609_061545/85788304/ccs,m64020e_230609_061545/152634337/ccs,m64020e_230609_061545/149095342/ccs,m64020e_230609_061545/74910423/ccs,m64020e_230609_061545/39913485/ccs,m64020e_230609_061545/93586512/ccs,m64020e_230609_061545/124323398/ccs,m64020e_230609_061545/139987500/ccs,m64020e_230609_061545/48431151/ccs,m64020e_230609_061545/167903917/ccs,m64020e_230609_061545/139854814/ccs,m64020e_230609_061545/129696077/ccs,m64020e_230609_061545/49546871/ccs,m64020e_230609_061545/103153853/ccs,m64020e_230609_061545/131074177/ccs,m64020e_230609_061545/43779406/ccs,m64020e_230609_061545/90571911/ccs,m64020e_230609_061545/71369475/ccs,m64020e_230609_061545/93454968/ccs,m64020e_230609_061545/119605245/ccs,m64020e_230609_061545/30149321/ccs,m64020e_230609_061545/115607280/ccs,m64020e_230609_061545/11207674/ccs,m64020e_230609_061545/61670443/ccs
    ## 3                                                                                                                                                                                                                                                                                      m64020e_230609_061545/118751822/ccs,m64020e_230609_061545/106104993/ccs,m64020e_230609_061545/104662417/ccs,m64020e_230609_061545/78448771/ccs,m64020e_230609_061545/87098506/ccs,m64020e_230609_061545/129960675/ccs,m64020e_230609_061545/131598979/ccs,m64020e_230609_061545/39453230/ccs,m64020e_230609_061545/155320582/ccs,m64020e_230609_061545/143131349/ccs,m64020e_230609_061545/114098374/ccs,m64020e_230609_061545/72943399/ccs,m64020e_230609_061545/104399635/ccs,m64020e_230609_061545/11274028/ccs,m64020e_230609_061545/147654405/ccs,m64020e_230609_061545/109838942/ccs,m64020e_230609_061545/10881262/ccs,m64020e_230609_061545/80216276/ccs,m64020e_230609_061545/43648987/ccs,m64020e_230609_061545/71698911/ccs,m64020e_230609_061545/4128893/ccs,m64020e_230609_061545/78777072/ccs,m64020e_230609_061545/27919297/ccs,m64020e_230609_061545/120325160/ccs,m64020e_230609_061545/93455866/ccs,m64020e_230609_061545/160827209/ccs,m64020e_230609_061545/158927534/ccs,m64020e_230609_061545/157745222/ccs,m64020e_230609_061545/100402779/ccs,m64020e_230609_061545/98042272/ccs,m64020e_230609_061545/91752153/ccs,m64020e_230609_061545/70126252/ccs,m64020e_230609_061545/101255229/ccs,m64020e_230609_061545/123601427/ccs,m64020e_230609_061545/81855179/ccs,m64020e_230609_061545/44108226/ccs,m64020e_230609_061545/61605453/ccs,m64020e_230609_061545/153553439/ccs,m64020e_230609_061545/30279701/ccs,m64020e_230609_061545/161677786/ccs,m64020e_230609_061545/172886018/ccs,m64020e_230609_061545/153747552/ccs,m64020e_230609_061545/63506599/ccs,m64020e_230609_061545/28182970/ccs,m64020e_230609_061545/47383528/ccs,m64020e_230609_061545/3081437/ccs,m64020e_230609_061545/103679940/ccs,m64020e_230609_061545/121571108/ccs,m64020e_230609_061545/132383436/ccs,m64020e_230609_061545/158270112/ccs,m64020e_230609_061545/142084161/ccs,m64020e_230609_061545/121571675/ccs,m64020e_230609_061545/156697567/ccs,m64020e_230609_061545/173476066/ccs,m64020e_230609_061545/164235691/ccs,m64020e_230609_061545/18613574/ccs,m64020e_230609_061545/177340713/ccs,m64020e_230609_061545/51249568/ccs
    ## 4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     m64020e_230609_061545/177277670/ccs,m64020e_230609_061545/12584650/ccs,m64020e_230609_061545/128254280/ccs,m64020e_230609_061545/118555777/ccs,m64020e_230609_061545/107479921/ccs,m64020e_230609_061545/123077702/ccs,m64020e_230609_061545/136905566/ccs,m64020e_230609_061545/77268151/ccs,m64020e_230609_061545/1900561/ccs,m64020e_230609_061545/144048225/ccs,m64020e_230609_061545/119866716/ccs,m64020e_230609_061545/67897710/ccs,m64020e_230609_061545/173476461/ccs,m64020e_230609_061545/119147138/ccs,m64020e_230609_061545/70256472/ccs,m64020e_230609_061545/173474043/ccs,m64020e_230609_061545/106103178/ccs,m64020e_230609_061545/10094059/ccs,m64020e_230609_061545/75041209/ccs,m64020e_230609_061545/65143924/ccs,m64020e_230609_061545/67504188/ccs,m64020e_230609_061545/157614090/ccs,m64020e_230609_061545/17432985/ccs,m64020e_230609_061545/138086526/ccs,m64020e_230609_061545/16975413/ccs,m64020e_230609_061545/84215838/ccs,m64020e_230609_061545/56100315/ccs,m64020e_230609_061545/26739056/ccs,m64020e_230609_061545/36569239/ccs,m64020e_230609_061545/101123379/ccs,m64020e_230609_061545/52233078/ccs,m64020e_230609_061545/60556982/ccs,m64020e_230609_061545/29098618/ccs,m64020e_230609_061545/43518410/ccs,m64020e_230609_061545/64555372/ccs,m64020e_230609_061545/44369840/ccs,m64020e_230609_061545/20580011/ccs,m64020e_230609_061545/40764677/ccs,m64020e_230609_061545/38930182/ccs,m64020e_230609_061545/50662004/ccs,m64020e_230609_061545/14420804/ccs,m64020e_230609_061545/42862269/ccs,m64020e_230609_061545/133040556/ccs,m64020e_230609_061545/103613449/ccs,m64020e_230609_061545/148244537/ccs,m64020e_230609_061545/103287019/ccs,m64020e_230609_061545/99025928/ccs,m64020e_230609_061545/68814331/ccs,m64020e_230609_061545/157221897/ccs,m64020e_230609_061545/62128180/ccs,m64020e_230609_061545/102630459/ccs
    ## 5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     m64020e_230609_061545/132581745/ccs,m64020e_230609_061545/76284242/ccs,m64020e_230609_061545/136053433/ccs,m64020e_230609_061545/5570738/ccs,m64020e_230609_061545/112658288/ccs,m64020e_230609_061545/134089541/ccs,m64020e_230609_061545/155386837/ccs,m64020e_230609_061545/83165841/ccs,m64020e_230609_061545/121899043/ccs,m64020e_230609_061545/43451211/ccs,m64020e_230609_061545/155256825/ccs,m64020e_230609_061545/74123174/ccs,m64020e_230609_061545/36569694/ccs,m64020e_230609_061545/46139690/ccs,m64020e_230609_061545/177275193/ccs,m64020e_230609_061545/114100302/ccs,m64020e_230609_061545/1638703/ccs,m64020e_230609_061545/101976142/ccs,m64020e_230609_061545/125765811/ccs,m64020e_230609_061545/57279569/ccs,m64020e_230609_061545/133302188/ccs,m64020e_230609_061545/86903121/ccs,m64020e_230609_061545/150669513/ccs,m64020e_230609_061545/85787237/ccs,m64020e_230609_061545/166791456/ccs,m64020e_230609_061545/117442001/ccs,m64020e_230609_061545/123208997/ccs,m64020e_230609_061545/113967752/ccs,m64020e_230609_061545/47777121/ccs,m64020e_230609_061545/76022104/ccs,m64020e_230609_061545/75825848/ccs,m64020e_230609_061545/5310069/ccs,m64020e_230609_061545/130091018/ccs,m64020e_230609_061545/49743242/ccs,m64020e_230609_061545/21236485/ccs,m64020e_230609_061545/132645122/ccs,m64020e_230609_061545/35979690/ccs,m64020e_230609_061545/51382613/ccs,m64020e_230609_061545/123142256/ccs,m64020e_230609_061545/35651855/ccs,m64020e_230609_061545/96994410/ccs,m64020e_230609_061545/60426229/ccs,m64020e_230609_061545/79167723/ccs,m64020e_230609_061545/97911878/ccs,m64020e_230609_061545/163251729/ccs,m64020e_230609_061545/125763996/ccs,m64020e_230609_061545/102302770/ccs,m64020e_230609_061545/104859360/ccs,m64020e_230609_061545/107872353/ccs,m64020e_230609_061545/173671317/ccs
    ## 6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        m64020e_230609_061545/175179174/ccs,m64020e_230609_061545/102105426/ccs,m64020e_230609_061545/8650841/ccs,m64020e_230609_061545/62195769/ccs,m64020e_230609_061545/143132304/ccs,m64020e_230609_061545/50069842/ccs,m64020e_230609_061545/154861767/ccs,m64020e_230609_061545/394075/ccs,m64020e_230609_061545/99682944/ccs,m64020e_230609_061545/90965754/ccs,m64020e_230609_061545/133629169/ccs,m64020e_230609_061545/51839753/ccs,m64020e_230609_061545/113116875/ccs,m64020e_230609_061545/46270531/ccs,m64020e_230609_061545/31130451/ccs,m64020e_230609_061545/33031899/ccs,m64020e_230609_061545/39519736/ccs,m64020e_230609_061545/172425248/ccs,m64020e_230609_061545/172165340/ccs,m64020e_230609_061545/74384296/ccs,m64020e_230609_061545/89065898/ccs,m64020e_230609_061545/76153376/ccs,m64020e_230609_061545/144509759/ccs,m64020e_230609_061545/114032675/ccs,m64020e_230609_061545/94439949/ccs,m64020e_230609_061545/107547472/ccs,m64020e_230609_061545/122685075/ccs,m64020e_230609_061545/146604287/ccs,m64020e_230609_061545/142869697/ccs,m64020e_230609_061545/77268978/ccs,m64020e_230609_061545/5310511/ccs,m64020e_230609_061545/160107065/ccs,m64020e_230609_061545/111871814/ccs,m64020e_230609_061545/20382573/ccs,m64020e_230609_061545/155190628/ccs,m64020e_230609_061545/113640614/ccs,m64020e_230609_061545/179767654/ccs,m64020e_230609_061545/27526868/ccs,m64020e_230609_061545/21760302/ccs,m64020e_230609_061545/124389831/ccs,m64020e_230609_061545/16386709/ccs,m64020e_230609_061545/123800294/ccs,m64020e_230609_061545/112460499/ccs,m64020e_230609_061545/179635157/ccs,m64020e_230609_061545/48171843/ccs
    ##   LR_FFPM JunctionReadCount SpanningFragCount est_J est_S
    ## 1  14.059                 2                 0     2     0
    ## 2  12.568                 3                 1     3     1
    ## 3  12.355                NA                NA    NA    NA
    ## 4  10.864                 1                 1     1     1
    ## 5  10.651                 1                 1     1     1
    ## 6   9.586                NA                NA    NA    NA
    ##                  LeftGene_SR             RightGene_SR LargeAnchorSupport
    ## 1   KIF5B^ENSG00000170759.10   RET^ENSG00000165731.16                YES
    ## 2 SLC34A2^ENSG00000157765.10   ROS1^ENSG00000047936.9                YES
    ## 3                                                                       
    ## 4    LMNA^ENSG00000160789.18 NTRK1^ENSG00000198400.10                YES
    ## 5    CD74^ENSG00000019582.13   ROS1^ENSG00000047936.9                 NO
    ## 6                                                                       
    ##                                                                                                                                      JunctionReads
    ## 1                                    HFYGCDRX3230916:1:2203:2284:23265/2,HFYGCDRX3230916:2:2215:20012:24377/1,HFYGCDRX3230916:2:2215:20012:24377/2
    ## 2 HFYGCDRX3230916:1:2165:10059:1188/2,HFYGCDRX3230916:1:2248:18891:17738/1,HFYGCDRX3230916:1:2254:1551:29011/2,HFYGCDRX3230916:1:2165:10059:1188/1
    ## 3                                                                                                                                                 
    ## 4                                                                                                              HG5J5DRX3230915:1:2147:2790:36448/2
    ## 5                                                                          HFYGCDRX3230916:1:2207:10628:4053/2,HFYGCDRX3230916:1:2207:10628:4053/1
    ## 6                                                                                                                                                 
    ##                       SpanningFrags NumCounterFusionLeft
    ## 1                                                     33
    ## 2 HFYGCDRX3230916:1:2121:19967:7232                    0
    ## 3                                                     NA
    ## 4 HG5J5DRX3230915:1:2251:9679:22482                   93
    ## 5 HFYGCDRX3230916:1:2168:13593:8688                 3625
    ## 6                                                     NA
    ##                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        CounterFusionLeftReads
    ## 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         HG5J5DRX3230915:1:2140:13937:34679,HFYGCDRX3230916:2:2211:15935:17409,HFYGCDRX3230916:1:2159:16947:26021,HFYGCDRX3230916:2:2133:1407:23782,HFYGCDRX3230916:1:2156:31051:10175,HFYGCDRX3230916:1:2125:24433:9737,HFYGCDRX3230916:2:2253:30445:32737,HFYGCDRX3230916:1:2107:30201:22294,HFYGCDRX3230916:1:2158:4110:13745,HG5J5DRX3230915:1:2172:4960:6010,HFYGCDRX3230916:1:2274:4969:23406,HG5J5DRX3230915:1:2109:26295:18787,HFYGCDRX3230916:1:2160:10601:1752,HG5J5DRX3230915:1:2131:32660:30029,HFYGCDRX3230916:1:2132:5701:36573,HFYGCDRX3230916:2:2157:25744:14074,HFYGCDRX3230916:2:2206:15664:24580,HFYGCDRX3230916:1:2233:24216:19225,HG5J5DRX3230915:1:2140:13928:34695,HFYGCDRX3230916:1:2137:11822:25003,HG5J5DRX3230915:1:2110:3043:15092,HFYGCDRX3230916:1:2132:25590:2159,HFYGCDRX3230916:2:2268:4173:21684,HFYGCDRX3230916:1:2173:23258:33191,HFYGCDRX3230916:1:2238:19831:19774,HG5J5DRX3230915:1:2110:3034:15076,HFYGCDRX3230916:1:2156:29631:33364,HFYGCDRX3230916:1:2247:1407:31203,HFYGCDRX3230916:1:2231:4860:17331,HFYGCDRX3230916:1:2237:28302:29810,HFYGCDRX3230916:1:2274:17400:21261,HFYGCDRX3230916:1:2147:3983:31000,HG5J5DRX3230915:1:2215:29658:15092
    ## 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           .
    ## 3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
    ## 4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         HFYGCDRX3230916:1:2112:13630:1454,HFYGCDRX3230916:1:2121:17345:28776,HFYGCDRX3230916:2:2172:18665:25645,HFYGCDRX3230916:2:2269:11360:9580,HFYGCDRX3230916:1:2135:17716:3208,HFYGCDRX3230916:2:2207:1136:23813,HFYGCDRX3230916:1:2263:16875:12179,HFYGCDRX3230916:2:2160:25437:27915,HFYGCDRX3230916:2:2268:32407:13902,HFYGCDRX3230916:1:2247:23692:14779,HFYGCDRX3230916:2:2103:22959:33301,HFYGCDRX3230916:1:2136:20347:16125,HFYGCDRX3230916:1:2108:6596:25379,HFYGCDRX3230916:1:2178:13494:34381,HFYGCDRX3230916:2:2257:26060:31563,HFYGCDRX3230916:1:2259:5466:13401,HFYGCDRX3230916:1:2101:11098:12947,HFYGCDRX3230916:1:2166:21269:29935,HFYGCDRX3230916:2:2258:4743:20917,HFYGCDRX3230916:1:2119:8585:29888,HFYGCDRX3230916:1:2114:14073:9925,HFYGCDRX3230916:2:2138:10059:28682,HG5J5DRX3230915:1:2258:1597:5228,HFYGCDRX3230916:1:2119:12481:3944,HFYGCDRX3230916:2:2162:28230:18380,HFYGCDRX3230916:2:2129:11704:25676,HFYGCDRX3230916:1:2217:13187:9204,HFYGCDRX3230916:1:2222:13937:35336,HFYGCDRX3230916:2:2252:31403:35524,HFYGCDRX3230916:1:2263:21432:14184,HFYGCDRX3230916:1:2215:19849:7185,HFYGCDRX3230916:1:2158:27308:15436,HFYGCDRX3230916:1:2144:32054:9846,HFYGCDRX3230916:2:2258:9842:35916,HFYGCDRX3230916:1:2226:9308:25316,HG5J5DRX3230915:1:2218:10926:31375,HFYGCDRX3230916:1:2240:12590:28682,HFYGCDRX3230916:2:2262:7979:23516,HG5J5DRX3230915:1:2261:14986:9815,HFYGCDRX3230916:1:2140:5358:29277,HG5J5DRX3230915:1:2135:20618:12806,HFYGCDRX3230916:2:2116:17354:24251,HFYGCDRX3230916:2:2118:9805:34413,HFYGCDRX3230916:1:2147:32362:25379,HFYGCDRX3230916:2:2144:17400:5635,HFYGCDRX3230916:1:2242:17698:32706,HFYGCDRX3230916:2:2172:3920:4742,HFYGCDRX3230916:1:2172:20256:20603,HFYGCDRX3230916:2:2115:20302:5087,HFYGCDRX3230916:1:2105:18322:17440,HFYGCDRX3230916:2:2142:18195:18349,HFYGCDRX3230916:1:2159:28257:9972,HFYGCDRX3230916:1:2113:3893:9518,HG5J5DRX3230915:1:2148:24650:24612,HFYGCDRX3230916:2:2153:2871:26882,HFYGCDRX3230916:2:2273:31340:3223,HG5J5DRX3230915:1:2248:11234:2503,HFYGCDRX3230916:1:2120:10330:15217,HFYGCDRX3230916:2:2224:13322:17581,HFYGCDRX3230916:1:2225:1958:22921,HFYGCDRX3230916:1:2129:9200:23093,HFYGCDRX3230916:2:2134:19922:4366,HFYGCDRX3230916:1:2166:6280:26647,HFYGCDRX3230916:1:2176:17933:34021,HFYGCDRX3230916:1:2148:18855:11788,HG5J5DRX3230915:1:2271:25988:22889,HFYGCDRX3230916:1:2223:31837:4805,HFYGCDRX3230916:2:2226:12427:6762,HFYGCDRX3230916:2:2154:5575:17910,HFYGCDRX3230916:2:2123:25500:34287,HG5J5DRX3230915:1:2122:31864:22952,HFYGCDRX3230916:1:2109:31078:21590,HFYGCDRX3230916:2:2143:5593:28401,HFYGCDRX3230916:2:2135:6686:16235,HFYGCDRX3230916:2:2253:16586:25551,HG5J5DRX3230915:1:2118:26395:34303,HFYGCDRX3230916:1:2271:2040:30483,HFYGCDRX3230916:2:2129:14950:3865,HFYGCDRX3230916:2:2232:18945:31986,HFYGCDRX3230916:1:2151:29215:13197,HFYGCDRX3230916:1:2163:17906:9518,HFYGCDRX3230916:1:2128:5656:22623,HFYGCDRX3230916:1:2114:22028:20697,HFYGCDRX3230916:1:2276:26539:15671,HFYGCDRX3230916:2:2130:17616:22075,HG5J5DRX3230915:1:2101:23647:6214,HFYGCDRX3230916:1:2151:21414:21543,HFYGCDRX3230916:2:2244:4896:30827,HFYGCDRX3230916:1:2142:4435:1470,HFYGCDRX3230916:2:2255:9833:33364,HFYGCDRX3230916:2:2209:17662:16579,HG5J5DRX3230915:1:2131:28989:23954,HFYGCDRX3230916:2:2147:9254:7341
    ## 5 HFYGCDRX3230916:1:2208:1307:31688,HFYGCDRX3230916:1:2140:9435:12007,HG5J5DRX3230915:1:2162:14190:25942,HFYGCDRX3230916:2:2175:31051:6637,HFYGCDRX3230916:1:2261:3513:12868,HFYGCDRX3230916:1:2164:4616:34945,HFYGCDRX3230916:1:2131:24062:18521,HFYGCDRX3230916:1:2254:16523:3208,HFYGCDRX3230916:1:2148:15881:3912,HFYGCDRX3230916:1:2157:2112:14544,HFYGCDRX3230916:1:2176:28348:25723,HFYGCDRX3230916:1:2240:15203:18991,HFYGCDRX3230916:1:2128:29279:34131,HFYGCDRX3230916:2:2235:4327:25520,HFYGCDRX3230916:1:2121:32560:29857,HFYGCDRX3230916:2:2169:28203:10316,HFYGCDRX3230916:2:2122:13810:21746,HFYGCDRX3230916:1:2123:6515:34225,HFYGCDRX3230916:2:2240:1190:34522,HFYGCDRX3230916:1:2159:18864:17159,HFYGCDRX3230916:1:2166:25048:23390,HFYGCDRX3230916:1:2217:17255:11741,HFYGCDRX3230916:1:2223:12481:1532,HFYGCDRX3230916:1:2109:24596:4163,HG5J5DRX3230915:1:2119:16188:25927,HFYGCDRX3230916:2:2121:3857:15060,HFYGCDRX3230916:1:2156:18276:11193,HFYGCDRX3230916:2:2271:27932:8093,HFYGCDRX3230916:1:2148:23249:7028,HFYGCDRX3230916:2:2103:18973:15593,HG5J5DRX3230915:1:2143:10013:15170,HFYGCDRX3230916:2:2101:18041:31798,HFYGCDRX3230916:1:2220:29686:22780,HFYGCDRX3230916:2:2254:1181:29277,HFYGCDRX3230916:1:2103:25554:20353,HFYGCDRX3230916:1:2111:29333:25426,HFYGCDRX3230916:2:2275:10999:4852,HG5J5DRX3230915:1:2262:18747:5087,HG5J5DRX3230915:1:2101:10809:33959,HFYGCDRX3230916:1:2156:4689:16908,HFYGCDRX3230916:1:2212:2727:9314,HG5J5DRX3230915:1:2252:13141:5713,HFYGCDRX3230916:1:2165:12228:4225,HFYGCDRX3230916:1:2158:3215:28385,HG5J5DRX3230915:1:2211:28908:9314,HFYGCDRX3230916:1:2103:21739:5509,HFYGCDRX3230916:1:2173:14172:16861,HFYGCDRX3230916:2:2162:20473:1313,HFYGCDRX3230916:2:2234:8730:36370,HG5J5DRX3230915:1:2240:3278:17910,HFYGCDRX3230916:1:2145:27841:18615,HFYGCDRX3230916:1:2256:23909:5134,HFYGCDRX3230916:1:2121:25337:19507,HFYGCDRX3230916:1:2210:3531:14090,HG5J5DRX3230915:1:2142:16550:34413,HFYGCDRX3230916:1:2126:28330:36182,HFYGCDRX3230916:2:2264:20256:2597,HFYGCDRX3230916:2:2236:27986:27633,HFYGCDRX3230916:2:2215:16441:21731,HFYGCDRX3230916:2:2224:19199:28134,HG5J5DRX3230915:1:2155:16975:2080,HFYGCDRX3230916:1:2123:27353:5212,HFYGCDRX3230916:1:2137:11035:20102,HG5J5DRX3230915:1:2157:2519:25300,HFYGCDRX3230916:1:2164:26277:9048,HFYGCDRX3230916:2:2139:9037:33145,HG5J5DRX3230915:1:2106:28601:17143,HFYGCDRX3230916:1:2141:2627:17660,HFYGCDRX3230916:1:2138:17264:29951,HFYGCDRX3230916:1:2175:11324:27743,HFYGCDRX3230916:1:2253:15555:12743,HFYGCDRX3230916:2:2138:9055:28792,HFYGCDRX3230916:2:2140:29080:24173,HFYGCDRX3230916:2:2143:26865:24377,HG5J5DRX3230915:1:2260:3504:36683,HFYGCDRX3230916:1:2174:26060:18411,HFYGCDRX3230916:1:2214:17861:6715,HG5J5DRX3230915:1:2275:4390:14481,HFYGCDRX3230916:2:2106:20030:9721,HFYGCDRX3230916:1:2211:31295:9846,HG5J5DRX3230915:1:2106:30517:31015,HFYGCDRX3230916:1:2106:14543:11365,HG5J5DRX3230915:1:2259:11930:35963,HFYGCDRX3230916:1:2152:23330:21230,HFYGCDRX3230916:2:2169:20763:35196,HFYGCDRX3230916:2:2178:3848:28792,HG5J5DRX3230915:1:2277:25437:8093,HFYGCDRX3230916:1:2245:29315:2910,HFYGCDRX3230916:1:2176:31602:1548,HFYGCDRX3230916:2:2159:25373:23484,HFYGCDRX3230916:2:2163:2275:13416,HFYGCDRX3230916:1:2128:31222:23249,HFYGCDRX3230916:1:2131:14226:35524,HFYGCDRX3230916:1:2227:5032:21104,HFYGCDRX3230916:1:2202:8576:31782,HFYGCDRX3230916:1:2102:19614:6433,HG5J5DRX3230915:1:2154:4698:27727,HFYGCDRX3230916:2:2266:21097:35775,HG5J5DRX3230915:1:2155:1199:18599,HFYGCDRX3230916:1:2245:22299:17534,HFYGCDRX3230916:1:2248:28176:22482,HFYGCDRX3230916:1:2214:10610:14325,HFYGCDRX3230916:2:2132:9236:24627,HFYGCDRX3230916:1:2213:23466:35744,HFYGCDRX3230916:1:2106:20690:1908,HFYGCDRX3230916:2:2110:9588:35697,HFYGCDRX3230916:2:2217:6605:30154,HFYGCDRX3230916:2:2122:29243:16845,HFYGCDRX3230916:2:2168:29261:31657,HFYGCDRX3230916:1:2122:7310:5541,HFYGCDRX3230916:1:2152:29035:20838,HFYGCDRX3230916:1:2154:11704:35415,HFYGCDRX3230916:1:2235:9760:32957,HFYGCDRX3230916:1:2155:19623:15311,HFYGCDRX3230916:1:2263:13973:10473,HFYGCDRX3230916:2:2115:15447:2065,HFYGCDRX3230916:2:2274:7600:26584,HFYGCDRX3230916:2:2170:24469:8672,HFYGCDRX3230916:1:2104:31675:11443,HFYGCDRX3230916:1:2157:5132:8343,HFYGCDRX3230916:2:2248:26196:3458,HFYGCDRX3230916:2:2143:27001:32722,HFYGCDRX3230916:2:2203:31259:4116,HFYGCDRX3230916:2:2131:32316:20134,HFYGCDRX3230916:2:2108:17164:2284,HFYGCDRX3230916:1:2112:29279:19820,HFYGCDRX3230916:1:2201:4770:33833,HFYGCDRX3230916:2:2232:7798:26303,HFYGCDRX3230916:2:2133:8956:15906,HFYGCDRX3230916:1:2251:12617:36620,HFYGCDRX3230916:1:2151:14244:7059,HFYGCDRX3230916:2:2167:23357:3396,HFYGCDRX3230916:2:2160:29197:9251,HFYGCDRX3230916:2:2165:6108:28009,HFYGCDRX3230916:2:2145:27787:13667,HFYGCDRX3230916:1:2245:27281:12978,HFYGCDRX3230916:1:2132:12572:19977,HFYGCDRX3230916:1:2212:30382:3317,HFYGCDRX3230916:1:2119:4065:24878,HFYGCDRX3230916:1:2106:29532:14278,HFYGCDRX3230916:1:2115:19596:1924,HFYGCDRX3230916:1:2135:3784:16219,HFYGCDRX3230916:1:2117:12861:9768,HFYGCDRX3230916:1:2134:29821:14967,HFYGCDRX3230916:2:2122:8567:9189,HFYGCDRX3230916:2:2170:13657:7889,HFYGCDRX3230916:1:2245:7988:36652,HFYGCDRX3230916:1:2271:16215:26819,HFYGCDRX3230916:2:2177:3568:2127,HFYGCDRX3230916:2:2265:11035:31062,HFYGCDRX3230916:1:2221:24668:3129,HFYGCDRX3230916:1:2145:11225:9627,HFYGCDRX3230916:2:2227:2935:28933,HFYGCDRX3230916:1:2102:6569:36166,HFYGCDRX3230916:1:2172:13946:9737,HFYGCDRX3230916:1:2151:12590:15217,HFYGCDRX3230916:2:2212:2202:2487,HFYGCDRX3230916:1:2176:1506:24361,HFYGCDRX3230916:2:2153:25138:4445,HFYGCDRX3230916:1:2109:10981:35039,HG5J5DRX3230915:1:2230:24026:5087,HFYGCDRX3230916:2:2143:30400:4225,HFYGCDRX3230916:2:2172:31367:13166,HFYGCDRX3230916:2:2176:29984:9455,HFYGCDRX3230916:2:2151:3848:17174,HFYGCDRX3230916:1:2227:5593:32127,HFYGCDRX3230916:2:2147:18747:21183,HFYGCDRX3230916:1:2275:27218:8641,HFYGCDRX3230916:1:2107:8404:2519,HFYGCDRX3230916:1:2106:30599:9142,HG5J5DRX3230915:1:2165:7175:17895,HFYGCDRX3230916:2:2105:30644:4648,HFYGCDRX3230916:2:2121:17381:10551,HFYGCDRX3230916:1:2118:4634:25207,HFYGCDRX3230916:1:2174:24939:1564,HFYGCDRX3230916:2:2139:21856:24251,HFYGCDRX3230916:1:2206:2609:12931,HFYGCDRX3230916:2:2138:1244:34178,HFYGCDRX3230916:2:2275:8612:24706,HFYGCDRX3230916:1:2169:6225:9111,HFYGCDRX3230916:1:2203:3296:33035,HFYGCDRX3230916:2:2168:17445:23844,HFYGCDRX3230916:1:2158:28465:1595,HG5J5DRX3230915:1:2236:4607:4085,HFYGCDRX3230916:2:2210:2835:22373,HG5J5DRX3230915:1:2142:18059:16141,HFYGCDRX3230916:2:2158:24560:13025,HG5J5DRX3230915:1:2258:19171:19225,HFYGCDRX3230916:2:2231:3477:4163,HFYGCDRX3230916:1:2227:25355:13244,HFYGCDRX3230916:2:2140:13223:12148,HFYGCDRX3230916:1:2244:14742:20917,HFYGCDRX3230916:1:2244:9281:10927,HFYGCDRX3230916:1:2134:27444:5024,HFYGCDRX3230916:1:2115:3106:1642,HFYGCDRX3230916:1:2136:22652:25848,HG5J5DRX3230915:1:2113:27733:32268,HFYGCDRX3230916:2:2260:32307:13103,HFYGCDRX3230916:1:2215:26196:27978,HFYGCDRX3230916:2:2235:2419:27602,HG5J5DRX3230915:1:2260:14624:28980,HFYGCDRX3230916:1:2238:15049:26772,HFYGCDRX3230916:2:2106:4698:35775,HG5J5DRX3230915:1:2107:21269:36229,HFYGCDRX3230916:1:2108:23637:5353,HFYGCDRX3230916:1:2221:9552:22169,HFYGCDRX3230916:1:2157:28447:21856,HFYGCDRX3230916:2:2257:20256:36104,HFYGCDRX3230916:1:2156:19958:7498,HFYGCDRX3230916:2:2123:18285:4038,HFYGCDRX3230916:1:2228:28673:9878,HG5J5DRX3230915:1:2148:22634:26882,HFYGCDRX3230916:2:2135:30156:4586,HFYGCDRX3230916:1:2131:30083:31454,HFYGCDRX3230916:1:2234:19262:27618,HG5J5DRX3230915:1:2167:31213:30686,HFYGCDRX3230916:1:2271:21197:20165,HFYGCDRX3230916:2:2216:6479:20447,HFYGCDRX3230916:1:2246:1118:2895,HFYGCDRX3230916:1:2272:2257:20369,HFYGCDRX3230916:2:2121:30129:20196,HFYGCDRX3230916:1:2271:20654:5572,HFYGCDRX3230916:2:2243:4869:26209,HFYGCDRX3230916:1:2156:5692:15295,HFYGCDRX3230916:2:2207:22987:6198,HFYGCDRX3230916:2:2203:4978:9862,HFYGCDRX3230916:2:2144:3179:17957,HFYGCDRX3230916:2:2131:6623:15248,HFYGCDRX3230916:2:2145:1895:23187,HG5J5DRX3230915:1:2133:11650:20979,HFYGCDRX3230916:1:2208:26069:36182,HFYGCDRX3230916:2:2236:4155:21120,HFYGCDRX3230916:2:2217:25798:10410,HFYGCDRX3230916:1:2201:8079:30545,HFYGCDRX3230916:2:2225:11062:29637,HFYGCDRX3230916:1:2169:6985:3724,HFYGCDRX3230916:2:2104:32036:2926,HFYGCDRX3230916:2:2219:19388:8672,HFYGCDRX3230916:1:2210:30743:32158,HG5J5DRX3230915:1:2155:17409:24095,HFYGCDRX3230916:1:2106:8865:12461,HFYGCDRX3230916:1:2167:7057:25551,HFYGCDRX3230916:1:2210:30147:26835,HG5J5DRX3230915:1:2174:28474:3583,HFYGCDRX3230916:1:2102:20392:5055,HFYGCDRX3230916:1:2261:29324:36182,HFYGCDRX3230916:1:2174:11858:14481,HFYGCDRX3230916:1:2238:17291:6324,HFYGCDRX3230916:1:2114:30843:12978,HFYGCDRX3230916:1:2236:27308:35446,HFYGCDRX3230916:2:2251:6912:9142,HFYGCDRX3230916:2:2223:15112:31234,HFYGCDRX3230916:2:2247:29261:15405,HFYGCDRX3230916:1:2176:32163:12915,HFYGCDRX3230916:2:2203:28890:19304,HFYGCDRX3230916:1:2116:21766:16235,HG5J5DRX3230915:1:2265:32163:12195,HFYGCDRX3230916:1:2123:10059:28338,HFYGCDRX3230916:1:2153:10538:29324,HFYGCDRX3230916:1:2234:16504:31078,HFYGCDRX3230916:1:2273:14995:5760,HFYGCDRX3230916:1:2120:28510:4993,HG5J5DRX3230915:1:2160:12798:14231,HFYGCDRX3230916:2:2223:21721:17942,HG5J5DRX3230915:1:2156:10827:17801,HFYGCDRX3230916:2:2246:7690:13714,HFYGCDRX3230916:2:2171:30147:24079,HFYGCDRX3230916:1:2209:31982:31767,HFYGCDRX3230916:2:2235:4146:22200,HFYGCDRX3230916:2:2245:1868:17816,HFYGCDRX3230916:1:2239:18909:16705,HFYGCDRX3230916:2:2230:7844:36620,HFYGCDRX3230916:2:2273:16631:21277,HFYGCDRX3230916:1:2155:10022:11334,HFYGCDRX3230916:1:2207:21395:36354,HFYGCDRX3230916:2:2108:28763:35180,HFYGCDRX3230916:2:2231:7808:6308,HFYGCDRX3230916:2:2263:3956:17300,HFYGCDRX3230916:2:2265:29848:1454,HFYGCDRX3230916:1:2174:14145:33912,HFYGCDRX3230916:2:2146:10384:33379,HFYGCDRX3230916:1:2239:3613:14606,HFYGCDRX3230916:1:2230:6786:33661,HFYGCDRX3230916:1:2204:18692:22654,HFYGCDRX3230916:1:2138:13602:11459,HFYGCDRX3230916:1:2105:26784:32127,HFYGCDRX3230916:2:2150:29984:3411,HFYGCDRX3230916:1:2169:27724:8328,HFYGCDRX3230916:2:2120:22788:16783,HFYGCDRX3230916:1:2267:10610:13949,HFYGCDRX3230916:1:2115:28881:23046,HFYGCDRX3230916:1:2225:8748:3176,HFYGCDRX3230916:1:2108:4336:22373,HG5J5DRX3230915:1:2115:6858:6762,HFYGCDRX3230916:1:2150:15619:34209,HFYGCDRX3230916:2:2202:6741:28072,HG5J5DRX3230915:1:2206:14778:18035,HFYGCDRX3230916:1:2137:24894:32142,HFYGCDRX3230916:1:2144:22299:3912,HFYGCDRX3230916:2:2247:16884:9126,HFYGCDRX3230916:1:2110:27995:29246,HFYGCDRX3230916:1:2149:7075:18787,HFYGCDRX3230916:2:2120:2356:29403,HFYGCDRX3230916:2:2259:13621:9518,HFYGCDRX3230916:1:2140:9362:11569,HFYGCDRX3230916:2:2220:12509:35744,HFYGCDRX3230916:1:2164:15817:17769,HFYGCDRX3230916:1:2159:13910:21981,HFYGCDRX3230916:2:2134:8422:17080,HFYGCDRX3230916:1:2150:21676:9972,HFYGCDRX3230916:1:2225:23918:33520,HFYGCDRX3230916:1:2144:30183:34788,HFYGCDRX3230916:2:2265:30563:1251,HFYGCDRX3230916:1:2153:8513:18865,HFYGCDRX3230916:1:2102:20690:18035,HG5J5DRX3230915:1:2259:14968:3646,HFYGCDRX3230916:1:2251:2808:21386,HFYGCDRX3230916:1:2278:21775:9079,HG5J5DRX3230915:1:2138:23466:17362,HFYGCDRX3230916:1:2112:11885:8015,HFYGCDRX3230916:1:2248:22715:31156,HFYGCDRX3230916:2:2107:14588:29136,HFYGCDRX3230916:2:2105:11550:17425,HFYGCDRX3230916:1:2105:11975:12524,HFYGCDRX3230916:1:2232:2275:30765,HFYGCDRX3230916:1:2104:23836:28651,HFYGCDRX3230916:2:2235:10782:19288,HFYGCDRX3230916:1:2165:14651:28808,HFYGCDRX3230916:1:2265:20745:1157,HFYGCDRX3230916:2:2229:3766:25958,HFYGCDRX3230916:1:2112:9417:10661,HFYGCDRX3230916:2:2131:7021:31657,HFYGCDRX3230916:1:2126:25599:8531,HG5J5DRX3230915:1:2138:22887:23719,HFYGCDRX3230916:2:2140:23249:18709,HFYGCDRX3230916:2:2209:17698:5869,HFYGCDRX3230916:2:2221:13078:26303,HG5J5DRX3230915:1:2167:3748:16094,HFYGCDRX3230916:1:2178:13648:25441,HG5J5DRX3230915:1:2258:18023:1767,HFYGCDRX3230916:1:2217:26738:9408,HFYGCDRX3230916:1:2219:25726:24721,HFYGCDRX3230916:1:2108:7853:9737,HG5J5DRX3230915:1:2158:9688:12132,HFYGCDRX3230916:2:2103:25238:1485,HFYGCDRX3230916:2:2262:11360:22138,HG5J5DRX3230915:1:2171:27001:18474,HG5J5DRX3230915:1:2233:22272:3552,HFYGCDRX3230916:1:2149:25491:9972,HFYGCDRX3230916:1:2171:18936:11209,HFYGCDRX3230916:1:2237:7862:26475,HFYGCDRX3230916:1:2202:20618:8578,HFYGCDRX3230916:2:2214:32054:17769,HFYGCDRX3230916:1:2215:7310:28181,HFYGCDRX3230916:1:2117:32226:10520,HFYGCDRX3230916:1:2220:9670:31203,HFYGCDRX3230916:1:2126:16640:3349,HG5J5DRX3230915:1:2242:28375:17628,HFYGCDRX3230916:2:2203:4860:4679,HFYGCDRX3230916:2:2247:31313:1579,HFYGCDRX3230916:1:2246:1118:18239,HFYGCDRX3230916:1:2228:6967:18724,HG5J5DRX3230915:1:2276:32588:1689,HFYGCDRX3230916:2:2156:3495:20666,HFYGCDRX3230916:2:2255:23882:33238,HFYGCDRX3230916:1:2230:24270:11898,HFYGCDRX3230916:1:2240:25111:14920,HFYGCDRX3230916:2:2278:23430:28166,HG5J5DRX3230915:1:2154:21151:5682,HFYGCDRX3230916:1:2238:6307:15013,HFYGCDRX3230916:2:2160:27597:19820,HG5J5DRX3230915:1:2243:4562:10614,HFYGCDRX3230916:2:2177:26603:35133,HFYGCDRX3230916:1:2176:24225:4648,HFYGCDRX3230916:2:2161:9968:15624,HFYGCDRX3230916:1:2134:10140:28354,HFYGCDRX3230916:2:2262:28320:14779,HFYGCDRX3230916:1:2108:15745:35931,HFYGCDRX3230916:1:2145:24994:6543,HFYGCDRX3230916:1:2113:15393:8390,HFYGCDRX3230916:1:2108:23692:6449,HFYGCDRX3230916:1:2120:19822:34068,HFYGCDRX3230916:1:2156:16333:10833,HFYGCDRX3230916:2:2108:20717:3239,HFYGCDRX3230916:2:2123:18539:16376,HFYGCDRX3230916:2:2166:25518:26209,HG5J5DRX3230915:1:2109:25265:14967,HFYGCDRX3230916:1:2175:23827:9408,HFYGCDRX3230916:2:2248:24650:13620,HFYGCDRX3230916:2:2161:22471:17707,HFYGCDRX3230916:1:2139:7880:24439,HFYGCDRX3230916:1:2221:2121:20603,HFYGCDRX3230916:1:2255:1497:34710,HFYGCDRX3230916:1:2221:3685:23312,HFYGCDRX3230916:1:2162:29134:34507,HFYGCDRX3230916:2:2107:10972:26318,HFYGCDRX3230916:1:2252:12292:18333,HFYGCDRX3230916:2:2130:24071:3630,HG5J5DRX3230915:1:2173:19777:27445,HFYGCDRX3230916:2:2158:25943:35869,HFYGCDRX3230916:1:2133:3504:10661,HG5J5DRX3230915:1:2155:5394:23860,HFYGCDRX3230916:1:2215:21721:32409,HFYGCDRX3230916:1:2177:6488:15984,HFYGCDRX3230916:1:2157:4752:23062,HFYGCDRX3230916:1:2165:28528:4178,HFYGCDRX3230916:1:2248:20627:30295,HFYGCDRX3230916:2:2128:27832:7482,HG5J5DRX3230915:1:2264:1380:34601,HFYGCDRX3230916:2:2246:22589:19194,HFYGCDRX3230916:2:2114:20916:25473,HG5J5DRX3230915:1:2158:7699:8563,HFYGCDRX3230916:1:2145:11478:4742,HFYGCDRX3230916:1:2203:8260:3677,HFYGCDRX3230916:2:2265:17065:1391,HG5J5DRX3230915:1:2269:26982:35603,HFYGCDRX3230916:2:2137:13169:14779,HFYGCDRX3230916:1:2266:6352:33599,HFYGCDRX3230916:2:2240:13684:29387,HFYGCDRX3230916:2:2168:30002:28494,HFYGCDRX3230916:1:2276:28926:10504,HFYGCDRX3230916:1:2157:25590:12148,HFYGCDRX3230916:2:2239:9236:3803,HFYGCDRX3230916:1:2156:22489:35274,HFYGCDRX3230916:1:2149:19235:35117,HG5J5DRX3230915:1:2267:12970:25332,HFYGCDRX3230916:2:2225:25907:34240,HFYGCDRX3230916:1:2205:15899:3912,HFYGCDRX3230916:1:2265:5882:18129,HFYGCDRX3230916:1:2141:14904:2754,HFYGCDRX3230916:2:2214:11008:3959,HG5J5DRX3230915:1:2276:19678:2159,HFYGCDRX3230916:1:2241:8486:17284,HFYGCDRX3230916:1:2234:31828:11052,HFYGCDRX3230916:1:2131:17616:6762,HFYGCDRX3230916:2:2262:4707:16376,HFYGCDRX3230916:1:2135:12753:28181,HFYGCDRX3230916:1:2155:27742:8641,HFYGCDRX3230916:2:2120:32606:4539,HFYGCDRX3230916:1:2109:4227:9377,HG5J5DRX3230915:1:2257:9507:17049,HFYGCDRX3230916:2:2217:25473:16141,HFYGCDRX3230916:1:2151:13874:24142,HG5J5DRX3230915:1:2228:8766:18239,HFYGCDRX3230916:1:2153:1859:16203,HFYGCDRX3230916:2:2243:31349:16517,HFYGCDRX3230916:1:2110:18322:21418,HFYGCDRX3230916:2:2146:32588:8516,HFYGCDRX3230916:2:2174:23891:31751,HFYGCDRX3230916:2:2177:28971:12430,HFYGCDRX3230916:2:2175:12861:6605,HFYGCDRX3230916:2:2168:16007:36417,HFYGCDRX3230916:2:2208:8531:15515,HFYGCDRX3230916:2:2269:8368:5400,HFYGCDRX3230916:1:2230:10059:4038,HFYGCDRX3230916:2:2206:18620:33739,HFYGCDRX3230916:1:2172:17833:30248,HFYGCDRX3230916:1:2159:7473:8390,HG5J5DRX3230915:1:2211:27073:12680,HG5J5DRX3230915:1:2159:15221:4429,HFYGCDRX3230916:2:2103:32235:22373,HFYGCDRX3230916:2:2109:12997:16955,HFYGCDRX3230916:2:2163:3504:33865,HFYGCDRX3230916:1:2263:15284:31939,HFYGCDRX3230916:1:2213:12970:14152,HFYGCDRX3230916:1:2216:23565:14873,HFYGCDRX3230916:1:2274:17842:34554,HG5J5DRX3230915:1:2247:17056:2440,HFYGCDRX3230916:2:2118:5773:4131,HFYGCDRX3230916:1:2264:11975:7420,HFYGCDRX3230916:1:2230:26865:22811,HFYGCDRX3230916:1:2258:30337:7936,HFYGCDRX3230916:2:2148:19479:9298,HFYGCDRX3230916:2:2154:3622:16501,HFYGCDRX3230916:2:2156:9317:33442,HFYGCDRX3230916:1:2221:21748:2300,HFYGCDRX3230916:1:2148:5936:27555,HFYGCDRX3230916:1:2262:22851:20525,HFYGCDRX3230916:1:2264:4390:7717,HFYGCDRX3230916:1:2217:7817:31250,HFYGCDRX3230916:2:2121:19443:1125,HFYGCDRX3230916:1:2115:28158:29027,HFYGCDRX3230916:1:2262:15257:17143,HFYGCDRX3230916:1:2124:20048:22310,HFYGCDRX3230916:2:2163:12093:23249,HFYGCDRX3230916:1:2130:25943:18302,HFYGCDRX3230916:2:2167:22182:17331,HFYGCDRX3230916:2:2142:8630:21731,HG5J5DRX3230915:1:2259:12255:22467,HFYGCDRX3230916:1:2145:16541:6997,HFYGCDRX3230916:1:2118:31087:5071,HFYGCDRX3230916:1:2250:29026:9424,HFYGCDRX3230916:1:2170:1615:15499,HFYGCDRX3230916:2:2277:25265:29622,HFYGCDRX3230916:1:2107:20808:36338,HFYGCDRX3230916:1:2138:27335:20400,HFYGCDRX3230916:1:2150:10863:14418,HFYGCDRX3230916:1:2143:7346:36072,HFYGCDRX3230916:1:2229:21947:36526,HFYGCDRX3230916:2:2162:2989:20666,HFYGCDRX3230916:2:2263:23583:22451,HFYGCDRX3230916:1:2113:24804:6057,HFYGCDRX3230916:1:2230:8585:23124,HFYGCDRX3230916:1:2244:15763:31485,HFYGCDRX3230916:2:2167:24903:21950,HFYGCDRX3230916:2:2124:13557:5212,HFYGCDRX3230916:2:2166:10357:20744,HFYGCDRX3230916:1:2162:10881:29543,HFYGCDRX3230916:2:2154:27389:15796,HFYGCDRX3230916:2:2269:8621:7936,HFYGCDRX3230916:1:2169:11867:24048,HFYGCDRX3230916:1:2270:25717:1376,HFYGCDRX3230916:1:2172:4824:17895,HFYGCDRX3230916:1:2164:19081:5321,HFYGCDRX3230916:2:2276:13060:13933,HFYGCDRX3230916:1:2217:4092:27367,HFYGCDRX3230916:1:2245:24071:17503,HFYGCDRX3230916:2:2258:3079:11115,HFYGCDRX3230916:1:2252:7274:25864,HFYGCDRX3230916:2:2163:25437:31203,HFYGCDRX3230916:1:2155:15456:33614,HG5J5DRX3230915:1:2115:1515:30107,HFYGCDRX3230916:1:2113:23357:3145,HFYGCDRX3230916:1:2235:21640:11099,HFYGCDRX3230916:2:2150:18114:8970,HFYGCDRX3230916:1:2129:6162:10379,HFYGCDRX3230916:2:2123:20754:25535,HFYGCDRX3230916:1:2129:1289:26052,HG5J5DRX3230915:1:2265:20112:31093,HFYGCDRX3230916:2:2257:11442:22279,HFYGCDRX3230916:1:2142:22643:37012,HFYGCDRX3230916:2:2227:8675:10160,HG5J5DRX3230915:1:2235:11451:27931,HG5J5DRX3230915:1:2108:17192:26130,HFYGCDRX3230916:2:2227:17092:31344,HFYGCDRX3230916:2:2166:5701:12023,HFYGCDRX3230916:2:2128:26359:20525,HFYGCDRX3230916:1:2243:6361:11819,HFYGCDRX3230916:2:2153:3323:20181,HFYGCDRX3230916:1:2234:29875:23766,HFYGCDRX3230916:2:2178:9516:33818,HFYGCDRX3230916:1:2266:12970:16157,HFYGCDRX3230916:1:2245:2284:3129,HG5J5DRX3230915:1:2124:3106:16924,HFYGCDRX3230916:1:2109:1687:31344,HFYGCDRX3230916:2:2126:24813:20854,HFYGCDRX3230916:2:2123:19705:1360,HFYGCDRX3230916:2:2229:9986:30530,HFYGCDRX3230916:1:2144:8477:15796,HFYGCDRX3230916:1:2119:4399:33567,HFYGCDRX3230916:1:2235:16071:27101,HFYGCDRX3230916:1:2238:14995:26616,HFYGCDRX3230916:1:2164:22679:26021,HFYGCDRX3230916:2:2151:27751:28729,HFYGCDRX3230916:2:2275:26747:34851,HFYGCDRX3230916:2:2110:25626:21324,HFYGCDRX3230916:2:2208:10827:30796,HFYGCDRX3230916:1:2223:7509:12524,HFYGCDRX3230916:1:2258:9751:31438,HFYGCDRX3230916:2:2243:12075:5400,HFYGCDRX3230916:1:2237:30761:15123,HFYGCDRX3230916:2:2263:23502:30013,HFYGCDRX3230916:1:2170:15564:13197,HFYGCDRX3230916:1:2144:31385:1736,HFYGCDRX3230916:1:2246:25355:4914,HG5J5DRX3230915:1:2215:19533:35477,HFYGCDRX3230916:1:2278:13078:28432,HG5J5DRX3230915:1:2277:7428:3302,HFYGCDRX3230916:1:2140:2437:32299,HFYGCDRX3230916:2:2272:15546:15295,HFYGCDRX3230916:2:2264:21983:22686,HFYGCDRX3230916:1:2247:4083:8124,HFYGCDRX3230916:2:2137:3143:21245,HG5J5DRX3230915:1:2243:14100:5807,HFYGCDRX3230916:1:2232:19777:21652,HFYGCDRX3230916:2:2277:8160:14027,HFYGCDRX3230916:1:2147:14714:11036,HFYGCDRX3230916:2:2253:24985:25598,HFYGCDRX3230916:1:2149:20618:28808,HFYGCDRX3230916:1:2124:2383:4805,HFYGCDRX3230916:1:2244:4200:10614,HFYGCDRX3230916:1:2204:5050:13902,HFYGCDRX3230916:1:2108:16134:18411,HFYGCDRX3230916:2:2217:1787:35149,HFYGCDRX3230916:1:2231:18575:25708,HG5J5DRX3230915:1:2242:27606:30639,HFYGCDRX3230916:1:2157:5782:32706,HG5J5DRX3230915:1:2277:2446:15687,HG5J5DRX3230915:1:2208:26060:8390,HFYGCDRX3230916:1:2226:30337:21527,HFYGCDRX3230916:1:2209:2510:28573,HFYGCDRX3230916:1:2239:11171:26725,HFYGCDRX3230916:2:2212:13196:22780,HFYGCDRX3230916:1:2208:13991:2738,HFYGCDRX3230916:2:2269:32660:20697,HFYGCDRX3230916:1:2117:29161:29042,HFYGCDRX3230916:1:2158:27010:23093,HFYGCDRX3230916:1:2134:17264:16329,HFYGCDRX3230916:1:2138:29794:23750,HFYGCDRX3230916:1:2265:13196:28103,HFYGCDRX3230916:2:2172:27371:16203,HG5J5DRX3230915:1:2172:10194:14575,HFYGCDRX3230916:1:2121:25979:10128,HFYGCDRX3230916:1:2122:20139:17206,HFYGCDRX3230916:2:2252:30400:8672,HFYGCDRX3230916:2:2168:10682:35837,HFYGCDRX3230916:2:2219:18041:26256,HFYGCDRX3230916:1:2238:24180:5290,HFYGCDRX3230916:1:2157:11858:33833,HFYGCDRX3230916:2:2169:5620:33833,HG5J5DRX3230915:1:2171:16251:25692,HFYGCDRX3230916:2:2101:15600:6277,HFYGCDRX3230916:1:2146:14615:4100,HFYGCDRX3230916:1:2114:18195:20823,HFYGCDRX3230916:1:2146:17969:18615,HFYGCDRX3230916:2:2113:3432:23688,HFYGCDRX3230916:1:2229:18747:20932,HFYGCDRX3230916:1:2141:17571:17174,HFYGCDRX3230916:2:2266:19723:13479,HFYGCDRX3230916:1:2121:25798:3364,HFYGCDRX3230916:2:2244:30689:3975,HFYGCDRX3230916:2:2272:8332:27696,HFYGCDRX3230916:1:2202:23665:18020,HFYGCDRX3230916:1:2244:27425:35931,HFYGCDRX3230916:1:2154:15655:33708,HFYGCDRX3230916:1:2217:20600:10050,HFYGCDRX3230916:1:2176:16161:4617,HFYGCDRX3230916:1:2140:16215:2707,HFYGCDRX3230916:1:2144:9408:15906,HFYGCDRX3230916:2:2129:11243:15796,HG5J5DRX3230915:1:2266:6976:33708,HFYGCDRX3230916:1:2157:31765:20932,HFYGCDRX3230916:1:2256:2663:26866,HFYGCDRX3230916:2:2177:11623:30170,HFYGCDRX3230916:2:2130:32353:29872,HFYGCDRX3230916:1:2112:17960:28213,HFYGCDRX3230916:2:2252:14407:5243,HFYGCDRX3230916:1:2161:32072:9659,HFYGCDRX3230916:1:2261:13024:19225,HFYGCDRX3230916:1:2103:32904:15233,HFYGCDRX3230916:1:2207:14760:23985,HG5J5DRX3230915:1:2267:23457:4445,HFYGCDRX3230916:1:2148:20121:29356,HFYGCDRX3230916:2:2216:4453:20071,HFYGCDRX3230916:1:2168:7943:32847,HFYGCDRX3230916:1:2148:19190:12493,HFYGCDRX3230916:1:2132:13141:2519,HG5J5DRX3230915:1:2118:1172:19053,HG5J5DRX3230915:1:2109:16514:22921,HFYGCDRX3230916:2:2241:27968:27978,HFYGCDRX3230916:1:2227:21956:6449,HFYGCDRX3230916:2:2150:25961:13604,HFYGCDRX3230916:1:2126:15854:8563,HG5J5DRX3230915:1:2154:19416:4210,HFYGCDRX3230916:1:2227:26214:25379,HFYGCDRX3230916:2:2118:21314:14982,HFYGCDRX3230916:2:2138:16821:19163,HFYGCDRX3230916:2:2225:1398:14841,HFYGCDRX3230916:1:2213:5801:34992,HFYGCDRX3230916:2:2177:24062:10128,HFYGCDRX3230916:1:2270:5186:5431,HFYGCDRX3230916:1:2215:17020:36918,HFYGCDRX3230916:2:2251:13349:26240,HFYGCDRX3230916:1:2105:16360:21684,HFYGCDRX3230916:2:2169:15953:3662,HFYGCDRX3230916:1:2137:22905:26976,HFYGCDRX3230916:1:2160:24840:18176,HFYGCDRX3230916:2:2260:29179:26944,HG5J5DRX3230915:1:2244:18584:8782,HFYGCDRX3230916:1:2166:10936:34428,HFYGCDRX3230916:2:2123:18240:1736,HG5J5DRX3230915:1:2223:26313:6261,HFYGCDRX3230916:1:2159:3848:2143,HFYGCDRX3230916:1:2148:14733:17174,HFYGCDRX3230916:1:2218:29505:11663,HFYGCDRX3230916:1:2233:11794:15499,HFYGCDRX3230916:2:2147:25238:5682,HFYGCDRX3230916:1:2162:17644:35243,HFYGCDRX3230916:1:2202:32560:35117,HG5J5DRX3230915:1:2153:5195:4038,HFYGCDRX3230916:2:2208:1551:3740,HFYGCDRX3230916:2:2135:18267:11177,HFYGCDRX3230916:1:2259:17960:29528,HFYGCDRX3230916:2:2220:17879:36119,HG5J5DRX3230915:1:2120:12970:16877,HFYGCDRX3230916:1:2234:26874:16814,HFYGCDRX3230916:1:2230:29270:31516,HFYGCDRX3230916:2:2110:16938:7811,HFYGCDRX3230916:2:2131:26024:7670,HFYGCDRX3230916:1:2148:20311:4664,HFYGCDRX3230916:2:2161:22950:25081,HFYGCDRX3230916:1:2150:18846:19946,HFYGCDRX3230916:1:2112:3197:36495,HFYGCDRX3230916:1:2255:20600:7983,HFYGCDRX3230916:2:2145:23927:19570,HFYGCDRX3230916:2:2153:13123:36683,HFYGCDRX3230916:2:2132:2835:30921,HFYGCDRX3230916:1:2134:9118:2284,HFYGCDRX3230916:1:2203:5195:19038,HFYGCDRX3230916:1:2204:14877:36839,HFYGCDRX3230916:2:2249:9824:11772,HFYGCDRX3230916:2:2105:6008:9361,HG5J5DRX3230915:1:2249:16080:5102,HFYGCDRX3230916:1:2231:23213:23375,HFYGCDRX3230916:1:2147:4634:1658,HFYGCDRX3230916:1:2216:3649:5869,HFYGCDRX3230916:1:2158:30165:27242,HFYGCDRX3230916:2:2217:20039:32002,HG5J5DRX3230915:1:2148:22498:20353,HFYGCDRX3230916:1:2141:21983:36307,HFYGCDRX3230916:1:2213:3115:6668,HFYGCDRX3230916:2:2125:5801:4304,HFYGCDRX3230916:1:2108:24026:8437,HFYGCDRX3230916:2:2228:20103:25786,HFYGCDRX3230916:2:2137:8232:27962,HFYGCDRX3230916:1:2123:24379:19351,HFYGCDRX3230916:2:2247:9471:20619,HFYGCDRX3230916:1:2248:9607:2159,HG5J5DRX3230915:1:2142:25382:3991,HFYGCDRX3230916:2:2272:14769:5682,HFYGCDRX3230916:1:2270:23845:34397,HG5J5DRX3230915:1:2159:21350:28447,HFYGCDRX3230916:1:2146:32325:10598,HG5J5DRX3230915:1:2250:18918:29528,HFYGCDRX3230916:2:2105:9037:22122,HFYGCDRX3230916:2:2125:23791:26412,HFYGCDRX3230916:1:2106:16577:28416,HFYGCDRX3230916:1:2122:25482:33692,HFYGCDRX3230916:1:2245:2103:6355,HFYGCDRX3230916:1:2257:14895:6057,HFYGCDRX3230916:1:2248:4490:31062,HFYGCDRX3230916:2:2238:14416:31281,HFYGCDRX3230916:2:2202:8504:36980,HFYGCDRX3230916:1:2147:26205:5228,HFYGCDRX3230916:2:2111:13304:25222,HG5J5DRX3230915:1:2114:13856:16689,HFYGCDRX3230916:1:2203:28284:19852,HFYGCDRX3230916:2:2266:8449:8390,HFYGCDRX3230916:1:2169:6723:22811,HFYGCDRX3230916:1:2105:17201:23328,HFYGCDRX3230916:2:2259:24080:23030,HFYGCDRX3230916:2:2109:2239:34741,HFYGCDRX3230916:1:2157:5222:30671,HFYGCDRX3230916:1:2114:21070:11303,HFYGCDRX3230916:1:2136:4499:11099,HFYGCDRX3230916:1:2274:18331:27508,HFYGCDRX3230916:1:2124:20998:36793,HFYGCDRX3230916:2:2128:26286:17675,HFYGCDRX3230916:1:2158:29767:34162,HFYGCDRX3230916:1:2271:15501:31751,HFYGCDRX3230916:1:2203:12698:21605,HFYGCDRX3230916:1:2158:4860:28416,HFYGCDRX3230916:1:2117:25681:18787,HFYGCDRX3230916:1:2210:18530:35336,HFYGCDRX3230916:1:2115:17056:7952,HFYGCDRX3230916:1:2168:8947:20494,HFYGCDRX3230916:2:2146:6433:33019,HFYGCDRX3230916:2:2168:15835:7811,HFYGCDRX3230916:2:2265:9941:8625,HFYGCDRX3230916:2:2134:10185:1282,HFYGCDRX3230916:2:2150:18078:29763,HFYGCDRX3230916:1:2272:10113:30592,HFYGCDRX3230916:1:2248:17192:9314,HFYGCDRX3230916:2:2103:30101:20275,HFYGCDRX3230916:1:2212:2700:29747,HG5J5DRX3230915:1:2155:8305:11929,HFYGCDRX3230916:1:2209:31521:24017,HFYGCDRX3230916:1:2237:20916:9283,HFYGCDRX3230916:2:2277:1967:5337,HG5J5DRX3230915:1:2137:2908:14325,HFYGCDRX3230916:2:2272:24487:5635,HFYGCDRX3230916:2:2124:29514:3944,HFYGCDRX3230916:2:2270:13051:16235,HFYGCDRX3230916:2:2220:3821:33098,HFYGCDRX3230916:1:2121:17327:4382,HFYGCDRX3230916:2:2273:29116:22545,HFYGCDRX3230916:2:2275:12174:16501,HFYGCDRX3230916:1:2139:25165:4085,HFYGCDRX3230916:2:2117:22733:35133,HFYGCDRX3230916:1:2148:29903:14857,HG5J5DRX3230915:1:2108:15130:20337,HFYGCDRX3230916:1:2249:32624:1157,HFYGCDRX3230916:1:2237:5159:28714,HFYGCDRX3230916:1:2103:30020:35916,HFYGCDRX3230916:2:2119:28772:24799,HFYGCDRX3230916:1:2256:11912:24251,HFYGCDRX3230916:2:2172:19524:36714,HFYGCDRX3230916:2:2237:8070:27492,HFYGCDRX3230916:2:2223:18412:34006,HFYGCDRX3230916:2:2147:7048:14920,HFYGCDRX3230916:1:2109:11017:20854,HFYGCDRX3230916:2:2215:25726:14418,HFYGCDRX3230916:1:2175:13051:26694,HFYGCDRX3230916:1:2206:30915:36839,HFYGCDRX3230916:1:2161:9995:11631,HFYGCDRX3230916:1:2165:27606:26882,HFYGCDRX3230916:2:2168:30273:13088,HFYGCDRX3230916:1:2142:3694:25582,HG5J5DRX3230915:1:2123:9923:8155,HFYGCDRX3230916:1:2222:21197:15937,HFYGCDRX3230916:1:2263:17445:35618,HFYGCDRX3230916:2:2169:9390:32972,HFYGCDRX3230916:2:2163:17110:7451,HFYGCDRX3230916:1:2129:2528:36276,HFYGCDRX3230916:2:2137:11894:3615,HFYGCDRX3230916:1:2104:4435:12743,HFYGCDRX3230916:1:2208:15194:7294,HFYGCDRX3230916:2:2254:27281:12320,HFYGCDRX3230916:1:2124:6126:10003,HFYGCDRX3230916:1:2253:26775:12821,HG5J5DRX3230915:1:2240:31684:19852,HG5J5DRX3230915:1:2138:15971:15280,HFYGCDRX3230916:1:2110:4725:1313,HG5J5DRX3230915:1:2102:23194:6621,HFYGCDRX3230916:2:2131:12572:23735,HFYGCDRX3230916:2:2242:24162:2190,HFYGCDRX3230916:1:2222:16957:36182,HFYGCDRX3230916:1:2273:18665:4507,HFYGCDRX3230916:2:2264:9326:8249,HFYGCDRX3230916:1:2168:32380:27946,HFYGCDRX3230916:1:2134:14253:15186,HFYGCDRX3230916:2:2268:32217:25942,HFYGCDRX3230916:1:2242:18186:7811,HFYGCDRX3230916:2:2166:11514:35336,HFYGCDRX3230916:2:2249:10303:33833,HFYGCDRX3230916:1:2108:13187:13150,HFYGCDRX3230916:1:2243:28474:12101,HG5J5DRX3230915:1:2154:19352:3975,HFYGCDRX3230916:1:2108:22516:7513,HFYGCDRX3230916:1:2150:25292:8343,HFYGCDRX3230916:1:2216:23637:18912,HFYGCDRX3230916:1:2241:31105:11334,HG5J5DRX3230915:1:2226:10013:3145,HFYGCDRX3230916:1:2228:7708:15060,HFYGCDRX3230916:2:2276:25536:18756,HFYGCDRX3230916:2:2169:4227:26944,HFYGCDRX3230916:2:2107:18584:35180,HFYGCDRX3230916:1:2154:31783:8876,HFYGCDRX3230916:2:2244:10881:36088,HFYGCDRX3230916:1:2258:31177:9799,HFYGCDRX3230916:2:2107:5376:16438,HFYGCDRX3230916:1:2151:3730:17816,HG5J5DRX3230915:1:2252:22019:11945,HFYGCDRX3230916:2:2214:20808:6370,HFYGCDRX3230916:1:2160:31006:4116,HFYGCDRX3230916:1:2174:26386:8422,HFYGCDRX3230916:1:2223:4218:33505,HG5J5DRX3230915:1:2126:6632:35023,HG5J5DRX3230915:1:2251:9173:27054,HFYGCDRX3230916:2:2252:31322:26616,HFYGCDRX3230916:1:2102:11406:26443,HFYGCDRX3230916:1:2102:21133:35086,HFYGCDRX3230916:1:2252:29857:32910,HG5J5DRX3230915:1:2121:3016:28980,HFYGCDRX3230916:1:2214:7301:3239,HFYGCDRX3230916:1:2127:30355:37059,HFYGCDRX3230916:1:2122:26775:33426,HG5J5DRX3230915:1:2164:5159:34444,HFYGCDRX3230916:1:2212:28339:20353,HFYGCDRX3230916:2:2257:25825:16125,HFYGCDRX3230916:1:2148:19542:5963,HG5J5DRX3230915:1:2211:31819:8531,HFYGCDRX3230916:1:2172:30364:6042,HFYGCDRX3230916:2:2219:13566:21762,HFYGCDRX3230916:1:2146:16532:36417,HFYGCDRX3230916:1:2119:13223:28401,HFYGCDRX3230916:1:2257:5394:9831,HFYGCDRX3230916:1:2270:31873:23406,HFYGCDRX3230916:1:2110:2772:2754,HFYGCDRX3230916:2:2177:16459:2253,HFYGCDRX3230916:2:2242:21115:20556,HFYGCDRX3230916:2:2225:15284:18850,HFYGCDRX3230916:2:2226:18276:7279,HFYGCDRX3230916:2:2124:16758:25316,HFYGCDRX3230916:2:2204:8350:15045,HFYGCDRX3230916:1:2105:11722:19789,HFYGCDRX3230916:1:2223:15890:31015,HFYGCDRX3230916:1:2270:4824:26349,HFYGCDRX3230916:1:2107:7835:19601,HFYGCDRX3230916:1:2148:13024:27931,HFYGCDRX3230916:2:2116:7139:2550,HG5J5DRX3230915:1:2117:23411:1391,HFYGCDRX3230916:1:2165:3739:8750,HFYGCDRX3230916:2:2142:32786:20290,HFYGCDRX3230916:1:2231:14317:23782,HFYGCDRX3230916:1:2226:9317:2378,HFYGCDRX3230916:1:2247:32054:12101,HFYGCDRX3230916:2:2129:8838:17644,HFYGCDRX3230916:1:2114:22309:22216,HFYGCDRX3230916:1:2128:17861:2801,HFYGCDRX3230916:1:2272:11867:8108,HFYGCDRX3230916:2:2157:3947:17096,HFYGCDRX3230916:1:2156:30056:18411,HFYGCDRX3230916:2:2102:5801:4836,HFYGCDRX3230916:1:2216:19859:17848,HFYGCDRX3230916:2:2270:5095:16892,HFYGCDRX3230916:1:2150:10022:12900,HFYGCDRX3230916:1:2175:3423:12712,HFYGCDRX3230916:2:2203:29297:14497,HFYGCDRX3230916:2:2163:21160:32972,HFYGCDRX3230916:2:2272:5041:10911,HFYGCDRX3230916:1:2266:3839:5541,HFYGCDRX3230916:2:2276:30581:20447,HG5J5DRX3230915:1:2246:32199:27320,HFYGCDRX3230916:1:2135:7753:20682,HFYGCDRX3230916:1:2170:10474:17065,HFYGCDRX3230916:1:2202:9697:28651,HFYGCDRX3230916:1:2173:22363:24001,HFYGCDRX3230916:1:2218:8910:31798,HFYGCDRX3230916:1:2104:6551:4539,HFYGCDRX3230916:2:2122:9399:12915,HFYGCDRX3230916:1:2117:16486:26506,HFYGCDRX3230916:2:2109:19054:18803,HFYGCDRX3230916:1:2277:15293:24721,HFYGCDRX3230916:2:2119:18927:10379,HFYGCDRX3230916:2:2108:12020:3897,HFYGCDRX3230916:2:2245:22453:29982,HFYGCDRX3230916:1:2153:22815:16830,HFYGCDRX3230916:1:2137:18123:10989,HG5J5DRX3230915:1:2276:2772:28526,HFYGCDRX3230916:1:2209:10239:11303,HFYGCDRX3230916:2:2232:16107:3991,HFYGCDRX3230916:1:2149:30888:4758,HFYGCDRX3230916:2:2112:13449:10692,HFYGCDRX3230916:1:2131:27317:11788,HG5J5DRX3230915:1:2252:20302:4335,HFYGCDRX3230916:2:2127:7220:33317,HG5J5DRX3230915:1:2204:1958:28995,HFYGCDRX3230916:1:2222:5276:28792,HFYGCDRX3230916:2:2110:10990:2613,HFYGCDRX3230916:2:2264:20437:21418,HFYGCDRX3230916:2:2105:8440:26475,HFYGCDRX3230916:1:2132:19768:27430,HFYGCDRX3230916:2:2127:25934:17284,HFYGCDRX3230916:1:2163:3188:17315,HFYGCDRX3230916:2:2159:21820:33489,HFYGCDRX3230916:1:2110:20817:27868,HFYGCDRX3230916:1:2102:16468:32675,HFYGCDRX3230916:2:2259:4282:9721,HFYGCDRX3230916:1:2110:24668:5916,HFYGCDRX3230916:1:2208:24288:24737,HFYGCDRX3230916:2:2264:24740:19100,HFYGCDRX3230916:1:2255:4481:34428,HFYGCDRX3230916:1:2211:25048:17566,HFYGCDRX3230916:2:2236:14199:25520,HFYGCDRX3230916:2:2218:3911:10989,HFYGCDRX3230916:1:2178:16468:26099,HFYGCDRX3230916:2:2207:15221:16485,HFYGCDRX3230916:1:2270:19859:14904,HFYGCDRX3230916:1:2247:3613:28541,HFYGCDRX3230916:2:2150:15103:26897,HFYGCDRX3230916:1:2251:5728:21966,HFYGCDRX3230916:1:2115:22318:11115,HFYGCDRX3230916:1:2201:12608:6793,HFYGCDRX3230916:1:2233:26720:19930,HFYGCDRX3230916:1:2231:22155:11240,HFYGCDRX3230916:2:2232:10185:4946,HFYGCDRX3230916:1:2101:27425:25942,HFYGCDRX3230916:1:2124:17038:31375,HFYGCDRX3230916:1:2227:13774:5588,HFYGCDRX3230916:1:2165:17020:11772,HFYGCDRX3230916:1:2213:3649:17331,HFYGCDRX3230916:2:2145:12726:16799,HFYGCDRX3230916:2:2275:23158:1705,HFYGCDRX3230916:1:2156:22173:21825,HFYGCDRX3230916:1:2173:24957:5697,HFYGCDRX3230916:1:2159:20229:22717,HFYGCDRX3230916:1:2108:28673:8688,HFYGCDRX3230916:1:2120:1796:30749,HFYGCDRX3230916:1:2136:8712:6652,HG5J5DRX3230915:1:2266:10565:27743,HFYGCDRX3230916:2:2210:27615:24486,HFYGCDRX3230916:2:2109:29930:35571,HFYGCDRX3230916:1:2227:32018:15577,HFYGCDRX3230916:2:2119:14027:5055,HFYGCDRX3230916:2:2167:20817:14434,HG5J5DRX3230915:1:2209:10800:28087,HFYGCDRX3230916:1:2242:7283:12633,HFYGCDRX3230916:1:2212:14009:30859,HFYGCDRX3230916:2:2233:31557:36354,HG5J5DRX3230915:1:2131:1985:5619,HFYGCDRX3230916:2:2107:1850:25801,HG5J5DRX3230915:1:2131:25970:18286,HFYGCDRX3230916:2:2168:10348:14747,HFYGCDRX3230916:2:2203:23592:15922,HFYGCDRX3230916:1:2153:30047:20181,HFYGCDRX3230916:2:2126:29342:4930,HFYGCDRX3230916:1:2110:24505:6887,HFYGCDRX3230916:1:2257:7681:15264,HFYGCDRX3230916:2:2274:4598:33473,HFYGCDRX3230916:2:2122:32362:2331,HFYGCDRX3230916:1:2165:28004:4272,HFYGCDRX3230916:1:2276:14299:5744,HFYGCDRX3230916:2:2136:11794:6887,HG5J5DRX3230915:1:2113:29116:9643,HFYGCDRX3230916:1:2148:29740:25441,HFYGCDRX3230916:1:2203:13729:26459,HFYGCDRX3230916:2:2178:18204:20650,HFYGCDRX3230916:1:2137:12662:37012,HFYGCDRX3230916:2:2121:31910:6496,HFYGCDRX3230916:2:2259:9317:25238,HFYGCDRX3230916:1:2158:2510:33614,HG5J5DRX3230915:1:2145:20528:14309,HFYGCDRX3230916:1:2173:9778:34835,HFYGCDRX3230916:1:2220:21007:4178,HFYGCDRX3230916:1:2259:29324:12414,HFYGCDRX3230916:2:2158:17038:2816,HFYGCDRX3230916:2:2213:3323:15702,HFYGCDRX3230916:2:2119:26323:24439,HFYGCDRX3230916:2:2131:12834:30890,HFYGCDRX3230916:1:2127:20320:35775,HFYGCDRX3230916:1:2222:30671:18944,HFYGCDRX3230916:2:2274:17779:30968,HFYGCDRX3230916:1:2120:14434:7858,HFYGCDRX3230916:1:2210:27769:28103,HFYGCDRX3230916:1:2106:10113:12618,HFYGCDRX3230916:1:2139:23592:6433,HFYGCDRX3230916:1:2154:27742:12054,HFYGCDRX3230916:2:2120:6732:28682,HFYGCDRX3230916:1:2210:32325:18051,HFYGCDRX3230916:1:2254:29089:1861,HG5J5DRX3230915:1:2109:26666:15264,HFYGCDRX3230916:1:2110:1759:2566,HFYGCDRX3230916:2:2210:9254:33833,HFYGCDRX3230916:1:2102:11605:28072,HFYGCDRX3230916:1:2225:8070:11616,HFYGCDRX3230916:2:2130:8594:1971,HG5J5DRX3230915:1:2249:24551:7654,HFYGCDRX3230916:2:2227:1425:7310,HG5J5DRX3230915:1:2242:15393:27774,HFYGCDRX3230916:1:2244:7753:4147,HFYGCDRX3230916:2:2225:24361:15812,HFYGCDRX3230916:1:2137:13774:8155,HFYGCDRX3230916:1:2276:31593:12054,HFYGCDRX3230916:1:2168:18313:14606,HFYGCDRX3230916:1:2106:10194:19867,HFYGCDRX3230916:1:2248:23140:25911,HFYGCDRX3230916:1:2109:24243:4398,HFYGCDRX3230916:2:2275:2492:23625,HFYGCDRX3230916:2:2234:14299:20807,HFYGCDRX3230916:1:2105:10339:5556,HFYGCDRX3230916:2:2147:23077:3349,HFYGCDRX3230916:1:2230:7319:27132,HFYGCDRX3230916:2:2143:4119:23970,HFYGCDRX3230916:2:2145:26350:26960,HFYGCDRX3230916:1:2243:10149:31970,HG5J5DRX3230915:1:2242:31277:19523,HFYGCDRX3230916:2:2162:5990:18537,HFYGCDRX3230916:2:2157:1687:29183,HFYGCDRX3230916:1:2272:29722:14951,HFYGCDRX3230916:1:2273:5041:26757,HFYGCDRX3230916:1:2269:30373:11976,HFYGCDRX3230916:1:2158:30020:7420,HFYGCDRX3230916:2:2242:16920:31109,HFYGCDRX3230916:2:2161:25807:10864,HFYGCDRX3230916:2:2172:18141:35102,HFYGCDRX3230916:2:2236:23936:20462,HFYGCDRX3230916:2:2249:21468:28651,HFYGCDRX3230916:1:2129:31024:14732,HFYGCDRX3230916:1:2174:29541:1423,HFYGCDRX3230916:2:2203:5330:5306,HFYGCDRX3230916:1:2259:26711:27054,HFYGCDRX3230916:2:2144:5819:25817,HG5J5DRX3230915:1:2209:12988:3724,HG5J5DRX3230915:1:2246:24334:6840,HFYGCDRX3230916:2:2104:32117:30123,HFYGCDRX3230916:1:2105:7545:15060,HFYGCDRX3230916:1:2276:27923:31688,HFYGCDRX3230916:2:2137:10773:2675,HG5J5DRX3230915:1:2168:23502:29105,HFYGCDRX3230916:2:2228:19343:35681,HFYGCDRX3230916:1:2115:18882:20228,HFYGCDRX3230916:1:2216:16758:24032,HFYGCDRX3230916:2:2217:30047:35305,HFYGCDRX3230916:2:2221:17463:11193,HFYGCDRX3230916:1:2250:29306:22905,HFYGCDRX3230916:1:2275:16911:15937,HFYGCDRX3230916:2:2224:22779:26663,HFYGCDRX3230916:1:2125:15953:1783,HFYGCDRX3230916:2:2252:17607:15295,HFYGCDRX3230916:1:2164:7853:19445,HFYGCDRX3230916:1:2224:18900:30499,HFYGCDRX3230916:2:2219:14335:28761,HFYGCDRX3230916:1:2135:27181:36636,HFYGCDRX3230916:1:2135:29713:12305,HFYGCDRX3230916:1:2112:9281:1188,HFYGCDRX3230916:1:2145:25907:28197,HG5J5DRX3230915:1:2174:32063:7827,HFYGCDRX3230916:2:2173:21802:23375,HFYGCDRX3230916:2:2119:17164:23077,HFYGCDRX3230916:1:2221:9254:4147,HG5J5DRX3230915:1:2278:10981:1344,HG5J5DRX3230915:1:2256:22372:21042,HFYGCDRX3230916:2:2139:1886:19820,HFYGCDRX3230916:2:2221:10682:36996,HFYGCDRX3230916:1:2132:27480:20744,HFYGCDRX3230916:2:2174:10104:31234,HFYGCDRX3230916:1:2260:26702:6965,HFYGCDRX3230916:2:2103:23954:14168,HFYGCDRX3230916:1:2118:8983:23625,HFYGCDRX3230916:1:2137:7835:7200,HFYGCDRX3230916:2:2103:18285:31125,HFYGCDRX3230916:1:2210:2220:23375,HFYGCDRX3230916:1:2119:19397:17832,HFYGCDRX3230916:2:2128:27543:9204,HFYGCDRX3230916:2:2120:30300:35775,HFYGCDRX3230916:2:2242:15763:1705,HFYGCDRX3230916:1:2164:6162:24878,HFYGCDRX3230916:2:2216:26341:7467,HFYGCDRX3230916:1:2171:11143:20259,HG5J5DRX3230915:1:2172:31602:13949,HFYGCDRX3230916:2:2272:4788:27790,HG5J5DRX3230915:1:2147:4815:32346,HFYGCDRX3230916:2:2256:32814:23970,HFYGCDRX3230916:1:2208:26332:34882,HFYGCDRX3230916:2:2254:16260:17816,HG5J5DRX3230915:1:2107:23701:11976,HG5J5DRX3230915:1:2138:7844:22091,HFYGCDRX3230916:1:2254:17752:31078,HG5J5DRX3230915:1:2110:24722:5321,HFYGCDRX3230916:1:2144:5258:36245,HFYGCDRX3230916:1:2133:9417:23688,HFYGCDRX3230916:1:2234:3152:4789,HFYGCDRX3230916:2:2246:6017:3364,HFYGCDRX3230916:1:2236:3920:2926,HG5J5DRX3230915:1:2165:10637:11741,HFYGCDRX3230916:1:2251:21432:18505,HFYGCDRX3230916:1:2175:5638:33395,HFYGCDRX3230916:1:2173:17861:15702,HG5J5DRX3230915:1:2268:24270:2096,HFYGCDRX3230916:1:2259:14642:20400,HFYGCDRX3230916:1:2144:25916:30436,HFYGCDRX3230916:1:2258:18584:23907,HFYGCDRX3230916:1:2166:16242:5885,HFYGCDRX3230916:1:2269:18087:15092,HFYGCDRX3230916:1:2132:3143:17895,HFYGCDRX3230916:2:2255:9254:11162,HFYGCDRX3230916:1:2173:4987:1642,HFYGCDRX3230916:2:2227:12509:2174,HFYGCDRX3230916:1:2206:13964:24706,HFYGCDRX3230916:2:2252:5168:11663,HG5J5DRX3230915:1:2276:8766:17206,HFYGCDRX3230916:2:2142:30635:10802,HG5J5DRX3230915:1:2228:4743:33098,HFYGCDRX3230916:2:2154:2293:36902,HFYGCDRX3230916:1:2178:14877:3771,HFYGCDRX3230916:2:2243:29722:22310,HFYGCDRX3230916:2:2112:11261:34147,HFYGCDRX3230916:2:2264:29649:8876,HFYGCDRX3230916:1:2255:15103:4413,HFYGCDRX3230916:1:2136:3667:34303,HFYGCDRX3230916:1:2273:2537:18662,HFYGCDRX3230916:2:2250:27651:22388,HFYGCDRX3230916:1:2263:11966:30013,HFYGCDRX3230916:2:2150:32344:4053,HFYGCDRX3230916:1:2142:20871:27273,HFYGCDRX3230916:2:2106:15637:33614,HFYGCDRX3230916:2:2129:1723:1908,HFYGCDRX3230916:2:2220:26295:19946,HFYGCDRX3230916:2:2115:1099:30545,HFYGCDRX3230916:1:2123:7762:8985,HFYGCDRX3230916:2:2134:10158:34428,HG5J5DRX3230915:1:2102:13187:24956,HFYGCDRX3230916:2:2140:25265:5729,HFYGCDRX3230916:1:2123:6207:24298,HFYGCDRX3230916:1:2135:22372:15843,HFYGCDRX3230916:1:2277:10276:21355,HFYGCDRX3230916:1:2108:24903:27743,HFYGCDRX3230916:1:2259:24343:33035,HFYGCDRX3230916:2:2127:8829:9392,HFYGCDRX3230916:1:2116:16432:18771,HFYGCDRX3230916:2:2231:29405:2002,HFYGCDRX3230916:1:2271:22037:29606,HFYGCDRX3230916:1:2275:18412:28338,HFYGCDRX3230916:1:2223:26313:10864,HFYGCDRX3230916:2:2229:3152:31782,HFYGCDRX3230916:1:2201:15275:8093,HFYGCDRX3230916:1:2205:11315:31735,HFYGCDRX3230916:2:2117:30056:13088,HFYGCDRX3230916:2:2109:28375:1626,HG5J5DRX3230915:1:2213:20582:25019,HFYGCDRX3230916:2:2174:18267:3693,HFYGCDRX3230916:1:2226:3034:28667,HFYGCDRX3230916:1:2107:13449:12633,HFYGCDRX3230916:1:2108:20166:1313,HFYGCDRX3230916:1:2227:17833:15655,HFYGCDRX3230916:1:2110:28366:10191,HFYGCDRX3230916:2:2121:6171:31125,HFYGCDRX3230916:2:2255:20175:4335,HFYGCDRX3230916:1:2110:27642:13510,HFYGCDRX3230916:1:2240:27995:16094,HFYGCDRX3230916:2:2117:17553:28166,HFYGCDRX3230916:2:2271:13205:19883,HFYGCDRX3230916:1:2272:4101:25974,HFYGCDRX3230916:2:2272:31946:15671,HFYGCDRX3230916:1:2251:25003:23218,HFYGCDRX3230916:1:2129:31105:35008,HFYGCDRX3230916:1:2273:2908:30859,HFYGCDRX3230916:2:2251:6388:6386,HFYGCDRX3230916:1:2211:6027:31720,HFYGCDRX3230916:1:2133:11858:7059,HFYGCDRX3230916:1:2260:14696:34240,HFYGCDRX3230916:1:2256:13286:21026,HG5J5DRX3230915:1:2236:27615:2096,HFYGCDRX3230916:1:2136:28537:35634,HFYGCDRX3230916:1:2238:25590:19601,HFYGCDRX3230916:2:2165:22950:20666,HFYGCDRX3230916:1:2170:31611:3818,HFYGCDRX3230916:2:2160:18873:4366,HFYGCDRX3230916:1:2152:19072:10097,HFYGCDRX3230916:1:2221:28754:7858,HFYGCDRX3230916:1:2129:21278:28072,HFYGCDRX3230916:1:2153:16541:13792,HFYGCDRX3230916:2:2272:27299:23750,HG5J5DRX3230915:1:2167:15971:35822,HFYGCDRX3230916:1:2137:24668:20290,HFYGCDRX3230916:1:2165:9173:7576,HFYGCDRX3230916:1:2168:17309:5509,HFYGCDRX3230916:1:2226:16514:31469,HFYGCDRX3230916:2:2205:31602:7936,HFYGCDRX3230916:1:2145:13051:11475,HFYGCDRX3230916:2:2128:29478:27336,HFYGCDRX3230916:2:2109:30870:8202,HFYGCDRX3230916:1:2175:24975:3881,HFYGCDRX3230916:1:2172:21233:6480,HFYGCDRX3230916:1:2128:4698:24690,HFYGCDRX3230916:2:2250:5755:35728,HG5J5DRX3230915:1:2245:19054:5337,HFYGCDRX3230916:1:2231:3233:13573,HFYGCDRX3230916:2:2107:12816:22185,HFYGCDRX3230916:2:2122:21667:9987,HFYGCDRX3230916:2:2174:2501:16658,HFYGCDRX3230916:1:2244:31855:16642,HFYGCDRX3230916:2:2213:4987:9846,HFYGCDRX3230916:1:2256:31530:22279,HFYGCDRX3230916:2:2148:23927:27085,HFYGCDRX3230916:2:2173:30282:12821,HFYGCDRX3230916:1:2173:21567:11130,HFYGCDRX3230916:2:2137:30761:12680,HFYGCDRX3230916:1:2240:11198:29872,HFYGCDRX3230916:1:2245:26621:7795,HFYGCDRX3230916:2:2177:8052:28902,HFYGCDRX3230916:2:2118:4743:27931,HFYGCDRX3230916:2:2121:6822:31250,HFYGCDRX3230916:2:2245:9091:6151,HG5J5DRX3230915:1:2263:19804:16783,HFYGCDRX3230916:2:2171:14036:21418,HFYGCDRX3230916:2:2227:24831:28119,HFYGCDRX3230916:1:2275:3703:33896,HFYGCDRX3230916:2:2267:5810:5666,HFYGCDRX3230916:2:2165:19235:32800,HFYGCDRX3230916:2:2221:26142:33959,HFYGCDRX3230916:1:2249:6542:12226,HFYGCDRX3230916:1:2176:20428:15452,HFYGCDRX3230916:1:2251:32895:21731,HFYGCDRX3230916:2:2217:5376:21073,HFYGCDRX3230916:1:2159:15772:16250,HFYGCDRX3230916:1:2128:15989:9737,HFYGCDRX3230916:1:2132:5538:5603,HFYGCDRX3230916:1:2111:8684:15499,HFYGCDRX3230916:1:2243:31394:26741,HG5J5DRX3230915:1:2215:18050:36542,HFYGCDRX3230916:2:2221:2808:21261,HFYGCDRX3230916:1:2114:29514:24987,HFYGCDRX3230916:2:2235:8350:4460,HG5J5DRX3230915:1:2147:3866:12508,HFYGCDRX3230916:2:2113:9561:10222,HG5J5DRX3230915:1:2272:9390:2722,HFYGCDRX3230916:1:2106:9191:23390,HFYGCDRX3230916:2:2262:9769:29935,HFYGCDRX3230916:1:2248:31430:21073,HFYGCDRX3230916:1:2255:29695:28338,HFYGCDRX3230916:1:2211:8938:6605,HFYGCDRX3230916:1:2217:31078:34554,HFYGCDRX3230916:2:2134:2600:24314,HFYGCDRX3230916:1:2232:24451:13150,HG5J5DRX3230915:1:2104:8024:5431,HFYGCDRX3230916:2:2212:10474:10958,HFYGCDRX3230916:1:2245:24930:19085,HFYGCDRX3230916:1:2140:22064:16250,HFYGCDRX3230916:1:2122:8169:23563,HFYGCDRX3230916:1:2255:22833:2738,HG5J5DRX3230915:1:2273:22869:14481,HFYGCDRX3230916:1:2122:12427:9862,HFYGCDRX3230916:1:2232:13874:17816,HFYGCDRX3230916:2:2214:19813:27759,HFYGCDRX3230916:1:2130:21956:29496,HFYGCDRX3230916:1:2226:24117:15358,HFYGCDRX3230916:1:2121:10113:28150,HFYGCDRX3230916:1:2177:14154:4335,HFYGCDRX3230916:1:2133:7129:3317,HFYGCDRX3230916:2:2114:11171:7717,HG5J5DRX3230915:1:2101:27814:18818,HFYGCDRX3230916:2:2207:29324:32831,HFYGCDRX3230916:1:2162:1280:33865,HFYGCDRX3230916:1:2174:1298:6840,HFYGCDRX3230916:1:2122:15058:15139,HG5J5DRX3230915:1:2207:7084:6120,HFYGCDRX3230916:2:2153:18991:34882,HFYGCDRX3230916:1:2170:12518:25708,HFYGCDRX3230916:1:2230:14000:20541,HFYGCDRX3230916:1:2241:6804:8516,HFYGCDRX3230916:2:2132:27425:3834,HFYGCDRX3230916:2:2223:19596:21089,HFYGCDRX3230916:2:2223:13928:18129,HFYGCDRX3230916:1:2137:18882:27367,HG5J5DRX3230915:1:2148:5240:5556,HFYGCDRX3230916:2:2133:24198:22545,HFYGCDRX3230916:1:2248:28275:4586,HFYGCDRX3230916:2:2214:31060:34303,HFYGCDRX3230916:1:2114:5755:35759,HFYGCDRX3230916:1:2162:30400:11083,HFYGCDRX3230916:2:2117:27335:12633,HG5J5DRX3230915:1:2253:3097:34914,HFYGCDRX3230916:1:2211:6614:22247,HG5J5DRX3230915:1:2172:32669:27132,HFYGCDRX3230916:1:2164:19976:23093,HFYGCDRX3230916:2:2232:12879:30812,HFYGCDRX3230916:1:2136:8052:14152,HFYGCDRX3230916:2:2259:12572:32659,HFYGCDRX3230916:2:2270:10239:20760,HFYGCDRX3230916:1:2160:9570:15374,HFYGCDRX3230916:1:2130:5529:4993,HFYGCDRX3230916:2:2151:20184:34381,HFYGCDRX3230916:2:2125:4083:26068,HFYGCDRX3230916:1:2103:32163:26443,HFYGCDRX3230916:1:2111:24017:28432,HFYGCDRX3230916:2:2159:11722:27211,HG5J5DRX3230915:1:2104:10077:22013,HFYGCDRX3230916:1:2119:13060:32127,HG5J5DRX3230915:1:2138:8567:22623,HFYGCDRX3230916:1:2172:6343:27195,HFYGCDRX3230916:1:2139:17056:33567,HFYGCDRX3230916:2:2132:15112:23625,HFYGCDRX3230916:2:2227:25464:30248,HG5J5DRX3230915:1:2132:32190:35383,HFYGCDRX3230916:1:2120:19271:28855,HFYGCDRX3230916:2:2228:12988:36855,HFYGCDRX3230916:1:2174:13404:36667,HFYGCDRX3230916:2:2201:18602:26976,HFYGCDRX3230916:2:2252:15374:16094,HFYGCDRX3230916:2:2132:15230:31375,HFYGCDRX3230916:1:2131:18973:31000,HFYGCDRX3230916:2:2175:1181:14559,HG5J5DRX3230915:1:2254:3314:1282,HFYGCDRX3230916:2:2245:12454:23437,HFYGCDRX3230916:1:2122:19461:11115,HFYGCDRX3230916:2:2151:8386:27539,HFYGCDRX3230916:1:2162:22950:19257,HFYGCDRX3230916:1:2226:13657:32471,HFYGCDRX3230916:1:2102:17662:25347,HFYGCDRX3230916:2:2165:13268:23156,HG5J5DRX3230915:1:2211:2139:36135,HFYGCDRX3230916:2:2173:14570:5650,HFYGCDRX3230916:1:2171:13376:28980,HFYGCDRX3230916:2:2119:6397:24032,HFYGCDRX3230916:1:2138:12671:18270,HG5J5DRX3230915:1:2251:26802:17754,HFYGCDRX3230916:2:2201:5068:23829,HFYGCDRX3230916:2:2270:4797:29904,HFYGCDRX3230916:1:2151:15989:5165,HFYGCDRX3230916:2:2157:16667:19366,HFYGCDRX3230916:1:2164:7482:6558,HFYGCDRX3230916:1:2174:16694:6887,HFYGCDRX3230916:2:2259:27914:11318,HFYGCDRX3230916:2:2278:17517:1892,HFYGCDRX3230916:1:2144:7826:32706,HFYGCDRX3230916:1:2256:17173:33395,HFYGCDRX3230916:1:2159:28565:10285,HFYGCDRX3230916:2:2278:19018:34992,HFYGCDRX3230916:2:2139:9688:11412,HFYGCDRX3230916:1:2172:22191:17691,HG5J5DRX3230915:1:2217:13313:21230,HFYGCDRX3230916:1:2212:22408:36104,HFYGCDRX3230916:1:2119:22688:27352,HFYGCDRX3230916:2:2262:27353:15546,HFYGCDRX3230916:1:2278:20437:32002,HFYGCDRX3230916:2:2206:31186:5713,HFYGCDRX3230916:1:2110:23493:15154,HFYGCDRX3230916:2:2254:17996:31814,HFYGCDRX3230916:1:2273:8576:33630,HG5J5DRX3230915:1:2169:24044:34303,HFYGCDRX3230916:2:2111:9489:7310,HFYGCDRX3230916:2:2204:30264:28855,HG5J5DRX3230915:1:2143:12029:28338,HFYGCDRX3230916:1:2142:12373:28776,HFYGCDRX3230916:2:2244:27760:11804,HFYGCDRX3230916:2:2253:7337:34147,HFYGCDRX3230916:2:2229:14895:23782,HFYGCDRX3230916:1:2248:19687:13228,HFYGCDRX3230916:1:2247:23981:23860,HFYGCDRX3230916:2:2143:10212:14481,HFYGCDRX3230916:2:2148:6506:25661,HFYGCDRX3230916:2:2272:13313:31062,HFYGCDRX3230916:1:2109:26295:13025,HFYGCDRX3230916:1:2262:29541:4679,HFYGCDRX3230916:1:2208:22073:34021,HFYGCDRX3230916:2:2127:9959:16767,HFYGCDRX3230916:2:2260:13657:9392,HFYGCDRX3230916:2:2246:10366:13745,HFYGCDRX3230916:1:2174:19379:13103,HFYGCDRX3230916:2:2123:12337:2033,HFYGCDRX3230916:1:2117:30481:22936,HFYGCDRX3230916:1:2233:11433:7326,HFYGCDRX3230916:2:2225:25482:9831,HFYGCDRX3230916:2:2123:1922:23296,HFYGCDRX3230916:1:2234:1642:33145,HFYGCDRX3230916:2:2104:9805:1438,HFYGCDRX3230916:1:2264:2591:20040,HFYGCDRX3230916:2:2138:11496:27508,HFYGCDRX3230916:1:2108:6343:33677,HG5J5DRX3230915:1:2221:12617:4617,HFYGCDRX3230916:2:2258:32054:29857,HFYGCDRX3230916:1:2175:16893:21073,HG5J5DRX3230915:1:2107:6903:33019,HFYGCDRX3230916:1:2273:12943:1830,HFYGCDRX3230916:1:2152:18891:32362,HFYGCDRX3230916:1:2140:6108:23719,HFYGCDRX3230916:1:2240:9715:6324,HG5J5DRX3230915:1:2274:25373:7764,HFYGCDRX3230916:1:2114:10248:20838,HFYGCDRX3230916:1:2247:1705:29747,HFYGCDRX3230916:2:2238:15953:7012,HFYGCDRX3230916:2:2257:24858:28260,HFYGCDRX3230916:1:2116:23493:25864,HFYGCDRX3230916:1:2238:10493:22451,HFYGCDRX3230916:1:2256:2049:25175,HFYGCDRX3230916:2:2245:23240:19288,HFYGCDRX3230916:1:2135:19741:21652,HFYGCDRX3230916:1:2156:30870:6480,HG5J5DRX3230915:1:2223:27434:13463,HFYGCDRX3230916:2:2149:18466:32095,HFYGCDRX3230916:2:2104:22733:24017,HFYGCDRX3230916:1:2112:5755:4726,HFYGCDRX3230916:1:2212:20193:12070,HG5J5DRX3230915:1:2130:26937:16078,HFYGCDRX3230916:1:2246:27462:18865,HFYGCDRX3230916:1:2216:5141:5008,HFYGCDRX3230916:1:2221:20419:13213,HFYGCDRX3230916:1:2128:29252:3771,HFYGCDRX3230916:1:2160:8495:6715,HFYGCDRX3230916:1:2150:16134:26146,HFYGCDRX3230916:2:2145:17924:34695,HFYGCDRX3230916:1:2274:20265:21997,HFYGCDRX3230916:2:2101:30436:14027,HFYGCDRX3230916:2:2148:31087:21104,HFYGCDRX3230916:1:2107:17933:34898,HFYGCDRX3230916:1:2137:8070:20228,HFYGCDRX3230916:2:2125:20708:28275,HFYGCDRX3230916:2:2126:11017:4288,HFYGCDRX3230916:2:2202:1877:30671,HFYGCDRX3230916:2:2157:30816:32440,HFYGCDRX3230916:1:2167:32461:6104,HFYGCDRX3230916:2:2257:9236:28792,HG5J5DRX3230915:1:2257:7943:35853,HFYGCDRX3230916:1:2176:21187:3646,HFYGCDRX3230916:1:2109:17318:20118,HFYGCDRX3230916:2:2122:27507:12806,HFYGCDRX3230916:2:2220:3495:32847,HFYGCDRX3230916:1:2136:25672:13542,HFYGCDRX3230916:1:2158:27624:12602,HFYGCDRX3230916:2:2269:2817:8375,HFYGCDRX3230916:2:2125:2501:30718,HFYGCDRX3230916:2:2123:29649:24972,HG5J5DRX3230915:1:2272:3974:14387,HG5J5DRX3230915:1:2152:2320:26459,HFYGCDRX3230916:2:2119:24822:26162,HFYGCDRX3230916:2:2132:32063:18505,HFYGCDRX3230916:1:2242:26223:20697,HG5J5DRX3230915:1:2130:27823:21872,HFYGCDRX3230916:1:2258:6759:20932,HFYGCDRX3230916:2:2218:27236:20228,HFYGCDRX3230916:1:2217:15456:2143,HFYGCDRX3230916:1:2134:16532:17942,HFYGCDRX3230916:1:2236:22245:28150,HFYGCDRX3230916:1:2104:12011:13150,HFYGCDRX3230916:2:2202:8793:32878,HG5J5DRX3230915:1:2147:28501:1376,HFYGCDRX3230916:2:2102:6207:9925,HFYGCDRX3230916:1:2140:29677:7326,HFYGCDRX3230916:2:2149:17553:35524,HFYGCDRX3230916:2:2262:8703:4445,HFYGCDRX3230916:1:2131:19922:32080,HG5J5DRX3230915:1:2114:15130:33489,HFYGCDRX3230916:1:2252:28646:21981,HFYGCDRX3230916:2:2247:1334:29888,HFYGCDRX3230916:2:2268:28628:35164,HFYGCDRX3230916:2:2117:29324:27320,HFYGCDRX3230916:2:2259:13937:9627,HFYGCDRX3230916:1:2211:3794:12727,HFYGCDRX3230916:2:2107:11568:25629,HFYGCDRX3230916:1:2153:15745:16329,HFYGCDRX3230916:1:2241:30282:16078,HG5J5DRX3230915:1:2208:25889:21934,HFYGCDRX3230916:1:2115:7401:9925,HFYGCDRX3230916:1:2216:25138:9424,HFYGCDRX3230916:2:2169:9968:13557,HFYGCDRX3230916:1:2213:4652:35540,HFYGCDRX3230916:1:2139:18909:3771,HFYGCDRX3230916:2:2109:19289:20776,HFYGCDRX3230916:1:2129:16975:15515,HFYGCDRX3230916:1:2158:25138:15217,HG5J5DRX3230915:1:2134:1850:8547,HFYGCDRX3230916:2:2162:24343:15217,HG5J5DRX3230915:1:2172:7934:7028,HG5J5DRX3230915:1:2113:9724:23437,HFYGCDRX3230916:1:2206:24099:8531,HFYGCDRX3230916:1:2262:25654:9314,HFYGCDRX3230916:2:2120:3414:21308,HG5J5DRX3230915:1:2249:10257:36918,HFYGCDRX3230916:1:2152:23511:14465,HG5J5DRX3230915:1:2241:29622:5134,HFYGCDRX3230916:2:2116:24551:11569,HFYGCDRX3230916:1:2225:11541:16250,HG5J5DRX3230915:1:2206:31566:8312,HFYGCDRX3230916:2:2101:28429:25394,HFYGCDRX3230916:1:2243:16875:6261,HG5J5DRX3230915:1:2140:8088:35383,HFYGCDRX3230916:1:2221:30626:21057,HFYGCDRX3230916:1:2241:8422:15890,HFYGCDRX3230916:2:2249:20419:13495,HFYGCDRX3230916:2:2101:3025:1282,HFYGCDRX3230916:1:2140:11577:31093,HFYGCDRX3230916:2:2141:9127:7592,HFYGCDRX3230916:1:2267:28366:3552,HFYGCDRX3230916:1:2251:19470:12446,HG5J5DRX3230915:1:2214:21079:29450,HFYGCDRX3230916:1:2147:18150:32049,HFYGCDRX3230916:2:2104:32244:25457,HFYGCDRX3230916:1:2161:2067:14215,HFYGCDRX3230916:2:2148:26747:33473,HFYGCDRX3230916:1:2150:19678:33098,HFYGCDRX3230916:1:2251:31033:32377,HG5J5DRX3230915:1:2206:11180:14403,HFYGCDRX3230916:1:2134:16143:36620,HFYGCDRX3230916:1:2254:24677:8218,HFYGCDRX3230916:2:2101:1723:15655,HFYGCDRX3230916:2:2247:13566:5916,HFYGCDRX3230916:1:2213:31204:25128,HFYGCDRX3230916:1:2264:27796:22545,HFYGCDRX3230916:1:2273:15022:5619,HFYGCDRX3230916:2:2221:26015:3364,HFYGCDRX3230916:1:2247:22562:10285,HFYGCDRX3230916:2:2125:25247:10426,HFYGCDRX3230916:2:2106:5773:9987,HFYGCDRX3230916:1:2121:14669:31438,HFYGCDRX3230916:2:2240:17264:19116,HFYGCDRX3230916:2:2157:32895:31313,HFYGCDRX3230916:2:2252:32570:29309,HFYGCDRX3230916:1:2114:9724:22654,HFYGCDRX3230916:1:2126:12753:7106,HFYGCDRX3230916:1:2232:5575:11397,HG5J5DRX3230915:1:2204:24876:13448,HFYGCDRX3230916:2:2132:27697:35305,HFYGCDRX3230916:2:2118:15293:14325,HFYGCDRX3230916:1:2228:17309:1783,HFYGCDRX3230916:1:2134:25482:13808,HFYGCDRX3230916:2:2225:7256:35383,HFYGCDRX3230916:2:2276:22887:32362,HFYGCDRX3230916:1:2102:25798:35994,HFYGCDRX3230916:1:2272:4092:12399,HFYGCDRX3230916:1:2106:6488:3176,HFYGCDRX3230916:2:2249:29170:25207,HFYGCDRX3230916:2:2126:31656:8844,HFYGCDRX3230916:1:2112:31494:14638,HG5J5DRX3230915:1:2266:8504:12900,HG5J5DRX3230915:1:2219:30960:4695,HFYGCDRX3230916:1:2124:9010:25363,HFYGCDRX3230916:1:2109:4083:11068,HFYGCDRX3230916:2:2112:5321:27618,HFYGCDRX3230916:1:2263:5999:15139,HFYGCDRX3230916:2:2245:14588:18051,HFYGCDRX3230916:1:2240:21305:8641,HFYGCDRX3230916:1:2131:10755:22842,HFYGCDRX3230916:1:2163:6714:10488,HFYGCDRX3230916:1:2137:30427:2613,HFYGCDRX3230916:1:2114:11234:15843,HFYGCDRX3230916:2:2130:18105:25551,HFYGCDRX3230916:2:2209:11243:5744,HFYGCDRX3230916:1:2171:27064:4492,HFYGCDRX3230916:1:2139:13241:21292,HFYGCDRX3230916:1:2225:16378:26663,HFYGCDRX3230916:1:2218:5303:29121,HFYGCDRX3230916:1:2207:24487:21167,HFYGCDRX3230916:1:2214:18973:8077,HFYGCDRX3230916:2:2121:13123:27352,HFYGCDRX3230916:1:2253:28257:17769,HFYGCDRX3230916:1:2177:21856:17331,HFYGCDRX3230916:2:2271:3152:29496,HFYGCDRX3230916:1:2133:26910:20917,HFYGCDRX3230916:2:2175:29984:33223,HFYGCDRX3230916:1:2138:25003:11193,HG5J5DRX3230915:1:2174:24777:8422,HFYGCDRX3230916:2:2206:17580:18255,HFYGCDRX3230916:1:2214:27425:4961,HFYGCDRX3230916:1:2143:15429:32315,HFYGCDRX3230916:2:2125:9028:30561,HG5J5DRX3230915:1:2205:12834:26631,HG5J5DRX3230915:1:2133:9733:33160,HFYGCDRX3230916:2:2109:24605:21089,HFYGCDRX3230916:1:2111:26341:11005,HFYGCDRX3230916:2:2219:6216:18239,HG5J5DRX3230915:1:2123:24749:16830,HFYGCDRX3230916:2:2171:11939:11459,HFYGCDRX3230916:1:2138:26359:20744,HFYGCDRX3230916:2:2227:6533:2503,HFYGCDRX3230916:2:2265:19343:6245,HFYGCDRX3230916:2:2109:29812:8437,HFYGCDRX3230916:1:2227:16116:31845,HFYGCDRX3230916:2:2240:16676:9392,HFYGCDRX3230916:2:2257:27606:26537,HFYGCDRX3230916:2:2121:27633:22075,HG5J5DRX3230915:1:2104:27751:15483,HFYGCDRX3230916:1:2120:7527:27837,HG5J5DRX3230915:1:2269:2917:6449,HFYGCDRX3230916:2:2276:13386:3035,HFYGCDRX3230916:1:2205:2709:32831,HFYGCDRX3230916:1:2131:6126:35900,HFYGCDRX3230916:1:2102:20193:11788,HFYGCDRX3230916:2:2159:16694:15123,HFYGCDRX3230916:1:2126:1154:34303,HFYGCDRX3230916:2:2115:3694:2691,HFYGCDRX3230916:1:2145:31991:11898,HFYGCDRX3230916:2:2136:4074:2816,HFYGCDRX3230916:1:2133:16731:19351,HFYGCDRX3230916:1:2140:1588:12727,HFYGCDRX3230916:2:2221:27670:30279,HFYGCDRX3230916:1:2249:3025:13056,HFYGCDRX3230916:2:2237:19732:1752,HFYGCDRX3230916:1:2154:17173:26162,HFYGCDRX3230916:1:2176:15067:26522,HFYGCDRX3230916:1:2127:2248:16438,HFYGCDRX3230916:2:2136:26910:1658,HFYGCDRX3230916:2:2231:3269:14544,HFYGCDRX3230916:2:2208:30770:23343,HFYGCDRX3230916:2:2138:7202:3787,HFYGCDRX3230916:1:2144:32000:35305,HFYGCDRX3230916:2:2157:21233:25770,HFYGCDRX3230916:2:2136:12400:25848,HFYGCDRX3230916:1:2114:22996:35430,HFYGCDRX3230916:2:2126:25572:30311,HFYGCDRX3230916:2:2152:22173:7889,HFYGCDRX3230916:1:2171:32859:31000,HFYGCDRX3230916:2:2153:3106:7122,HFYGCDRX3230916:1:2157:3450:32049,HFYGCDRX3230916:2:2167:29197:24721,HFYGCDRX3230916:1:2127:16034:5337,HFYGCDRX3230916:2:2224:15555:18129,HFYGCDRX3230916:2:2101:10122:21966,HFYGCDRX3230916:1:2232:30490:33880,HFYGCDRX3230916:1:2227:6623:25645,HFYGCDRX3230916:2:2103:5376:13088,HFYGCDRX3230916:1:2221:6225:34444,HFYGCDRX3230916:2:2108:31331:20212,HFYGCDRX3230916:1:2245:23574:30201,HFYGCDRX3230916:1:2166:15112:10128,HFYGCDRX3230916:1:2116:24297:14669,HFYGCDRX3230916:1:2171:3586:25269,HG5J5DRX3230915:1:2230:11758:20509,HFYGCDRX3230916:2:2273:22978:19554,HFYGCDRX3230916:2:2275:18087:34381,HFYGCDRX3230916:2:2138:22788:22733,HG5J5DRX3230915:1:2122:1904:31156,HFYGCDRX3230916:1:2126:28248:35790,HG5J5DRX3230915:1:2129:5529:3677,HFYGCDRX3230916:1:2122:4860:11256,HFYGCDRX3230916:1:2232:18340:20165,HG5J5DRX3230915:1:2108:3477:34068,HFYGCDRX3230916:2:2103:17535:4554,HFYGCDRX3230916:1:2263:16577:31767,HFYGCDRX3230916:1:2258:2501:4131,HFYGCDRX3230916:1:2112:16224:5165,HFYGCDRX3230916:1:2201:30373:28573,HG5J5DRX3230915:1:2260:18050:12148,HFYGCDRX3230916:1:2152:20790:29982,HFYGCDRX3230916:1:2121:20085:23124,HFYGCDRX3230916:2:2177:2284:13777,HFYGCDRX3230916:1:2227:5638:26788,HFYGCDRX3230916:1:2132:19795:36526,HFYGCDRX3230916:2:2272:10728:13401,HFYGCDRX3230916:1:2261:30535:2895,HFYGCDRX3230916:2:2256:15393:31187,HFYGCDRX3230916:1:2207:28348:25441,HFYGCDRX3230916:2:2115:28320:19413,HFYGCDRX3230916:1:2178:30255:34538,HFYGCDRX3230916:1:2104:23258:1031,HFYGCDRX3230916:1:2238:3875:2503,HFYGCDRX3230916:2:2116:15628:21104,HFYGCDRX3230916:1:2106:6460:11584,HFYGCDRX3230916:2:2169:2654:19366,HFYGCDRX3230916:2:2156:20934:26944,HFYGCDRX3230916:2:2169:5556:23015,HFYGCDRX3230916:1:2176:31873:14951,HFYGCDRX3230916:1:2101:17164:33974,HG5J5DRX3230915:1:2233:19931:26991,HFYGCDRX3230916:2:2162:14642:15608,HFYGCDRX3230916:1:2211:12689:26725,HFYGCDRX3230916:2:2107:15510:12821,HFYGCDRX3230916:2:2238:4942:21136,HFYGCDRX3230916:2:2263:10149:30311,HFYGCDRX3230916:1:2154:2672:31516,HFYGCDRX3230916:1:2229:20283:35368,HFYGCDRX3230916:1:2258:22607:21762,HFYGCDRX3230916:2:2149:10294:31093,HG5J5DRX3230915:1:2232:14055:9925,HFYGCDRX3230916:1:2177:21612:21418,HFYGCDRX3230916:1:2131:14380:25614,HFYGCDRX3230916:2:2151:15763:28197,HFYGCDRX3230916:1:2144:6027:8547,HFYGCDRX3230916:1:2220:9281:10207,HFYGCDRX3230916:2:2272:10954:33113,HFYGCDRX3230916:1:2174:25681:30311,HG5J5DRX3230915:1:2161:27335:30452,HFYGCDRX3230916:1:2165:11071:13526,HFYGCDRX3230916:2:2224:2564:4648,HFYGCDRX3230916:1:2148:6234:15201,HG5J5DRX3230915:1:2160:6542:2832,HFYGCDRX3230916:1:2166:18475:1548,HFYGCDRX3230916:2:2231:1994:17440,HFYGCDRX3230916:2:2124:17806:11819,HFYGCDRX3230916:2:2228:16215:4867,HG5J5DRX3230915:1:2118:9634:25786,HFYGCDRX3230916:2:2128:2085:20478,HFYGCDRX3230916:2:2263:22697:7138,HFYGCDRX3230916:2:2240:19605:2096,HFYGCDRX3230916:2:2150:11180:35196,HFYGCDRX3230916:1:2216:31720:32064,HFYGCDRX3230916:1:2144:31033:34100,HFYGCDRX3230916:1:2171:14380:8390,HFYGCDRX3230916:1:2174:1154:13542,HG5J5DRX3230915:1:2122:14416:32283,HFYGCDRX3230916:1:2227:21540:29935,HFYGCDRX3230916:2:2228:22254:24815,HFYGCDRX3230916:1:2145:25617:30326,HFYGCDRX3230916:1:2213:18105:12211,HFYGCDRX3230916:1:2113:16694:11021,HFYGCDRX3230916:1:2158:18177:2816,HFYGCDRX3230916:1:2105:29405:27868,HFYGCDRX3230916:1:2265:17481:24690,HFYGCDRX3230916:2:2177:7898:13542,HFYGCDRX3230916:1:2239:4589:1517,HFYGCDRX3230916:2:2255:4670:26804,HFYGCDRX3230916:1:2155:5882:25739,HFYGCDRX3230916:2:2107:23330:6355,HFYGCDRX3230916:1:2151:21016:5008,HFYGCDRX3230916:2:2202:22064:3944,HFYGCDRX3230916:2:2161:31448:20572,HFYGCDRX3230916:1:2159:9362:31548,HFYGCDRX3230916:2:2201:32461:34131,HFYGCDRX3230916:2:2150:20338:24471,HFYGCDRX3230916:1:2158:20880:6026,HFYGCDRX3230916:2:2268:10140:3239,HFYGCDRX3230916:1:2268:4453:23359,HFYGCDRX3230916:2:2277:29767:34381,HFYGCDRX3230916:2:2110:21495:12038,HFYGCDRX3230916:1:2136:29704:8061,HFYGCDRX3230916:1:2262:1316:32957,HFYGCDRX3230916:1:2176:15013:18223,HG5J5DRX3230915:1:2155:32000:16861,HFYGCDRX3230916:2:2151:29731:8202,HFYGCDRX3230916:2:2250:32570:33285,HFYGCDRX3230916:1:2215:28438:11036,HFYGCDRX3230916:1:2238:15139:17691,HFYGCDRX3230916:1:2154:23484:7623,HFYGCDRX3230916:1:2217:16161:32268,HFYGCDRX3230916:1:2254:32063:26115,HFYGCDRX3230916:1:2165:26268:22404,HFYGCDRX3230916:2:2121:32054:9972,HFYGCDRX3230916:2:2201:19361:2174,HFYGCDRX3230916:1:2270:25572:4382,HFYGCDRX3230916:2:2246:14669:1313,HFYGCDRX3230916:1:2277:29288:25473,HG5J5DRX3230915:1:2255:30192:16642,HFYGCDRX3230916:1:2258:23556:19335,HFYGCDRX3230916:1:2168:12988:4069,HFYGCDRX3230916:2:2110:23737:7122,HFYGCDRX3230916:1:2104:20130:30780,HG5J5DRX3230915:1:2117:16740:11381,HFYGCDRX3230916:2:2232:23014:13385,HFYGCDRX3230916:1:2107:17806:18991,HFYGCDRX3230916:1:2128:1777:22044,HFYGCDRX3230916:2:2264:25536:25895,HFYGCDRX3230916:2:2104:11659:10066,HFYGCDRX3230916:2:2259:11424:3396,HFYGCDRX3230916:2:2170:10728:32127,HFYGCDRX3230916:1:2136:32443:31814,HFYGCDRX3230916:1:2176:4878:28166,HFYGCDRX3230916:1:2121:1461:11224,HFYGCDRX3230916:1:2135:11957:21355,HFYGCDRX3230916:2:2146:19135:28307,HFYGCDRX3230916:1:2257:16405:28745,HFYGCDRX3230916:1:2171:18656:28197,HFYGCDRX3230916:2:2162:17698:33677,HFYGCDRX3230916:1:2242:27977:16814,HFYGCDRX3230916:1:2254:14262:17801,HFYGCDRX3230916:2:2263:7572:21966,HG5J5DRX3230915:1:2113:5113:10003,HFYGCDRX3230916:2:2278:5222:15139,HFYGCDRX3230916:2:2146:8449:8265,HFYGCDRX3230916:2:2135:17436:31657,HFYGCDRX3230916:2:2256:15772:31814,HFYGCDRX3230916:2:2260:19678:1689,HFYGCDRX3230916:1:2276:4707:16344,HFYGCDRX3230916:1:2210:25391:24079,HFYGCDRX3230916:1:2252:5376:12618,HG5J5DRX3230915:1:2176:5077:16141,HFYGCDRX3230916:1:2150:27480:3020,HFYGCDRX3230916:1:2229:20763:32221,HFYGCDRX3230916:1:2125:24144:37043,HFYGCDRX3230916:2:2174:27823:36495,HFYGCDRX3230916:1:2221:1570:26600,HFYGCDRX3230916:1:2215:27914:13291,HFYGCDRX3230916:2:2252:9019:14043,HFYGCDRX3230916:1:2109:3007:21042,HG5J5DRX3230915:1:2230:30318:24095,HFYGCDRX3230916:1:2122:5177:12743,HFYGCDRX3230916:2:2138:16604:32659,HFYGCDRX3230916:1:2160:4770:20619,HFYGCDRX3230916:1:2222:2871:31297,HFYGCDRX3230916:1:2175:5900:18693,HFYGCDRX3230916:2:2206:16224:15718,HFYGCDRX3230916:2:2232:29884:26788,HFYGCDRX3230916:2:2217:12454:18427,HFYGCDRX3230916:2:2207:25898:29246,HG5J5DRX3230915:1:2237:24207:23375,HG5J5DRX3230915:1:2201:22824:24768,HG5J5DRX3230915:1:2138:17879:15828,HFYGCDRX3230916:1:2251:28917:22044,HFYGCDRX3230916:2:2138:26304:30232,HFYGCDRX3230916:1:2150:1090:22952,HFYGCDRX3230916:2:2101:30816:22764,HFYGCDRX3230916:1:2204:8431:2660,HFYGCDRX3230916:2:2224:10502:32111,HFYGCDRX3230916:1:2203:13042:12211,HFYGCDRX3230916:2:2275:10239:7388,HFYGCDRX3230916:1:2235:7853:30029,HFYGCDRX3230916:1:2127:22833:10567,HG5J5DRX3230915:1:2153:2383:13260,HG5J5DRX3230915:1:2207:1796:20979,HFYGCDRX3230916:1:2253:21106:31970,HFYGCDRX3230916:1:2237:16902:18051,HFYGCDRX3230916:2:2265:14145:11898,HFYGCDRX3230916:2:2237:26323:9752,HFYGCDRX3230916:1:2153:14660:22122,HFYGCDRX3230916:2:2117:9435:12383,HFYGCDRX3230916:1:2167:19298:6511,HFYGCDRX3230916:2:2158:17128:35446,HFYGCDRX3230916:1:2247:21377:26052,HFYGCDRX3230916:1:2246:6379:22811,HG5J5DRX3230915:1:2122:29658:11428,HFYGCDRX3230916:1:2130:26910:22701,HFYGCDRX3230916:2:2142:3586:1282,HFYGCDRX3230916:2:2115:16957:31485,HFYGCDRX3230916:2:2109:30924:12461,HFYGCDRX3230916:1:2143:2058:33364,HFYGCDRX3230916:2:2268:7826:22122,HFYGCDRX3230916:1:2250:4915:22592,HFYGCDRX3230916:1:2165:29631:14011,HFYGCDRX3230916:1:2227:23990:25316,HFYGCDRX3230916:1:2206:17490:5509,HG5J5DRX3230915:1:2166:13413:19492,HFYGCDRX3230916:1:2256:28619:17143,HG5J5DRX3230915:1:2201:22643:4758,HFYGCDRX3230916:1:2176:32307:27790,HFYGCDRX3230916:1:2155:4273:14121,HFYGCDRX3230916:1:2111:7265:35900,HG5J5DRX3230915:1:2255:14687:31250,HFYGCDRX3230916:1:2251:28076:30389,HFYGCDRX3230916:1:2228:2501:34945,HFYGCDRX3230916:1:2146:26765:34569,HFYGCDRX3230916:2:2156:17752:21371,HFYGCDRX3230916:1:2153:12897:4257,HG5J5DRX3230915:1:2219:16034:33959,HFYGCDRX3230916:1:2108:26368:3443,HFYGCDRX3230916:1:2129:21856:25692,HFYGCDRX3230916:1:2249:20265:9408,HFYGCDRX3230916:1:2127:10411:11443,HFYGCDRX3230916:2:2125:16731:21136,HFYGCDRX3230916:2:2150:23213:37027,HFYGCDRX3230916:2:2226:16938:9533,HFYGCDRX3230916:2:2117:11053:15812,HFYGCDRX3230916:1:2270:5638:1924,HFYGCDRX3230916:1:2120:20274:2628,HFYGCDRX3230916:2:2156:19135:14027,HG5J5DRX3230915:1:2178:9805:22138,HFYGCDRX3230916:2:2169:28655:32863,HFYGCDRX3230916:1:2109:21115:29951,HFYGCDRX3230916:2:2263:13738:25504,HFYGCDRX3230916:2:2173:32009:23046,HG5J5DRX3230915:1:2103:5963:31704,HFYGCDRX3230916:1:2236:8856:30608,HG5J5DRX3230915:1:2125:24370:35931,HFYGCDRX3230916:1:2132:7952:25567,HFYGCDRX3230916:1:2222:29866:5619,HFYGCDRX3230916:1:2111:9082:3192,HG5J5DRX3230915:1:2168:5150:2206,HFYGCDRX3230916:1:2136:14244:36808,HG5J5DRX3230915:1:2231:12617:33051,HFYGCDRX3230916:1:2263:4381:28338,HFYGCDRX3230916:1:2236:23854:10927,HFYGCDRX3230916:2:2201:8178:30530,HFYGCDRX3230916:1:2178:8187:31579,HG5J5DRX3230915:1:2269:25111:6464,HFYGCDRX3230916:1:2137:1958:17879,HFYGCDRX3230916:2:2273:25807:30123,HFYGCDRX3230916:1:2113:15329:33614,HFYGCDRX3230916:1:2153:22336:25645,HFYGCDRX3230916:1:2133:3549:31939,HFYGCDRX3230916:2:2174:1515:2675,HFYGCDRX3230916:1:2173:23565:5040,HFYGCDRX3230916:1:2221:12283:3004,HFYGCDRX3230916:2:2110:8983:20776,HFYGCDRX3230916:1:2119:15546:13354,HFYGCDRX3230916:1:2174:18484:33035,HFYGCDRX3230916:2:2119:5312:10504,HFYGCDRX3230916:1:2137:23276:6511,HFYGCDRX3230916:2:2150:13720:3991,HFYGCDRX3230916:1:2155:3188:34131,HFYGCDRX3230916:2:2115:27281:7028,HG5J5DRX3230915:1:2126:25672:15515,HFYGCDRX3230916:1:2121:27263:8406,HFYGCDRX3230916:1:2170:8061:27853,HFYGCDRX3230916:1:2208:16468:20337,HFYGCDRX3230916:1:2235:19425:8046,HFYGCDRX3230916:2:2144:31575:15687,HFYGCDRX3230916:1:2243:25102:15562,HFYGCDRX3230916:1:2165:24442:15546,HFYGCDRX3230916:1:2173:26449:27821,HFYGCDRX3230916:1:2254:4119:25974,HFYGCDRX3230916:1:2152:16396:22780,HFYGCDRX3230916:1:2213:12337:20854,HFYGCDRX3230916:2:2247:17354:17550,HG5J5DRX3230915:1:2226:2763:9157,HFYGCDRX3230916:1:2278:18575:33943,HFYGCDRX3230916:2:2132:6912:21073,HFYGCDRX3230916:1:2124:15311:30264,HFYGCDRX3230916:1:2220:15863:16720,HFYGCDRX3230916:2:2217:17779:31093,HFYGCDRX3230916:2:2243:1127:6292,HFYGCDRX3230916:2:2236:29894:31438,HFYGCDRX3230916:2:2136:4707:15217,HG5J5DRX3230915:1:2167:12310:11694,HFYGCDRX3230916:2:2243:28863:9079,HG5J5DRX3230915:1:2163:17002:8265,HFYGCDRX3230916:1:2218:24460:10097,HFYGCDRX3230916:2:2117:17047:24627,HFYGCDRX3230916:1:2135:28194:28682,HFYGCDRX3230916:1:2223:8088:29309,HFYGCDRX3230916:1:2107:24270:3787,HFYGCDRX3230916:1:2149:13575:7592,HFYGCDRX3230916:1:2237:19958:5650,HFYGCDRX3230916:2:2137:2682:7827,HFYGCDRX3230916:2:2241:16667:3928,HFYGCDRX3230916:1:2229:32398:12101,HFYGCDRX3230916:1:2128:28402:1141,HFYGCDRX3230916:1:2205:25238:33395,HFYGCDRX3230916:1:2247:1470:12680,HFYGCDRX3230916:1:2277:17598:31532,HFYGCDRX3230916:1:2246:13304:12790,HFYGCDRX3230916:1:2249:28637:17018,HFYGCDRX3230916:2:2176:28565:2832,HFYGCDRX3230916:2:2125:21151:22529,HFYGCDRX3230916:1:2146:16179:14763,HFYGCDRX3230916:2:2128:31033:5259,HFYGCDRX3230916:1:2158:25183:7811,HFYGCDRX3230916:1:2157:2627:22983,HFYGCDRX3230916:1:2122:17888:15405,HG5J5DRX3230915:1:2160:19741:20337,HG5J5DRX3230915:1:2202:18701:4507,HG5J5DRX3230915:1:2243:9173:5822,HFYGCDRX3230916:2:2130:3803:25739,HFYGCDRX3230916:1:2274:31684:17221,HFYGCDRX3230916:1:2136:29080:7294,HFYGCDRX3230916:1:2161:18819:23469,HFYGCDRX3230916:1:2145:29559:25347,HFYGCDRX3230916:1:2259:3983:36229,HFYGCDRX3230916:1:2216:4743:10676,HFYGCDRX3230916:1:2157:28013:29496,HFYGCDRX3230916:2:2206:26901:33176,HFYGCDRX3230916:2:2163:14416:32315,HFYGCDRX3230916:1:2204:7328:26396,HFYGCDRX3230916:1:2207:28194:18317,HFYGCDRX3230916:1:2143:18656:13698,HFYGCDRX3230916:2:2103:1208:7560,HFYGCDRX3230916:1:2132:11189:18114,HFYGCDRX3230916:1:2121:12707:12665,HFYGCDRX3230916:2:2108:9733:9173,HFYGCDRX3230916:2:2262:20645:5995,HFYGCDRX3230916:1:2128:12689:8531,HFYGCDRX3230916:2:2256:10737:9565,HFYGCDRX3230916:1:2143:30165:19758,HFYGCDRX3230916:1:2222:10276:6856,HFYGCDRX3230916:1:2133:27588:28416,HFYGCDRX3230916:1:2143:12527:12132,HFYGCDRX3230916:1:2107:8784:15796,HFYGCDRX3230916:1:2169:18792:20353,HFYGCDRX3230916:1:2228:32099:5541,HFYGCDRX3230916:2:2177:30454:25614,HG5J5DRX3230915:1:2115:12979:26819,HFYGCDRX3230916:1:2101:30517:21151,HG5J5DRX3230915:1:2122:1533:11036,HFYGCDRX3230916:2:2135:30508:23015,HFYGCDRX3230916:1:2234:7374:16391,HFYGCDRX3230916:1:2252:1389:3740,HFYGCDRX3230916:1:2118:7943:28714,HFYGCDRX3230916:2:2114:2709:5087,HFYGCDRX3230916:1:2139:25554:25582,HFYGCDRX3230916:2:2139:15845:10708,HFYGCDRX3230916:1:2217:11125:24330,HG5J5DRX3230915:1:2237:30779:9706,HFYGCDRX3230916:2:2159:26368:16752,HFYGCDRX3230916:2:2205:17445:28823,HFYGCDRX3230916:2:2134:8983:6245,HFYGCDRX3230916:2:2256:12997:31798,HFYGCDRX3230916:1:2138:14778:6386,HFYGCDRX3230916:1:2170:24650:1501,HFYGCDRX3230916:1:2213:2962:12821,HFYGCDRX3230916:2:2163:6867:30702,HFYGCDRX3230916:2:2131:10954:30170,HFYGCDRX3230916:1:2152:20889:30718,HFYGCDRX3230916:2:2106:10637:8140,HFYGCDRX3230916:2:2126:5611:6230,HFYGCDRX3230916:1:2240:3667:17926,HFYGCDRX3230916:1:2119:10628:34053,HFYGCDRX3230916:1:2231:24478:9565,HG5J5DRX3230915:1:2231:4698:25692,HFYGCDRX3230916:2:2102:32307:8375,HFYGCDRX3230916:1:2115:18186:6370,HFYGCDRX3230916:1:2259:25581:14043,HFYGCDRX3230916:1:2208:16242:7576,HFYGCDRX3230916:2:2256:31864:28025,HFYGCDRX3230916:1:2213:10710:10394,HFYGCDRX3230916:1:2253:29749:24925,HFYGCDRX3230916:1:2130:11180:1939,HFYGCDRX3230916:1:2277:10646:5149,HFYGCDRX3230916:2:2219:15664:4038,HFYGCDRX3230916:1:2252:31141:24643,HFYGCDRX3230916:1:2218:6931:30279,HFYGCDRX3230916:1:2206:28718:4038,HFYGCDRX3230916:1:2129:8296:3208,HFYGCDRX3230916:1:2277:7392:17989,HFYGCDRX3230916:1:2162:17653:27367,HFYGCDRX3230916:2:2138:7374:27978,HFYGCDRX3230916:1:2222:26847:16799,HFYGCDRX3230916:1:2228:23140:29324,HFYGCDRX3230916:1:2142:25916:18035,HFYGCDRX3230916:1:2151:20763:23359,HFYGCDRX3230916:2:2101:13973:33802,HFYGCDRX3230916:1:2102:9046:6887,HG5J5DRX3230915:1:2237:12364:36401,HFYGCDRX3230916:2:2134:1380:1313,HFYGCDRX3230916:1:2276:1732:10755,HFYGCDRX3230916:1:2207:27615:6324,HFYGCDRX3230916:1:2274:26973:11819,HFYGCDRX3230916:2:2276:10113:15969,HFYGCDRX3230916:2:2171:28980:5932,HFYGCDRX3230916:2:2140:22399:33959,HFYGCDRX3230916:1:2114:15465:10081,HFYGCDRX3230916:2:2231:18466:23985,HFYGCDRX3230916:1:2242:14588:7435,HFYGCDRX3230916:1:2157:5602:19085,HFYGCDRX3230916:1:2205:10502:18114,HFYGCDRX3230916:1:2209:11912:12038,HFYGCDRX3230916:1:2131:25753:15875,HFYGCDRX3230916:2:2202:27453:34882,HFYGCDRX3230916:2:2227:4797:8202,HFYGCDRX3230916:1:2219:2672:17394,HFYGCDRX3230916:2:2167:17300:18176,HFYGCDRX3230916:1:2175:7120:35117,HFYGCDRX3230916:1:2171:6587:24236,HFYGCDRX3230916:1:2139:26087:26663,HFYGCDRX3230916:2:2163:19840:1720,HFYGCDRX3230916:1:2101:22679:10614,HFYGCDRX3230916:1:2204:21757:24893,HFYGCDRX3230916:2:2247:10357:24439,HFYGCDRX3230916:2:2145:20880:28166,HFYGCDRX3230916:2:2132:29613:3302,HFYGCDRX3230916:1:2127:19958:1141,HFYGCDRX3230916:2:2153:21811:31814,HFYGCDRX3230916:1:2257:15221:11694,HFYGCDRX3230916:2:2119:11767:19241,HFYGCDRX3230916:2:2257:26675:10081,HFYGCDRX3230916:1:2203:2076:5963,HG5J5DRX3230915:1:2168:5493:12038,HG5J5DRX3230915:1:2176:18213:27931,HG5J5DRX3230915:1:2216:28149:11475,HFYGCDRX3230916:2:2133:20880:6590,HFYGCDRX3230916:1:2177:9760:25598,HFYGCDRX3230916:2:2215:22272:31203,HFYGCDRX3230916:1:2278:21630:17691,HG5J5DRX3230915:1:2136:15076:13416,HFYGCDRX3230916:1:2262:8567:20212,HFYGCDRX3230916:2:2146:22643:6543,HFYGCDRX3230916:1:2161:26106:21308,HFYGCDRX3230916:1:2267:14036:22107,HFYGCDRX3230916:2:2130:22589:29246,HFYGCDRX3230916:1:2133:12057:17926,HFYGCDRX3230916:1:2262:17951:36714,HFYGCDRX3230916:1:2245:14787:34272,HFYGCDRX3230916:1:2114:24189:9095,HFYGCDRX3230916:1:2170:22028:32252,HFYGCDRX3230916:1:2106:25165:27445,HG5J5DRX3230915:1:2162:10041:20071,HFYGCDRX3230916:2:2153:7211:21903,HFYGCDRX3230916:1:2150:4309:7482,HFYGCDRX3230916:2:2152:7184:11866,HFYGCDRX3230916:2:2232:32081:27962,HFYGCDRX3230916:1:2245:24071:1470,HFYGCDRX3230916:1:2109:2166:20682,HFYGCDRX3230916:2:2269:13675:6230,HFYGCDRX3230916:1:2266:13277:15123,HFYGCDRX3230916:2:2239:22959:34585,HFYGCDRX3230916:2:2120:3351:31062,HFYGCDRX3230916:2:2221:32108:12602,HFYGCDRX3230916:1:2230:4896:29136,HFYGCDRX3230916:1:2151:22345:10880,HFYGCDRX3230916:2:2137:29460:9737,HFYGCDRX3230916:1:2162:12689:26005,HFYGCDRX3230916:2:2212:28375:30436,HFYGCDRX3230916:2:2101:10321:15828,HFYGCDRX3230916:1:2233:13593:36057,HG5J5DRX3230915:1:2130:15013:28432,HFYGCDRX3230916:1:2265:10529:12085,HFYGCDRX3230916:1:2112:15691:20776,HFYGCDRX3230916:2:2126:5258:6057,HFYGCDRX3230916:2:2270:2573:33129,HFYGCDRX3230916:2:2248:9507:33927,HFYGCDRX3230916:1:2223:9146:29074,HFYGCDRX3230916:1:2207:18502:30499,HFYGCDRX3230916:2:2177:27697:18834,HG5J5DRX3230915:1:2229:10194:31391,HFYGCDRX3230916:2:2111:13874:7545,HFYGCDRX3230916:1:2257:18177:30060,HFYGCDRX3230916:1:2139:26051:7373,HG5J5DRX3230915:1:2216:2184:10003,HFYGCDRX3230916:1:2243:28736:10207,HFYGCDRX3230916:2:2227:13702:34741,HFYGCDRX3230916:2:2264:23836:13275,HFYGCDRX3230916:1:2223:10628:17989,HFYGCDRX3230916:1:2269:29921:7310,HFYGCDRX3230916:2:2203:23809:30514,HFYGCDRX3230916:2:2238:3369:31156,HG5J5DRX3230915:1:2227:17228:4147,HFYGCDRX3230916:1:2253:22779:23312,HFYGCDRX3230916:1:2136:22724:36338,HFYGCDRX3230916:2:2115:10104:3834,HFYGCDRX3230916:1:2259:27670:15906,HFYGCDRX3230916:2:2220:18837:25222,HFYGCDRX3230916:1:2101:21025:34867,HFYGCDRX3230916:1:2147:22860:19225,HFYGCDRX3230916:1:2278:17888:24768,HG5J5DRX3230915:1:2134:21133:9627,HFYGCDRX3230916:2:2202:30065:19617,HFYGCDRX3230916:1:2233:16125:36057,HFYGCDRX3230916:1:2261:17237:9267,HFYGCDRX3230916:1:2213:31620:33176,HFYGCDRX3230916:1:2152:19063:23735,HFYGCDRX3230916:1:2127:22996:2268,HFYGCDRX3230916:1:2218:17761:18474,HFYGCDRX3230916:2:2163:18783:25535,HFYGCDRX3230916:1:2260:11822:29919,HFYGCDRX3230916:2:2121:14362:4977,HFYGCDRX3230916:2:2117:26431:15358,HFYGCDRX3230916:1:2147:5204:29418,HFYGCDRX3230916:1:2137:28736:27211,HFYGCDRX3230916:2:2137:25870:35869,HFYGCDRX3230916:1:2271:4553:22185,HFYGCDRX3230916:2:2166:30418:23390,HG5J5DRX3230915:1:2153:25617:5368,HFYGCDRX3230916:2:2163:25283:20008,HFYGCDRX3230916:2:2110:2935:17347,HFYGCDRX3230916:2:2101:20961:27273,HG5J5DRX3230915:1:2133:6949:18129,HFYGCDRX3230916:2:2257:22073:17300,HFYGCDRX3230916:1:2276:7798:18662,HFYGCDRX3230916:2:2205:21504:22107,HFYGCDRX3230916:2:2241:10068:2832,HFYGCDRX3230916:1:2234:5791:14465,HFYGCDRX3230916:1:2224:4417:34006,HFYGCDRX3230916:1:2123:5945:8343,HFYGCDRX3230916:2:2277:26549:3975,HFYGCDRX3230916:1:2242:25192:18192,HFYGCDRX3230916:2:2112:29686:2456,HG5J5DRX3230915:1:2134:6081:33849,HFYGCDRX3230916:1:2217:6090:32706,HFYGCDRX3230916:1:2114:11767:5368,HFYGCDRX3230916:1:2224:10936:24533,HFYGCDRX3230916:1:2124:30969:21465,HFYGCDRX3230916:2:2167:8947:11287,HFYGCDRX3230916:1:2112:17255:25614,HFYGCDRX3230916:2:2211:21992:31093,HFYGCDRX3230916:2:2107:18340:25144,HFYGCDRX3230916:2:2122:7355:25347,HFYGCDRX3230916:1:2148:13214:30639,HFYGCDRX3230916:1:2145:30463:16485,HFYGCDRX3230916:1:2178:29188:22827,HG5J5DRX3230915:1:2175:25635:6151,HFYGCDRX3230916:1:2106:25934:36135,HFYGCDRX3230916:2:2142:7916:35493,HFYGCDRX3230916:1:2154:22101:36166,HFYGCDRX3230916:2:2137:2917:18004,HFYGCDRX3230916:1:2233:29387:14747,HFYGCDRX3230916:1:2120:10239:15593,HFYGCDRX3230916:1:2232:26241:5509,HG5J5DRX3230915:1:2263:27471:20791,HG5J5DRX3230915:1:2251:7184:15060,HFYGCDRX3230916:1:2225:21748:31078,HFYGCDRX3230916:2:2225:21829:33880,HFYGCDRX3230916:2:2214:9959:11162,HG5J5DRX3230915:1:2255:25608:32722,HFYGCDRX3230916:2:2175:5358:23516,HFYGCDRX3230916:2:2230:27263:35712,HFYGCDRX3230916:2:2118:6045:32878,HFYGCDRX3230916:1:2157:9010:33599,HFYGCDRX3230916:2:2231:31720:24424,HFYGCDRX3230916:2:2261:1579:11115,HG5J5DRX3230915:1:2267:28013:9925,HG5J5DRX3230915:1:2141:13684:2769,HG5J5DRX3230915:1:2164:11650:28025,HFYGCDRX3230916:1:2249:25003:4398,HG5J5DRX3230915:1:2264:5638:9909,HFYGCDRX3230916:2:2206:2302:28244,HFYGCDRX3230916:1:2132:9588:26929,HFYGCDRX3230916:1:2176:14832:13777,HFYGCDRX3230916:1:2103:27570:34397,HFYGCDRX3230916:1:2160:29496:12211,HFYGCDRX3230916:2:2165:16052:8343,HFYGCDRX3230916:2:2205:4237:13526,HFYGCDRX3230916:1:2239:10239:16250,HFYGCDRX3230916:1:2276:24505:6292,HFYGCDRX3230916:2:2163:9833:29543,HFYGCDRX3230916:2:2109:6506:33990,HFYGCDRX3230916:1:2105:24044:24909,HFYGCDRX3230916:1:2122:6063:20447,HFYGCDRX3230916:2:2274:20790:13072,HFYGCDRX3230916:2:2234:15347:2581,HFYGCDRX3230916:1:2212:16043:22576,HFYGCDRX3230916:2:2155:12274:4867,HFYGCDRX3230916:1:2220:15835:33019,HG5J5DRX3230915:1:2252:25156:8328,HFYGCDRX3230916:1:2155:17201:7576,HG5J5DRX3230915:1:2165:28989:8202,HFYGCDRX3230916:2:2160:12237:8625,HFYGCDRX3230916:1:2135:8115:14262,HFYGCDRX3230916:1:2264:5972:36072,HFYGCDRX3230916:1:2169:31403:17143,HFYGCDRX3230916:1:2123:16758:22905,HFYGCDRX3230916:2:2156:22173:14810,HG5J5DRX3230915:1:2109:5909:1767,HFYGCDRX3230916:2:2170:5882:33505,HFYGCDRX3230916:2:2148:19018:33865,HFYGCDRX3230916:2:2218:27190:9596,HFYGCDRX3230916:2:2169:14470:23578,HFYGCDRX3230916:2:2220:20844:28667,HG5J5DRX3230915:1:2207:10221:6324,HFYGCDRX3230916:1:2157:9815:28823,HFYGCDRX3230916:2:2167:29306:29637,HFYGCDRX3230916:2:2130:30617:2785,HFYGCDRX3230916:1:2143:28510:2801,HFYGCDRX3230916:2:2238:29912:10363,HFYGCDRX3230916:1:2257:22779:24721,HFYGCDRX3230916:2:2139:10185:33536,HFYGCDRX3230916:1:2160:12970:21699,HFYGCDRX3230916:2:2252:12590:36949,HG5J5DRX3230915:1:2111:30526:1658,HFYGCDRX3230916:1:2132:22092:11506,HFYGCDRX3230916:1:2169:15492:6934,HFYGCDRX3230916:2:2109:11975:22013,HG5J5DRX3230915:1:2242:27534:20275,HFYGCDRX3230916:2:2231:16251:6277,HFYGCDRX3230916:2:2126:12292:25629,HFYGCDRX3230916:1:2271:31241:12195,HFYGCDRX3230916:1:2114:30418:28056,HFYGCDRX3230916:1:2134:16803:25958,HFYGCDRX3230916:1:2145:19506:14575,HFYGCDRX3230916:1:2175:24135:15890,HFYGCDRX3230916:2:2243:20076:19038,HFYGCDRX3230916:2:2147:15004:11318,HG5J5DRX3230915:1:2233:7274:26396,HG5J5DRX3230915:1:2129:8874:16203,HFYGCDRX3230916:2:2143:5502:31125,HFYGCDRX3230916:2:2205:30346:16344,HFYGCDRX3230916:2:2158:6488:22060,HFYGCDRX3230916:2:2223:16785:35102,HFYGCDRX3230916:2:2140:14344:5697,HFYGCDRX3230916:1:2166:15582:23719,HG5J5DRX3230915:1:2228:14624:13322,HFYGCDRX3230916:1:2213:31765:22153,HFYGCDRX3230916:2:2177:16559:22467,HFYGCDRX3230916:2:2266:22010:9142,HFYGCDRX3230916:2:2121:15212:23547,HFYGCDRX3230916:2:2258:21142:2002,HFYGCDRX3230916:2:2246:12400:1485,HFYGCDRX3230916:1:2173:21160:26365,HFYGCDRX3230916:1:2176:19425:36166,HFYGCDRX3230916:1:2116:30933:14763,HFYGCDRX3230916:2:2255:17734:11381,HFYGCDRX3230916:2:2221:14145:35884,HFYGCDRX3230916:2:2266:20175:1673,HFYGCDRX3230916:2:2158:20247:36620,HFYGCDRX3230916:1:2216:1244:15546,HFYGCDRX3230916:1:2147:15808:31501,HFYGCDRX3230916:2:2257:10077:17660,HFYGCDRX3230916:1:2228:10086:34240,HG5J5DRX3230915:1:2244:25174:32910,HFYGCDRX3230916:1:2162:13575:2425,HFYGCDRX3230916:2:2215:27028:35869,HFYGCDRX3230916:1:2262:4508:9612,HFYGCDRX3230916:2:2239:9001:7623,HFYGCDRX3230916:2:2217:3965:14278,HFYGCDRX3230916:1:2124:15076:28291,HFYGCDRX3230916:1:2173:7238:13745,HFYGCDRX3230916:2:2137:30789:5055,HFYGCDRX3230916:2:2137:23547:3380,HFYGCDRX3230916:2:2116:26476:30937,HFYGCDRX3230916:1:2161:28836:32080,HFYGCDRX3230916:1:2228:25030:34287,HFYGCDRX3230916:1:2121:28971:27336,HFYGCDRX3230916:2:2256:8947:31454,HFYGCDRX3230916:1:2209:32072:34679,HFYGCDRX3230916:1:2128:28284:32127,HFYGCDRX3230916:1:2142:8160:17691,HFYGCDRX3230916:2:2101:5312:15828,HFYGCDRX3230916:2:2231:26503:27508,HFYGCDRX3230916:1:2143:28917:12023,HFYGCDRX3230916:2:2247:26666:31673,HFYGCDRX3230916:1:2235:10095:2942,HFYGCDRX3230916:1:2124:12409:17942,HFYGCDRX3230916:2:2151:28067:7921,HFYGCDRX3230916:1:2239:10086:16736,HFYGCDRX3230916:2:2138:25066:13056,HG5J5DRX3230915:1:2241:19009:15342,HFYGCDRX3230916:1:2223:2971:7326,HFYGCDRX3230916:2:2104:2293:33395,HFYGCDRX3230916:1:2235:11930:33113,HFYGCDRX3230916:2:2118:3522:30953,HG5J5DRX3230915:1:2234:11758:30812,HFYGCDRX3230916:1:2142:3595:22874,HFYGCDRX3230916:1:2231:7654:24111,HFYGCDRX3230916:2:2212:32705:28855,HFYGCDRX3230916:1:2244:19886:25003,HFYGCDRX3230916:1:2174:12572:26240,HFYGCDRX3230916:2:2141:12798:19742,HFYGCDRX3230916:2:2210:6696:20979,HFYGCDRX3230916:2:2160:3920:6277,HFYGCDRX3230916:2:2166:3540:18615,HFYGCDRX3230916:2:2122:11849:10207,HFYGCDRX3230916:2:2237:31421:11287,HFYGCDRX3230916:2:2157:8034:22200,HFYGCDRX3230916:1:2157:13774:12696,HFYGCDRX3230916:2:2211:10529:10582,HFYGCDRX3230916:2:2109:3586:16313,HFYGCDRX3230916:2:2203:4453:1251,HFYGCDRX3230916:2:2166:3640:22921,HFYGCDRX3230916:1:2212:30662:8688,HG5J5DRX3230915:1:2258:17192:25974,HFYGCDRX3230916:1:2216:20672:1188,HFYGCDRX3230916:2:2176:9543:2300,HFYGCDRX3230916:2:2237:20356:18051,HFYGCDRX3230916:1:2128:21712:2174,HFYGCDRX3230916:2:2244:5339:14810,HFYGCDRX3230916:1:2251:31928:16548,HFYGCDRX3230916:2:2109:19750:6261,HFYGCDRX3230916:2:2261:31331:5995,HFYGCDRX3230916:1:2146:7844:13667,HG5J5DRX3230915:1:2221:13630:13823,HFYGCDRX3230916:1:2263:2320:18537,HFYGCDRX3230916:2:2271:27624:17268,HFYGCDRX3230916:1:2262:22525:29857,HFYGCDRX3230916:1:2239:8793:22263,HG5J5DRX3230915:1:2167:22281:31281,HFYGCDRX3230916:2:2121:13494:35070,HFYGCDRX3230916:2:2171:10041:28150,HFYGCDRX3230916:1:2206:20627:15890,HFYGCDRX3230916:2:2240:17002:33285,HFYGCDRX3230916:2:2250:15501:25207,HFYGCDRX3230916:1:2215:17300:32675,HFYGCDRX3230916:1:2232:16685:21433,HFYGCDRX3230916:1:2225:24388:9345,HFYGCDRX3230916:1:2223:1316:6934,HFYGCDRX3230916:1:2255:1416:4820,HFYGCDRX3230916:1:2125:3477:1564,HFYGCDRX3230916:1:2159:19244:16595,HFYGCDRX3230916:1:2209:23457:15468,HFYGCDRX3230916:1:2107:8088:34225,HG5J5DRX3230915:1:2130:28827:26991,HFYGCDRX3230916:1:2173:19614:5368,HFYGCDRX3230916:1:2120:27380:33724,HFYGCDRX3230916:2:2207:1380:1125,HFYGCDRX3230916:1:2264:3631:4805,HFYGCDRX3230916:2:2251:3314:12273,HFYGCDRX3230916:1:2114:22001:20337,HFYGCDRX3230916:2:2231:14841:27665,HFYGCDRX3230916:1:2228:27254:5321,HFYGCDRX3230916:1:2266:25220:28917,HFYGCDRX3230916:2:2120:24306:33974,HFYGCDRX3230916:1:2160:15962:33364,HG5J5DRX3230915:1:2145:14687:28902,HFYGCDRX3230916:1:2104:17861:27946,HFYGCDRX3230916:2:2105:12165:27477,HFYGCDRX3230916:1:2103:23095:9267,HFYGCDRX3230916:2:2161:16143:13291,HFYGCDRX3230916:2:2148:5303:19413,HFYGCDRX3230916:2:2222:23204:11365,HFYGCDRX3230916:2:2110:7961:15937,HFYGCDRX3230916:1:2121:20672:7607,HFYGCDRX3230916:1:2118:7229:16830,HFYGCDRX3230916:1:2238:23285:11788,HFYGCDRX3230916:1:2136:28402:11036,HFYGCDRX3230916:1:2109:25427:34914,HFYGCDRX3230916:1:2105:26042:13589,HFYGCDRX3230916:2:2206:28872:30859,HFYGCDRX3230916:1:2137:29749:35258,HFYGCDRX3230916:2:2251:7672:1814,HG5J5DRX3230915:1:2235:3351:30436,HFYGCDRX3230916:2:2158:30147:24236,HFYGCDRX3230916:1:2141:3911:19445,HFYGCDRX3230916:1:2256:6316:33254,HFYGCDRX3230916:1:2256:28845:36824,HG5J5DRX3230915:1:2202:3830:15452,HFYGCDRX3230916:1:2110:3125:19116,HFYGCDRX3230916:1:2116:27841:35994,HFYGCDRX3230916:1:2248:9977:35368,HFYGCDRX3230916:1:2274:21269:20290,HFYGCDRX3230916:2:2158:1976:29778,HFYGCDRX3230916:1:2228:6985:34194,HFYGCDRX3230916:2:2260:16884:12414,HG5J5DRX3230915:1:2130:32687:15327,HFYGCDRX3230916:1:2264:21495:14011,HFYGCDRX3230916:1:2162:5629:31657,HFYGCDRX3230916:2:2263:16613:31328,HFYGCDRX3230916:2:2163:1714:20838,HFYGCDRX3230916:2:2158:9796:10473,HFYGCDRX3230916:2:2244:25066:32221,HG5J5DRX3230915:1:2134:22896:9549,HFYGCDRX3230916:1:2105:2365:3427,HFYGCDRX3230916:2:2203:21052:2848,HFYGCDRX3230916:1:2121:5385:27383,HFYGCDRX3230916:1:2108:19425:36479,HFYGCDRX3230916:2:2124:28284:32784,HFYGCDRX3230916:1:2245:24252:26991,HFYGCDRX3230916:1:2240:16450:10880,HFYGCDRX3230916:1:2162:18050:11397,HFYGCDRX3230916:1:2231:20292:16219,HFYGCDRX3230916:2:2142:27561:13745,HFYGCDRX3230916:1:2211:25536:10457,HFYGCDRX3230916:1:2111:5150:18740,HFYGCDRX3230916:1:2217:10529:19319,HFYGCDRX3230916:1:2134:6967:11490,HFYGCDRX3230916:1:2277:13783:5541,HFYGCDRX3230916:2:2128:13078:3004,HFYGCDRX3230916:2:2272:25039:20306,HFYGCDRX3230916:1:2158:14371:3239,HFYGCDRX3230916:1:2146:6433:14575,HFYGCDRX3230916:1:2272:10565:15280,HFYGCDRX3230916:2:2103:26964:4977,HG5J5DRX3230915:1:2162:24325:7200,HFYGCDRX3230916:2:2171:16667:17707,HFYGCDRX3230916:1:2155:3757:4085,HFYGCDRX3230916:1:2167:22959:32706,HFYGCDRX3230916:2:2103:20085:22498,HFYGCDRX3230916:2:2237:12943:30765,HFYGCDRX3230916:1:2243:4725:11898,HFYGCDRX3230916:2:2162:20925:3004,HFYGCDRX3230916:1:2252:1425:25504,HFYGCDRX3230916:1:2238:32452:24752,HG5J5DRX3230915:1:2261:5692:36464,HFYGCDRX3230916:1:2176:23059:5979,HG5J5DRX3230915:1:2137:8332:30859,HFYGCDRX3230916:2:2143:28863:25457,HFYGCDRX3230916:1:2201:15411:11835,HFYGCDRX3230916:1:2107:1235:31720,HFYGCDRX3230916:1:2163:28917:5885,HFYGCDRX3230916:1:2255:1199:33129,HG5J5DRX3230915:1:2204:32172:28150,HFYGCDRX3230916:2:2130:5954:11772,HFYGCDRX3230916:1:2238:17137:18584,HFYGCDRX3230916:1:2157:12924:4398,HG5J5DRX3230915:1:2147:4029:21496,HFYGCDRX3230916:1:2102:20030:21934,HFYGCDRX3230916:1:2131:28357:29152,HFYGCDRX3230916:2:2120:25427:36573,HG5J5DRX3230915:1:2175:32488:25567,HFYGCDRX3230916:2:2210:21703:35352,HFYGCDRX3230916:1:2227:30445:29825,HG5J5DRX3230915:1:2178:23086:28729,HG5J5DRX3230915:1:2231:3577:32205,HFYGCDRX3230916:1:2153:5502:26553,HFYGCDRX3230916:1:2271:27796:31344,HG5J5DRX3230915:1:2138:9001:35650,HFYGCDRX3230916:2:2256:30816:12837,HFYGCDRX3230916:1:2224:22959:19116,HFYGCDRX3230916:1:2131:8169:1892,HFYGCDRX3230916:2:2247:1443:4116,HFYGCDRX3230916:1:2137:13747:27336,HFYGCDRX3230916:1:2171:25482:16063,HFYGCDRX3230916:2:2106:11089:7388,HFYGCDRX3230916:1:2131:6578:19241,HFYGCDRX3230916:1:2160:9299:22858,HFYGCDRX3230916:1:2235:10682:33614,HFYGCDRX3230916:1:2236:10710:30217,HFYGCDRX3230916:1:2163:14416:16532,HFYGCDRX3230916:2:2106:13114:36636,HFYGCDRX3230916:2:2217:11677:21433,HFYGCDRX3230916:2:2162:9860:31375,HFYGCDRX3230916:1:2236:25681:33066,HFYGCDRX3230916:2:2127:1777:27085,HFYGCDRX3230916:1:2111:28926:16141,HFYGCDRX3230916:2:2126:24840:16924,HFYGCDRX3230916:1:2201:3821:3756,HFYGCDRX3230916:1:2246:24985:23876,HFYGCDRX3230916:1:2111:23095:14559,HFYGCDRX3230916:2:2239:22869:14920,HG5J5DRX3230915:1:2148:2555:36730,HFYGCDRX3230916:1:2138:15971:35509,HFYGCDRX3230916:1:2106:4508:5259,HFYGCDRX3230916:2:2162:11189:10379,HFYGCDRX3230916:1:2129:20898:11976,HFYGCDRX3230916:2:2134:14552:9157,HFYGCDRX3230916:1:2111:18141:9017,HFYGCDRX3230916:2:2226:4010:25911,HFYGCDRX3230916:1:2228:2691:7905,HFYGCDRX3230916:2:2150:7039:35916,HFYGCDRX3230916:2:2106:24279:4053,HFYGCDRX3230916:1:2217:2944:9064,HFYGCDRX3230916:1:2202:19135:28181,HFYGCDRX3230916:1:2133:6569:29778,HFYGCDRX3230916:2:2267:24279:10191,HG5J5DRX3230915:1:2221:21468:28682,HFYGCDRX3230916:1:2215:4001:31720,HFYGCDRX3230916:2:2140:7328:10551,HG5J5DRX3230915:1:2146:14136:35368,HFYGCDRX3230916:2:2262:31765:29356,HFYGCDRX3230916:1:2262:15076:27477,HFYGCDRX3230916:1:2107:31629:31407,HFYGCDRX3230916:1:2155:29116:4789,HG5J5DRX3230915:1:2262:10899:27508,HFYGCDRX3230916:2:2107:27525:2785,HFYGCDRX3230916:1:2137:4354:21151,HFYGCDRX3230916:1:2201:15664:36824,HFYGCDRX3230916:1:2115:6189:30937,HFYGCDRX3230916:2:2172:1515:9157,HFYGCDRX3230916:2:2206:8305:8703,HFYGCDRX3230916:1:2138:10429:23876,HFYGCDRX3230916:1:2271:4372:17738,HFYGCDRX3230916:2:2242:14751:16799,HFYGCDRX3230916:2:2139:26404:31375,HG5J5DRX3230915:1:2114:1796:16031,HFYGCDRX3230916:1:2113:3097:26021,HFYGCDRX3230916:1:2141:21658:15201,HG5J5DRX3230915:1:2273:21784:2300,HFYGCDRX3230916:1:2129:30291:28369,HFYGCDRX3230916:2:2162:25427:35227,HFYGCDRX3230916:1:2142:2257:23343,HFYGCDRX3230916:1:2230:24225:17957,HFYGCDRX3230916:1:2203:24514:1892,HFYGCDRX3230916:2:2241:16369:32878,HFYGCDRX3230916:1:2243:12698:29027,HG5J5DRX3230915:1:2204:11577:11146,HFYGCDRX3230916:2:2109:23873:20102,HG5J5DRX3230915:1:2127:3622:12618,HG5J5DRX3230915:1:2164:19569:14935,HFYGCDRX3230916:1:2120:23158:11631,HFYGCDRX3230916:1:2268:16360:34303,HFYGCDRX3230916:1:2246:15962:36965,HFYGCDRX3230916:1:2145:30418:22294,HFYGCDRX3230916:2:2213:4363:4820,HFYGCDRX3230916:2:2217:13738:24502,HFYGCDRX3230916:1:2246:2510:10003,HFYGCDRX3230916:1:2128:25446:18380,HFYGCDRX3230916:1:2238:7229:21997,HG5J5DRX3230915:1:2145:13955:16673,HFYGCDRX3230916:1:2119:1723:12680,HFYGCDRX3230916:2:2222:4815:1939,HFYGCDRX3230916:2:2233:19633:18646,HFYGCDRX3230916:2:2249:25491:33896,HFYGCDRX3230916:2:2209:30346:13119,HFYGCDRX3230916:2:2146:16125:12038,HFYGCDRX3230916:2:2111:26124:30232,HFYGCDRX3230916:2:2113:10465:31234,HFYGCDRX3230916:1:2273:18421:23343,HFYGCDRX3230916:1:2129:20464:36338,HFYGCDRX3230916:1:2104:18873:23187,HFYGCDRX3230916:1:2165:32868:28260,HFYGCDRX3230916:1:2224:30355:18145,HG5J5DRX3230915:1:2222:3667:26537,HG5J5DRX3230915:1:2265:11532:4554,HFYGCDRX3230916:2:2230:20654:10927,HG5J5DRX3230915:1:2216:1145:4225,HFYGCDRX3230916:1:2168:8359:32346,HFYGCDRX3230916:1:2238:15962:20901,HFYGCDRX3230916:1:2241:25780:9471,HFYGCDRX3230916:1:2264:16821:5760,HFYGCDRX3230916:2:2237:17517:5306,HFYGCDRX3230916:1:2127:17436:16125,HFYGCDRX3230916:2:2108:18873:20588,HFYGCDRX3230916:2:2146:30346:11741,HFYGCDRX3230916:1:2150:11234:6887,HFYGCDRX3230916:1:2272:15854:18771,HFYGCDRX3230916:1:2131:31168:15890,HFYGCDRX3230916:1:2140:8196:18317,HFYGCDRX3230916:2:2225:18358:34507,HFYGCDRX3230916:1:2201:24966:23124,HFYGCDRX3230916:2:2114:3983:35759,HFYGCDRX3230916:2:2142:5647:16282,HG5J5DRX3230915:1:2276:13575:2237,HFYGCDRX3230916:1:2114:17372:23938,HFYGCDRX3230916:1:2176:19868:9314,HFYGCDRX3230916:1:2234:9561:20870,HFYGCDRX3230916:2:2154:2474:32863,HFYGCDRX3230916:2:2146:13684:30890,HFYGCDRX3230916:1:2245:12780:3208,HFYGCDRX3230916:1:2123:29532:24893,HFYGCDRX3230916:1:2158:15564:2832,HFYGCDRX3230916:2:2260:28465:19038,HFYGCDRX3230916:1:2123:28230:35665,HG5J5DRX3230915:1:2148:2817:7560,HFYGCDRX3230916:2:2218:7374:12759,HFYGCDRX3230916:2:2117:2627:14591,HFYGCDRX3230916:2:2218:25418:18490,HFYGCDRX3230916:1:2144:23276:30718,HFYGCDRX3230916:1:2143:12129:1924,HFYGCDRX3230916:1:2163:30047:5494,HFYGCDRX3230916:1:2254:6515:33974,HFYGCDRX3230916:1:2219:29993:36620,HFYGCDRX3230916:1:2276:5367:11130,HFYGCDRX3230916:2:2269:9570:7200,HFYGCDRX3230916:1:2236:29206:18192,HFYGCDRX3230916:2:2166:8748:2988,HFYGCDRX3230916:1:2128:19307:11694,HG5J5DRX3230915:1:2101:20419:27398,HFYGCDRX3230916:2:2240:28275:10535,HG5J5DRX3230915:1:2257:14570:2237,HFYGCDRX3230916:1:2213:28357:16313,HFYGCDRX3230916:1:2255:7319:22153,HFYGCDRX3230916:2:2138:2139:16282,HFYGCDRX3230916:1:2165:24144:5415,HFYGCDRX3230916:1:2148:7817:35070,HFYGCDRX3230916:2:2233:8223:22686,HG5J5DRX3230915:1:2139:17128:8672,HFYGCDRX3230916:1:2132:4119:1705,HFYGCDRX3230916:1:2123:7030:13730,HG5J5DRX3230915:1:2130:2880:10708,HFYGCDRX3230916:2:2176:3495:4257,HFYGCDRX3230916:1:2123:26892:21355,HG5J5DRX3230915:1:2122:20066:15107,HG5J5DRX3230915:1:2233:12373:33285,HFYGCDRX3230916:1:2166:3341:23124,HG5J5DRX3230915:1:2165:2709:25692,HFYGCDRX3230916:2:2122:20726:33630,HFYGCDRX3230916:1:2149:15094:30295,HG5J5DRX3230915:1:2255:2962:11005,HFYGCDRX3230916:1:2237:6045:4257,HFYGCDRX3230916:2:2226:27046:36871,HFYGCDRX3230916:1:2137:20645:36464,HFYGCDRX3230916:2:2144:7066:7185,HFYGCDRX3230916:2:2125:22001:29825,HFYGCDRX3230916:1:2216:26738:25379,HG5J5DRX3230915:1:2267:21395:31469,HFYGCDRX3230916:1:2264:18041:11694,HFYGCDRX3230916:2:2158:15609:3129,HFYGCDRX3230916:1:2214:30373:20275,HFYGCDRX3230916:1:2203:32488:26757,HFYGCDRX3230916:1:2274:20003:8797,HFYGCDRX3230916:1:2219:5231:1908,HFYGCDRX3230916:1:2124:20636:7952,HFYGCDRX3230916:1:2135:1768:5807,HFYGCDRX3230916:2:2145:7265:13980,HG5J5DRX3230915:1:2144:13548:11616,HFYGCDRX3230916:2:2232:8712:33708,HFYGCDRX3230916:1:2245:29134:29277,HFYGCDRX3230916:1:2172:10167:31438,HFYGCDRX3230916:2:2277:27037:10770,HG5J5DRX3230915:1:2124:17381:30968,HG5J5DRX3230915:1:2216:24325:4069,HFYGCDRX3230916:2:2109:6343:6214,HFYGCDRX3230916:1:2233:6686:13135,HFYGCDRX3230916:1:2152:6949:35383,HFYGCDRX3230916:1:2152:21106:6449,HFYGCDRX3230916:2:2208:12237:4773,HFYGCDRX3230916:1:2268:30897:22780,HFYGCDRX3230916:1:2107:6307:29637,HFYGCDRX3230916:2:2167:21251:10958,HFYGCDRX3230916:2:2263:17119:35837,HFYGCDRX3230916:1:2218:1262:18615,HG5J5DRX3230915:1:2170:27100:25191,HFYGCDRX3230916:2:2112:3604:8516,HFYGCDRX3230916:2:2246:1723:27242,HFYGCDRX3230916:1:2261:21043:36213,HG5J5DRX3230915:1:2142:24994:31375,HFYGCDRX3230916:2:2218:16360:11725,HFYGCDRX3230916:1:2116:29812:7936,HFYGCDRX3230916:1:2115:27859:27508,HFYGCDRX3230916:1:2247:9607:4507,HFYGCDRX3230916:2:2253:29225:6887,HFYGCDRX3230916:1:2163:9173:35790,HFYGCDRX3230916:1:2165:14118:29450,HFYGCDRX3230916:1:2164:2781:4178,HG5J5DRX3230915:1:2239:22968:10708,HFYGCDRX3230916:2:2144:10673:3756,HFYGCDRX3230916:1:2110:18954:8829,HFYGCDRX3230916:2:2275:24930:21496,HFYGCDRX3230916:1:2113:5457:13385,HG5J5DRX3230915:1:2202:21269:26334,HFYGCDRX3230916:2:2159:5611:8797,HFYGCDRX3230916:1:2138:31123:17096,HFYGCDRX3230916:2:2251:14913:28855,HFYGCDRX3230916:1:2150:12057:34648,HFYGCDRX3230916:1:2236:10990:32236,HFYGCDRX3230916:1:2257:8576:13839,HFYGCDRX3230916:1:2252:26874:10457,HFYGCDRX3230916:1:2233:19027:22545,HFYGCDRX3230916:2:2144:8232:6637,HFYGCDRX3230916:2:2261:30373:31735,HFYGCDRX3230916:1:2177:19678:32471,HFYGCDRX3230916:1:2202:7048:18771,HFYGCDRX3230916:1:2177:22598:24972,HFYGCDRX3230916:1:2169:22950:26960,HFYGCDRX3230916:1:2221:11541:8484,HFYGCDRX3230916:1:2266:2293:34961,HFYGCDRX3230916:2:2153:31665:1532,HFYGCDRX3230916:2:2147:18114:27289,HFYGCDRX3230916:1:2117:14100:11099,HFYGCDRX3230916:2:2254:31421:26913,HFYGCDRX3230916:1:2121:25084:31000,HFYGCDRX3230916:1:2127:17011:19335,HFYGCDRX3230916:2:2135:14109:9518,HFYGCDRX3230916:1:2209:11261:28385,HFYGCDRX3230916:1:2135:15239:20024,HG5J5DRX3230915:1:2122:28646:26804,HFYGCDRX3230916:1:2170:21667:26960,HFYGCDRX3230916:1:2248:1407:20494,HFYGCDRX3230916:1:2239:3992:19304,HFYGCDRX3230916:1:2120:32136:18192,HFYGCDRX3230916:1:2165:9932:15969,HFYGCDRX3230916:2:2250:12816:32080,HFYGCDRX3230916:2:2119:28899:13150,HFYGCDRX3230916:1:2274:32154:29465,HFYGCDRX3230916:2:2238:28194:25175,HFYGCDRX3230916:2:2143:11026:14794,HFYGCDRX3230916:2:2161:8431:6355,HFYGCDRX3230916:2:2265:23773:26694,HFYGCDRX3230916:2:2233:20500:32643,HFYGCDRX3230916:1:2139:4960:16031,HG5J5DRX3230915:1:2140:17192:17989,HFYGCDRX3230916:1:2245:2899:21731,HFYGCDRX3230916:2:2150:17716:7091,HFYGCDRX3230916:2:2148:8847:3380,HFYGCDRX3230916:1:2209:27218:32784,HG5J5DRX3230915:1:2231:17734:29324,HFYGCDRX3230916:1:2131:18168:17895,HG5J5DRX3230915:1:2276:12870:2206,HFYGCDRX3230916:1:2108:16694:17942,HFYGCDRX3230916:1:2214:16387:35352,HFYGCDRX3230916:2:2108:26594:20181,HFYGCDRX3230916:2:2154:14434:3255,HFYGCDRX3230916:1:2201:11957:14685,HFYGCDRX3230916:2:2227:29324:22623,HFYGCDRX3230916:2:2128:23050:17143,HFYGCDRX3230916:1:2278:6352:9455,HG5J5DRX3230915:1:2176:1841:14575,HFYGCDRX3230916:1:2145:31204:34084,HG5J5DRX3230915:1:2258:19244:27023,HG5J5DRX3230915:1:2141:27570:27571,HFYGCDRX3230916:2:2175:31539:32221,HFYGCDRX3230916:1:2226:9742:9095,HFYGCDRX3230916:1:2115:5611:32189,HFYGCDRX3230916:1:2128:15284:20760,HFYGCDRX3230916:1:2114:7717:5274,HFYGCDRX3230916:2:2270:24415:23923,HFYGCDRX3230916:1:2178:19217:18803,HFYGCDRX3230916:2:2222:1416:3818,HFYGCDRX3230916:1:2122:27317:32424,HFYGCDRX3230916:1:2240:1163:27211,HFYGCDRX3230916:1:2166:4571:22153,HFYGCDRX3230916:1:2166:10167:20322,HFYGCDRX3230916:2:2133:14452:14904,HFYGCDRX3230916:1:2173:3396:9784,HFYGCDRX3230916:1:2162:32307:33552,HFYGCDRX3230916:1:2168:25898:22013,HFYGCDRX3230916:1:2116:32687:3145,HG5J5DRX3230915:1:2103:9932:8171,HG5J5DRX3230915:1:2159:28176:4570,HFYGCDRX3230916:1:2266:23520:24815,HFYGCDRX3230916:1:2134:24659:20149,HFYGCDRX3230916:1:2236:7591:11130,HFYGCDRX3230916:2:2234:14968:26537,HFYGCDRX3230916:1:2153:30617:24142,HFYGCDRX3230916:2:2266:26304:19272,HFYGCDRX3230916:2:2256:1443:8469,HFYGCDRX3230916:2:2222:6289:19867,HFYGCDRX3230916:1:2164:10863:14669,HG5J5DRX3230915:1:2107:8314:17206,HFYGCDRX3230916:1:2244:22761:30013,HFYGCDRX3230916:1:2166:16052:4492,HFYGCDRX3230916:1:2126:14226:26944,HFYGCDRX3230916:1:2136:17228:18646,HG5J5DRX3230915:1:2245:5547:24377,HG5J5DRX3230915:1:2118:5204:16329,HFYGCDRX3230916:2:2224:15157:3944,HFYGCDRX3230916:2:2274:19425:3317,HFYGCDRX3230916:2:2228:11496:27915,HG5J5DRX3230915:1:2108:14290:26396,HFYGCDRX3230916:2:2122:25934:2754,HFYGCDRX3230916:2:2144:3034:3176,HFYGCDRX3230916:1:2217:20320:9627,HFYGCDRX3230916:1:2145:13304:3490,HFYGCDRX3230916:1:2245:30282:34460,HFYGCDRX3230916:2:2121:12879:21605,HFYGCDRX3230916:2:2223:16803:5603,HFYGCDRX3230916:1:2153:5484:20322,HFYGCDRX3230916:1:2167:6397:13604,HFYGCDRX3230916:2:2245:5556:6042,HFYGCDRX3230916:1:2219:29134:31970,HFYGCDRX3230916:2:2163:1796:27430,HFYGCDRX3230916:2:2226:6677:1501,HG5J5DRX3230915:1:2156:10131:16000,HG5J5DRX3230915:1:2270:27760:6543,HFYGCDRX3230916:2:2250:12328:7404,HFYGCDRX3230916:1:2178:1154:24502,HFYGCDRX3230916:1:2215:31358:1846,HFYGCDRX3230916:1:2274:19135:31031,HFYGCDRX3230916:1:2259:2944:23062,HFYGCDRX3230916:1:2172:3079:21762,HG5J5DRX3230915:1:2258:1588:9752,HFYGCDRX3230916:1:2265:26874:20071,HFYGCDRX3230916:1:2176:27073:25958,HFYGCDRX3230916:2:2133:19370:33755,HFYGCDRX3230916:1:2153:4453:12085,HFYGCDRX3230916:1:2163:7374:28134,HFYGCDRX3230916:2:2161:3450:15702,HG5J5DRX3230915:1:2172:23231:5525,HFYGCDRX3230916:1:2122:19849:3897,HFYGCDRX3230916:1:2120:11668:5541,HFYGCDRX3230916:1:2145:3540:18051,HFYGCDRX3230916:1:2126:22589:7388,HFYGCDRX3230916:1:2101:24623:30232,HG5J5DRX3230915:1:2262:22905:13448,HG5J5DRX3230915:1:2172:25048:30060,HFYGCDRX3230916:2:2246:28492:32111,HFYGCDRX3230916:1:2246:20943:34381,HFYGCDRX3230916:2:2149:20943:10207,HFYGCDRX3230916:1:2231:6370:29340,HG5J5DRX3230915:1:2133:16161:1517,HFYGCDRX3230916:1:2157:15094:36088,HFYGCDRX3230916:1:2108:1443:34209,HFYGCDRX3230916:1:2174:15347:16172,HFYGCDRX3230916:2:2163:16604:27117,HFYGCDRX3230916:2:2111:2428:11365,HFYGCDRX3230916:1:2169:32868:10128,HFYGCDRX3230916:2:2131:12789:30655,HFYGCDRX3230916:1:2142:7012:4335,HFYGCDRX3230916:1:2136:21495:7717,HFYGCDRX3230916:1:2154:23176:35243,HFYGCDRX3230916:2:2222:5575:6825,HFYGCDRX3230916:1:2127:4987:11350,HFYGCDRX3230916:1:2145:20401:32503,HFYGCDRX3230916:2:2103:31665:5134,HFYGCDRX3230916:2:2124:9308:24878,HFYGCDRX3230916:2:2103:24433:34757,HFYGCDRX3230916:2:2134:2003:12947,HFYGCDRX3230916:2:2250:8693:36370,HFYGCDRX3230916:1:2278:17797:5196,HFYGCDRX3230916:1:2258:10954:12164,HFYGCDRX3230916:1:2218:31864:7106,HFYGCDRX3230916:1:2123:2157:11428,HFYGCDRX3230916:1:2266:24487:22451,HFYGCDRX3230916:2:2213:31430:13150,HFYGCDRX3230916:2:2154:32316:26584,HFYGCDRX3230916:1:2273:17255:30937,HFYGCDRX3230916:2:2139:3351:29465,HFYGCDRX3230916:1:2115:14208:9972,HG5J5DRX3230915:1:2142:19126:2206,HFYGCDRX3230916:2:2277:22480:12399,HFYGCDRX3230916:2:2237:23294:16000,HFYGCDRX3230916:1:2106:8377:12680,HFYGCDRX3230916:2:2167:18313:33833,HFYGCDRX3230916:2:2246:13874:33191,HG5J5DRX3230915:1:2234:21486:1376,HFYGCDRX3230916:1:2209:6560:30733,HG5J5DRX3230915:1:2258:32353:4977,HFYGCDRX3230916:1:2205:6153:3443,HFYGCDRX3230916:2:2252:6560:27164,HFYGCDRX3230916:2:2113:2383:15389,HFYGCDRX3230916:2:2147:14470:7513,HFYGCDRX3230916:1:2209:6858:14090,HFYGCDRX3230916:2:2208:10194:1673,HFYGCDRX3230916:2:2136:19352:9674,HFYGCDRX3230916:1:2244:22571:34256,HG5J5DRX3230915:1:2245:23999:11804,HFYGCDRX3230916:2:2220:1235:4445,HG5J5DRX3230915:1:2161:24686:36135,HG5J5DRX3230915:1:2111:11984:17425,HFYGCDRX3230916:1:2273:16387:9392,HFYGCDRX3230916:1:2240:1814:8453,HFYGCDRX3230916:2:2257:1199:35477,HG5J5DRX3230915:1:2201:2338:35383,HFYGCDRX3230916:2:2251:28682:18912,HFYGCDRX3230916:2:2265:23475:6637,HFYGCDRX3230916:2:2259:24243:25379,HFYGCDRX3230916:1:2157:3305:27477,HG5J5DRX3230915:1:2234:6632:33489,HG5J5DRX3230915:1:2224:27425:9471,HFYGCDRX3230916:1:2214:1588:20650,HFYGCDRX3230916:2:2232:31575:7513,HFYGCDRX3230916:1:2270:19587:18286,HFYGCDRX3230916:2:2137:8892:8187,HFYGCDRX3230916:2:2220:27661:25441,HFYGCDRX3230916:1:2253:27868:5384,HFYGCDRX3230916:1:2225:15167:24251,HFYGCDRX3230916:1:2203:27715:1767,HG5J5DRX3230915:1:2265:7663:4429,HFYGCDRX3230916:1:2140:7111:29653,HFYGCDRX3230916:2:2119:6723:24189,HG5J5DRX3230915:1:2151:2365:9565,HFYGCDRX3230916:2:2153:29568:21950,HFYGCDRX3230916:2:2104:13431:4805,HFYGCDRX3230916:1:2132:26964:26804,HG5J5DRX3230915:1:2120:19958:3583,HFYGCDRX3230916:2:2113:3821:5228,HFYGCDRX3230916:1:2175:25590:28463,HFYGCDRX3230916:1:2268:13069:5901,HFYGCDRX3230916:1:2235:16007:31814,HFYGCDRX3230916:1:2127:26467:1924,HFYGCDRX3230916:2:2261:29821:4820,HFYGCDRX3230916:1:2274:1588:20212,HFYGCDRX3230916:1:2125:32714:16438,HFYGCDRX3230916:2:2159:11623:29293,HFYGCDRX3230916:1:2250:22128:6778,HFYGCDRX3230916:1:2121:19596:35524,HFYGCDRX3230916:1:2252:10755:23030,HFYGCDRX3230916:1:2141:24306:5572,HFYGCDRX3230916:1:2221:13548:10207,HFYGCDRX3230916:1:2129:6298:28463,HFYGCDRX3230916:1:2130:20681:8594,HFYGCDRX3230916:1:2235:8938:8797,HFYGCDRX3230916:2:2237:30174:23844,HFYGCDRX3230916:2:2205:25409:7921,HFYGCDRX3230916:1:2266:7880:17018,HFYGCDRX3230916:2:2166:11315:18176,HFYGCDRX3230916:1:2176:10321:2769,HFYGCDRX3230916:2:2136:2980:8782,HFYGCDRX3230916:1:2171:18927:18145,HFYGCDRX3230916:1:2124:32705:5588,HFYGCDRX3230916:2:2230:10330:20729,HFYGCDRX3230916:2:2110:26485:24878,HFYGCDRX3230916:1:2217:19913:26365,HFYGCDRX3230916:2:2156:1994:13056,HFYGCDRX3230916:1:2128:11586:1110,HFYGCDRX3230916:1:2218:19768:35571,HFYGCDRX3230916:1:2227:29821:18599,HFYGCDRX3230916:1:2151:6298:35603,HG5J5DRX3230915:1:2278:7473:2879,HFYGCDRX3230916:1:2103:11948:34366,HFYGCDRX3230916:2:2140:23430:2738,HFYGCDRX3230916:1:2174:23294:11428,HFYGCDRX3230916:1:2154:21513:13041,HG5J5DRX3230915:1:2127:16034:17738,HG5J5DRX3230915:1:2271:14534:35243,HFYGCDRX3230916:1:2145:10194:8813,HFYGCDRX3230916:1:2126:32154:29778,HFYGCDRX3230916:1:2155:13783:4570,HFYGCDRX3230916:1:2130:11134:2550,HFYGCDRX3230916:1:2114:3197:3239,HFYGCDRX3230916:2:2118:8115:15640,HFYGCDRX3230916:1:2255:5547:12508,HFYGCDRX3230916:1:2118:19416:3364,HFYGCDRX3230916:1:2108:13593:1266,HFYGCDRX3230916:1:2220:21423:33458,HFYGCDRX3230916:2:2104:29487:21997,HFYGCDRX3230916:2:2262:9769:15468,HFYGCDRX3230916:2:2229:25699:5666,HFYGCDRX3230916:1:2228:7509:25050,HFYGCDRX3230916:1:2111:15040:32831,HFYGCDRX3230916:2:2107:29677:2566,HG5J5DRX3230915:1:2121:11686:30248,HFYGCDRX3230916:2:2108:15600:27759,HFYGCDRX3230916:1:2115:18801:27821,HFYGCDRX3230916:1:2115:16812:5118,HFYGCDRX3230916:1:2147:10402:3724,HFYGCDRX3230916:1:2110:4065:20682,HFYGCDRX3230916:2:2252:27823:35211,HFYGCDRX3230916:2:2133:6641:8296,HFYGCDRX3230916:2:2131:18132:19147,HFYGCDRX3230916:1:2161:29894:34225,HFYGCDRX3230916:2:2264:7093:16908,HFYGCDRX3230916:1:2223:2591:34726,HFYGCDRX3230916:2:2137:5421:16329,HFYGCDRX3230916:1:2127:5791:24518,HFYGCDRX3230916:1:2203:27245:27633,HFYGCDRX3230916:1:2271:9164:31641,HG5J5DRX3230915:1:2120:3649:27132,HFYGCDRX3230916:1:2169:14850:9768,HG5J5DRX3230915:1:2102:2356:6136,HG5J5DRX3230915:1:2273:26530:21292,HFYGCDRX3230916:1:2168:24207:17738,HFYGCDRX3230916:1:2203:5855:25535,HFYGCDRX3230916:2:2214:14660:20713,HFYGCDRX3230916:1:2242:16685:9220,HFYGCDRX3230916:2:2126:1181:36166,HFYGCDRX3230916:2:2147:24361:6261,HFYGCDRX3230916:1:2234:7265:33176,HFYGCDRX3230916:2:2232:9815:25003,HFYGCDRX3230916:1:2221:26268:2957,HFYGCDRX3230916:1:2129:28212:17221,HFYGCDRX3230916:1:2238:24135:28604,HFYGCDRX3230916:2:2112:6479:32597,HFYGCDRX3230916:2:2214:26585:33880,HFYGCDRX3230916:1:2233:19949:12837,HFYGCDRX3230916:1:2245:12391:5979,HFYGCDRX3230916:1:2177:26747:29841,HFYGCDRX3230916:1:2269:1561:1720,HFYGCDRX3230916:1:2209:9616:26882,HFYGCDRX3230916:1:2275:3441:23641,HFYGCDRX3230916:1:2249:9833:35618,HFYGCDRX3230916:2:2109:23321:35274,HFYGCDRX3230916:2:2169:20365:19789,HFYGCDRX3230916:1:2104:9064:13996,HFYGCDRX3230916:2:2256:27859:17613,HFYGCDRX3230916:1:2176:13612:20682,HG5J5DRX3230915:1:2144:28158:13463,HFYGCDRX3230916:1:2141:14977:15248,HFYGCDRX3230916:2:2110:14814:31814,HG5J5DRX3230915:1:2128:19470:4648,HFYGCDRX3230916:2:2270:19072:26443,HFYGCDRX3230916:1:2223:31557:5948,HFYGCDRX3230916:1:2143:10673:3630,HFYGCDRX3230916:1:2169:30553:16579,HG5J5DRX3230915:1:2263:2935:16250,HG5J5DRX3230915:1:2258:27453:4539,HFYGCDRX3230916:1:2244:14281:23406,HFYGCDRX3230916:2:2144:22607:34914,HFYGCDRX3230916:2:2127:21459:1892,HG5J5DRX3230915:1:2144:32425:31093,HFYGCDRX3230916:1:2233:9064:32847,HG5J5DRX3230915:1:2228:7039:15311,HFYGCDRX3230916:1:2262:18023:29450,HFYGCDRX3230916:2:2125:5665:12242,HFYGCDRX3230916:1:2131:2013:3474,HFYGCDRX3230916:2:2112:15799:6840,HFYGCDRX3230916:1:2112:26675:5290,HFYGCDRX3230916:2:2166:11180:27398,HFYGCDRX3230916:1:2107:27118:13448,HFYGCDRX3230916:1:2144:5611:24893,HFYGCDRX3230916:1:2133:15248:35477,HFYGCDRX3230916:2:2240:14461:1767,HFYGCDRX3230916:1:2227:9182:30326,HFYGCDRX3230916:2:2250:28230:19601,HFYGCDRX3230916:2:2224:5819:19836,HFYGCDRX3230916:1:2145:5005:34178,HFYGCDRX3230916:2:2248:26205:35822,HFYGCDRX3230916:1:2271:14244:16047,HFYGCDRX3230916:2:2251:15121:19570,HFYGCDRX3230916:1:2116:14922:32252,HFYGCDRX3230916:1:2215:29658:33442,HFYGCDRX3230916:1:2106:14498:14199,HFYGCDRX3230916:2:2220:10203:34601,HFYGCDRX3230916:1:2218:5195:32283,HFYGCDRX3230916:2:2125:16929:22889,HFYGCDRX3230916:2:2163:23167:34632,HFYGCDRX3230916:2:2258:10059:9549,HG5J5DRX3230915:1:2167:17074:31908,HFYGCDRX3230916:1:2174:8223:7936,HG5J5DRX3230915:1:2261:24234:9580,HG5J5DRX3230915:1:2260:31801:13135,HFYGCDRX3230916:2:2155:4417:35196,HFYGCDRX3230916:2:2124:3269:28072,HFYGCDRX3230916:1:2113:29469:29700,HFYGCDRX3230916:1:2250:15727:14293,HFYGCDRX3230916:2:2234:18195:33035,HFYGCDRX3230916:1:2223:26558:26224,HFYGCDRX3230916:2:2234:9444:15843,HFYGCDRX3230916:2:2140:21359:30123,HFYGCDRX3230916:1:2262:15248:2190,HFYGCDRX3230916:1:2235:29903:32988,HFYGCDRX3230916:1:2208:3043:5603,HFYGCDRX3230916:1:2217:31882:5321,HFYGCDRX3230916:1:2145:29125:9878,HFYGCDRX3230916:1:2166:2754:18881,HFYGCDRX3230916:1:2223:16640:27398,HFYGCDRX3230916:1:2226:21034:22670,HFYGCDRX3230916:1:2253:11559:9893,HG5J5DRX3230915:1:2134:22914:9549,HFYGCDRX3230916:2:2149:13621:36605,HFYGCDRX3230916:1:2276:27923:21574,HFYGCDRX3230916:2:2149:27100:27414,HFYGCDRX3230916:1:2103:6451:33520,HFYGCDRX3230916:2:2107:10031:24972,HFYGCDRX3230916:1:2166:23005:21198,HFYGCDRX3230916:1:2115:22580:8907,HFYGCDRX3230916:1:2110:10872:8516,HFYGCDRX3230916:2:2208:16143:27915,HFYGCDRX3230916:1:2128:4426:2581,HFYGCDRX3230916:1:2124:2130:28917,HG5J5DRX3230915:1:2135:24722:11772,HFYGCDRX3230916:2:2271:20112:7858,HFYGCDRX3230916:1:2107:16098:34162,HFYGCDRX3230916:1:2269:23665:6778,HFYGCDRX3230916:1:2147:30029:7153,HFYGCDRX3230916:2:2144:6424:22952,HFYGCDRX3230916:1:2240:31756:2440,HFYGCDRX3230916:1:2106:8314:8030,HFYGCDRX3230916:2:2167:17038:35477,HFYGCDRX3230916:1:2222:31015:32283,HFYGCDRX3230916:1:2268:13765:4100,HFYGCDRX3230916:1:2266:14950:36589,HFYGCDRX3230916:1:2110:32786:27117,HFYGCDRX3230916:1:2118:31873:27915,HFYGCDRX3230916:1:2214:2356:29716,HFYGCDRX3230916:1:2153:21820:9251,HFYGCDRX3230916:1:2120:18475:17707,HFYGCDRX3230916:1:2102:11107:36479,HFYGCDRX3230916:1:2174:17463:25128,HFYGCDRX3230916:2:2262:25247:8829,HFYGCDRX3230916:2:2163:31222:36526,HFYGCDRX3230916:1:2162:11713:2769,HFYGCDRX3230916:2:2274:27380:30592,HG5J5DRX3230915:1:2270:4607:4993,HFYGCDRX3230916:2:2107:8712:17675,HFYGCDRX3230916:2:2165:13340:10285,HFYGCDRX3230916:1:2135:4282:28980,HFYGCDRX3230916:1:2150:6623:22921,HFYGCDRX3230916:2:2165:29930:15593,HFYGCDRX3230916:1:2138:5828:5134,HFYGCDRX3230916:1:2246:22372:2159,HFYGCDRX3230916:1:2227:11559:20854,HFYGCDRX3230916:2:2111:30291:6699,HFYGCDRX3230916:1:2114:18783:33771,HFYGCDRX3230916:2:2245:25789:28150,HFYGCDRX3230916:1:2157:29387:28307,HFYGCDRX3230916:1:2115:18276:24001,HFYGCDRX3230916:1:2223:1172:35587,HFYGCDRX3230916:1:2244:1470:9706,HFYGCDRX3230916:2:2239:24849:11052,HFYGCDRX3230916:2:2267:28980:5462,HFYGCDRX3230916:1:2136:26865:6089,HFYGCDRX3230916:1:2131:16731:13244,HFYGCDRX3230916:2:2237:25681:21605,HFYGCDRX3230916:2:2246:10755:18865,HFYGCDRX3230916:1:2114:29315:20259,HFYGCDRX3230916:1:2111:28094:9032,HFYGCDRX3230916:2:2101:26341:31767,HG5J5DRX3230915:1:2112:31656:36558,HFYGCDRX3230916:1:2130:10755:11256,HFYGCDRX3230916:2:2211:30906:7670,HG5J5DRX3230915:1:2270:28619:8782,HFYGCDRX3230916:2:2218:31882:32722,HFYGCDRX3230916:2:2240:6777:29888,HFYGCDRX3230916:2:2120:20311:13213,HFYGCDRX3230916:2:2140:8504:35916,HG5J5DRX3230915:1:2225:22688:4398,HFYGCDRX3230916:2:2172:5846:34663,HFYGCDRX3230916:1:2261:6705:27038,HFYGCDRX3230916:1:2167:3947:32440,HFYGCDRX3230916:1:2143:15609:16501,HFYGCDRX3230916:1:2201:17942:22169,HFYGCDRX3230916:2:2107:5701:9298,HFYGCDRX3230916:2:2146:9399:21402,HFYGCDRX3230916:2:2241:1163:24173,HG5J5DRX3230915:1:2142:17445:4022,HFYGCDRX3230916:2:2136:3739:12383,HFYGCDRX3230916:1:2131:15835:8061,HFYGCDRX3230916:1:2153:10547:11866,HG5J5DRX3230915:1:2248:16604:21386,HFYGCDRX3230916:2:2115:32108:26412,HG5J5DRX3230915:1:2178:12292:4178,HFYGCDRX3230916:1:2117:19452:32049,HFYGCDRX3230916:1:2228:1624:8312,HFYGCDRX3230916:1:2202:29351:16000,HG5J5DRX3230915:1:2126:27344:22670,HFYGCDRX3230916:2:2267:28339:18568,HFYGCDRX3230916:1:2150:30816:32409,HFYGCDRX3230916:1:2231:4273:20541,HFYGCDRX3230916:1:2259:17011:14575,HG5J5DRX3230915:1:2201:24071:30561,HFYGCDRX3230916:2:2159:29225:4382,HG5J5DRX3230915:1:2101:13340:24533,HFYGCDRX3230916:2:2111:6027:2754,HFYGCDRX3230916:1:2243:26069:9752,HFYGCDRX3230916:1:2119:17562:35446,HFYGCDRX3230916:1:2126:17427:32925,HFYGCDRX3230916:1:2207:15013:9549,HFYGCDRX3230916:1:2176:11415:19570,HFYGCDRX3230916:1:2206:16324:29230,HFYGCDRX3230916:2:2268:18421:2018,HFYGCDRX3230916:2:2153:7310:3850,HFYGCDRX3230916:1:2202:19813:6903,HFYGCDRX3230916:2:2108:31286:16125,HG5J5DRX3230915:1:2138:30843:22592,HFYGCDRX3230916:1:2235:31385:33927,HG5J5DRX3230915:1:2163:10719:21371,HFYGCDRX3230916:1:2126:31675:34679,HFYGCDRX3230916:2:2257:2492:15546,HFYGCDRX3230916:1:2138:11116:20087,HFYGCDRX3230916:1:2112:25102:30405,HFYGCDRX3230916:2:2131:3839:21574,HFYGCDRX3230916:1:2210:19868:33395,HG5J5DRX3230915:1:2116:9408:23672,HFYGCDRX3230916:1:2212:31304:34068,HG5J5DRX3230915:1:2243:6307:14325,HG5J5DRX3230915:1:2216:24578:34100,HG5J5DRX3230915:1:2276:6967:23954,HFYGCDRX3230916:2:2177:20274:22357,HFYGCDRX3230916:2:2236:32877:26146,HFYGCDRX3230916:2:2225:25816:19492,HFYGCDRX3230916:2:2274:29640:12962,HFYGCDRX3230916:2:2176:23836:12524,HFYGCDRX3230916:1:2165:27995:13777,HFYGCDRX3230916:1:2207:23619:26115,HG5J5DRX3230915:1:2276:29785:16250,HFYGCDRX3230916:1:2163:12879:5572,HFYGCDRX3230916:1:2124:11867:9799,HFYGCDRX3230916:1:2129:26539:20118,HFYGCDRX3230916:1:2111:18168:17550,HFYGCDRX3230916:1:2224:3305:31704,HFYGCDRX3230916:2:2158:14055:23735,HFYGCDRX3230916:1:2214:8477:36777,HFYGCDRX3230916:1:2237:2248:28244,HFYGCDRX3230916:2:2139:31566:24815,HFYGCDRX3230916:1:2123:19813:15421,HFYGCDRX3230916:1:2160:28058:30358,HFYGCDRX3230916:1:2103:22137:21198,HFYGCDRX3230916:1:2143:26494:22482,HFYGCDRX3230916:1:2155:4110:7639,HFYGCDRX3230916:2:2133:12255:28855,HFYGCDRX3230916:2:2116:20564:23641,HFYGCDRX3230916:2:2150:20401:24518,HFYGCDRX3230916:1:2260:28510:19210,HFYGCDRX3230916:1:2105:6225:25520,HFYGCDRX3230916:1:2224:25852:19867,HFYGCDRX3230916:2:2146:12328:7811,HG5J5DRX3230915:1:2206:18774:21010,HFYGCDRX3230916:1:2112:26395:9439,HFYGCDRX3230916:2:2133:28827:17785,HFYGCDRX3230916:1:2173:12717:2096,HG5J5DRX3230915:1:2268:24930:23782,HFYGCDRX3230916:1:2250:14642:4335,HFYGCDRX3230916:1:2266:9263:30530,HFYGCDRX3230916:2:2209:7645:16078,HFYGCDRX3230916:2:2254:13196:5055,HFYGCDRX3230916:1:2210:4318:25034,HFYGCDRX3230916:1:2103:17897:35963,HFYGCDRX3230916:2:2249:24641:12070,HFYGCDRX3230916:2:2111:31123:13369,HFYGCDRX3230916:2:2152:14073:20322,HFYGCDRX3230916:1:2230:31277:5650,HFYGCDRX3230916:2:2239:24397:20228,HG5J5DRX3230915:1:2276:31684:11960,HFYGCDRX3230916:1:2129:6171:2440,HFYGCDRX3230916:2:2131:19786:20979,HFYGCDRX3230916:1:2211:5032:25175,HFYGCDRX3230916:2:2269:1705:17942,HFYGCDRX3230916:1:2223:23873:3192,HFYGCDRX3230916:2:2110:14534:11287,HFYGCDRX3230916:1:2164:3586:16188,HFYGCDRX3230916:1:2276:32877:4570,HFYGCDRX3230916:2:2250:17499:12132,HFYGCDRX3230916:2:2262:27245:25535,HFYGCDRX3230916:1:2165:24985:2581,HFYGCDRX3230916:2:2132:22327:9690,HFYGCDRX3230916:1:2103:25536:1125,HFYGCDRX3230916:2:2149:29875:16125,HFYGCDRX3230916:2:2170:30192:27289,HFYGCDRX3230916:1:2106:1199:26209,HFYGCDRX3230916:1:2175:27290:2409,HG5J5DRX3230915:1:2149:20898:29543,HFYGCDRX3230916:1:2147:22381:20212,HFYGCDRX3230916:2:2212:23402:16501,HG5J5DRX3230915:1:2107:13955:30076,HFYGCDRX3230916:1:2271:13946:34601,HFYGCDRX3230916:1:2249:22724:18396,HFYGCDRX3230916:2:2162:15817:34084,HFYGCDRX3230916:2:2249:26485:34334,HFYGCDRX3230916:1:2113:1705:35446,HG5J5DRX3230915:1:2118:9245:11146,HFYGCDRX3230916:1:2124:19280:32847,HFYGCDRX3230916:1:2116:23294:30686,HFYGCDRX3230916:2:2157:8684:27524,HFYGCDRX3230916:2:2205:14389:21465,HFYGCDRX3230916:2:2130:30861:14387,HFYGCDRX3230916:2:2161:8965:2237,HFYGCDRX3230916:2:2120:24370:8688,HFYGCDRX3230916:2:2101:5719:3411,HFYGCDRX3230916:2:2233:28393:23797,HG5J5DRX3230915:1:2211:14244:10160,HFYGCDRX3230916:2:2128:12744:10003,HFYGCDRX3230916:2:2136:4770:20932,HFYGCDRX3230916:1:2245:26711:26616,HFYGCDRX3230916:1:2132:1127:34882,HFYGCDRX3230916:1:2230:16468:20212,HFYGCDRX3230916:2:2254:16550:4194,HFYGCDRX3230916:1:2255:27561:10645,HFYGCDRX3230916:1:2248:14660:5337,HFYGCDRX3230916:2:2109:12310:3364,HFYGCDRX3230916:2:2247:3866:1297,HFYGCDRX3230916:2:2242:10863:22592,HFYGCDRX3230916:1:2246:18982:17832,HFYGCDRX3230916:1:2147:6352:24079,HFYGCDRX3230916:2:2133:2953:8077,HFYGCDRX3230916:1:2255:16514:23015,HFYGCDRX3230916:1:2204:9588:19225,HFYGCDRX3230916:1:2105:9579:26631,HFYGCDRX3230916:1:2115:31367:16767,HG5J5DRX3230915:1:2226:27326:8422,HFYGCDRX3230916:1:2239:18873:31046,HFYGCDRX3230916:2:2238:7365:10238,HFYGCDRX3230916:2:2143:2103:25770,HFYGCDRX3230916:2:2272:31096:5055,HFYGCDRX3230916:2:2162:24994:22921,HFYGCDRX3230916:1:2168:18656:11882,HFYGCDRX3230916:1:2167:2166:23030,HFYGCDRX3230916:1:2153:25183:36808,HFYGCDRX3230916:1:2120:26494:3912,HFYGCDRX3230916:1:2101:7265:1892,HFYGCDRX3230916:1:2170:18141:5134,HFYGCDRX3230916:1:2144:27606:24377,HFYGCDRX3230916:1:2243:14398:9799,HFYGCDRX3230916:1:2230:32579:17550,HFYGCDRX3230916:1:2242:28483:18474,HFYGCDRX3230916:1:2221:23601:4977,HG5J5DRX3230915:1:2253:15745:22185,HFYGCDRX3230916:2:2256:16631:32894,HFYGCDRX3230916:1:2270:12084:8171,HFYGCDRX3230916:1:2211:27597:28588,HFYGCDRX3230916:2:2177:9842:17253,HFYGCDRX3230916:1:2138:17372:21746,HFYGCDRX3230916:1:2263:28456:17519,HFYGCDRX3230916:2:2266:4788:17707,HG5J5DRX3230915:1:2149:20663:29387,HFYGCDRX3230916:2:2118:2003:18458,HFYGCDRX3230916:1:2257:29080:6699,HFYGCDRX3230916:1:2119:27877:11381,HFYGCDRX3230916:1:2151:11568:29669,HFYGCDRX3230916:2:2156:8522:16877,HFYGCDRX3230916:2:2226:21676:24032,HFYGCDRX3230916:1:2269:14073:10457,HFYGCDRX3230916:1:2147:26259:29027,HFYGCDRX3230916:2:2209:28537:8484,HFYGCDRX3230916:1:2114:16107:7780,HFYGCDRX3230916:2:2147:18927:9565,HFYGCDRX3230916:2:2141:4327:28401,HFYGCDRX3230916:1:2165:15383:23531,HFYGCDRX3230916:1:2136:20329:2127,HFYGCDRX3230916:2:2168:10022:35665,HFYGCDRX3230916:1:2178:4336:33552,HFYGCDRX3230916:1:2176:14913:17957,HFYGCDRX3230916:2:2248:4734:7216,HFYGCDRX3230916:1:2159:30779:13056,HFYGCDRX3230916:1:2223:31358:31156,HFYGCDRX3230916:1:2204:9272:26443,HFYGCDRX3230916:1:2239:9769:35509,HFYGCDRX3230916:2:2230:29441:12430,HFYGCDRX3230916:1:2219:15881:15374,HG5J5DRX3230915:1:2105:29848:30639,HFYGCDRX3230916:1:2274:2853:4085,HFYGCDRX3230916:1:2225:13702:12947,HFYGCDRX3230916:1:2106:1832:22013,HFYGCDRX3230916:1:2224:1099:13228,HFYGCDRX3230916:2:2155:10664:17644,HFYGCDRX3230916:1:2153:8395:32346,HFYGCDRX3230916:1:2129:22336:23578,HFYGCDRX3230916:1:2146:31575:10019,HFYGCDRX3230916:1:2173:13241:5666,HFYGCDRX3230916:1:2150:30318:11569,HFYGCDRX3230916:2:2143:11288:36198,HFYGCDRX3230916:2:2247:4643:21934,HFYGCDRX3230916:1:2135:6307:10567,HFYGCDRX3230916:1:2124:16568:23077,HFYGCDRX3230916:2:2163:26494:20290,HFYGCDRX3230916:1:2256:25617:6089,HFYGCDRX3230916:1:2109:28320:30906,HFYGCDRX3230916:1:2130:4634:14372,HFYGCDRX3230916:1:2203:19099:7106,HFYGCDRX3230916:1:2146:1118:7216,HFYGCDRX3230916:1:2276:16712:10708,HFYGCDRX3230916:2:2171:5014:34663,HFYGCDRX3230916:2:2130:29695:30906,HFYGCDRX3230916:1:2221:19524:18333,HFYGCDRX3230916:1:2225:24306:5916,HFYGCDRX3230916:1:2173:20518:25974,HFYGCDRX3230916:2:2269:12825:34663,HFYGCDRX3230916:1:2242:18150:8938,HFYGCDRX3230916:2:2138:9073:36996,HFYGCDRX3230916:2:2133:19904:34585,HFYGCDRX3230916:2:2277:8874:14512,HFYGCDRX3230916:1:2205:8703:29027,HFYGCDRX3230916:1:2135:6325:8813,HFYGCDRX3230916:1:2139:27434:34037,HFYGCDRX3230916:2:2117:19407:34256,HFYGCDRX3230916:2:2104:13150:22451,HFYGCDRX3230916:1:2176:29360:32800,HFYGCDRX3230916:1:2223:4797:24111,HFYGCDRX3230916:1:2102:29333:12587,HFYGCDRX3230916:1:2253:18783:11005,HFYGCDRX3230916:1:2252:13756:34773,HFYGCDRX3230916:1:2129:10004:13307,HG5J5DRX3230915:1:2123:1967:35931,HFYGCDRX3230916:1:2148:24460:2174,HFYGCDRX3230916:1:2273:28890:31767,HFYGCDRX3230916:2:2110:22137:4695,HFYGCDRX3230916:1:2236:29568:13683,HFYGCDRX3230916:1:2220:28528:9659,HFYGCDRX3230916:1:2256:1741:2127,HFYGCDRX3230916:2:2209:8757:34507,HFYGCDRX3230916:1:2235:8061:33708,HFYGCDRX3230916:1:2212:15854:11913,HFYGCDRX3230916:1:2268:13910:3411,HFYGCDRX3230916:1:2263:24677:6590,HG5J5DRX3230915:1:2243:7798:21292,HFYGCDRX3230916:2:2138:12138:3129,HFYGCDRX3230916:1:2112:1118:22623,HFYGCDRX3230916:1:2157:29062:12524,HFYGCDRX3230916:1:2210:2501:36260,HFYGCDRX3230916:2:2121:18846:25989,HFYGCDRX3230916:1:2235:1777:13683,HG5J5DRX3230915:1:2227:9959:20744,HFYGCDRX3230916:2:2131:23674:24956,HFYGCDRX3230916:1:2107:5593:1626,HFYGCDRX3230916:1:2260:28682:14058,HG5J5DRX3230915:1:2112:20166:22044,HFYGCDRX3230916:1:2145:8458:17895,HG5J5DRX3230915:1:2177:4354:28823,HFYGCDRX3230916:2:2106:16251:29888,HFYGCDRX3230916:1:2150:19895:32941,HFYGCDRX3230916:2:2132:20754:1861,HG5J5DRX3230915:1:2155:28592:14184,HFYGCDRX3230916:1:2153:32190:9831,HFYGCDRX3230916:1:2169:27742:8328,HFYGCDRX3230916:2:2221:26946:34162,HFYGCDRX3230916:2:2151:24297:21840,HG5J5DRX3230915:1:2126:9263:10614,HFYGCDRX3230916:1:2276:3848:6652,HFYGCDRX3230916:1:2241:32425:2033,HFYGCDRX3230916:1:2238:13096:33943,HFYGCDRX3230916:1:2146:15320:7670,HFYGCDRX3230916:2:2126:5059:16203,HFYGCDRX3230916:1:2107:15121:14027,HFYGCDRX3230916:1:2116:3911:17754,HFYGCDRX3230916:2:2171:12029:25363,HFYGCDRX3230916:1:2107:14172:1986,HFYGCDRX3230916:2:2256:19904:33051,HFYGCDRX3230916:2:2151:27859:33113,HFYGCDRX3230916:1:2265:10719:5118,HG5J5DRX3230915:1:2273:11234:20509,HFYGCDRX3230916:2:2261:31313:13260,HFYGCDRX3230916:1:2221:7645:27414,HFYGCDRX3230916:1:2109:1940:11021,HFYGCDRX3230916:1:2159:22092:16110,HFYGCDRX3230916:2:2218:25880:25958,HG5J5DRX3230915:1:2178:13069:35556,HFYGCDRX3230916:2:2172:8865:13182,HFYGCDRX3230916:2:2253:1678:24533,HFYGCDRX3230916:1:2227:7455:9048,HFYGCDRX3230916:2:2148:8495:17300,HFYGCDRX3230916:2:2171:4490:10582,HFYGCDRX3230916:2:2159:31557:4069,HFYGCDRX3230916:2:2122:27272:34194,HFYGCDRX3230916:1:2166:12111:6496,HFYGCDRX3230916:1:2178:16920:35055,HFYGCDRX3230916:1:2265:11216:9831,HG5J5DRX3230915:1:2217:15311:30671,HFYGCDRX3230916:2:2264:29487:27226,HFYGCDRX3230916:2:2125:8874:11631,HFYGCDRX3230916:2:2250:12635:35243,HFYGCDRX3230916:2:2254:19072:5744,HFYGCDRX3230916:1:2233:27109:27430,HFYGCDRX3230916:1:2244:3504:34867,HG5J5DRX3230915:1:2142:14624:26882,HFYGCDRX3230916:1:2113:8061:33646,HFYGCDRX3230916:1:2161:32416:8750,HFYGCDRX3230916:1:2275:10339:33051,HFYGCDRX3230916:2:2170:30065:13479,HFYGCDRX3230916:1:2144:6144:22561,HFYGCDRX3230916:2:2153:7075:16814,HFYGCDRX3230916:2:2231:3794:7560,HFYGCDRX3230916:1:2214:24614:8484,HFYGCDRX3230916:1:2201:10746:18537,HFYGCDRX3230916:2:2247:24171:29481,HFYGCDRX3230916:2:2251:23692:5134,HFYGCDRX3230916:1:2277:27805:29951,HFYGCDRX3230916:2:2251:4987:17550,HFYGCDRX3230916:1:2203:14796:21543,HFYGCDRX3230916:2:2172:30517:15577,HFYGCDRX3230916:2:2104:17870:23359,HFYGCDRX3230916:1:2266:19407:16125,HFYGCDRX3230916:1:2264:11957:24486,HFYGCDRX3230916:1:2265:30382:13463,HFYGCDRX3230916:1:2105:29939:22811,HFYGCDRX3230916:1:2275:5376:21543,HFYGCDRX3230916:1:2107:30092:30217,HG5J5DRX3230915:1:2230:27028:34178,HFYGCDRX3230916:1:2253:11785:12289,HFYGCDRX3230916:1:2258:8594:29403,HFYGCDRX3230916:1:2152:21459:10567,HFYGCDRX3230916:2:2264:3504:10942,HFYGCDRX3230916:2:2147:8223:16673,HFYGCDRX3230916:1:2274:10031:22654,HFYGCDRX3230916:2:2156:6225:7607,HFYGCDRX3230916:1:2145:26639:7795,HFYGCDRX3230916:1:2119:13395:1611,HFYGCDRX3230916:1:2265:9525:19022,HFYGCDRX3230916:1:2231:24135:2613,HFYGCDRX3230916:2:2275:3522:28604,HG5J5DRX3230915:1:2201:29586:9392,HFYGCDRX3230916:2:2249:31602:27226,HFYGCDRX3230916:1:2101:16541:29731,HFYGCDRX3230916:1:2128:4878:35994,HFYGCDRX3230916:1:2253:15347:1861,HFYGCDRX3230916:1:2211:30092:14685,HFYGCDRX3230916:1:2233:3378:21183,HFYGCDRX3230916:1:2160:29017:6277,HFYGCDRX3230916:2:2148:28257:4679,HFYGCDRX3230916:1:2163:21477:26694,HFYGCDRX3230916:1:2163:31937:5791,HFYGCDRX3230916:1:2212:17101:21339,HFYGCDRX3230916:1:2144:20971:5901,HFYGCDRX3230916:2:2161:29080:2190,HFYGCDRX3230916:2:2105:26313:9079,HFYGCDRX3230916:2:2140:4679:9283,HFYGCDRX3230916:2:2140:2184:32800,HFYGCDRX3230916:2:2159:30129:5196,HFYGCDRX3230916:2:2138:18593:22107,HFYGCDRX3230916:1:2154:20121:3959,HFYGCDRX3230916:2:2214:12852:5181,HFYGCDRX3230916:2:2116:18448:10614,HFYGCDRX3230916:1:2275:32362:7404,HFYGCDRX3230916:2:2101:9887:32111,HFYGCDRX3230916:1:2259:13232:22874,HG5J5DRX3230915:1:2236:22842:1094,HFYGCDRX3230916:1:2228:8052:6292,HFYGCDRX3230916:1:2261:17553:35900,HFYGCDRX3230916:1:2218:15953:17409,HFYGCDRX3230916:2:2251:32497:21574,HFYGCDRX3230916:2:2155:24352:12070,HFYGCDRX3230916:2:2168:23050:31548,HFYGCDRX3230916:1:2237:12255:35587,HG5J5DRX3230915:1:2178:16523:34648,HFYGCDRX3230916:1:2270:13196:14168,HFYGCDRX3230916:2:2175:12961:25441,HFYGCDRX3230916:1:2126:29640:14904,HG5J5DRX3230915:1:2262:32271:6684,HFYGCDRX3230916:1:2268:25174:30467,HFYGCDRX3230916:2:2113:16080:7200,HFYGCDRX3230916:2:2154:20799:36448,HFYGCDRX3230916:2:2231:15555:29183,HG5J5DRX3230915:1:2259:23240:7263,HG5J5DRX3230915:1:2207:7066:14231,HFYGCDRX3230916:1:2238:20717:10097,HFYGCDRX3230916:1:2109:15709:23062,HFYGCDRX3230916:2:2214:11921:10050,HFYGCDRX3230916:1:2151:22525:25473,HFYGCDRX3230916:1:2202:27498:14606,HFYGCDRX3230916:1:2103:12472:34272,HG5J5DRX3230915:1:2105:1262:6214,HFYGCDRX3230916:1:2229:28537:1094,HFYGCDRX3230916:1:2124:11198:33630,HFYGCDRX3230916:1:2158:29252:14293,HFYGCDRX3230916:1:2227:29080:5948,HG5J5DRX3230915:1:2175:21667:11177,HFYGCDRX3230916:2:2150:3803:2347,HG5J5DRX3230915:1:2240:1642:7122,HFYGCDRX3230916:2:2109:31015:5321,HFYGCDRX3230916:2:2151:4842:13698,HFYGCDRX3230916:2:2177:25816:18396,HFYGCDRX3230916:1:2276:20627:7623,HFYGCDRX3230916:2:2244:3097:10269,HFYGCDRX3230916:1:2169:24704:35008,HFYGCDRX3230916:1:2266:24162:31814,HFYGCDRX3230916:2:2214:16613:20275,HFYGCDRX3230916:2:2142:25626:36667,HFYGCDRX3230916:1:2167:20265:28855,HFYGCDRX3230916:2:2145:32723:19554,HFYGCDRX3230916:1:2223:24985:8844,HFYGCDRX3230916:2:2218:27163:36260,HFYGCDRX3230916:1:2102:5945:14826,HFYGCDRX3230916:1:2214:31638:33677,HFYGCDRX3230916:1:2170:10022:3067,HFYGCDRX3230916:1:2212:16685:9752,HFYGCDRX3230916:2:2270:1434:16595,HG5J5DRX3230915:1:2120:30156:36088,HFYGCDRX3230916:2:2117:9742:24408,HFYGCDRX3230916:1:2177:30969:20149,HFYGCDRX3230916:1:2201:23954:8688,HFYGCDRX3230916:2:2174:24605:17394,HFYGCDRX3230916:1:2223:18313:14982,HFYGCDRX3230916:1:2253:6650:1673,HFYGCDRX3230916:2:2175:32913:33285,HFYGCDRX3230916:2:2114:30129:11490,HG5J5DRX3230915:1:2143:17056:4820,HFYGCDRX3230916:1:2238:20229:29857,HFYGCDRX3230916:2:2245:17553:16141,HFYGCDRX3230916:2:2211:28836:9314,HG5J5DRX3230915:1:2263:1262:13573,HFYGCDRX3230916:1:2114:6406:10645,HG5J5DRX3230915:1:2109:19162:18584,HFYGCDRX3230916:2:2249:25934:8891,HFYGCDRX3230916:1:2128:1280:20181,HFYGCDRX3230916:1:2258:2446:35853,HFYGCDRX3230916:2:2152:2139:33411,HFYGCDRX3230916:2:2103:11369:5181,HFYGCDRX3230916:1:2157:28076:1799,HFYGCDRX3230916:2:2273:29903:6245,HFYGCDRX3230916:2:2176:26341:20243,HFYGCDRX3230916:2:2157:24867:35477,HG5J5DRX3230915:1:2225:25075:9314,HFYGCDRX3230916:1:2169:21576:21230,HFYGCDRX3230916:2:2266:7301:12352,HFYGCDRX3230916:1:2209:8874:14418,HFYGCDRX3230916:1:2210:27236:7012,HFYGCDRX3230916:2:2160:27308:15436,HFYGCDRX3230916:1:2122:17490:10426,HFYGCDRX3230916:2:2259:31602:27195,HFYGCDRX3230916:1:2169:16016:5181,HFYGCDRX3230916:1:2268:6144:17112,HFYGCDRX3230916:1:2254:20799:2409,HFYGCDRX3230916:2:2274:7708:24925,HFYGCDRX3230916:1:2225:8187:18709,HFYGCDRX3230916:1:2204:4381:23610,HFYGCDRX3230916:1:2150:16387:34381,HFYGCDRX3230916:1:2143:8684:7576,HFYGCDRX3230916:1:2177:22146:9001,HFYGCDRX3230916:1:2148:6307:36307,HFYGCDRX3230916:2:2125:20844:20306,HFYGCDRX3230916:1:2257:23637:34882,HFYGCDRX3230916:1:2204:10673:11522
    ## 6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
    ##   NumCounterFusionRight
    ## 1                     0
    ## 2                     0
    ## 3                    NA
    ## 4                     2
    ## 5                     0
    ## 6                    NA
    ##                                                CounterFusionRightReads FAR_left
    ## 1                                                                    .     0.09
    ## 2                                                                    .     5.00
    ## 3                                                                            NA
    ## 4 HFYGCDRX3230916:2:2174:26124:28416,HFYGCDRX3230916:2:2162:25581:5494     0.03
    ## 5                                                                    .     0.00
    ## 6                                                                            NA
    ##   FAR_right LeftBreakDinuc LeftBreakEntropy RightBreakDinuc RightBreakEntropy
    ## 1         3             GT           1.9656              AG            1.9656
    ## 2         5             GT           1.8892              AG            1.7465
    ## 3        NA                              NA                                NA
    ## 4         1             GT           1.7465              AG            1.5058
    ## 5         3             GT           1.7819              AG            1.7465
    ## 6        NA                              NA                                NA
    ##   SR_FFPM microh_brkpt_dist num_microh_near_brkpt
    ## 1  0.3094              3178                     0
    ## 2  0.6188               999                     0
    ## 3      NA                NA                    NA
    ## 4  0.3094               947                     0
    ## 5  0.3094              2407                     0
    ## 6      NA                NA                    NA
    ##                                                                                                                                                                                                          annots
    ## 1                                                                                                                                         [ChimerKB,ChimerPub,Cosmic,ChimerSeq,INTRACHROMOSOMAL[chr10:11.02Mb]]
    ## 2                                                               [ChimerKB,ChimerSeq,TCGA_StarF2019,CCLE_StarF2019,Klijn_CellLines,GUO2018CR_TCGA,chimerdb_pubmed,ChimerPub,Cosmic,INTERCHROMOSOMAL[chr4--chr6]]
    ## 3 [ChimerKB,ChimerSeq,TCGA_StarF2019,CCLE_StarF2019,YOSHIHARA_TCGA,Klijn_CellLines,DEEPEST2019,GUO2018CR_TCGA,ChimerPub,TumorFusionsNAR2018,Cosmic,INTRACHROMOSOMAL[chr4:0.05Mb],LOCAL_REARRANGEMENT:+:[48131]]
    ## 4                                                                                                                                      [ChimerKB,ChimerPub,Cosmic,TCGA_StarF2019,INTRACHROMOSOMAL[chr1:0.68Mb]]
    ## 5                                              [ChimerKB,ChimerSeq,TCGA_StarF2019,Klijn_CellLines,chimerdb_pubmed,DEEPEST2019,GUO2018CR_TCGA,ChimerPub,TumorFusionsNAR2018,Cosmic,INTERCHROMOSOMAL[chr5--chr6]]
    ## 6                 [ChimerKB,Larsson_TCGA,ChimerSeq,TCGA_StarF2019,CCLE_StarF2019,YOSHIHARA_TCGA,chimerdb_pubmed,DEEPEST2019,GUO2018CR_TCGA,ChimerPub,TumorFusionsNAR2018,Cosmic,INTRACHROMOSOMAL[chr21:2.80Mb]]
    ##                                                                                                                                                                                                        annots.1
    ## 1                                                                                                                                         [ChimerKB,ChimerPub,Cosmic,ChimerSeq,INTRACHROMOSOMAL[chr10:11.02Mb]]
    ## 2                                                               [ChimerKB,ChimerSeq,TCGA_StarF2019,CCLE_StarF2019,Klijn_CellLines,GUO2018CR_TCGA,chimerdb_pubmed,ChimerPub,Cosmic,INTERCHROMOSOMAL[chr4--chr6]]
    ## 3 [ChimerKB,ChimerSeq,TCGA_StarF2019,CCLE_StarF2019,YOSHIHARA_TCGA,Klijn_CellLines,DEEPEST2019,GUO2018CR_TCGA,ChimerPub,TumorFusionsNAR2018,Cosmic,INTRACHROMOSOMAL[chr4:0.05Mb],LOCAL_REARRANGEMENT:+:[48131]]
    ## 4                                                                                                                                      [ChimerKB,ChimerPub,Cosmic,TCGA_StarF2019,INTRACHROMOSOMAL[chr1:0.68Mb]]
    ## 5                                              [ChimerKB,ChimerSeq,TCGA_StarF2019,Klijn_CellLines,chimerdb_pubmed,DEEPEST2019,GUO2018CR_TCGA,ChimerPub,TumorFusionsNAR2018,Cosmic,INTERCHROMOSOMAL[chr5--chr6]]
    ## 6                 [ChimerKB,Larsson_TCGA,ChimerSeq,TCGA_StarF2019,CCLE_StarF2019,YOSHIHARA_TCGA,chimerdb_pubmed,DEEPEST2019,GUO2018CR_TCGA,ChimerPub,TumorFusionsNAR2018,Cosmic,INTRACHROMOSOMAL[chr21:2.80Mb]]
    ##   max_LR_FFPM frac_dom_iso above_frac_dom_iso dataset num_SR
    ## 1      14.059            1               True ISO-seq      2
    ## 2      12.568            1               True ISO-seq      4
    ## 3      12.355            1               True ISO-seq     NA
    ## 4      10.864            1               True ISO-seq      2
    ## 5      10.651            1               True ISO-seq      2
    ## 6       9.586            1               True ISO-seq     NA

``` r
p = ctatLRF_FI_data %>% ggplot(aes(x=LR_FFPM, y=SR_FFPM)) + geom_point() +  
    theme_bw() +
 stat_smooth(method = "lm", 
              formula = y ~ x, 
              geom = "smooth")

p
```

    ## Warning: Removed 3932 rows containing non-finite values (`stat_smooth()`).

    ## Warning: Removed 3932 rows containing missing values (`geom_point()`).

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-3-1.png)<!-- -->

``` r
lm(ctatLRF_FI_data$LR_FFPM ~ ctatLRF_FI_data$SR_FFPM  )
```

    ## 
    ## Call:
    ## lm(formula = ctatLRF_FI_data$LR_FFPM ~ ctatLRF_FI_data$SR_FFPM)
    ## 
    ## Coefficients:
    ##             (Intercept)  ctatLRF_FI_data$SR_FFPM  
    ##                   6.474                    4.584

``` r
p + geom_point(data=ctatLRF_FI_data %>% filter(FusionName %in% control_fusions$FusionName), color='red')
```

    ## Warning: Removed 3932 rows containing non-finite values (`stat_smooth()`).

    ## Warning: Removed 3932 rows containing missing values (`geom_point()`).

    ## Warning: Removed 11 rows containing missing values (`geom_point()`).

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-5-1.png)<!-- -->

``` r
# conpare FFPM values LR vs. SR

ctatLRF_FI_data %>% select(FusionName, LR_FFPM, SR_FFPM) %>% 
    filter (! is.na(SR_FFPM)) %>% filter(! is.na(LR_FFPM)) %>%
    mutate(LR_div_SR_FFPM = LR_FFPM/SR_FFPM) %>% 
    mutate(control_fusion = (FusionName %in% control_fusions$FusionName)) %>%
    ggplot() + 
    theme_bw() +
    geom_boxplot(aes(x=control_fusion, y=LR_div_SR_FFPM))
```

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-6-1.png)<!-- -->

The spike-in control fusions do appear to be better captured by
MAS-ISO-seq than the non-control fusions.

``` r
# restrict fusion calls to the 16 control fusions

ctatLRF_FI_control_results = left_join( cross_join(control_fusions, data.frame(dataset=c('ISO-seq', 'MAS-seq-R1', 'MAS-seq-R2'))),
                                    ctatLRF_FI_data %>% 
                                        select(FusionName, LeftBreakpoint, RightBreakpoint, 
                                               num_LR, LR_FFPM, num_SR, SR_FFPM, dataset),
                                    by=c('FusionName', 'LeftBreakpoint', 'RightBreakpoint', 'dataset'))


ctatLRF_FI_control_results =  ctatLRF_FI_control_results %>% mutate(num_SR = ifelse(is.na(num_SR), 0, num_SR))

ctatLRF_FI_control_results
```

    ##         FusionName LeftGene   LeftBreakpoint RightGene  RightBreakpoint
    ## 1       KIF5B--RET    KIF5B chr10:32017143:-       RET chr10:43114480:+
    ## 2       KIF5B--RET    KIF5B chr10:32017143:-       RET chr10:43114480:+
    ## 3       KIF5B--RET    KIF5B chr10:32017143:-       RET chr10:43114480:+
    ## 4    SLC34A2--ROS1  SLC34A2  chr4:25664330:+      ROS1 chr6:117324415:-
    ## 5    SLC34A2--ROS1  SLC34A2  chr4:25664330:+      ROS1 chr6:117324415:-
    ## 6    SLC34A2--ROS1  SLC34A2  chr4:25664330:+      ROS1 chr6:117324415:-
    ## 7     FGFR3--TACC3    FGFR3   chr4:1806934:+     TACC3   chr4:1739702:+
    ## 8     FGFR3--TACC3    FGFR3   chr4:1806934:+     TACC3   chr4:1739702:+
    ## 9     FGFR3--TACC3    FGFR3   chr4:1806934:+     TACC3   chr4:1739702:+
    ## 10     LMNA--NTRK1     LMNA chr1:156130773:+     NTRK1 chr1:156874906:+
    ## 11     LMNA--NTRK1     LMNA chr1:156130773:+     NTRK1 chr1:156874906:+
    ## 12     LMNA--NTRK1     LMNA chr1:156130773:+     NTRK1 chr1:156874906:+
    ## 13      CD74--ROS1     CD74 chr5:150404680:-      ROS1 chr6:117324415:-
    ## 14      CD74--ROS1     CD74 chr5:150404680:-      ROS1 chr6:117324415:-
    ## 15      CD74--ROS1     CD74 chr5:150404680:-      ROS1 chr6:117324415:-
    ## 16    TMPRSS2--ERG  TMPRSS2 chr21:41508081:-       ERG chr21:38584945:-
    ## 17    TMPRSS2--ERG  TMPRSS2 chr21:41508081:-       ERG chr21:38584945:-
    ## 18    TMPRSS2--ERG  TMPRSS2 chr21:41508081:-       ERG chr21:38584945:-
    ## 19      NCOA4--RET    NCOA4 chr10:46012883:-       RET chr10:43116584:+
    ## 20      NCOA4--RET    NCOA4 chr10:46012883:-       RET chr10:43116584:+
    ## 21      NCOA4--RET    NCOA4 chr10:46012883:-       RET chr10:43116584:+
    ## 22 FGFR3--BAIAP2L1    FGFR3   chr4:1806934:+  BAIAP2L1  chr7:98362432:-
    ## 23 FGFR3--BAIAP2L1    FGFR3   chr4:1806934:+  BAIAP2L1  chr7:98362432:-
    ## 24 FGFR3--BAIAP2L1    FGFR3   chr4:1806934:+  BAIAP2L1  chr7:98362432:-
    ## 25     TPM3--NTRK1     TPM3 chr1:154170400:-     NTRK1 chr1:156874571:+
    ## 26     TPM3--NTRK1     TPM3 chr1:154170400:-     NTRK1 chr1:156874571:+
    ## 27     TPM3--NTRK1     TPM3 chr1:154170400:-     NTRK1 chr1:156874571:+
    ## 28      CCDC6--RET    CCDC6 chr10:59906122:-       RET chr10:43116584:+
    ## 29      CCDC6--RET    CCDC6 chr10:59906122:-       RET chr10:43116584:+
    ## 30      CCDC6--RET    CCDC6 chr10:59906122:-       RET chr10:43116584:+
    ## 31     PAX8--PPARG     PAX8 chr2:113235394:-     PPARG  chr3:12379704:+
    ## 32     PAX8--PPARG     PAX8 chr2:113235394:-     PPARG  chr3:12379704:+
    ## 33     PAX8--PPARG     PAX8 chr2:113235394:-     PPARG  chr3:12379704:+
    ## 34    EGFR--SEPT14     EGFR  chr7:55200413:+    SEPT14  chr7:55796092:-
    ## 35    EGFR--SEPT14     EGFR  chr7:55200413:+    SEPT14  chr7:55796092:-
    ## 36    EGFR--SEPT14     EGFR  chr7:55200413:+    SEPT14  chr7:55796092:-
    ## 37   SLC45A3--BRAF  SLC45A3 chr1:205680394:-      BRAF chr7:140794467:-
    ## 38   SLC45A3--BRAF  SLC45A3 chr1:205680394:-      BRAF chr7:140794467:-
    ## 39   SLC45A3--BRAF  SLC45A3 chr1:205680394:-      BRAF chr7:140794467:-
    ## 40       EML4--ALK     EML4  chr2:42295516:+       ALK  chr2:29223528:-
    ## 41       EML4--ALK     EML4  chr2:42295516:+       ALK  chr2:29223528:-
    ## 42       EML4--ALK     EML4  chr2:42295516:+       ALK  chr2:29223528:-
    ## 43     ETV6--NTRK3     ETV6 chr12:11869969:+     NTRK3 chr15:87940753:-
    ## 44     ETV6--NTRK3     ETV6 chr12:11869969:+     NTRK3 chr15:87940753:-
    ## 45     ETV6--NTRK3     ETV6 chr12:11869969:+     NTRK3 chr15:87940753:-
    ## 46      TFG--NTRK1      TFG chr3:100732672:+     NTRK1 chr1:156874571:+
    ## 47      TFG--NTRK1      TFG chr3:100732672:+     NTRK1 chr1:156874571:+
    ## 48      TFG--NTRK1      TFG chr3:100732672:+     NTRK1 chr1:156874571:+
    ##       dataset num_LR LR_FFPM num_SR SR_FFPM
    ## 1     ISO-seq     66  14.059      2  0.3094
    ## 2  MAS-seq-R1    134  17.124      8  0.7822
    ## 3  MAS-seq-R2    139  18.428      8  0.8022
    ## 4     ISO-seq     59  12.568      4  0.6188
    ## 5  MAS-seq-R1     75   9.584      3  0.2933
    ## 6  MAS-seq-R2     89  11.799      2  0.2005
    ## 7     ISO-seq     58  12.355      0      NA
    ## 8  MAS-seq-R1    104  13.290      5  0.4889
    ## 9  MAS-seq-R2     97  12.860      0      NA
    ## 10    ISO-seq     51  10.864      2  0.3094
    ## 11 MAS-seq-R1     93  11.884      2  0.1956
    ## 12 MAS-seq-R2    103  13.655      0      NA
    ## 13    ISO-seq     50  10.651      2  0.3094
    ## 14 MAS-seq-R1     73   9.329      3  0.2933
    ## 15 MAS-seq-R2     63   8.352      2  0.2006
    ## 16    ISO-seq     45   9.586      0      NA
    ## 17 MAS-seq-R1     98  12.523      1  0.0978
    ## 18 MAS-seq-R2    104  13.788      0      NA
    ## 19    ISO-seq     41   8.734      2  0.3094
    ## 20 MAS-seq-R1     85  10.862      0      NA
    ## 21 MAS-seq-R2     60   7.954      4  0.4011
    ## 22    ISO-seq     39   8.308      1  0.1547
    ## 23 MAS-seq-R1     58   7.412      4  0.3911
    ## 24 MAS-seq-R2     41   5.436      0      NA
    ## 25    ISO-seq     36   7.669      0      NA
    ## 26 MAS-seq-R1     69   8.817      2  0.1955
    ## 27 MAS-seq-R2     75   9.943      9  0.9024
    ## 28    ISO-seq     34   7.242      2  0.3094
    ## 29 MAS-seq-R1     77   9.840      1  0.0978
    ## 30 MAS-seq-R2     62   8.220      1  0.1003
    ## 31    ISO-seq     34   7.242      1  0.1547
    ## 32 MAS-seq-R1     51   6.517      2  0.1955
    ## 33 MAS-seq-R2     32   4.242      3  0.3008
    ## 34    ISO-seq     34   7.242      3  0.4641
    ## 35 MAS-seq-R1     55   7.028      2  0.1955
    ## 36 MAS-seq-R2     64   8.485      3  0.3008
    ## 37    ISO-seq     28   5.964      2  0.3094
    ## 38 MAS-seq-R1     75   9.584      3  0.2933
    ## 39 MAS-seq-R2     65   8.617      1  0.1003
    ## 40    ISO-seq     26   5.538      0      NA
    ## 41 MAS-seq-R1     68   8.690      3  0.2933
    ## 42 MAS-seq-R2     52   6.894      2  0.2006
    ## 43    ISO-seq     20   4.260      0      NA
    ## 44 MAS-seq-R1     44   5.623      2  0.1955
    ## 45 MAS-seq-R2     24   3.182      2  0.2005
    ## 46    ISO-seq     19   4.047      0      NA
    ## 47 MAS-seq-R1     38   4.856      3  0.2933
    ## 48 MAS-seq-R2     25   3.314      3  0.3008

# examine number of long reads per control fusion

``` r
# by read count

seracare_read_count_barplot = ctatLRF_FI_control_results %>% 
    ggplot(aes(x=FusionName, y=num_LR)) + theme_bw() +
    geom_bar(stat='identity', position='dodge', aes(fill=dataset))   + 
    theme(axis.text.x = element_text(angle = 90, hjust = 1))

seracare_read_count_barplot
```

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-8-1.png)<!-- -->

``` r
ggsave(seracare_read_count_barplot, file="seracare_read_count_barplot.svg", width=9, height=5)
```

``` r
# by normalized read count

seracare_FFPM_barplot = ctatLRF_FI_control_results %>% 
    ggplot(aes(x=FusionName, y=LR_FFPM)) + theme_bw() +
    geom_bar(stat='identity', position='dodge', aes(fill=dataset))   + 
    theme(axis.text.x = element_text(angle = 90, hjust = 1))


seracare_FFPM_barplot
```

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-10-1.png)<!-- -->

``` r
ggsave(seracare_FFPM_barplot, file="seracare_FFPM_barplot.svg", width=9, height=5)
```

``` r
write.table(ctatLRF_FI_control_results, file="SeraCare_CTAT_LRF_FI_summary.tsv", quote=F, sep="\t", row.names=F)
```

# examine counts of long reads (ctatLRF) vs. short reads (FI) evidence

``` r
paperfig_LR_vs_SR = ctatLRF_FI_control_results %>% gather(key=read_count_type, value=read_count, num_LR, num_SR) %>%
    ggplot(aes(x=read_count_type, y=read_count)) +  theme_bw() +
    geom_bar(stat='identity', position = 'dodge', aes(color=dataset, fill=read_count_type)) +
    facet_wrap(~FusionName) +
      theme(axis.text.x = element_text(angle = 90, hjust = 1))  +
          geom_text(position=position_dodge(width=0.9), aes(label=read_count, group=dataset))

paperfig_LR_vs_SR
```

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-13-1.png)<!-- -->

``` r
ggsave(paperfig_LR_vs_SR, file="seracare_LR_vs_SR_barplot.svg", width=9, height=7)
```

``` r
# How many fusions are missing short read evidence in at least one of the replicates?

ctatLRF_FI_control_results %>% filter(num_SR == 0) %>% select(FusionName) %>% unique()
```

    ##         FusionName
    ## 1     FGFR3--TACC3
    ## 3      LMNA--NTRK1
    ## 4     TMPRSS2--ERG
    ## 6       NCOA4--RET
    ## 7  FGFR3--BAIAP2L1
    ## 8      TPM3--NTRK1
    ## 9        EML4--ALK
    ## 10     ETV6--NTRK3
    ## 11      TFG--NTRK1

``` r
# for 9/16 control fusions, missing SR evidence in at least one replicate
```

``` r
# what's the range of long read support observed?

ctatLRF_FI_control_results %>% summarize(max_LR_support=max(num_LR), min_LR_support = min(num_LR))
```

    ##   max_LR_support min_LR_support
    ## 1            139             19

``` r
# 20 to 139 long read support for control fusions
```

``` r
# compare the normalized read support FFPM values

ctatLRF_FI_control_results %>% ggplot(aes(x=LR_FFPM, y=SR_FFPM)) + geom_point() +
    theme_bw() +
  stat_smooth(method = "lm", 
              formula = y ~ x, 
              geom = "smooth")
```

    ## Warning: Removed 11 rows containing non-finite values (`stat_smooth()`).

    ## Warning: Removed 11 rows containing missing values (`geom_point()`).

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-17-1.png)<!-- -->

``` r
lm(ctatLRF_FI_control_results$SR_FFPM ~ ctatLRF_FI_control_results$LR_FFPM)
```

    ## 
    ## Call:
    ## lm(formula = ctatLRF_FI_control_results$SR_FFPM ~ ctatLRF_FI_control_results$LR_FFPM)
    ## 
    ## Coefficients:
    ##                        (Intercept)  ctatLRF_FI_control_results$LR_FFPM  
    ##                            0.05634                             0.02834

``` r
plot(ctatLRF_FI_control_results$LR_FFPM, ctatLRF_FI_control_results$SR_FFPM )
abline(a=0.05671, b=0.02847)
```

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-19-1.png)<!-- -->

Based on the slope of the line, would be \~35x better detection based on
LR than SR, but obviously a lot of variance around that.

``` r
stats::fivenum(ctatLRF_FI_control_results$LR_FFPM)
```

    ## [1]  3.1820  6.9610  8.6535 11.3315 18.4280

``` r
stats::fivenum(ctatLRF_FI_control_results$SR_FFPM)
```

    ## [1] 0.0978 0.1955 0.2933 0.3094 0.9024

``` r
stats::fivenum(ctatLRF_FI_control_results$LR_FFPM) / stats::fivenum(ctatLRF_FI_control_results$SR_FFPM)
```

    ## [1] 32.53579 35.60614 29.50392 36.62411 20.42110

so \~20x to \~35x more LR than SR for control fusion reads.

``` r
# what about the non-control fusions?

noncontrol_fusions = ctatLRF_FI_data %>% filter(! FusionName %in% control_fusions$FusionName) %>% filter(LR_FFPM > 0 & SR_FFPM > 0)

noncontrol_fusions 
```

    ##                    FusionName num_LR      LeftGene LeftLocalBreakpoint
    ## 1 RP11-96H19.1--RP11-446N19.1      8  RP11-96H19.1                2709
    ## 2    CTD-2215E18.1--LINC01340      1 CTD-2215E18.1                6285
    ## 3 RP11-96H19.1--RP11-446N19.1     22  RP11-96H19.1                2709
    ## 4                CASC4--PDIA3      1         CASC4                8731
    ## 5              BOLA2B--SMG1P5      1        BOLA2B                1949
    ## 6 RP11-96H19.1--RP11-446N19.1     19  RP11-96H19.1                2709
    ##     LeftBreakpoint     RightGene RightLocalBreakpoint  RightBreakpoint
    ## 1 chr12:46387972:+ RP11-446N19.1                12597 chr12:46652390:+
    ## 2  chr5:97431900:+     LINC01340                13110  chr5:97668551:+
    ## 3 chr12:46387972:+ RP11-446N19.1                12597 chr12:46652390:+
    ## 4 chr15:44338317:+         PDIA3                30987 chr15:43761424:+
    ## 5 chr16:30193358:-        SMG1P5                15849 chr16:30288785:-
    ## 6 chr12:46387972:+ RP11-446N19.1                12597 chr12:46652390:+
    ##        SpliceType
    ## 1 ONLY_REF_SPLICE
    ## 2 ONLY_REF_SPLICE
    ## 3 ONLY_REF_SPLICE
    ## 4 ONLY_REF_SPLICE
    ## 5 ONLY_REF_SPLICE
    ## 6 ONLY_REF_SPLICE
    ##                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            LR_accessions
    ## 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             m64020e_230609_061545/60751983/ccs,m64020e_230609_061545/70847315/ccs,m64020e_230609_061545/6881663/ccs,m64020e_230609_061545/116197727/ccs,m64020e_230609_061545/93521323/ccs,m64020e_230609_061545/152044870/ccs,m64020e_230609_061545/116721527/ccs,m64020e_230609_061545/142082144/ccs
    ## 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     m64020e_230609_061545/21300468/ccs
    ## 3 m64363e_230614_195212/124388270/ccs/5055_5488,m64363e_230614_195212/163187394/ccs/4762_7133,m64363e_230614_195212/28770896/ccs/1040_1497,m64363e_230614_195212/114755248/ccs/1256_1704,m64363e_230614_195212/128713112/ccs/3733_4166,m64363e_230614_195212/139067520/ccs/3532_3983,m64363e_230614_195212/71370486/ccs/6255_6765,m64363e_230614_195212/160564435/ccs/9628_10075,m64363e_230614_195212/20972697/ccs/8893_9329,m64363e_230614_195212/163317140/ccs/4420_6696,m64363e_230614_195212/104401316/ccs/4140_4590,m64363e_230614_195212/1967968/ccs/5912_6360,m64363e_230614_195212/109643999/ccs/8262_10823,m64363e_230614_195212/169806442/ccs/6630_7085,m64363e_230614_195212/37945945/ccs/3177_3628,m64363e_230614_195212/14745841/ccs/6597_7142,m64363e_230614_195212/105841961/ccs/6564_6992,m64363e_230614_195212/93849186/ccs/67_2439,m64363e_230614_195212/124060252/ccs/4904_5354,m64363e_230614_195212/84150133/ccs/3307_5512,m64363e_230614_195212/460036/ccs/6769_7569,m64363e_230614_195212/74777510/ccs/7439_7877
    ## 4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           m64363e_230614_195212/83822532/ccs/2130_4030
    ## 5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          m64363e_230614_195212/125830109/ccs/3952_8090
    ## 6                                                                                                                                                 m64363e_230614_195212/99813855/ccs/3345_3801,m64363e_230614_195212/165019744/ccs/3837_4288,m64363e_230614_195212/114951083/ccs/817_1374,m64363e_230614_195212/100794537/ccs/1891_2355,m64363e_230614_195212/93456103/ccs/4664_5217,m64363e_230614_195212/60491968/ccs/5532_5979,m64363e_230614_195212/34472070/ccs/655_1553,m64363e_230614_195212/154273308/ccs/2276_2804,m64363e_230614_195212/56035799/ccs/4044_4501,m64363e_230614_195212/115410405/ccs/4818_5275,m64363e_230614_195212/172492781/ccs/67_435,m64363e_230614_195212/120064396/ccs/1237_1700,m64363e_230614_195212/71239922/ccs/4910_5361,m64363e_230614_195212/3801438/ccs/9097_10338,m64363e_230614_195212/71762618/ccs/67_513,m64363e_230614_195212/155189483/ccs/1858_2298,m64363e_230614_195212/16450369/ccs/1075_1701,m64363e_230614_195212/90834476/ccs/3538_3988,m64363e_230614_195212/33947829/ccs/5689_6131
    ##   LR_FFPM JunctionReadCount SpanningFragCount est_J est_S
    ## 1   1.704                 1                 1     1  0.33
    ## 2   0.213                 1                 0     1  0.00
    ## 3   2.811                 6                 2     6  1.71
    ## 4   0.128                 1                 0     1  0.00
    ## 5   0.128                 7                 3     7  2.07
    ## 6   2.519                 2                 0     2  0.00
    ##                       LeftGene_SR                    RightGene_SR
    ## 1  RP11-96H19.1^ENSG00000257261.4 RP11-446N19.1^ENSG00000272369.1
    ## 2 CTD-2215E18.1^ENSG00000251513.2     LINC01340^ENSG00000250331.1
    ## 3  RP11-96H19.1^ENSG00000257261.4 RP11-446N19.1^ENSG00000272369.1
    ## 4        CASC4^ENSG00000166734.17        PDIA3^ENSG00000167004.11
    ## 5        BOLA2B^ENSG00000169627.7       SMG1P5^ENSG00000183604.13
    ## 6  RP11-96H19.1^ENSG00000257261.4 RP11-446N19.1^ENSG00000272369.1
    ##   LargeAnchorSupport
    ## 1                YES
    ## 2                YES
    ## 3                YES
    ## 4                YES
    ## 5                YES
    ## 6                YES
    ##                                                                                                                                                                                                                                                                                                                              JunctionReads
    ## 1                                                                                                                                                                                                                                                                                                     HFYGCDRX3230916:2:2276:27597:34601/1
    ## 2                                                                                                                                                                                                                                                                                                     HFYGCDRX3230916:2:2172:20537:33051/2
    ## 3 HFYGCDRX3230916:1:2150:4698:32080/2,HFYGCDRX3230916:2:2103:17463:27633/1,HG5J5DRX3230915:1:2120:21260:17112/2,HG5J5DRX3230915:1:2135:23176:8719/1,HFYGCDRX3230916:1:2150:4698:32080/1,HFYGCDRX3230916:2:2103:17463:27633/2,HG5J5DRX3230915:1:2120:21260:17112/1,HFYGCDRX3230916:1:2115:14145:35039/2,HFYGCDRX3230916:1:2245:1958:29528/1
    ## 4                                                                                                                                                                                                                                                                                                       HFYGCDRX3230916:2:2121:8368:1955/1
    ## 5                                        HFYGCDRX3230916:2:2209:6650:23594/1,HG5J5DRX3230915:1:2167:8648:15655/2,HFYGCDRX3230916:2:2116:28266:26522/2,HG5J5DRX3230915:1:2167:8648:15655/1,HFYGCDRX3230916:2:2104:31828:26115/2,HFYGCDRX3230916:1:2228:17065:1078/1,HFYGCDRX3230916:1:2157:11017:28808/2,HFYGCDRX3230916:2:2126:1217:9862/2
    ## 6                                                                                                                                                                                                                                                                   HFYGCDRX3230916:2:2153:2772:26678/1,HG5J5DRX3230915:1:2268:4652:3599/2
    ##                                                                                             SpanningFrags
    ## 1                                                                      HG5J5DRX3230915:1:2105:24632:22764
    ## 2                                                                                                        
    ## 3                                   HFYGCDRX3230916:1:2149:11198:29841,HFYGCDRX3230916:1:2259:14262:20964
    ## 4                                                                                                        
    ## 5 HFYGCDRX3230916:1:2167:32325:21778,HFYGCDRX3230916:1:2252:21088:22921,HFYGCDRX3230916:1:2264:17228:5212
    ## 6                                                                                                        
    ##   NumCounterFusionLeft
    ## 1                    2
    ## 2                    0
    ## 3                    1
    ## 4                   24
    ## 5                   96
    ## 6                    0
    ##                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   CounterFusionLeftReads
    ## 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    HFYGCDRX3230916:1:2264:7979:28588,HFYGCDRX3230916:1:2225:15709:4711
    ## 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
    ## 3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     HFYGCDRX3230916:2:2169:29857:29622
    ## 4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               HFYGCDRX3230916:2:2214:2239:9220,HFYGCDRX3230916:1:2137:17065:34147,HFYGCDRX3230916:1:2204:14940:31375,HFYGCDRX3230916:1:2129:13169:21324,HFYGCDRX3230916:2:2175:6605:20322,HFYGCDRX3230916:1:2121:14950:6872,HFYGCDRX3230916:2:2251:3341:21402,HFYGCDRX3230916:2:2125:8187:17237,HFYGCDRX3230916:2:2247:25373:28307,HFYGCDRX3230916:1:2206:25201:14043,HFYGCDRX3230916:1:2158:19226:13495,HFYGCDRX3230916:1:2223:16676:19319,HFYGCDRX3230916:1:2260:2971:35227,HFYGCDRX3230916:1:2150:18222:25066,HFYGCDRX3230916:2:2137:25120:29904,HFYGCDRX3230916:1:2112:31114:1204,HFYGCDRX3230916:1:2104:15546:24721,HFYGCDRX3230916:2:2218:14787:4178,HFYGCDRX3230916:2:2205:4607:29700,HG5J5DRX3230915:1:2152:8865:8923,HFYGCDRX3230916:2:2140:5602:23437,HFYGCDRX3230916:2:2113:23258:18411,HFYGCDRX3230916:1:2205:3667:27665,HFYGCDRX3230916:2:2114:2401:12164
    ## 5 HFYGCDRX3230916:1:2229:2365:31986,HFYGCDRX3230916:1:2104:15492:30608,HFYGCDRX3230916:1:2169:31033:27054,HFYGCDRX3230916:1:2160:9607:23578,HFYGCDRX3230916:2:2165:27199:3756,HFYGCDRX3230916:2:2177:17761:10332,HG5J5DRX3230915:1:2164:7229:32424,HG5J5DRX3230915:1:2213:26096:10488,HFYGCDRX3230916:2:2228:16116:23860,HFYGCDRX3230916:1:2114:6180:11381,HFYGCDRX3230916:1:2117:22462:22608,HFYGCDRX3230916:1:2266:10447:32456,HFYGCDRX3230916:1:2124:25265:22013,HFYGCDRX3230916:1:2164:1850:20666,HFYGCDRX3230916:1:2175:2022:4398,HFYGCDRX3230916:2:2232:21947:22216,HFYGCDRX3230916:2:2266:25003:15358,HFYGCDRX3230916:2:2177:14045:9345,HFYGCDRX3230916:2:2113:26404:30655,HFYGCDRX3230916:2:2124:15492:3897,HFYGCDRX3230916:1:2111:15646:17785,HG5J5DRX3230915:1:2120:31114:11318,HG5J5DRX3230915:1:2222:23628:33019,HFYGCDRX3230916:2:2159:9815:1955,HFYGCDRX3230916:2:2239:21820:35775,HFYGCDRX3230916:1:2272:24352:17989,HFYGCDRX3230916:1:2217:23149:22200,HFYGCDRX3230916:2:2167:2465:14497,HFYGCDRX3230916:1:2169:3757:3583,HG5J5DRX3230915:1:2253:28420:27696,HFYGCDRX3230916:2:2213:15745:28761,HFYGCDRX3230916:2:2202:31575:24392,HFYGCDRX3230916:2:2163:3296:13307,HFYGCDRX3230916:2:2247:32262:31438,HFYGCDRX3230916:1:2248:3604:8202,HFYGCDRX3230916:1:2270:17363:8609,HFYGCDRX3230916:1:2108:8287:35070,HFYGCDRX3230916:2:2276:30282:27946,HFYGCDRX3230916:2:2120:13132:6856,HFYGCDRX3230916:1:2134:23448:26506,HG5J5DRX3230915:1:2219:20618:32095,HG5J5DRX3230915:1:2176:14796:24799,HFYGCDRX3230916:2:2255:13078:20447,HFYGCDRX3230916:2:2259:6370:32941,HFYGCDRX3230916:2:2134:20247:3051,HFYGCDRX3230916:1:2107:6506:17738,HFYGCDRX3230916:1:2174:2175:18349,HFYGCDRX3230916:1:2145:17734:32612,HFYGCDRX3230916:1:2157:17978:17033,HFYGCDRX3230916:1:2165:21251:15154,HFYGCDRX3230916:2:2124:17978:5822,HFYGCDRX3230916:1:2238:16486:32111,HFYGCDRX3230916:2:2227:2040:3114,HFYGCDRX3230916:1:2107:32669:12853,HFYGCDRX3230916:1:2136:19967:20917,HFYGCDRX3230916:2:2157:25464:27931,HFYGCDRX3230916:2:2104:19678:33098,HFYGCDRX3230916:1:2259:23294:18380,HG5J5DRX3230915:1:2257:27651:29183,HFYGCDRX3230916:2:2202:23339:11600,HFYGCDRX3230916:2:2153:30581:26271,HFYGCDRX3230916:1:2241:7301:19554,HFYGCDRX3230916:1:2138:28366:5713,HFYGCDRX3230916:1:2245:10077:30843,HFYGCDRX3230916:2:2214:23999:20948,HFYGCDRX3230916:1:2175:21043:31485,HFYGCDRX3230916:2:2272:15917:33692,HFYGCDRX3230916:1:2105:21486:10488,HFYGCDRX3230916:2:2134:5493:24095,HFYGCDRX3230916:2:2207:20048:5431,HFYGCDRX3230916:2:2207:30183:22044,HFYGCDRX3230916:1:2254:3622:3380,HG5J5DRX3230915:1:2172:14181:19727,HFYGCDRX3230916:1:2130:6985:2910,HFYGCDRX3230916:1:2144:6099:24267,HFYGCDRX3230916:1:2169:1624:11099,HFYGCDRX3230916:2:2177:15528:4523,HFYGCDRX3230916:1:2151:6940:1548,HG5J5DRX3230915:1:2165:32551:30624,HFYGCDRX3230916:2:2262:28637:16172,HFYGCDRX3230916:1:2164:19000:10755,HFYGCDRX3230916:1:2239:4734:9064,HFYGCDRX3230916:2:2249:29333:1063,HFYGCDRX3230916:2:2203:11478:1642,HFYGCDRX3230916:2:2126:8097:9659,HG5J5DRX3230915:1:2175:3414:19648,HFYGCDRX3230916:1:2206:4074:26146,HFYGCDRX3230916:2:2242:1850:1908,HFYGCDRX3230916:2:2173:27471:27837,HFYGCDRX3230916:1:2151:18656:9032,HFYGCDRX3230916:1:2162:6668:14293,HFYGCDRX3230916:1:2168:17183:4288,HG5J5DRX3230915:1:2126:20853:20854,HFYGCDRX3230916:2:2112:31015:6261,HFYGCDRX3230916:1:2240:18792:33442,HG5J5DRX3230915:1:2104:4146:9048
    ## 6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
    ##   NumCounterFusionRight
    ## 1                     2
    ## 2                     0
    ## 3                     4
    ## 4                   150
    ## 5                     6
    ## 6                     5
    ##                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              CounterFusionRightReads
    ## 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               HG5J5DRX3230915:1:2223:30553:4492,HFYGCDRX3230916:1:2262:27914:31673
    ## 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
    ## 3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          HFYGCDRX3230916:1:2121:21902:18443,HFYGCDRX3230916:1:2249:28203:9377,HFYGCDRX3230916:1:2145:14642:17143,HFYGCDRX3230916:1:2269:23836:5791
    ## 4 HFYGCDRX3230916:1:2249:20356:12007,HFYGCDRX3230916:1:2107:19687:32362,HFYGCDRX3230916:2:2109:13801:18443,HFYGCDRX3230916:2:2233:22309:15170,HFYGCDRX3230916:2:2155:24505:19507,HFYGCDRX3230916:2:2101:14244:14638,HFYGCDRX3230916:2:2126:9652:24721,HG5J5DRX3230915:1:2103:28103:12117,HG5J5DRX3230915:1:2230:7048:33332,HFYGCDRX3230916:2:2206:26639:26334,HFYGCDRX3230916:2:2229:29432:31422,HFYGCDRX3230916:1:2171:21025:3615,HFYGCDRX3230916:1:2226:5095:15953,HFYGCDRX3230916:1:2145:26096:13213,HFYGCDRX3230916:2:2269:14868:25770,HFYGCDRX3230916:1:2111:23384:32346,HFYGCDRX3230916:2:2211:23511:18098,HFYGCDRX3230916:2:2240:25346:19429,HFYGCDRX3230916:1:2128:15022:3991,HFYGCDRX3230916:2:2239:9860:12587,HFYGCDRX3230916:2:2172:16215:24001,HFYGCDRX3230916:1:2146:7211:25723,HG5J5DRX3230915:1:2239:8106:11397,HFYGCDRX3230916:1:2120:11614:10081,HFYGCDRX3230916:1:2159:18665:9298,HG5J5DRX3230915:1:2271:3396:10441,HFYGCDRX3230916:2:2135:29107:24126,HFYGCDRX3230916:2:2106:7247:18333,HFYGCDRX3230916:2:2131:23963:16939,HFYGCDRX3230916:1:2176:2853:22999,HG5J5DRX3230915:1:2128:7057:7106,HFYGCDRX3230916:1:2218:4580:30624,HFYGCDRX3230916:1:2217:26395:13448,HFYGCDRX3230916:1:2270:20934:33301,HFYGCDRX3230916:1:2160:12020:14638,HFYGCDRX3230916:2:2271:22209:18255,HFYGCDRX3230916:2:2207:22426:21574,HFYGCDRX3230916:1:2270:7229:12633,HFYGCDRX3230916:1:2124:21612:13620,HFYGCDRX3230916:1:2107:20066:14888,HFYGCDRX3230916:1:2149:7961:26804,HFYGCDRX3230916:2:2157:15284:8328,HFYGCDRX3230916:1:2138:2374:34945,HFYGCDRX3230916:1:2108:9507:35963,HFYGCDRX3230916:1:2125:2338:13651,HFYGCDRX3230916:1:2118:8477:14074,HFYGCDRX3230916:2:2162:32136:6856,HFYGCDRX3230916:1:2115:23086:21840,HFYGCDRX3230916:1:2275:12735:31908,HFYGCDRX3230916:1:2122:23366:29810,HFYGCDRX3230916:1:2232:23665:4304,HFYGCDRX3230916:2:2114:10556:28322,HFYGCDRX3230916:1:2136:5195:34475,HFYGCDRX3230916:1:2156:14832:32095,HFYGCDRX3230916:1:2225:1886:3035,HFYGCDRX3230916:1:2149:16477:33160,HFYGCDRX3230916:2:2207:20175:1454,HFYGCDRX3230916:2:2202:29785:11616,HFYGCDRX3230916:1:2143:30092:8641,HFYGCDRX3230916:1:2147:26323:33990,HFYGCDRX3230916:1:2123:15094:24596,HFYGCDRX3230916:2:2268:14163:28369,HFYGCDRX3230916:2:2219:8332:14638,HFYGCDRX3230916:1:2128:26729:3161,HFYGCDRX3230916:1:2268:10031:35524,HFYGCDRX3230916:1:2161:20139:3928,HFYGCDRX3230916:1:2216:28745:15515,HFYGCDRX3230916:1:2160:9787:19413,HFYGCDRX3230916:2:2218:23900:13041,HFYGCDRX3230916:2:2204:23728:23202,HFYGCDRX3230916:1:2257:23520:15922,HFYGCDRX3230916:2:2102:20256:9392,HFYGCDRX3230916:2:2101:1452:16376,HFYGCDRX3230916:1:2120:20066:6621,HFYGCDRX3230916:2:2232:19687:30452,HG5J5DRX3230915:1:2257:2248:1658,HFYGCDRX3230916:2:2244:14118:10692,HFYGCDRX3230916:1:2137:24144:31532,HFYGCDRX3230916:1:2176:28953:31156,HFYGCDRX3230916:1:2136:3486:5431,HFYGCDRX3230916:1:2239:26594:7435,HFYGCDRX3230916:1:2274:7961:24424,HFYGCDRX3230916:2:2140:20265:13698,HFYGCDRX3230916:2:2151:25319:18129,HFYGCDRX3230916:1:2170:19407:30373,HFYGCDRX3230916:2:2102:12020:9878,HG5J5DRX3230915:1:2241:13431:5055,HFYGCDRX3230916:1:2222:15637:6652,HFYGCDRX3230916:1:2270:12843:7012,HFYGCDRX3230916:2:2216:20582:4946,HFYGCDRX3230916:1:2109:17146:36166,HFYGCDRX3230916:1:2215:10710:31970,HFYGCDRX3230916:1:2120:7618:16939,HFYGCDRX3230916:1:2142:7184:10739,HFYGCDRX3230916:1:2235:9986:4038,HFYGCDRX3230916:1:2212:6985:1846,HFYGCDRX3230916:2:2141:9290:25786,HG5J5DRX3230915:1:2260:30517:33552,HFYGCDRX3230916:1:2137:19940:18333,HG5J5DRX3230915:1:2128:11089:17347,HG5J5DRX3230915:1:2125:17734:28291,HFYGCDRX3230916:1:2165:31738:10833,HFYGCDRX3230916:1:2110:14416:28808,HG5J5DRX3230915:1:2156:1452:20760,HFYGCDRX3230916:2:2208:13277:36730,HFYGCDRX3230916:2:2227:21070:22013,HFYGCDRX3230916:1:2157:19524:9345,HG5J5DRX3230915:1:2221:31521:7576,HFYGCDRX3230916:2:2121:27814:2409,HFYGCDRX3230916:2:2224:14507:21386,HFYGCDRX3230916:1:2237:19081:30624,HFYGCDRX3230916:2:2132:23818:18881,HFYGCDRX3230916:2:2244:7455:34100,HFYGCDRX3230916:1:2224:26404:32784,HFYGCDRX3230916:1:2170:22724:29543,HFYGCDRX3230916:2:2131:29695:4319,HFYGCDRX3230916:1:2164:5303:2033,HG5J5DRX3230915:1:2259:14027:22717,HFYGCDRX3230916:2:2142:20491:4413,HFYGCDRX3230916:1:2132:26820:26021,HFYGCDRX3230916:1:2211:12346:17675,HFYGCDRX3230916:1:2171:31033:21073,HFYGCDRX3230916:1:2264:6117:7232,HFYGCDRX3230916:2:2251:22715:22733,HG5J5DRX3230915:1:2144:17490:34726,HG5J5DRX3230915:1:2248:21097:26913,HFYGCDRX3230916:2:2135:13214:13322,HFYGCDRX3230916:1:2250:28492:15389,HFYGCDRX3230916:2:2140:22824:36354,HFYGCDRX3230916:1:2203:16947:28087,HFYGCDRX3230916:1:2169:24912:20275,HFYGCDRX3230916:1:2144:28926:17300,HFYGCDRX3230916:1:2241:27534:6308,HFYGCDRX3230916:1:2141:1768:6057,HFYGCDRX3230916:1:2168:25039:8938,HFYGCDRX3230916:2:2161:7048:20713,HFYGCDRX3230916:2:2144:1190:25974,HFYGCDRX3230916:2:2104:4309:36417,HFYGCDRX3230916:1:2229:23032:13197,HFYGCDRX3230916:1:2269:19135:33724,HFYGCDRX3230916:2:2232:12400:19241,HG5J5DRX3230915:1:2169:20392:32330,HFYGCDRX3230916:1:2243:4643:23124,HFYGCDRX3230916:2:2119:26422:29027,HFYGCDRX3230916:1:2237:26458:1282,HFYGCDRX3230916:1:2255:9778:9690,HFYGCDRX3230916:1:2140:16848:18270,HG5J5DRX3230915:1:2212:32108:6652,HFYGCDRX3230916:2:2255:27814:9455,HFYGCDRX3230916:1:2104:6234:27946
    ## 5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      HG5J5DRX3230915:1:2227:3206:30091,HFYGCDRX3230916:1:2260:10520:25535,HFYGCDRX3230916:2:2158:3748:32440,HFYGCDRX3230916:1:2229:3830:12226,HFYGCDRX3230916:2:2143:11912:12884,HFYGCDRX3230916:2:2158:9082:11772
    ## 6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      HFYGCDRX3230916:1:2209:15609:16094,HFYGCDRX3230916:2:2227:28284:27336,HFYGCDRX3230916:1:2127:13440:31563,HFYGCDRX3230916:1:2137:13756:11036,HFYGCDRX3230916:1:2278:5303:34162
    ##   FAR_left FAR_right LeftBreakDinuc LeftBreakEntropy RightBreakDinuc
    ## 1     1.00      1.00             GT           1.7465              AG
    ## 2     2.00      2.00             GT           1.7232              AG
    ## 3     4.50      1.80             GT           1.7465              AG
    ## 4     0.08      0.01             GT           1.8323              AG
    ## 5     0.11      1.57             GT           1.9329              AG
    ## 6     3.00      0.50             GT           1.7465              AG
    ##   RightBreakEntropy SR_FFPM microh_brkpt_dist num_microh_near_brkpt
    ## 1            1.8323  0.2058              1854                     0
    ## 2            1.8323  0.1547              1621                     0
    ## 3            1.8323  0.7538              1854                     0
    ## 4            1.9899  0.0978              2545                     0
    ## 5            1.9329  0.8868               833                     0
    ## 6            1.8323  0.2005              1854                     0
    ##                                                           annots
    ## 1                               [INTRACHROMOSOMAL[chr12:0.12Mb]]
    ## 2               [INTRACHROMOSOMAL[chr5:0.07Mb],NEIGHBORS[67479]]
    ## 3                               [INTRACHROMOSOMAL[chr12:0.12Mb]]
    ## 4                   [DEEPEST2019,INTRACHROMOSOMAL[chr15:0.52Mb]]
    ## 5 [INTRACHROMOSOMAL[chr16:0.07Mb],LOCAL_REARRANGEMENT:-:[73247]]
    ## 6                               [INTRACHROMOSOMAL[chr12:0.12Mb]]
    ##                                                         annots.1 max_LR_FFPM
    ## 1                               [INTRACHROMOSOMAL[chr12:0.12Mb]]       1.704
    ## 2               [INTRACHROMOSOMAL[chr5:0.07Mb],NEIGHBORS[67479]]       0.213
    ## 3                               [INTRACHROMOSOMAL[chr12:0.12Mb]]       2.811
    ## 4                   [DEEPEST2019,INTRACHROMOSOMAL[chr15:0.52Mb]]       0.128
    ## 5 [INTRACHROMOSOMAL[chr16:0.07Mb],LOCAL_REARRANGEMENT:-:[73247]]       0.128
    ## 6                               [INTRACHROMOSOMAL[chr12:0.12Mb]]       2.519
    ##   frac_dom_iso above_frac_dom_iso    dataset num_SR
    ## 1            1               True    ISO-seq   1.33
    ## 2            1               True    ISO-seq   1.00
    ## 3            1               True MAS-seq-R1   7.71
    ## 4            1               True MAS-seq-R1   1.00
    ## 5            1               True MAS-seq-R1   9.07
    ## 6            1               True MAS-seq-R2   2.00

``` r
noncontrol_fusions$LR_FFPM
```

    ## [1] 1.704 0.213 2.811 0.128 0.128 2.519

``` r
noncontrol_fusions$SR_FFPM
```

    ## [1] 0.2058 0.1547 0.7538 0.0978 0.8868 0.2005

``` r
noncontrol_fusions$LR_FFPM / noncontrol_fusions$SR_FFPM
```

    ## [1]  8.2798834  1.3768584  3.7291059  1.3087935  0.1443392 12.5635910

``` r
stats::fivenum(noncontrol_fusions$LR_FFPM / noncontrol_fusions$SR_FFPM)
```

    ## [1]  0.1443392  1.3087935  2.5529821  8.2798834 12.5635910

Don’t have many good examples, but rougly 1x to 10x LR to SR for LR
support seems likely

# compare gene expression levels between long and short reads:

``` r
LR_gene_expr = read.table("data/expr_quant/LR.salmon.gene.TMM.EXPR.matrix.gz", header=T, sep="\t") %>%
    rename(gene_id=X)

TruSeq_gene_expr = read.table("data/expr_quant/TruSeq.salmon.gene.TMM.EXPR.matrix.gz", header=T, sep="\t") %>%
    rename(gene_id=X)

LR_mean_gene_expr = LR_gene_expr %>% rowwise() %>%  mutate(mean_LR_gene_expr = mean(SCF_IsoSeq, SCF_bc08, SCF_bc09)) %>% select(gene_id, mean_LR_gene_expr)

TruSeq_mean_gene_expr = TruSeq_gene_expr %>% rowwise() %>% mutate(mean_TruSeq_gene_expr = mean(SeraFusion_r1, SeraFusion_r2, SeraFusion_r3)) %>% select(gene_id, mean_TruSeq_gene_expr)

mean_gene_expr = full_join(LR_mean_gene_expr, TruSeq_mean_gene_expr, by='gene_id') %>% filter(mean_LR_gene_expr > 0 & mean_TruSeq_gene_expr > 0)
```

``` r
# from: https://stackoverflow.com/questions/13094827/how-to-reproduce-smoothscatters-outlier-plotting-in-ggplot


densVals <- function(x, y = NULL, nbin = 128, bandwidth, range.x) {
  dat <- cbind(x, y)
  # limit dat to strictly finite values
  sel <- is.finite(x) & is.finite(y)
  dat.sel <- dat[sel, ]
  # density map with arbitrary graining along x and y
  map   <- grDevices:::.smoothScatterCalcDensity(dat.sel, nbin, bandwidth)
  map.x <- findInterval(dat.sel[, 1], map$x1)
  map.y <- findInterval(dat.sel[, 2], map$x2)
  # weighted mean of the fitted density map according to how close x and y are
  # to the arbitrary grain of the map
  den <- mapply(function(x, y) weighted.mean(x = c(
    map$fhat[x, y], map$fhat[x + 1, y + 1],
    map$fhat[x + 1, y], map$fhat[x, y + 1]), w = 1 / c(
    map$x1[x] + map$x2[y], map$x1[x + 1] + map$x2[y + 1],
    map$x1[x + 1] + map$x2[y], map$x1[x] + map$x2[y + 1])),
    map.x, map.y)
  # replace missing density estimates with NaN
  res <- rep(NaN, length(sel))
  res[sel] <- den
  res
}

mean_gene_expr$point_density <- densVals(log10(mean_gene_expr$mean_LR_gene_expr), log10(mean_gene_expr$mean_TruSeq_gene_expr))

mean_gene_expr_plot = mean_gene_expr  %>% 
    ggplot(aes(x = log10(mean_LR_gene_expr), y=log10(mean_TruSeq_gene_expr))) +
    theme_bw() +
  stat_density2d(geom = "raster", aes(fill = ..density.. ^ 0.25), contour = FALSE) +
  #scale_x_log10() + scale_y_log10() +
  scale_fill_gradientn(colours = colorRampPalette(c("white", blues9))(256)) +
  # select only the 100 sparesest points
   geom_point(data = mean_gene_expr %>% arrange(point_density) %>% head(100), size = .5) +
  stat_smooth(method = "lm", 
              formula = y ~ x, 
              geom = "smooth")


mean_gene_expr_plot
```

    ## Warning: The dot-dot notation (`..density..`) was deprecated in ggplot2 3.4.0.
    ## ℹ Please use `after_stat(density)` instead.
    ## This warning is displayed once every 8 hours.
    ## Call `lifecycle::last_lifecycle_warnings()` to see where this warning was
    ## generated.

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-26-1.png)<!-- -->

``` r
ggsave(mean_gene_expr_plot, file="SeraCare_LR_vs_SR_gene_expr_scatter_density_plot.svg", width=7, height=4)
```

``` r
cor.test(log10(mean_gene_expr$mean_LR_gene_expr), log10(mean_gene_expr$mean_TruSeq_gene_expr))
```

    ## 
    ##  Pearson's product-moment correlation
    ## 
    ## data:  log10(mean_gene_expr$mean_LR_gene_expr) and log10(mean_gene_expr$mean_TruSeq_gene_expr)
    ## t = 162.93, df = 15659, p-value < 2.2e-16
    ## alternative hypothesis: true correlation is not equal to 0
    ## 95 percent confidence interval:
    ##  0.7872060 0.7988292
    ## sample estimates:
    ##       cor 
    ## 0.7930898

# examine Arriba short read findings:

``` r
arriba_1 = read.csv("data/arriba/MDL_163_SeraSeqFusion_1.arriba.fusions.tsv.gz", header=T, sep="\t", com='', stringsAsFactors = F)
arriba_1$dataset = "ISO-seq"


arriba_2 = read.csv("data/arriba/MDL_163_SeraSeqFusion_2.arriba.fusions.tsv.gz", header=T, sep="\t", com='', stringsAsFactors = F)
arriba_2$dataset = "MAS-seq-R1"


arriba_3 = read.csv("data/arriba/MDL_163_SeraSeqFusion_2.arriba.fusions.tsv.gz", header=T, sep="\t", com='', stringsAsFactors = F)
arriba_3$dataset = "MAS-seq-R2"


arriba_data = bind_rows(arriba_1, arriba_2, arriba_3)

arriba_data = arriba_data %>% 
    mutate(FusionName = paste0(X.gene1, "--", gene2) ) %>%
    mutate(num_reads = split_reads1 + split_reads2 + discordant_mates) %>%
    select(FusionName, num_reads, dataset)

arriba_data %>% head()
```

    ##         FusionName num_reads dataset
    ## 1   EGFR--SEPTIN14         4 ISO-seq
    ## 2    SLC34A2--ROS1         3 ISO-seq
    ## 3       CCDC6--RET         2 ISO-seq
    ## 4       KIF5B--RET         2 ISO-seq
    ## 5      LMNA--NTRK1         2 ISO-seq
    ## 6 IGHV3-48--AHCTF1        38 ISO-seq

``` r
ctatLRF_FI_control_results_w_arriba = left_join(ctatLRF_FI_control_results  %>% filter(FusionName %in% control_fusions$FusionName),
                                                arriba_data %>% filter(FusionName %in% control_fusions$FusionName) %>% mutate(arriba_SR = num_reads),
                                                by=c('FusionName', 'dataset') ) %>%
    mutate(arriba_SR = ifelse(is.na(arriba_SR), 0, arriba_SR))
```

``` r
ctatLRF_FI_control_results_w_arriba %>% gather(key=read_count_type, value=read_count, num_LR, num_SR, arriba_SR) %>%
    mutate(read_count_type = factor(read_count_type, levels=c('num_LR', 'num_SR', 'arriba_SR'))) %>%
    ggplot(aes(x=read_count_type, y=read_count)) +  theme_bw() +
    geom_bar(stat='identity', position = 'dodge', aes(color=dataset, fill=read_count_type)) +
    facet_wrap(~FusionName) +
      theme(axis.text.x = element_text(angle = 90, hjust = 1))  +
          geom_text(position=position_dodge(width=0.9), aes(label=read_count, group=dataset))
```

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-31-1.png)<!-- -->

# Examine reads per gene in LR vs. SR for all genes

``` r
LR_read_gene_counts = read.csv("data/expr_quant/LR.salmon.gene.counts.matrix.gz", header=T, sep="\t", stringsAsFactors = F) %>%
    rename(gene_id = X)

colnames(LR_read_gene_counts) = c('gene_id', 'LR_r1', 'LR_r2', 'LR_r3')

LR_read_gene_counts %>% head()
```

    ##                     gene_id LR_r1 LR_r2 LR_r3
    ## 1 5S_rRNA|ENSG00000201285.1     0  0.00     0
    ## 2 5S_rRNA|ENSG00000212595.1     0  0.00     0
    ## 3 5S_rRNA|ENSG00000252830.2     0  0.00     0
    ## 4 5S_rRNA|ENSG00000271924.1     0 38.16     0
    ## 5 5S_rRNA|ENSG00000272253.1     0  0.00     0
    ## 6 5S_rRNA|ENSG00000272351.1     0  0.00     0

``` r
SR_read_gene_counts = read.csv("data/expr_quant/TruSeq.salmon.gene.counts.matrix.gz", header=T, sep="\t", stringsAsFactors = F) %>%
    rename(gene_id = X)

colnames(SR_read_gene_counts) = c('gene_id', 'SR_r1', 'SR_r2', 'SR_r3')

SR_read_gene_counts %>% head()
```

    ##                     gene_id SR_r1 SR_r2 SR_r3
    ## 1 5S_rRNA|ENSG00000201285.1     0     0     0
    ## 2 5S_rRNA|ENSG00000212595.1     0     0     0
    ## 3 5S_rRNA|ENSG00000252830.2     0     0     0
    ## 4 5S_rRNA|ENSG00000271924.1     0     0     0
    ## 5 5S_rRNA|ENSG00000272253.1     0     0     0
    ## 6 5S_rRNA|ENSG00000272351.1     0     0     0

``` r
gene_read_counts = left_join(LR_read_gene_counts, SR_read_gene_counts, by='gene_id')

gene_read_counts %>% head()
```

    ##                     gene_id LR_r1 LR_r2 LR_r3 SR_r1 SR_r2 SR_r3
    ## 1 5S_rRNA|ENSG00000201285.1     0  0.00     0     0     0     0
    ## 2 5S_rRNA|ENSG00000212595.1     0  0.00     0     0     0     0
    ## 3 5S_rRNA|ENSG00000252830.2     0  0.00     0     0     0     0
    ## 4 5S_rRNA|ENSG00000271924.1     0 38.16     0     0     0     0
    ## 5 5S_rRNA|ENSG00000272253.1     0  0.00     0     0     0     0
    ## 6 5S_rRNA|ENSG00000272351.1     0  0.00     0     0     0     0

``` r
gene_read_counts %>% ggplot(aes(x=LR_r1, y=SR_r1)) + geom_point() +
    theme_bw() + 
    scale_x_continuous(trans='log10') +
    scale_y_continuous(trans='log10') +
  stat_smooth(method = "lm", 
              formula = y ~ x, 
              geom = "smooth")
```

    ## Warning: Transformation introduced infinite values in continuous x-axis

    ## Warning: Transformation introduced infinite values in continuous y-axis

    ## Warning: Transformation introduced infinite values in continuous x-axis

    ## Warning: Transformation introduced infinite values in continuous y-axis

    ## Warning: Removed 44018 rows containing non-finite values (`stat_smooth()`).

![](CTAT_SeraCareFusion_files/figure-gfm/unnamed-chunk-35-1.png)<!-- -->

``` r
# convert to CPM

gene_ids = gene_read_counts %>% pull(gene_id)

col_sums = gene_read_counts %>% select(-gene_id) %>% summarize(sum_LR_r1 = sum(LR_r1), 
                                                               sum_LR_r2 = sum(LR_r2),
                                                               sum_LR_r3 = sum(LR_r3),
                                                              