# Installing FusionInspector

If you can use [Docker](#Docker) or [Singularity](#Singularity) (preferred), that's the easiest way to hit the ground running!  All software you need comes installed in the images and it's easy to run if you have either installed. 

## Software requirements:

FusionInspector requires the following companion software tools to be installed:

* [FusionInspector](https://github.com/FusionInspector/FusionInspector/releases) software itself, of course.

* [STAR](https://github.com/alexdobin/STAR)
  * currently using version 2.6.1a
  * you can use a newer version of STAR, but it may not be compatible with the plug-n-play data resource lib described below.

* [samtools](https://sourceforge.net/projects/samtools/files/samtools/) (modern versions, 1.3+)

* Perl module: Set::IntervalTree
  * can be installed like so:
```bash
        sudo perl -MCPAN -e shell
        install Set::IntervalTree
        quit
```

>Note, the [cpanm](http://www.cpan.org/modules/INSTALL.html) tool is a useful alternative for local installations of Perl modules.

* Python modules: igv-reports, requests
  * can be installed like so:
``` bash
         pip install igv-reports requests
```

### [Optional, but recommended] for de novo reconstruction of fusion transcripts

The following are needed if you want to perform de novo reconstruction of fusion transcripts

* [Trinity](https://github.com/trinityrnaseq/trinityrnaseq/wiki) (Even if you do not wish to de novo assemble fusion transcripts, components of the Trinity software are still required.)

* [GMAP](http://research-pub.gene.com/gmap/) is required if you perform the Trinity de novo reconstruction and used to align the Trinity transcripts back to the fusion contigs.

>Be sure STAR, samtools, and bgzip are available via your PATH env var setting, and create env var TRINITY_HOME set to the Trinity installation directory.**

## Data requirements

  Visit the [FusionFilter](https://github.com/FusionFilter/FusionFilter/wiki) website for links to existing data resources for human fusion transcript detection, or instructions on how to build your own data resources for use with CTAT.

### Data Resources Required:

FusionInspector is a component of the [Trinity Cancer Transcriptome Analysis Toolkit](https://github.com/NCIP/Trinity_CTAT/wiki), and as with the other fusion-transcriptome components of CTAT, FusionInspector leverages the CTAT genome lib data resource, containing a reference genome and corresponding protein-coding gene annotation set, and various metadata.  

We provide several alternative resources for human fusion transcript detection depending on whether you want to use GRCh37 or GRCh38 reference human genomes and corresponding [Gencode](https://www.gencodegenes.org/) annotation sets.  Options are available here: <https://data.broadinstitute.org/Trinity/CTAT_RESOURCE_LIB/>, so choose one, and below we refer to it as 'CTAT_resource_lib.tar.gz'.  The 'plug-n-play' libs are that... just download, unpack it (tar -zxvf filename.tar.gz)   

If you're looking to apply FusionInspector using a different target, you'll need to generate the required resources as described by our [FusionFilter](http://FusionFilter.github.io) resource builder.  


## Other Installation Alternatives
<img src="https://s3.amazonaws.com/media-p.slid.es/uploads/602799/images/3238125/moby.svg" width=200 />

<a name='Docker'></a>
### Docker

FusionInspector is available on DockerHub at <https://hub.docker.com/r/trinityctat/fusioninspector>

An example of running FusionInspector would be like so:

``` bash
TESTDIR=/data/test
fusion_files_list="${TESTDIR}/fusion_targets.A.txt,${TESTDIR}/fusion_targets.B.txt,${TESTDIR}/fusion_targets.C.txt"
left_fq="${TESTDIR}/test.reads_1.fastq.gz"
right_fq="${TESTDIR}/test.reads_2.fastq.gz"

docker run -v `pwd`:/data --rm trinityctat/fusioninspector:latest FusionInspector  \
       --fusions $fusion_files_list \
       --out_dir ${TESTDIR}/FusionInspector-by-docker \
       --left_fq ${left_fq} \
       --right_fq ${right_fq} \
       --genome_lib /data/${CTAT_GENOME_LIB}/ctat_genome_lib_build_dir  \
       --out_prefix finspector \
       --vis \
       --include_Trinity \
       --examine_coding_effect \
       --extract_fusion_reads_file FusionInspector-pe_samples/fusion_reads 
```

If you'd like to explore a working example of the above, you can do so within the FusionInspector codebase.

Just do the following:

``` bash
    cd FusionInspector/Docker
    ./__test_run_Docker.sh
```

and it should download a CTAT genome lib and then run the provided sample data using the Docker image.



<a name='Singularity'></a>
### Singularity

<img src="https://sylabs.io/assets/images/logos/singularity.png" width=200 >

Singularity is easier and safer to use than Docker, and is our preferred method for running FusionInspector. All modern releases of FusionInspector have a Singularity image (.simg) offered for download from the [release site](https://github.com/FusionInspector/FusionInspector/releases).  If you have [Singularity](https://sylabs.io/docs/) installed and the .simg file downloaded, you can run FusionInspector like so:

```
fusion_files_list="fusion_targets.A.txt,fusion_targets.B.txt,fusion_targets.C.txt"
left_fq="reads_1.fastq.gz"
right_fq="reads_2.fastq.gz"

singularity exec -e -B `pwd` -B /path/to/ctat_genome_lib_build_dir \
    FusionInspector.v${VERSION}.simg FusionInspector \
    --fusions $fusion_files_list \
       --output_dir FusionInspectorOutDir \
       --left_fq ${left_fq} \
       --right_fq ${right_fq} \
       --genome_lib /path/to/ctat_genome_lib_build_dir  \
       --out_prefix finspector \
       --vis \
       --include_Trinity \
       --examine_coding_effect \
       --extract_fusion_reads_file FusionInspectorOutDir/fusion_reads 

```

