# FusionInspector Visualization

There are several ways to visualize and explore the FusionInspector results.  The methods we advocate below leverage the web-based or desktop-based **Integrative Genomics Viewer**.

Either method requires that you enable the 'FusionInspector --vis' parameter at execution.  If you've already obtained results and did not include that parameter, just rerun your original command and include the --vis parameter, and it should just generate the missing content required for visualization.

## fusion_inspector_web.html (self-contained dynamic html)

When the `FusionInspector --vis` parameter is set, FusionInspector will generate an html summary file 'finspector.fusion_inspector_web.html' that can be opened in your web browser, allowing you to navigate the evidence for the fusions.  An [example finspector.fusion_inspector_web.html](https://raw.githubusercontent.com/wiki/FusionInspector/FusionInspector/HTML/finspector.fusion_inspector_web.html) is available - just right-click the link, save as html file, and open in your browser.  An  example view is shown below.

A table of fusions and attributes are provided in the initial view:

<img src="images/FusionInspector_igvreports_table.png" />

&nbsp;

If you select a fusion, it will create a tab that shows the evidence for the visualization in a web-based igv view.

<img src="images/FusionInspector_igv_report.png" />



This system was developed using [igv-reports](https://github.com/igvteam/igv-reports).


## Visualization using Desktop-IGV

When envoking the 'FusionInspector --vis' parameter, it will generate a number of files that can be leveraged for viewing the evidence in [IGV](https://software.broadinstitute.org/software/igv/) (or other) genome browser:

    finspector.fa : the candidate fusion-gene contigs (if you copy things elsewhere, make sure to als copy the index file finspector.fa.fai)
    finspector.bed : the reference gene structure annotations for fusion partners
    finspector.junction_reads.bam : alignments of the breakpoint-junction supporting reads.
    finspector.spanning_reads.bam : alignments of the breakpoint-spanning paired-end reads.

An example of viewing a fusion candidate with recovered read evidence using IGV is shown below. 

You can load the 'finspector.fa' as a 'new genome' and then load up the various gtf and bam files for viewing, or simply run a command like so (assuming you have IGV installed and the 'igv.sh' script in your PATH setting):

    %  igv.sh -g `pwd`/finspector.fa \
    `pwd`/finspector.gtf,`pwd`/finspector.spanning_reads.bam,`pwd`/finspector.junction_reads.bam

Alternatively, if you want to load the fusion evidence using IGV's graphical menu options, do the following:

Use `Menu->Genomes->Create .genome File`, then choose the name and description yourself, then add the following files which you can find in FusionInspector-inspect folder:

```
finspector.fa # Make sure the index file finspector.fa.fai is in the same folder
finspector.gtf # use this for 'Genes'
cytoBand.txt  # use this for 'optional Cytoband'
```

Your IGV 'minigenome' is now ready but has no reads loaded yet. To do that, select your freshly created minigenome from the drop-down list and proceed to add add the bam files by 
choosing `File -> Load from File ...`

```
finspector.junction_reads.bam  # make sure the corresponding *.bam.bai files ...
finspector.spanning_reads.bam  # ... are in the same folder
```

The view (from invoking `igv.sh` or the manual steps) would look similar to this:

<img src="https://raw.githubusercontent.com/wiki/FusionInspector/FusionInspector/images/finspector_bcr--abl.png" />


where you can readily examine the paired-end and split-read evidence for any of the supported fusions. 


For more information on how to interpret what you see in IGV, please see this training video:


<a href="http://www.youtube.com/watch?feature=player_embedded&v=awGN-rpLYas" target="_blank">
<img src="http://img.youtube.com/vi/awGN-rpLYas/0.jpg" 
alt="Using IGV for analyzing RNA-seq" width="400" border="10" /></a>