# FusionAnnotator

FusionAnnotator is a simple tool for annotating fusion transcripts, incorporated into the [Trinity Cancer Transcriptome Analysis Toolkit](https://github.com/NCIP/Trinity_CTAT/wiki) utilities, and leveraging databases including [CTAT Human Fusion Lib](https://github.com/FusionAnnotator/CTAT_HumanFusionLib/wiki).

An example of fusion annotations when applying FusionAnnotator using our pre-compiled CTAT_HmanFusionLib:

    %  FusionAnnotator --genome_lib_dir GRCh37_gencode_v19_CTAT_lib_July192017/ctat_genome_lib_build_dir/ \
                       --annotate fusions.list.txt


```
BCR--ABL1	["chimerdb_pubmed","CCLE","Klijn_CellLines","chimerdb_omim","ChimerSeq","ChimerKB","FA_CancerSupp","Cosmic","Mitelman","ChimerPub","INTERCHROMOSOMAL[chr22--chr9]"]
ACTB--ACTG1	["ChimerSeq","INTERCHROMOSOMAL[chr7--chr17]"]
ZFP91--RAB6A	["YOSHIHARA_TCGA","FA_CancerSupp","ChimerSeq","INTRACHROMOSOMAL[chr11:15.00Mb]"]
ABCB9--ARL6IP4	["INTRACHROMOSOMAL[chr12:0.00Mb]","NEIGHBORS_OVERLAP:-:+:[1589]"]
KMT2A--EPS15	["ChimerKB","Cosmic","Mitelman","INTERCHROMOSOMAL[chr11--chr1]"]
PRMT1--AURKB	["INTERCHROMOSOMAL[chr19--chr17]"]
ZNF580--ZNF510	["HGNC_GENEFAM","INTERCHROMOSOMAL[chr19--chr9]"]
ETV6--ABL2	["ChimerKB","ChimerPub","chimerdb_omim","INTERCHROMOSOMAL[chr12--chr1]"]
EML4--ALK	["ChimerPub","Cosmic","ChimerKB","ChimerSeq","FA_CancerSupp","YOSHIHARA_TCGA","CCLE","chimerdb_pubmed","HaasMedCancer","Klijn_CellLines","INTRACHROMOSOMAL[chr2:12.25Mb]"]
EWSR1--ATF1	["ChimerSeq","ChimerKB","Cosmic","Mitelman","ChimerPub","INTERCHROMOSOMAL[chr22--chr12]"]
EWSR1--FLI1	["CCLE","Klijn_CellLines","ChimerKB","ChimerSeq","FA_CancerSupp","ChimerPub","Mitelman","Cosmic","INTERCHROMOSOMAL[chr22--chr11]"]
TMPRSS2--ETV1	["ChimerSeq","chimerdb_pubmed","ChimerKB","FA_CancerSupp","Cosmic","ChimerPub","INTERCHROMOSOMAL[chr21--chr7]"]
ETV6--NTRK3	["chimerdb_omim","Larsson_TCGA","YOSHIHARA_TCGA","chimerdb_pubmed","HaasMedCancer","Cosmic","ChimerPub","ChimerSeq","ChimerKB","FA_CancerSupp","INTERCHROMOSOMAL[chr12--chr15]"]
CD74--ROS1	["ChimerKB","chimerdb_pubmed","ChimerSeq","FA_CancerSupp","Klijn_CellLines","ChimerPub","Cosmic","INTERCHROMOSOMAL[chr5--chr6]"]
HOOK3--RET	["Cosmic","ChimerKB","ChimerSeq","HaasMedCancer","INTERCHROMOSOMAL[chr8--chr10]"]
EML4--ALK	["ChimerPub","Cosmic","ChimerKB","ChimerSeq","FA_CancerSupp","YOSHIHARA_TCGA","CCLE","chimerdb_pubmed","HaasMedCancer","Klijn_CellLines","INTRACHROMOSOMAL[chr2:12.25Mb]"]
AKAP9--BRAF	["HaasMedCancer","chimerdb_pubmed","ChimerKB","ChimerSeq","ChimerPub","Cosmic","INTRACHROMOSOMAL[chr7:48.68Mb]"]
BRD4--NUTM1	["Cosmic","ChimerSeq","CCLE","ChimerKB","HaasMedCancer","INTERCHROMOSOMAL[chr19--chr15]"]
FGFR3--TACC3	["CCLE","Klijn_CellLines","YOSHIHARA_TCGA","ChimerKB","ChimerSeq","FA_CancerSupp","ChimerPub","Cosmic","INTRACHROMOSOMAL[chr4:0.05Mb]","LOCAL_REARRANGEMENT:+:[48136]"]
FIP1L1--PDGFRA	["ConjoinG","Mitelman","chimerdb_pubmed","ChimerKB","ChimerSeq","INTRACHROMOSOMAL[chr4:0.77Mb]"]
GOPC--ROS1	["chimerdb_pubmed","ChimerKB","ChimerPub","Cosmic","Mitelman","INTRACHROMOSOMAL[chr6:0.13Mb]"]
PDE6B--PPP2R2D	["GTEx","INTERCHROMOSOMAL[chr4--chr10]"]
NCOR2--UBC	["ChimerSeq","GTEx","BodyMap","INTRACHROMOSOMAL[chr12:0.34Mb]"]
KANSL1--ARL17B	["Babiceanu_Normal","ChimerSeq","CCLE","BodyMap","GTEx","INTRACHROMOSOMAL[chr17:0.05Mb]","LOCAL_REARRANGEMENT:-:[49417]"]
KANSL1--ARL17A	["Babiceanu_Normal","ChimerSeq","GTEx","BodyMap","INTRACHROMOSOMAL[chr17:0.29Mb]"]
C15orf57--CBX3	["Babiceanu_Normal","GTEx","BodyMap","INTERCHROMOSOMAL[chr15--chr7]"]
```

For more detailed annotations, you can use the '--full' parameter like so:

     %  FusionAnnotator --genome_lib_dir GRCh37_gencode_v19_CTAT_lib_July192017/ctat_genome_lib_build_dir/ \
                       --annotate fusions.list.txt --full

```
BCR--ABL1	{"BCR--ABL1":{"Mitelman":"MDS_NOS=2,ALL=5,Nonneo_hemat=2,AUL=2,DLBL=2,AML=14,Heart=7,AL_bi=2,Skin=2,MM=2,CML_ab_t=291,BL=2,RA=2","chimerdb_omim":"AcuteLymphocyticLeukemia,ChronicMyelogenousLeukemia","chimerdb_pubmed":"Tcell acute lymphoblastic leukemia (TALL),Philadelphianegative chronic myeloid leukaemia,\"Tcell acute lymphoblastic leukemia, acute myelomonocytic leukemia\",chronic myelogenous leukemia,\"chronic myelogenous leukemia(CML), mediastinal tumor\",K562,\"chronic myeloid leukemia (CML), acute lymphoblastic leukemia(APL)\",Chronic myelogenous leukemia (CML) ,chronic granulocytic leukemia,leukemic cells ,chronic myeloid leukemia(CML),acute nonlymphocytic leukaemia (ANLL),Chronic myeloid leukemia (CML),chronic myeloid leukaemia,Chronic Myeloid Leukaemia (CML),\"chronic myelogenous leukemia(CML), acute lymphoblastic leukemia(ALL)\",myelodysplastic syndromes (MDS),\"chronic myelogenous leukemia (CML), acute myeloid leukemia (AML)\",two Ph chromosome positive chronic myelogenous leukemia,\"chronic myeloid leukemia(CML), acute lymphoblastic leukemia (ALL)\",\"chronic myelogenous leukaemia(CML), Ewing's sarcoma\",chronic lymphocytic leukemia,Chronic myeloid leukemia(CML),Chronic myelogenous leukemia,\"Philadelphia chromosomenegative (Ph()) nonHodgkin's lymphomas (NHLs), Phpositive (Ph(+)) chronic myelogenous leukemia (CML)\",\"chronic myeloid leukemia (CML), acute myeloid leukemia (AML)\",Blineage acute lymphoblastic leukemia(Blineage ALL),\"erythroleukemia, chronic myeloid leukemia (CML)\",childhood acute lymphoblastic leukemia,chronic myelogenous leukemia (CML),Chronic myelogenous leukaemia (CML),Acute leukaemia,Philadelphia chromosomepositive leukemias,Philadelphia (Ph)positive acute lymphoblastic leukemia (ALL),chronic myeloid leukemias (CML),\"chronic myelogenous leukemia (CML), acute lymphoblastic leukemia (ALL)\",\"CML, ALL\",chronic neutrophilic leukemia and multiple myeloma (IgG kappa),chronic myelogenous leukaemia (CML),chronic myeloid leukaemia (CML),Chronic myelogenous leukemia(CML),Philadelphiapositive chronic myelogenous leukemia ,adult acute lymphoblastic leukemia(ALL),acute myeloid leukemia(AML),acute lymphoblastic leukemia(ALL),\"acute lymphoblastic leukemia (ALL), Chronic myelogeneous leukaemia (CML)\",chronic myeloid leukaemia(CML),leukemogenesis,acute myelogenous leukemia (AML),\"chronic myeloid leukemia (CML), Ph+ ALL\",Leukemia,B cell precursor leukemia cells,\"chronic myeloid leukemia (CML), acute lymphoblastic leukemia (ALL), acute myeloid leukemia(AML), myeloproliferative disorder (MPD)\",Chronic myelogeneous leukaemia (CML),Philadelphia positive leukaemia,leukemia,severalleukaemia,acute lymphoblastic leukemia (ALL),CML,Acute lymphoblastic leukemia (ALL),Chronic myeloid leukemia (CML) ,chronic myeloid leukemia (CML),chronic myelomonocytic leukemia,acute B lymphocytic leukemia,Chronic myelogenous leukemia (CML) acute lymphoblastic leukemias (ALL),childhood ALL,thrombocythemia,Philadelphia chromosome (Ph) positive Chronic myeloid leukaemia (CML),Chronic myeloid leukaemia (CML),chronic myeloid leukemia,chronic myelocytic leukemia (CML),\"chronic myelogenous leukemia (CML),myelodysplastic syndromes (MDS),acute myelogenous leukemia(AML)\",acute lymphoblastic leukemia,\"chronic myeloid leukaemia (CML), ALL and AML\",\"chronic myelocytic leukaemia, acute lymphoblastic leukaemia\",\"PreB acute lymphoblastic leukemia(ALL), positive chronic myelogenous leukemia (CML)\",Chronic myelogenous leukemia (CML),Chronic Myeloid Leukemia (CML),acute leukemia,\"chronic myeloid leukemia (CML), acute lymphoblastic leukemia (ALL)\",\"acute lymphoblastic leukemia(ALL), chronic myeloid leukemia (CML), biphenotypic leukemia\",\"chronic granulocytic leukaemiam, chronic myeloid leukaemias, acute myeloid leukaemia\",\"chronic myeloid leukemia, acute lymphoblastic leukemia\",acute lymphoblastic leukemia.,chronic myelogenous leukemia(CML),chronic myeloid leukemia ,acute undifferentiated leukemia (AUL),Chronic myeloid leukemia","Klijn_CellLines":"{Klijn_CellLines:Lymphoid=4}","ATTS":["chimerdb_pubmed","CCLE","Klijn_CellLines","chimerdb_omim","ChimerSeq","ChimerKB","FA_CancerSupp","Cosmic","Mitelman","ChimerPub"],"LOCALITY":["INTERCHROMOSOMAL[chr22--chr9]"],"Cosmic":"Cosmic{samples=8832,mutations=5480,papers=244}"}}
ACTB--ACTG1	{"ACTB--ACTG1":{"ATTS":["ChimerSeq"],"LOCALITY":["INTERCHROMOSOMAL[chr7--chr17]"],"BLASTPAIR":"{ACTG1|ACTB|pID:91.304|E:0.0}"}}
ZFP91--RAB6A	{"ZFP91--RAB6A":{"YOSHIHARA_TCGA":"BRCA:9","ATTS":["YOSHIHARA_TCGA","FA_CancerSupp","ChimerSeq"],"LOCALITY":["INTRACHROMOSOMAL[chr11:15.00Mb]"]}}
ABCB9--ARL6IP4	{"ABCB9--ARL6IP4":{"LOCALITY":["INTRACHROMOSOMAL[chr12:0.00Mb]","NEIGHBORS_OVERLAP:-:+:[1589]"]}}
KMT2A--EPS15	{"KMT2A--EPS15":{"Mitelman":"AL_bi=2,ALL=2,AML=7","ATTS":["ChimerKB","Cosmic","Mitelman"],"LOCALITY":["INTERCHROMOSOMAL[chr11--chr1]"],"Cosmic":"Cosmic{samples=131,mutations=9,papers=14}"}}
PRMT1--AURKB	{"PRMT1--AURKB":{"LOCALITY":["INTERCHROMOSOMAL[chr19--chr17]"]}}
ZNF580--ZNF510	{"ZNF580--ZNF510":{"ATTS":["HGNC_GENEFAM"],"LOCALITY":["INTERCHROMOSOMAL[chr19--chr9]"]}}
ETV6--ABL2	{"ETV6--ABL2":{"chimerdb_omim":"acutemyeloblasticleukemiawithmorphologyM3cellline","ATTS":["ChimerKB","ChimerPub","chimerdb_omim"],"LOCALITY":["INTERCHROMOSOMAL[chr12--chr1]"]}}
EML4--ALK	{"EML4--ALK":{"YOSHIHARA_TCGA":"LUAD:4|THCA:1","HaasMedCancer":{"PMID:29281951":"Gene Fusions in Thyroid Cancer."},"chimerdb_pubmed":"lung cancer,lung cancers,nonsmall cell lung cancers (NSCLC),nonsmallcell lung cancer (NSCLC),nonsmallcell lung cancers (NSCLC),nonsmall cell lung cancer (NSCLC),nonsmall cell lung carcinoma","Klijn_CellLines":"{Klijn_CellLines:Lung=1}","ATTS":["ChimerPub","Cosmic","ChimerKB","ChimerSeq","FA_CancerSupp","YOSHIHARA_TCGA","CCLE","chimerdb_pubmed","HaasMedCancer","Klijn_CellLines"],"LOCALITY":["INTRACHROMOSOMAL[chr2:12.25Mb]"],"Cosmic":"Cosmic{samples=11215,mutations=703,papers=514}"}}
EWSR1--ATF1	{"EWSR1--ATF1":{"Mitelman":"SA_clear=4","ATTS":["ChimerSeq","ChimerKB","Cosmic","Mitelman","ChimerPub"],"LOCALITY":["INTERCHROMOSOMAL[chr22--chr12]"],"Cosmic":"Cosmic{samples=357,mutations=179,papers=46}"}}
EWSR1--FLI1	{"EWSR1--FLI1":{"Mitelman":"SA_Ewing=14","Klijn_CellLines":"{Klijn_CellLines:Sarcomatoid=3}","ATTS":["CCLE","Klijn_CellLines","ChimerKB","ChimerSeq","FA_CancerSupp","ChimerPub","Mitelman","Cosmic"],"LOCALITY":["INTERCHROMOSOMAL[chr22--chr11]"],"Cosmic":"Cosmic{samples=2132,mutations=1332,papers=165}"}}
TMPRSS2--ETV1	{"TMPRSS2--ETV1":{"chimerdb_pubmed":"prostate carcinomas,prostate cancer","ATTS":["ChimerSeq","chimerdb_pubmed","ChimerKB","FA_CancerSupp","Cosmic","ChimerPub"],"LOCALITY":["INTERCHROMOSOMAL[chr21--chr7]"],"Cosmic":"Cosmic{samples=1078,mutations=21,papers=34}"}}
ETV6--NTRK3	{"ETV6--NTRK3":{"YOSHIHARA_TCGA":"BRCA:1|SKCM:1|THCA:6","HaasMedCancer":{"PMID:29281951":"Gene Fusions in Thyroid Cancer."},"chimerdb_omim":"ongenitalfibrosarcoma","chimerdb_pubmed":"secretory breast cancer,\"Congenital fibrosarcoma (CFS), adulttype fibrosarcoma (ATFS)\",\"AML, Mesoblastic nephroma\",secretory breast carcinoma,congenital fibrosarcoma,\"Secretory carcinomas (SBC), invasive ductal carcinoma\",synovial sarcomas,Secretory breast carcinoma,Secretory carcinomas,congenital mesoblastic nephromas (CMNs),certain pediatric tumor,soft tissue tumours ,DanaFarber Cancer,synovial sarcoma,myelodysplastic syndrome (MDS)","ATTS":["chimerdb_omim","Larsson_TCGA","YOSHIHARA_TCGA","chimerdb_pubmed","HaasMedCancer","Cosmic","ChimerPub","ChimerSeq","ChimerKB","FA_CancerSupp"],"LOCALITY":["INTERCHROMOSOMAL[chr12--chr15]"],"Cosmic":"Cosmic{samples=1059,mutations=144,papers=49}"}}
CD74--ROS1	{"CD74--ROS1":{"Klijn_CellLines":"{Klijn_CellLines:Breast=1}","chimerdb_pubmed":"Lung Cancer","ATTS":["ChimerKB","chimerdb_pubmed","ChimerSeq","FA_CancerSupp","Klijn_CellLines","ChimerPub","Cosmic"],"LOCALITY":["INTERCHROMOSOMAL[chr5--chr6]"],"Cosmic":"Cosmic{samples=1701,mutations=39,papers=50}"}}
HOOK3--RET	{"HOOK3--RET":{"HaasMedCancer":{"PMID:29281951":"Gene Fusions in Thyroid Cancer."},"ATTS":["Cosmic","ChimerKB","ChimerSeq","HaasMedCancer"],"LOCALITY":["INTERCHROMOSOMAL[chr8--chr10]"],"Cosmic":"Cosmic{samples=55,mutations=1,papers=6}"}}
EML4--ALK	{"EML4--ALK":{"YOSHIHARA_TCGA":"LUAD:4|THCA:1","HaasMedCancer":{"PMID:29281951":"Gene Fusions in Thyroid Cancer."},"chimerdb_pubmed":"lung cancer,lung cancers,nonsmall cell lung cancers (NSCLC),nonsmallcell lung cancer (NSCLC),nonsmallcell lung cancers (NSCLC),nonsmall cell lung cancer (NSCLC),nonsmall cell lung carcinoma","Klijn_CellLines":"{Klijn_CellLines:Lung=1}","ATTS":["ChimerPub","Cosmic","ChimerKB","ChimerSeq","FA_CancerSupp","YOSHIHARA_TCGA","CCLE","chimerdb_pubmed","HaasMedCancer","Klijn_CellLines"],"LOCALITY":["INTRACHROMOSOMAL[chr2:12.25Mb]"],"Cosmic":"Cosmic{samples=11215,mutations=703,papers=514}"}}
AKAP9--BRAF	{"AKAP9--BRAF":{"HaasMedCancer":{"PMID:29281951":"Gene Fusions in Thyroid Cancer."},"chimerdb_pubmed":"Thyroid carcinoma","ATTS":["HaasMedCancer","chimerdb_pubmed","ChimerKB","ChimerSeq","ChimerPub","Cosmic"],"LOCALITY":["INTRACHROMOSOMAL[chr7:48.68Mb]"],"Cosmic":"Cosmic{samples=292,mutations=4,papers=11}"}}
BRD4--NUTM1	{"BRD4--NUTM1":{"HaasMedCancer":{"PMID:29356724":"NUTM1 Gene Fusions Characterize a Subset of Undifferentiated Soft Tissue and Visceral Tumors."},"ATTS":["Cosmic","ChimerSeq","CCLE","ChimerKB","HaasMedCancer"],"LOCALITY":["INTERCHROMOSOMAL[chr19--chr15]"],"Cosmic":"Cosmic{samples=174,mutations=19,papers=13}"}}
FGFR3--TACC3	{"FGFR3--TACC3":{"YOSHIHARA_TCGA":"BLCA:3|GBM:5|HNSC:2|LGG:1|LUSC:4","Klijn_CellLines":"{Klijn_CellLines:Urinary_Bladder=1,Liver=1}","ATTS":["CCLE","Klijn_CellLines","YOSHIHARA_TCGA","ChimerKB","ChimerSeq","FA_CancerSupp","ChimerPub","Cosmic"],"LOCALITY":["INTRACHROMOSOMAL[chr4:0.05Mb]","LOCAL_REARRANGEMENT:+:[48136]"],"Cosmic":"Cosmic{samples=330,mutations=14,papers=11}"}}
FIP1L1--PDGFRA	{"FIP1L1--PDGFRA":{"Mitelman":"ALL=1","chimerdb_pubmed":"myelodysplastic syndromes (MDS),\"chronic eosinophilic leukemia(CEL), Systemic mastocytosis (SM)\",eosinophiliaassociated myeloproliferative neoplasms,Chronic eosinophilic leukemia (CEL),lymphomatoid papulosis (LyP),eosinophiliaassociated myeloproliferative disorders (EosMPD),chronic eosinophilic leukemia(CEL),leukemia,Systemic mastocytosis (SM),chronic eosinophilic leukemia,Idiopathic hypereosinophilic syndrome  and chronic eosinophilia leukemia,acute myeloid leukemia (AML),Chronic eosinophilic leukemia,hypereosinophilic syndrome,idiopathic hypereosinophilia,Idiopathic hypereosinophilic syndrome (HES),Hypereosinophilic syndrome,chronic myeloid leukemia (CML),\"idiopathic hypereosinophilic syndrome, chronic eosinophilic leukemia\",chronic myeloid leukemia","ATTS":["ConjoinG","Mitelman","chimerdb_pubmed","ChimerKB","ChimerSeq"],"LOCALITY":["INTRACHROMOSOMAL[chr4:0.77Mb]"]}}
GOPC--ROS1	{"GOPC--ROS1":{"Mitelman":"Astcyt_III-IV=1","chimerdb_pubmed":"astrocytoma","ATTS":["chimerdb_pubmed","ChimerKB","ChimerPub","Cosmic","Mitelman"],"LOCALITY":["INTRACHROMOSOMAL[chr6:0.13Mb]"],"Cosmic":"Cosmic{samples=242,mutations=7,papers=15}"}}
PDE6B--PPP2R2D	{"PDE6B--PPP2R2D":{"ATTS":["GTEx"],"LOCALITY":["INTERCHROMOSOMAL[chr4--chr10]"],"GTEx":"GTEx_Recurrent:{Brain=[count:3=pct:0.4],Pancreas=[count:2=pct:1.1],Spleen=[count:1=pct:0.9],Lung=[count:1=pct:0.6],Prostate=[count:1=pct:1.6],Esophagus=[count:1=pct:0.2]}"}}
NCOR2--UBC	{"NCOR2--UBC":{"BodyMap":"adipose-ERR030880,liver-ERR030887,skeletal_muscle-ERR030876,thyroid-ERR030872","ATTS":["ChimerSeq","GTEx","BodyMap"],"LOCALITY":["INTRACHROMOSOMAL[chr12:0.34Mb]"],"GTEx":"GTEx_Recurrent:{Muscle=[count:53=pct:22.5],Esophagus=[count:44=pct:10.8],Skin=[count:33=pct:10.3],Blood_Vessel=[count:27=pct:7.3],Blood=[count:23=pct:13.2],Whole_Blood=[count:23=pct:17.4],Adipose_Tissue=[count:20=pct:6.7],Lung=[count:17=pct:10.2],Colon=[count:16=pct:8.4],Heart=[count:11=pct:4.3],Brain=[count:10=pct:1.5],Breast=[count:6=pct:5.4],Salivary_Gland=[count:5=pct:12.8],Stomach=[count:3=pct:3.4],Uterus=[count:3=pct:7.0],Liver=[count:3=pct:2.4],Bladder=[count:2=pct:22.2],Pituitary=[count:2=pct:3.8],Thyroid=[count:2=pct:1.1],Spleen=[count:2=pct:1.8],Prostate=[count:2=pct:3.3],Nerve=[count:1=pct:0.6],Adrenal_Gland=[count:1=pct:1.2],Small_Intestine=[count:1=pct:1.8],Ovary=[count:1=pct:1.9],Pancreas=[count:1=pct:0.6]}"}}
KANSL1--ARL17B	{"KANSL1--ARL17B":{"BodyMap":"brain-ERR030882,breast-ERR030883,kidney-ERR030885,lymph_node-ERR030878","ATTS":["Babiceanu_Normal","ChimerSeq","CCLE","BodyMap","GTEx"],"LOCALITY":["INTRACHROMOSOMAL[chr17:0.05Mb]","LOCAL_REARRANGEMENT:-:[49417]"],"GTEx":"GTEx_Recurrent:{Brain=[count:234=pct:34.7],Esophagus=[count:134=pct:33.0],Blood_Vessel=[count:116=pct:31.4],Adipose_Tissue=[count:103=pct:34.4],Skin=[count:103=pct:32.1],Heart=[count:75=pct:29.5],Muscle=[count:72=pct:30.5],Nerve=[count:64=pct:36.8],Thyroid=[count:58=pct:32.4],Colon=[count:57=pct:29.8],Blood=[count:54=pct:31.0],Lung=[count:53=pct:31.7],Whole_Blood=[count:45=pct:34.1],Pancreas=[count:43=pct:23.8],Breast=[count:38=pct:34.2],Liver=[count:36=pct:28.6],Testis=[count:34=pct:32.4],Spleen=[count:34=pct:30.4],Adrenal_Gland=[count:27=pct:31.8],Stomach=[count:26=pct:29.2],Vagina=[count:24=pct:43.6],Ovary=[count:23=pct:43.4],Prostate=[count:22=pct:36.1],Pituitary=[count:17=pct:32.7],Uterus=[count:16=pct:37.2],Small_Intestine=[count:16=pct:29.1],Salivary_Gland=[count:14=pct:35.9],Kidney=[count:5=pct:33.3],Cervix_Uteri=[count:4=pct:50.0],Bladder=[count:3=pct:33.3],Fallopian_Tube=[count:2=pct:33.3]}"}}
KANSL1--ARL17A	{"KANSL1--ARL17A":{"BodyMap":"colon-ERR030884","ATTS":["Babiceanu_Normal","ChimerSeq","GTEx","BodyMap"],"LOCALITY":["INTRACHROMOSOMAL[chr17:0.29Mb]"],"GTEx":"GTEx_Recurrent:{Brain=[count:13=pct:1.9],Heart=[count:9=pct:3.5],Esophagus=[count:6=pct:1.5],Adipose_Tissue=[count:5=pct:1.7],Blood_Vessel=[count:3=pct:0.8],Skin=[count:3=pct:0.9],Pancreas=[count:3=pct:1.7],Blood=[count:2=pct:1.1],Stomach=[count:2=pct:2.2],Liver=[count:2=pct:1.6],Spleen=[count:1=pct:0.9],Colon=[count:1=pct:0.5],Whole_Blood=[count:1=pct:0.8],Vagina=[count:1=pct:1.8],Adrenal_Gland=[count:1=pct:1.2],Muscle=[count:1=pct:0.4],Testis=[count:1=pct:1.0],Lung=[count:1=pct:0.6],Thyroid=[count:1=pct:0.6],Salivary_Gland=[count:1=pct:2.6]}"}}
C15orf57--CBX3	{"C15orf57--CBX3":{"BodyMap":"ovary-ERR030874","ATTS":["Babiceanu_Normal","GTEx","BodyMap"],"LOCALITY":["INTERCHROMOSOMAL[chr15--chr7]"],"GTEx":"GTEx_Recurrent:{Muscle=[count:83=pct:35.2],Blood_Vessel=[count:74=pct:20.0],Adipose_Tissue=[count:59=pct:19.7],Heart=[count:59=pct:23.2],Thyroid=[count:47=pct:26.3],Esophagus=[count:39=pct:9.6],Spleen=[count:39=pct:34.8],Lung=[count:35=pct:21.0],Brain=[count:27=pct:4.0],Colon=[count:26=pct:13.6],Adrenal_Gland=[count:20=pct:23.5],Pituitary=[count:16=pct:30.8],Nerve=[count:15=pct:8.6],Pancreas=[count:14=pct:7.7],Prostate=[count:12=pct:19.7],Stomach=[count:12=pct:13.5],Blood=[count:12=pct:6.9],Skin=[count:11=pct:3.4],Testis=[count:10=pct:9.5],Small_Intestine=[count:10=pct:18.2],Uterus=[count:8=pct:18.6],Ovary=[count:8=pct:15.1],Breast=[count:8=pct:7.2],Whole_Blood=[count:8=pct:6.1],Liver=[count:7=pct:5.6],Salivary_Gland=[count:5=pct:12.8],Vagina=[count:5=pct:9.1],Kidney=[count:3=pct:20.0]}"}}
```