/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.ResourceLimitedMap;
import htsjdk.samtools.util.ResourceLimitedMapFunctor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileAppendStreamLRUCache
extends ResourceLimitedMap<File, FileOutputStream> {
    public FileAppendStreamLRUCache(int cacheSize) {
        super(cacheSize, new Functor());
    }

    private static class Functor
    implements ResourceLimitedMapFunctor<File, FileOutputStream> {
        private static final int GC_FREQUENCY = 10000;
        private int numCloses = 0;

        private Functor() {
        }

        @Override
        public FileOutputStream makeValue(File file) {
            try {
                return new FileOutputStream(file, true);
            }
            catch (FileNotFoundException e) {
                System.gc();
                System.runFinalization();
                try {
                    return new FileOutputStream(file, true);
                }
                catch (FileNotFoundException e2) {
                    throw new SAMException(file + "not found", e2);
                }
            }
        }

        @Override
        public void finalizeValue(File file, FileOutputStream fileOutputStream) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw new SAMException("Exception closing FileOutputStream for " + file, e);
            }
        }
    }
}

