/*
 * Decompiled with CFR 0.152.
 */
package search.ranking.results;

import core.Haplogroup;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import search.SearchResult;
import search.ranking.results.RankedResult;

public class KylczynskiResult
extends RankedResult {
    private double kylcinskiDistance = this.calcDistance();

    public KylczynskiResult(SearchResult phyloSearchData, Haplogroup expectedHaplogroup) {
        super(phyloSearchData, expectedHaplogroup);
    }

    @Override
    public int compareTo(RankedResult o) {
        int delta = (int)Math.signum(((KylczynskiResult)o).kylcinskiDistance - this.kylcinskiDistance);
        if (delta == 0) {
            delta = super.compareTo(o);
        }
        return delta;
    }

    private double calcDistance() {
        if (this.getCorrectPolyInTestSampleRatio() > 0.0 && this.getCorrectPolyInHaplogroupRatio() > 0.0) {
            return this.getCorrectPolyInTestSampleRatio() * 0.5 + this.getCorrectPolyInHaplogroupRatio() * 0.5;
        }
        if (this.getCorrectPolyInTestSampleRatio() > 0.0) {
            return this.getCorrectPolyInTestSampleRatio() * 0.5;
        }
        if (this.getCorrectPolyInHaplogroupRatio() > 0.0) {
            return this.getCorrectPolyInHaplogroupRatio() * 0.5;
        }
        return 0.0;
    }

    public double getCorrectPolyInTestSampleRatio() {
        return this.searchResult.getWeightFoundPolys() / this.searchResult.getSumWeightsAllPolysSample();
    }

    private double getCorrectPolyInHaplogroupRatio() {
        if (this.searchResult.getExpectedWeightPolys() != 0.0) {
            return this.searchResult.getWeightFoundPolys() / this.searchResult.getExpectedWeightPolys();
        }
        return 1.0;
    }

    @Override
    public double getDistance() {
        return this.kylcinskiDistance;
    }

    @Override
    public void attachToJsonObject(JSONObject child) throws JSONException {
        DecimalFormat df = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        child.put("rank", df.format(this.kylcinskiDistance));
        child.put("name", this.searchResult.getHaplogroup().toString());
        child.put("id", this.searchResult.getHaplogroup().toString());
        if (!Double.isNaN(this.getCorrectPolyInTestSampleRatio())) {
            child.put("rankS", df.format(this.getCorrectPolyInTestSampleRatio()));
        } else {
            child.put("rankS", "-");
        }
        if (!Double.isNaN(this.getCorrectPolyInHaplogroupRatio())) {
            child.put("rankHG", df.format(this.getCorrectPolyInHaplogroupRatio()));
        } else {
            child.put("rankHG", "-");
        }
    }
}

