/*
 * Decompiled with CFR 0.152.
 */
package search.ranking.results;

import core.Haplogroup;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import search.SearchResult;
import search.ranking.results.RankedResult;

public class Kimura2PResult
extends RankedResult {
    private double kimura2PDistance = this.calcDistance();

    public Kimura2PResult(SearchResult phyloSearchData, Haplogroup expectedHaplogroup) {
        super(phyloSearchData, expectedHaplogroup);
    }

    @Override
    public int compareTo(RankedResult o) {
        int delta = (int)Math.signum(this.kimura2PDistance - ((Kimura2PResult)o).kimura2PDistance);
        if (delta == 0) {
            delta = super.compareTo(o);
        }
        return delta;
    }

    private double calcDistance() {
        double p = this.searchResult.getDetailedResult().getSumWeightsRemainingTransitions() / 16569.0;
        double q = this.searchResult.getDetailedResult().getSumWeightsRemainingTransversion() / 16569.0;
        return 0.5 * Math.log(1.0 / (1.0 - 2.0 * p - q)) + 0.25 * Math.log(1.0 / (1.0 - 2.0 * q));
    }

    private double getCorrectPolyInTestSample() {
        return this.searchResult.getDetailedResult().getSumWeightsRemainingTransitions();
    }

    private double getAllPoly() {
        return this.searchResult.getDetailedResult().getSumWeightsRemainingTransversion();
    }

    @Override
    public double getDistance() {
        return this.kimura2PDistance;
    }

    @Override
    public void attachToJsonObject(JSONObject child) throws JSONException {
        DecimalFormat df = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        child.put("rank", df.format(this.kimura2PDistance));
        child.put("rankHG", df.format(this.getCorrectPolyInTestSample()));
        child.put("rankS", df.format(this.getAllPoly()));
        child.put("name", this.searchResult.getHaplogroup().toString());
        child.put("id", this.searchResult.getHaplogroup().toString());
    }
}

