/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.rules;

import core.Polymorphism;
import core.TestSample;
import exceptions.parse.sample.InvalidPolymorphismException;
import genepi.io.table.reader.CsvTableReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import qualityAssurance.QualityAssistent;
import qualityAssurance.rules.HaplogrepRule;

public class FixNomenclature
extends HaplogrepRule {
    private HashMap<String, String> rules = null;

    public FixNomenclature(int priority, String file) {
        super(priority, file);
    }

    @Override
    public void evaluate(QualityAssistent qualityAssistent, TestSample currentSample) {
        if (this.rules == null) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.getFile());
            CsvTableReader reader = new CsvTableReader(new DataInputStream(stream), ',');
            this.rules = new HashMap();
            while (reader.next()) {
                this.rules.put(reader.getString("error"), reader.getString("expected"));
            }
        }
        ArrayList<Polymorphism> inPolys = currentSample.getSample().getPolymorphisms();
        ArrayList<Polymorphism> outPolys = new ArrayList<Polymorphism>();
        HashSet<String> inputProfile = new HashSet<String>();
        for (Polymorphism current : inPolys) {
            inputProfile.add(current.toString());
        }
        for (String error : this.rules.keySet()) {
            String[] splits;
            boolean applyRule = true;
            for (String split : splits = error.split(" ")) {
                if (inputProfile.contains(split)) continue;
                applyRule = false;
            }
            if (!applyRule) continue;
            String expected = this.rules.get(error);
            try {
                for (String exp : expected.split(" ")) {
                    outPolys.add(new Polymorphism(exp));
                }
                for (String err : error.split(" ")) {
                    inputProfile.remove(err);
                }
            }
            catch (InvalidPolymorphismException e) {
                e.printStackTrace();
            }
        }
        for (String in : inputProfile) {
            try {
                outPolys.add(new Polymorphism(in));
            }
            catch (InvalidPolymorphismException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(outPolys);
        currentSample.getSample().setPolymorphisms(outPolys);
    }

    @Override
    public void suppressIssues(QualityAssistent qualityAssistent, TestSample currentSample) {
    }
}

