/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.rules;

import core.Polymorphism;
import core.TestSample;
import exceptions.parse.sample.InvalidPolymorphismException;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityFatal;
import qualityAssurance.rules.HaplogrepRule;

public class CheckForSampleRCRSAligned
extends HaplogrepRule {
    public CheckForSampleRCRSAligned(int priority) {
        super(priority);
    }

    @Override
    public void evaluate(QualityAssistent qualityAssistent, TestSample currentSample) {
        try {
            if (currentSample.getSample().contains(new Polymorphism("263G")) == 0 && currentSample.getSample().contains(new Polymorphism("8860G")) == 0) {
                qualityAssistent.addNewIssue(new QualityFatal(qualityAssistent, currentSample, "Common rCRS polymorphim (263G 8860G or 15326G) not found! The sample seems not properly aligned to rCRS.", IssueType.QUAL));
            }
        }
        catch (InvalidPolymorphismException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void suppressIssues(QualityAssistent qualityAssistent, TestSample currentSample) {
    }
}

