/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.rules;

import core.Polymorphism;
import core.TestSample;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityWarning;
import qualityAssurance.rules.HaplogrepRule;

public class CheckForReferencePolymorhisms
extends HaplogrepRule {
    final Log log = LogFactory.getLog(CheckForReferencePolymorhisms.class);

    public CheckForReferencePolymorhisms(int priority) {
        super(priority);
    }

    @Override
    public void evaluate(QualityAssistent qualityAssistent, TestSample currentSample) {
        ArrayList<Polymorphism> foundReferencePolys = new ArrayList<Polymorphism>();
        for (Polymorphism currentPoly : currentSample.getSample().getPolymorphisms()) {
            if (!currentPoly.equalsReference()) continue;
            foundReferencePolys.add(currentPoly);
        }
        if (foundReferencePolys.size() > 0) {
            qualityAssistent.addNewIssue(new QualityWarning(qualityAssistent, currentSample, "The sample contains " + foundReferencePolys.size() + " polymorphimsms that are equal to the reference.", IssueType.QUAL));
        }
    }

    @Override
    public void suppressIssues(QualityAssistent qualityAssistent, TestSample currentSample) {
    }
}

