/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.issues;

import core.TestSample;
import java.util.ArrayList;
import qualityAssurance.CorrectionMethod;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;

public class QualityIssue
implements Comparable<QualityIssue> {
    int issueID;
    int priority;
    IssueType issueType;
    String description;
    TestSample sampleOfIssue;
    boolean suppress = false;
    protected ArrayList<CorrectionMethod> correctionMethods = new ArrayList();

    public QualityIssue(QualityAssistent qualityAssistent, int priority, TestSample sampleofIssue, String description, IssueType issue) {
        this.issueID = qualityAssistent.getNewIssueID();
        this.priority = priority;
        this.sampleOfIssue = sampleofIssue;
        this.description = description;
        this.issueType = issue;
    }

    @Override
    public int compareTo(QualityIssue o) {
        return this.priority - o.priority;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getIssueID() {
        return this.issueID;
    }

    public TestSample getSampleOfIssue() {
        return this.sampleOfIssue;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getSampleID() {
        return this.sampleOfIssue.getSampleID();
    }

    public boolean isSuppress() {
        return this.suppress;
    }

    public void setSuppress(boolean suppress) {
        this.suppress = suppress;
    }

    public ArrayList<CorrectionMethod> getChildren() {
        return this.correctionMethods;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public void setIssueType(IssueType issueType) {
        this.issueType = issueType;
    }

    public void doAutoCorrection(QualityAssistent qualityAssistent, int correctionMethodID) {
        if (this.correctionMethods.size() > correctionMethodID) {
            this.correctionMethods.get(correctionMethodID).execute(this.sampleOfIssue);
        }
    }

    public boolean getLeaf() {
        return this.correctionMethods.isEmpty();
    }

    public String getIconCls() {
        return "icon-show-rules";
    }
}

