/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance;

import core.TestSample;
import java.util.ArrayList;
import java.util.HashMap;
import qualityAssurance.QualityAssistent;
import qualityAssurance.rules.CheckExpectedHGMatchesDetectedHG;
import qualityAssurance.rules.CheckForAlignmentWarnings;
import qualityAssurance.rules.CheckForAmbiguosResult;
import qualityAssurance.rules.CheckForHeteroplasmy;
import qualityAssurance.rules.CheckForQuality;
import qualityAssurance.rules.CheckForTooManyGlobalPrivateMutations;
import qualityAssurance.rules.CheckForTooManyLocalPrivateMutations;
import qualityAssurance.rules.CheckForTooManyLocalPrivateMutationsHaploGroup;
import qualityAssurance.rules.CheckForTooManyN;
import qualityAssurance.rules.CheckForTooManyNotFound;
import qualityAssurance.rules.CheckForTooManyRCRSpos;
import qualityAssurance.rules.FixNomenclature;
import qualityAssurance.rules.HaplogrepRule;

public class RuleSet {
    HashMap<Integer, ArrayList<HaplogrepRule>> rules = new HashMap();

    public void addStandardRules() {
        this.addRule(new CheckExpectedHGMatchesDetectedHG(1));
        this.addRule(new CheckForTooManyGlobalPrivateMutations(1));
        this.addRule(new CheckForTooManyNotFound(1));
        this.addRule(new CheckForAmbiguosResult(1));
        this.addRule(new CheckForTooManyLocalPrivateMutations(1));
        this.addRule(new CheckForTooManyLocalPrivateMutationsHaploGroup(1));
        this.addRule(new CheckForAlignmentWarnings(1));
        this.addRule(new CheckForHeteroplasmy(1));
        this.addRule(new CheckForTooManyN(1));
        this.addRule(new CheckForTooManyRCRSpos(1));
        this.addRule(new CheckForQuality(1));
    }

    public void addNomenclatureRules(String file) {
        this.addRule(new FixNomenclature(1, file));
    }

    public void addRule(HaplogrepRule newRule) {
        if (!this.rules.containsKey(newRule.getPriority())) {
            this.rules.put(newRule.getPriority(), new ArrayList());
        }
        this.rules.get(newRule.getPriority()).add(newRule);
    }

    void reevaluateAllRules(QualityAssistent qualityAssistent, TestSample currentSample) {
        for (int i = 0; i < 10; ++i) {
            if (qualityAssistent.getIssues(currentSample).size() != 0) continue;
            this.reevaluateRules(qualityAssistent, i, currentSample);
        }
        for (int currentPriority : this.rules.keySet()) {
            if (currentSample.getQualityLevelReached() > currentPriority) continue;
            this.suppressRules(qualityAssistent, currentPriority, currentSample);
        }
    }

    private void reevaluateRules(QualityAssistent qualityAssistent, int priority, TestSample currentSample) {
        for (HaplogrepRule currentRule : this.rules.get(priority)) {
            currentRule.evaluate(qualityAssistent, currentSample);
        }
    }

    private void suppressRules(QualityAssistent qualityAssistent, int priority, TestSample currentSample) {
        for (HaplogrepRule currentRule : this.rules.get(priority)) {
            currentRule.suppressIssues(qualityAssistent, currentSample);
        }
    }

    public ArrayList<HaplogrepRule> getRulesLevel(int levelID) {
        return this.rules.get(levelID);
    }
}

