/*
 * Decompiled with CFR 0.152.
 */
package phylotree;

import core.Haplogroup;
import core.Polymorphism;
import core.TestSample;
import exceptions.parse.sample.InvalidBaseException;
import exceptions.parse.sample.InvalidPolymorphismException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import phylotree.PhyloTreeNode;
import search.SearchResult;
import search.ranking.RankingMethod;
import search.ranking.results.RankedResult;

public final class Phylotree {
    final Log log = LogFactory.getLog(Phylotree.class);
    private PhyloTreeNode root;
    private HashMap<String, Double> phyloGeneticWeights = new HashMap();
    private HashMap<Haplogroup, PhyloTreeNode> haplogroupLookup = new HashMap();

    public Phylotree(InputStream phylotreeFile, InputStream phylogeneticWeightsFile) {
        this.root = new PhyloTreeNode(this);
        SAXBuilder builder = new SAXBuilder();
        try {
            Document phyloTree = builder.build(phylotreeFile);
            this.buildPhylotree(this.root, phyloTree.getRootElement().getChild("haplogroup"));
            this.setPolygeneticWeights(phylogeneticWeightsFile);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (InvalidBaseException e) {
            e.printStackTrace();
        }
        catch (InvalidPolymorphismException e) {
            e.printStackTrace();
        }
    }

    private void buildPhylotree(PhyloTreeNode parentNode, Element currentXMLElement) throws InvalidPolymorphismException {
        PhyloTreeNode newNode = new PhyloTreeNode(this, parentNode, new Haplogroup(currentXMLElement.getAttribute("name").getValue()));
        parentNode.addSubHaplogroup(newNode);
        this.haplogroupLookup.put(newNode.getHaplogroup(), newNode);
        List polys = currentXMLElement.getChild("details").getChildren("poly");
        for (Element currentPolyElement : polys) {
            Polymorphism newExpectedPoly = new Polymorphism(currentPolyElement.getValue());
            newNode.addExpectedPoly(newExpectedPoly);
        }
        List children = currentXMLElement.getChildren("haplogroup");
        for (Element currentChildElement : children) {
            this.buildPhylotree(newNode, currentChildElement);
        }
    }

    public List<RankedResult> search(TestSample testSample, RankingMethod rankingMethodToUse) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        SearchResult rootResult = new SearchResult(this.root, testSample);
        this.searchPhylotree(this.root, results, testSample, rootResult);
        rankingMethodToUse.setResults(testSample, results);
        results.clear();
        return rankingMethodToUse.getResults();
    }

    private void searchPhylotree(PhyloTreeNode parent, ArrayList<SearchResult> results, TestSample sample, SearchResult parentResult) {
        List<PhyloTreeNode> children = parent.getSubHaplogroups();
        for (PhyloTreeNode currentElement : children) {
            SearchResult newResult = new SearchResult(currentElement, parentResult);
            ArrayList<Polymorphism> polys = currentElement.getExpectedPolys();
            for (Polymorphism currentPoly : polys) {
                if (sample.getSample().getSampleRanges().contains(currentPoly)) {
                    if (currentPoly.isBackMutation()) {
                        newResult.removeExpectedPolyWeight(currentPoly);
                        newResult.removeFoundPolyWeight(currentPoly, sample.getSample());
                        continue;
                    }
                    if (newResult.getSample().contains(currentPoly) == 1) {
                        newResult.addExpectedPolyWeight(currentPoly);
                        newResult.addFoundPolyWeight(currentPoly);
                        continue;
                    }
                    if (newResult.getSample().contains(currentPoly) == 2) {
                        currentPoly.setHeteroplasmy(true);
                        newResult.addExpectedPolyWeight(currentPoly);
                        newResult.addFoundPolyWeight(currentPoly);
                        continue;
                    }
                    if (currentPoly.isBackMutation()) {
                        newResult.removeMissingOutOfRangeWeight(currentPoly);
                    }
                    newResult.addExpectedPolyWeight(currentPoly);
                    continue;
                }
                newResult.addMissingOutOfRangeWeight(currentPoly);
            }
            results.add(newResult);
            this.searchPhylotree(currentElement, results, sample, newResult);
        }
    }

    private void getAllHaplogroups(PhyloTreeNode parent, ArrayList<SearchResult> results, SearchResult parentResult, PrintWriter fileHSD) {
        List<PhyloTreeNode> children = parent.getSubHaplogroups();
        StringBuffer sb = new StringBuffer();
        for (PhyloTreeNode currentElement : children) {
            SearchResult newResult = new SearchResult(currentElement, parentResult);
            ArrayList<Polymorphism> polys = currentElement.getExpectedPolys();
            fileHSD.printf("" + currentElement.getHaplogroup() + "\t 1-16569\t" + currentElement.getHaplogroup() + "\t" + newResult.getDetailedResult().getExpectedPolys().toString().replace(",", "\t").replace("[", "").replace("]", "").replace(" ", "") + "\n", new Object[0]);
            results.add(newResult);
            this.getAllHaplogroups(currentElement, results, newResult, fileHSD);
            fileHSD.printf("ENDE " + currentElement.getHaplogroup(), new Object[0]);
        }
    }

    public void setPolygeneticWeights(InputStream inStreamPhyloWeightsFile) throws IOException, InvalidBaseException {
        BufferedReader flucFile = new BufferedReader(new InputStreamReader(inStreamPhyloWeightsFile));
        String line = flucFile.readLine();
        while (line != null) {
            StringTokenizer mainTokenizer = new StringTokenizer(line, "\t");
            String polyString = mainTokenizer.nextToken();
            double phyloGeneticWeight = Double.parseDouble(mainTokenizer.nextToken());
            try {
                this.phyloGeneticWeights.put(polyString, phyloGeneticWeight);
            }
            catch (Exception exception) {
                // empty catch block
            }
            line = flucFile.readLine();
        }
    }

    public double getMutationRate(Polymorphism polyToCheck) {
        if (this.phyloGeneticWeights.containsKey(polyToCheck.toString())) {
            return this.phyloGeneticWeights.get(polyToCheck.toString());
        }
        return 0.0;
    }

    public PhyloTreeNode getPhyloTree() {
        return this.root;
    }

    public boolean isSuperHaplogroup(Haplogroup superGroup, Haplogroup hgToCheck) {
        if (superGroup == null) {
            return false;
        }
        for (PhyloTreeNode currentNode = this.haplogroupLookup.get(superGroup); currentNode != null; currentNode = currentNode.getParent()) {
            if (!currentNode.getHaplogroup().equals(hgToCheck)) continue;
            return true;
        }
        return false;
    }

    public int distanceToSuperHaplogroup(Haplogroup superGroup, Haplogroup hgToCheck) {
        PhyloTreeNode currentNode = this.haplogroupLookup.get(superGroup);
        int distance = 0;
        if (superGroup == null) {
            return -1;
        }
        while (currentNode != null) {
            if (currentNode.getHaplogroup().equals(hgToCheck)) {
                return distance;
            }
            currentNode = currentNode.getParent();
            ++distance;
        }
        return -1;
    }

    public int getDistanceBetweenHaplogroupsOld(Haplogroup hgToCheck1, Haplogroup hgToCheck2) {
        PhyloTreeNode c2;
        int distance = -1;
        HashSet<Haplogroup> markedHaplogroups = new HashSet<Haplogroup>();
        boolean complete = false;
        PhyloTreeNode c1 = this.haplogroupLookup.get(hgToCheck1);
        if (c1.equals((c2 = this.haplogroupLookup.get(hgToCheck2)).getParent()) || c2.equals(c1.getParent())) {
            distance = 1;
            complete = true;
        }
        while (!complete) {
            if (c1 != null && !markedHaplogroups.contains(c1.getHaplogroup())) {
                markedHaplogroups.add(c1.getHaplogroup());
                c1 = c1.getParent();
                ++distance;
            } else {
                complete = true;
                break;
            }
            if (c2 != null && !markedHaplogroups.contains(c2.getHaplogroup())) {
                markedHaplogroups.add(c2.getHaplogroup());
                c2 = c2.getParent();
                ++distance;
                continue;
            }
            complete = true;
            break;
        }
        return distance;
    }

    public int getDistanceBetweenHaplogroups(Haplogroup hgToCheck1, Haplogroup hgToCheck2) throws Exception {
        PhyloTreeNode c2;
        int distance = -1;
        HashSet<Haplogroup> markedHaplogroups = new HashSet<Haplogroup>();
        boolean complete = false;
        PhyloTreeNode c1 = this.haplogroupLookup.get(hgToCheck1);
        if (c1.equals((c2 = this.haplogroupLookup.get(hgToCheck2)).getParent()) || c2.equals(c1.getParent())) {
            distance = 1;
            return distance;
        }
        while (!complete) {
            if (c1 != null) {
                markedHaplogroups.add(c1.getHaplogroup());
                c1 = c1.getParent();
                ++distance;
                continue;
            }
            complete = true;
            break;
        }
        complete = false;
        Haplogroup result = null;
        while (!complete) {
            if (c2 != null && !markedHaplogroups.contains(c2.getHaplogroup())) {
                c2 = c2.getParent();
                ++distance;
                continue;
            }
            if (c2 != null) {
                result = c2.getHaplogroup();
            }
            complete = true;
            break;
        }
        int distanceShared = 0;
        if (result != null) {
            distanceShared = this.getDistanceToRoot(result);
        }
        return distance - distanceShared;
    }

    public Haplogroup getCommonAncestor(Haplogroup hgToCheck1, Haplogroup hgToCheck2) {
        HashSet<Haplogroup> markedHaplogroups = new HashSet<Haplogroup>();
        boolean complete = false;
        PhyloTreeNode c1 = this.haplogroupLookup.get(hgToCheck1);
        PhyloTreeNode c2 = this.haplogroupLookup.get(hgToCheck2);
        while (!complete) {
            if (c1 != null) {
                markedHaplogroups.add(c1.getHaplogroup());
                c1 = c1.getParent();
                continue;
            }
            complete = true;
            break;
        }
        complete = false;
        Haplogroup result = null;
        while (!complete) {
            if (c2 != null && !markedHaplogroups.contains(c2.getHaplogroup())) {
                c2 = c2.getParent();
                continue;
            }
            if (c2 != null) {
                result = c2.getHaplogroup();
            }
            complete = true;
            break;
        }
        return result;
    }

    public int getDistanceToRoot(Haplogroup hgToCheck1) {
        int distance = -1;
        HashSet<Haplogroup> markedHaplogroups = new HashSet<Haplogroup>();
        boolean complete = false;
        PhyloTreeNode c1 = this.haplogroupLookup.get(hgToCheck1);
        while (!complete) {
            if (c1 != null) {
                markedHaplogroups.add(c1.getHaplogroup());
                c1 = c1.getParent();
                ++distance;
                continue;
            }
            complete = true;
            break;
        }
        return distance;
    }
}

