/*
 * Decompiled with CFR 0.152.
 */
package phylotree;

import core.Haplogroup;
import core.Polymorphism;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import phylotree.Phylotree;

public class PhyloTreeNode
implements Serializable {
    private static final long serialVersionUID = -14323995952308895L;
    private Haplogroup haplogroup = null;
    private ArrayList<Polymorphism> expectedPolys = new ArrayList();
    private Phylotree tree = null;
    private PhyloTreeNode parent = null;
    private ArrayList<PhyloTreeNode> subHaplogroups = new ArrayList();

    PhyloTreeNode(Phylotree tree) {
        this.tree = tree;
        this.haplogroup = new Haplogroup("rCRS NC_012920");
    }

    PhyloTreeNode(Phylotree tree, PhyloTreeNode parentNode, Haplogroup haplogroup) {
        this.tree = tree;
        this.parent = parentNode;
        this.haplogroup = haplogroup;
        Collections.sort(this.expectedPolys);
    }

    public Haplogroup getHaplogroup() {
        return this.haplogroup;
    }

    public ArrayList<Polymorphism> getExpectedPolys() {
        return this.expectedPolys;
    }

    void addSubHaplogroup(PhyloTreeNode newChildNode) {
        this.subHaplogroups.add(newChildNode);
    }

    public List<PhyloTreeNode> getSubHaplogroups() {
        return this.subHaplogroups;
    }

    void addExpectedPoly(Polymorphism newExpectedPoly) {
        this.expectedPolys.add(newExpectedPoly);
    }

    public PhyloTreeNode getParent() {
        return this.parent;
    }

    public Phylotree getTree() {
        return this.tree;
    }
}

