/*
 * Decompiled with CFR 0.152.
 */
package phylotree;

import core.AnnotationAAC;
import core.Polymorphism;
import exceptions.parse.sample.InvalidPolymorphismException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Annotation {
    private HashMap<Polymorphism, AnnotationAAC> acidLookup;
    private static Annotation instance = null;
    String annotationPath = "aminoacidchange.txt";

    public void setAnnotationPath(String annotationPath) {
        this.annotationPath = annotationPath;
    }

    public static Annotation getInstance() {
        if (instance == null) {
            instance = new Annotation();
        }
        return instance;
    }

    private void loadLookup() {
        this.acidLookup = new HashMap();
        InputStream annotationStream = this.getClass().getClassLoader().getResourceAsStream(this.annotationPath);
        try {
            BufferedReader annotationFileReader = new BufferedReader(new InputStreamReader(annotationStream));
            String line = annotationFileReader.readLine();
            line = annotationFileReader.readLine();
            while (line != null) {
                StringTokenizer mainTokenizer = new StringTokenizer(line, "\t");
                String pos = mainTokenizer.nextToken();
                String gen = mainTokenizer.nextToken();
                short cod = Short.parseShort(mainTokenizer.nextToken());
                String aachange = mainTokenizer.nextToken();
                AnnotationAAC aac = new AnnotationAAC(pos, gen, cod, aachange);
                this.acidLookup.put(new Polymorphism(pos), aac);
                line = annotationFileReader.readLine();
            }
        }
        catch (InvalidPolymorphismException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HashMap<Polymorphism, AnnotationAAC> getAnnotation() {
        if (this.acidLookup == null) {
            this.loadLookup();
        }
        return this.acidLookup;
    }
}

