/*
 * Decompiled with CFR 0.152.
 */
package importer;

import importer.VcfImporter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import util.ExportUtils;
import vcf.Sample;
import vcf.Variant;

public class VcfLoaderTest {
    @Test
    public void IndelTest() throws Exception {
        String file = "test-data/vcf/testIndel.vcf";
        VcfImporter impvcf = new VcfImporter();
        HashMap<String, Sample> samples = impvcf.load(new File(file), false);
        ArrayList<String> lines = ExportUtils.vcfTohsd(samples);
        Assert.assertEquals((Object)"TL064\t1-16569\t?\t8281d\t8282d\t8283d\t8284d\t8285d\t8286d\t8287d\t8288d\t8289d\t8307d\t8860G\t15940C\t15941d", (Object)lines.get(0).toString().trim());
    }

    @Test
    public void VcfPolyHaploidTest() throws Exception {
        String file = "test-data/vcf/HG00097.vcf";
        VcfImporter impvcf = new VcfImporter();
        HashMap<String, Sample> samples = impvcf.load(new File(file), false);
        ArrayList<String> lines = ExportUtils.vcfTohsd(samples);
        Assert.assertEquals((Object)"HG00097\t1-16569\t?\t73G\t195C\t263G\t309.1CC\t315.1C\t709A\t750G\t1438G\t1888A\t2706G\t4216C\t4769G\t4917G\t5277C\t5426C\t6489A\t7028T\t8697A\t8860G\t10463C\t11251G\t11719A\t11812G\t13368A\t14233G\t14766T\t14905A\t15028A\t15043A\t15326G\t15452A\t15607G\t15928A\t16126C\t16182C\t16183C\t16189C\t16294T\t16296T\t16298C\t16519C", (Object)lines.get(0).toString().trim());
    }

    @Test
    public void VcfMultiAllelicTest() throws Exception {
        String file = "test-data/vcf/NA20877.vcf.gz";
        VcfImporter impvcf = new VcfImporter();
        HashMap<String, Sample> samples = impvcf.load(new File(file), false);
        ArrayList<String> lines = ExportUtils.vcfTohsd(samples);
        Assert.assertEquals((Object)"NA20877.MT.bam\t1-16569\t?\t73G\t152C\t263G\t750G\t1438G\t2706G\t4216C\t7028T\t7142C\t7657C\t8473C\t8860G\t9932A\t10685A\t11719A\t12654G\t13145A\t13500C\t14305A\t14590T\t14766T\t15326G\t16071T\t16519C", (Object)lines.get(0).toString().trim());
    }

    @Test
    public void VcfPolyDiploidTest() throws Exception {
        String file = "test-data/vcf/HG00097_Diploid.vcf";
        StringBuilder actual = new StringBuilder();
        VcfImporter impvcf = new VcfImporter();
        HashMap<String, Sample> samples = impvcf.load(new File(file), false);
        Sample sample = samples.get("HG00097");
        for (Variant var : sample.getVariants()) {
            if (var.getType() != 5) {
                actual.append(String.valueOf(var.getPos()) + var.getVariant() + ",");
                continue;
            }
            actual.append(String.valueOf(var.getInsertion()) + ",");
        }
        Assert.assertEquals((Object)"73G,195C,263G,309.1CC,315.1C,709A,750G,1438G,1888A,2706G,4216C,4769G,4917G,5277C,5426C,6489A,7028T,8697A,8860G,10463C,11251G,11719A,11812G,13368A,14233G,14766T,14905A,15028A,15043A,15326G,15452A,15607G,15928A,16126C,16182C,16183C,16189C,16294T,16296T,16298C,16519C,", (Object)actual.toString());
    }

    @Test
    public void test1000Del() throws Exception {
        String file = "test-data/vcf/1000Gdel.vcf";
        StringBuilder actual = new StringBuilder();
        VcfImporter impvcf = new VcfImporter();
        HashMap<String, Sample> samples = impvcf.load(new File(file), false);
        Sample sample = samples.get("HG00096");
        for (Variant var : sample.getVariants()) {
            actual.append(String.valueOf(var.getPos()) + var.getVariant() + ",");
        }
        Assert.assertEquals((Object)"249d,290d,291d,308d,310d,498d,521d,522d,523d,524d,8281d,8282d,8283d,8284d,8285d,8286d,8287d,8288d,8289d,8307d,16188T,", (Object)actual.toString());
        sample = samples.get("HG00097");
        actual.setLength(0);
        for (Variant var : sample.getVariants()) {
            if (var.getType() != 5) {
                actual.append(String.valueOf(var.getPos()) + var.getVariant() + ",");
                continue;
            }
            actual.append(String.valueOf(var.getInsertion()) + ",");
        }
        Assert.assertEquals((Object)"105T,249d,309.1CC,", (Object)actual.toString());
        sample = samples.get("HG00099");
        actual.setLength(0);
        for (Variant var : sample.getVariants()) {
            if (var.getType() != 5) {
                actual.append(String.valueOf(var.getPos()) + var.getVariant() + ",");
                continue;
            }
            actual.append(String.valueOf(var.getInsertion()) + ",");
        }
        Assert.assertEquals((Object)"309T,", (Object)actual.toString());
        sample = samples.get("HG00100");
        actual.setLength(0);
        for (Variant var : sample.getVariants()) {
            if (var.getType() != 5) {
                actual.append(String.valueOf(var.getPos()) + var.getVariant() + ",");
                continue;
            }
            actual.append(String.valueOf(var.getInsertion()) + ",");
        }
        Assert.assertEquals((Object)"309.1C,16189d,", (Object)actual.toString());
    }
}

