/*
 * Decompiled with CFR 0.152.
 */
package importer;

import importer.FastaImporter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class FastaImporterTests {
    @Test
    public void testRcrs() throws Exception {
        String file = "test-data/fasta/rCRS.fasta";
        StringBuilder actual = new StringBuilder();
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RCRS);
        String[] splits = samples.get(0).split("\t");
        int i = 3;
        while (i < splits.length) {
            actual.append(String.valueOf(splits[i]) + ",");
            ++i;
        }
        Assert.assertEquals((long)0L, (long)actual.length());
    }

    @Test
    public void testRsrs() throws Exception {
        String file = "test-data/fasta/rsrs.fasta";
        StringBuilder actual = new StringBuilder();
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RSRS);
        String[] splits = samples.get(0).split("\t");
        int i = 3;
        while (i < splits.length) {
            actual.append(String.valueOf(splits[i]) + ",");
            ++i;
        }
        Assert.assertEquals((long)0L, (long)actual.length());
    }

    @Test
    public void testRCrsWithRsrsReference() throws Exception {
        String file = "test-data/fasta/rCRS.fasta";
        StringBuilder actual = new StringBuilder();
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RSRS);
        String[] splits = samples.get(0).split("\t");
        int i = 3;
        while (i < splits.length) {
            actual.append(String.valueOf(splits[i]) + ",");
            ++i;
        }
        Assert.assertEquals((long)52L, (long)(splits.length - 3));
    }

    @Test
    public void testParseSampleWithDeletions() throws Exception {
        String file = "test-data/fasta/AY195749.fasta";
        StringBuilder actual = new StringBuilder();
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RSRS);
        String[] splits = samples.get(0).split("\t");
        boolean deletion = false;
        int i = 3;
        while (i < splits.length) {
            if (splits[i].equals("523-524d")) {
                deletion = true;
            }
            actual.append(String.valueOf(splits[i]) + ",");
            ++i;
        }
        Assert.assertEquals((Object)true, (Object)deletion);
    }

    @Test
    public void testParseSampleWithInsertionsDeletions() throws Exception {
        String file = "test-data/fasta/InsertionTest.fasta";
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RCRS);
        String[] splits = samples.get(0).split("\t");
        HashSet<String> set = new HashSet<String>();
        int i = 3;
        while (i < splits.length) {
            set.add(splits[i]);
            ++i;
        }
        Assert.assertEquals((Object)true, (Object)set.contains("16182.1C"));
        Assert.assertEquals((Object)true, (Object)set.contains("309.1CCT"));
        Assert.assertEquals((Object)true, (Object)set.contains("3106-3106d"));
        Assert.assertEquals((Object)true, (Object)set.contains("8270-8277d"));
    }

    @Test
    public void testParseSampleWithInsertionsDeletionsShuffle() throws Exception {
        String file = "test-data/fasta/InsertionTest2.fasta";
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RCRS);
        String[] splits = samples.get(0).split("\t");
        HashSet<String> set = new HashSet<String>();
        int i = 3;
        while (i < splits.length) {
            set.add(splits[i]);
            ++i;
        }
        Assert.assertEquals((Object)true, (Object)set.contains("16182.1C"));
        Assert.assertEquals((Object)true, (Object)set.contains("309.1CCT"));
        Assert.assertEquals((Object)true, (Object)set.contains("3106-3106d"));
        Assert.assertEquals((Object)true, (Object)set.contains("8270-8277d"));
    }

    @Test
    public void testParseSampleWithInsertionsDeletionsShuffleRandom() throws Exception {
        String file = "test-data/fasta/InsertionTest3.fasta";
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RCRS);
        String[] splits = samples.get(0).split("\t");
        HashSet<String> set = new HashSet<String>();
        int i = 3;
        while (i < splits.length) {
            set.add(splits[i]);
            ++i;
        }
        Assert.assertEquals((Object)true, (Object)set.contains("16182.1C"));
        Assert.assertEquals((Object)true, (Object)set.contains("309.1CCT"));
        Assert.assertEquals((Object)true, (Object)set.contains("3106-3106d"));
        Assert.assertEquals((Object)true, (Object)set.contains("8270-8277d"));
    }

    @Test
    public void test() throws Exception {
        String file = "test-data/fasta/ANI152.fasta";
        FastaImporter impFasta = new FastaImporter();
        ArrayList<String> samples = impFasta.load(new File(file), FastaImporter.References.RCRS);
        String[] splits = samples.get(0).split("\t");
        HashSet<String> set = new HashSet<String>();
        int i = 3;
        while (i < splits.length) {
            set.add(splits[i]);
            ++i;
        }
    }
}

