/*
 * Decompiled with CFR 0.152.
 */
package importer;

import com.github.lindenb.jbwa.jni.AlnRgn;
import com.github.lindenb.jbwa.jni.BwaIndex;
import com.github.lindenb.jbwa.jni.BwaMem;
import com.github.lindenb.jbwa.jni.ShortRead;
import genepi.io.FileUtil;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.FastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.SystemUtils;

public class FastaImporter {
    private String range;

    public ArrayList<String> load(File file, References referenceType) throws FileNotFoundException, IOException {
        return this.load(file, referenceType, 16569);
    }

    public ArrayList<String> load(File file, References referenceType, int length) throws FileNotFoundException, IOException {
        ReferenceSequence sequence;
        String jbwaDir = FileUtil.path("jbwa-" + System.currentTimeMillis() + "");
        String ref = "";
        if (referenceType == References.RCRS) {
            ref = "rCRS.fasta";
        } else if (referenceType == References.RSRS) {
            ref = "rsrs.fasta";
        } else if (referenceType == References.HORSE) {
            ref = "horse.fasta";
        } else if (referenceType == References.CATTLE) {
            ref = "cattle.fasta";
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.extractZip(jbwaDir);
        String referenceAsString = FastaImporter.readInReference(FileUtil.path(jbwaDir, ref));
        String jbwaLib = FileUtil.path(new File(jbwaDir + "/libbwajni.so").getAbsolutePath());
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            jbwaLib = FileUtil.path(new File(jbwaDir + "/libbwajni.jnilib").getAbsolutePath());
        }
        System.load(jbwaLib);
        BwaIndex index = new BwaIndex(new File(FileUtil.path(jbwaDir, ref)));
        BwaMem mem = new BwaMem(index);
        FastaSequenceFile refFasta = new FastaSequenceFile(file, true);
        while ((sequence = refFasta.nextSequence()) != null) {
            ShortRead read = new ShortRead(sequence.getName(), sequence.getBaseString().getBytes(), null);
            SAMFileHeader header = new SAMFileHeader();
            SAMLineParser parser = new SAMLineParser(header);
            StringBuilder profile = new StringBuilder();
            boolean first = true;
            for (AlnRgn alignedRead : mem.align(read)) {
                if (alignedRead.getAs() < 30) continue;
                if (header.getSequence(alignedRead.getChrom()) == null) {
                    header.addSequence(new SAMSequenceRecord(alignedRead.getChrom(), length));
                }
                StringBuilder samRecordBulder = new StringBuilder();
                samRecordBulder.append(sequence.getName());
                samRecordBulder.append("\t");
                samRecordBulder.append(0);
                samRecordBulder.append("\t");
                samRecordBulder.append(alignedRead.getChrom());
                samRecordBulder.append("\t");
                samRecordBulder.append(alignedRead.getPos());
                samRecordBulder.append("\t");
                samRecordBulder.append(alignedRead.getMQual());
                samRecordBulder.append("\t");
                samRecordBulder.append(alignedRead.getCigar());
                samRecordBulder.append("\t");
                samRecordBulder.append("*\t0\t0\t");
                samRecordBulder.append(sequence.getBaseString() + "\t");
                samRecordBulder.append("*\t");
                samRecordBulder.append("AS:i:" + alignedRead.getAs());
                SAMRecord samRecord = parser.parseLine(samRecordBulder.toString());
                String variants = this.readCigar(samRecord, referenceAsString);
                if (first) {
                    profile.append(sequence.getName() + "\t" + this.range + "\t?");
                    first = false;
                }
                profile.append(variants);
            }
            lines.add(profile.toString());
        }
        refFasta.close();
        FileUtil.deleteDirectory(jbwaDir);
        return lines;
    }

    private String readCigar(SAMRecord samRecord, String reference) {
        String readString = samRecord.getReadString();
        StringBuilder pos = new StringBuilder();
        StringBuilder _range = new StringBuilder();
        for (int i = 0; i < readString.length(); ++i) {
            char referenceBase;
            int currentPos = samRecord.getReferencePositionAtReadPosition(i + 1);
            char inputBase = readString.charAt(i);
            if (currentPos <= 0) continue;
            if (inputBase != 'N') {
                _range.append(currentPos + ";");
            }
            if (inputBase != 'A' && inputBase != 'C' && inputBase != 'G' && inputBase != 'T' || inputBase == (referenceBase = reference.charAt(currentPos - 1))) continue;
            pos.append("\t" + currentPos + "" + inputBase);
        }
        Integer currentReferencePos = samRecord.getAlignmentStart();
        int sequencePos = 0;
        for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
            Integer cigarElementLength = cigarElement.getLength();
            StringBuilder buildDeletion = new StringBuilder();
            if (cigarElement.getOperator() == CigarOperator.D) {
                Integer cigarElementStart = currentReferencePos;
                Integer cigarElementEnd = currentReferencePos + cigarElementLength;
                buildDeletion.append(cigarElementStart + "-" + (cigarElementEnd - 1) + "d");
                while (cigarElementStart < cigarElementEnd) {
                    Integer n = cigarElementStart;
                    Integer n2 = cigarElementStart = Integer.valueOf(cigarElementStart + 1);
                }
                pos.append("\t" + buildDeletion.toString());
            }
            if (cigarElement.getOperator() == CigarOperator.I) {
                int currentReferencePosIns = currentReferencePos - 1;
                int length = cigarElement.getLength();
                StringBuilder buildInsertion = new StringBuilder();
                for (int i = 1; i <= length; ++i) {
                    char insBase = samRecord.getReadString().charAt(sequencePos + i - 1);
                    buildInsertion.append(insBase);
                }
                pos.append("\t" + currentReferencePosIns + ".1" + buildInsertion.toString());
            }
            if (cigarElement.getOperator().consumesReferenceBases()) {
                currentReferencePos = currentReferencePos + cigarElement.getLength();
            }
            if (!cigarElement.getOperator().consumesReadBases()) continue;
            sequencePos += cigarElement.getLength();
        }
        this.range = _range.toString();
        return pos.toString();
    }

    public static String readInReference(String file) {
        StringBuilder stringBuilder = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(">")) continue;
                stringBuilder.append(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private void extractZip(String jbwaDir) throws IOException, FileNotFoundException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("jbwa.zip");
        ZipInputStream zis = new ZipInputStream(stream);
        ZipEntry entry = zis.getNextEntry();
        FileUtil.createDirectory(jbwaDir);
        while (entry != null) {
            int len;
            String fileName = entry.getName();
            byte[] buffer = new byte[1024];
            File newFile = new File(FileUtil.path(jbwaDir, fileName));
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            entry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    public static enum References {
        RCRS,
        RSRS,
        HORSE,
        CATTLE;

    }
}

