/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.vcf;

import genepi.io.table.reader.IReader;
import genepi.io.vcf.GenomeLocation;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class GenomeLocationReader
implements IReader<GenomeLocation> {
    private String filename;
    private BufferedReader in;
    private String line;
    private GenomeLocation currentGenomeLocation;

    public GenomeLocationReader(String filename) throws IOException {
        this.filename = filename;
        try {
            this.in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean next() throws IOException {
        this.line = this.in.readLine();
        while (this.line != null && this.line.startsWith("#")) {
            this.line = this.in.readLine();
        }
        if (this.line != null) {
            this.currentGenomeLocation = new GenomeLocation();
            String[] tiles = this.line.split("\t");
            String rsNumber = tiles[0];
            String chromosome = tiles[1];
            long position = Long.parseLong(tiles[2]);
            this.currentGenomeLocation.setId(rsNumber);
            this.currentGenomeLocation.setChromosome(chromosome);
            this.currentGenomeLocation.setPosition(position);
        }
        return this.line != null;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public GenomeLocation get() {
        return this.currentGenomeLocation;
    }

    @Override
    public Iterator<GenomeLocation> iterator() {
        return null;
    }

    @Override
    public void reset() {
    }

    public String getFilename() {
        return this.filename;
    }
}

