/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.text;

import genepi.io.FileUtil;
import genepi.io.table.reader.IReader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class AbstractLineReader<o>
implements IReader<o> {
    private String filename;
    protected BufferedReader in;
    private String line;
    private int lineNumber;

    public AbstractLineReader(String filename) throws IOException {
        this.filename = filename;
        FileInputStream inputStream = new FileInputStream(filename);
        InputStream in2 = FileUtil.decompressStream(inputStream);
        this.in = new BufferedReader(new InputStreamReader(in2));
    }

    public AbstractLineReader(DataInputStream inputStream) throws IOException {
        InputStream in2 = FileUtil.decompressStream(inputStream);
        this.in = new BufferedReader(new InputStreamReader(in2));
    }

    @Override
    public boolean next() throws IOException {
        this.line = this.in.readLine();
        if (this.line != null) {
            try {
                ++this.lineNumber;
                if (!this.line.trim().isEmpty()) {
                    this.parseLine(this.line);
                }
            }
            catch (Exception e) {
                throw new IOException(this.filename + ": Line " + this.lineNumber + ": " + e.getMessage());
            }
        }
        return this.line != null;
    }

    protected abstract void parseLine(String var1) throws Exception;

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset() {
    }

    public String getFilename() {
        return this.filename;
    }
}

